/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp;

import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import java.util.ArrayList;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacityScheduler;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.UserInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.AppsBlock;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.RmView;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerLeafQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.CapacitySchedulerQueueInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.ResponseInfo;
import org.apache.hadoop.yarn.webapp.SubView;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

class CapacitySchedulerPage
extends RmView {
    static final String _Q = ".ui-state-default.ui-corner-all";
    static final float Q_MAX_WIDTH = 0.8f;
    static final float Q_STATS_POS = 0.85f;
    static final String Q_END = "left:101%";
    static final String Q_GIVEN = "left:0%;background:none;border:1px dashed rgba(0,0,0,0.25)";
    static final String Q_OVER = "background:rgba(255, 140, 0, 0.8)";
    static final String Q_UNDER = "background:rgba(50, 205, 50, 0.8)";

    CapacitySchedulerPage() {
    }

    protected void postHead(Hamlet.HTML<HtmlPage._> html) {
        ((Hamlet.HTML)html.style().$type("text/css")._(new Object[]{"#cs { padding: 0.5em 0 1em 0; margin-bottom: 1em; position: relative }", "#cs ul { list-style: none }", "#cs a { font-weight: normal; margin: 2px; position: relative }", "#cs a span { font-weight: normal; font-size: 80% }", "#cs-wrapper .ui-widget-header { padding: 0.2em 0.5em }", ".qstats { font-weight: normal; font-size: 80%; position: absolute }", ".qlegend { font-weight: normal; padding: 0 1em; margin: 1em }", "table.info tr th {width: 50%}"})._()).script("/static/jt/jquery.jstree.js").script().$type("text/javascript")._(new Object[]{"$(function() {", "  $('#cs a span').addClass('ui-corner-all').css('position', 'absolute');", "  $('#cs').bind('loaded.jstree', function (e, data) {", "    data.inst.open_node('#pq', true);", "   }).", "    jstree({", "    core: { animation: 188, html_titles: true },", "    plugins: ['themeroller', 'html_data', 'ui'],", "    themeroller: { item_open: 'ui-icon-minus',", "      item_clsd: 'ui-icon-plus', item_leaf: 'ui-icon-gear'", "    }", "  });", "  $('#cs').bind('select_node.jstree', function(e, data) {", "    var q = $('.q', data.rslt.obj).first().text();", "    if (q == 'root') q = '';", "    else q = '^' + q.substr(q.lastIndexOf('.') + 1) + '$';", "    $('#apps').dataTable().fnFilter(q, 3, true);", "  });", "  $('#cs').show();", "});"})._();
    }

    @Override
    protected Class<? extends SubView> content() {
        return QueuesBlock.class;
    }

    static String percent(float f) {
        return String.format("%.1f%%", Float.valueOf(f * 100.0f));
    }

    static String width(float f) {
        return String.format("width:%.1f%%", Float.valueOf(f * 100.0f));
    }

    static String left(float f) {
        return String.format("left:%.1f%%", Float.valueOf(f * 100.0f));
    }

    static class QueuesBlock
    extends HtmlBlock {
        final CapacityScheduler cs;
        final CSQInfo csqinfo;

        @Inject
        QueuesBlock(ResourceManager rm, CSQInfo info) {
            this.cs = (CapacityScheduler)rm.getResourceScheduler();
            this.csqinfo = info;
        }

        public void render(HtmlBlock.Block html) {
            html._(MetricsOverviewTable.class);
            Hamlet.UL ul = ((Hamlet.DIV)html.div("#cs-wrapper.ui-widget").div(".ui-widget-header.ui-corner-top")._(new Object[]{"Application Queues"})._()).div("#cs.ui-widget-content.ui-corner-bottom").ul();
            if (this.cs == null) {
                ((Hamlet.LI)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(CapacitySchedulerPage.Q_END)._(new Object[]{"100% "})._()).span(".q", "default")._())._();
            } else {
                CapacitySchedulerInfo sinfo;
                CSQueue root = this.cs.getRootQueue();
                this.csqinfo.csinfo = sinfo = new CapacitySchedulerInfo(root);
                this.csqinfo.qinfo = null;
                float used = sinfo.getUsedCapacity() / 100.0f;
                ((Hamlet.LI)((Hamlet.LI)((Hamlet.A)((Hamlet.UL)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)((Hamlet.LI)ul.li().$style("margin-bottom: 1em").span().$style("font-weight: bold")._(new Object[]{"Legend:"})._()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_GIVEN)._(new Object[]{"Capacity"})._()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_UNDER)._(new Object[]{"Used"})._()).span().$class("qlegend ui-corner-all").$style(CapacitySchedulerPage.Q_OVER)._(new Object[]{"Used (over capacity)"})._()).span().$class("qlegend ui-corner-all ui-state-default")._(new Object[]{"Max Capacity"})._())._()).li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(0.8f)).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(used), ";left:0%;", used > 1.0f ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER}))._(new Object[]{"."})._()).span(".q", "root")._()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f))._(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})})._())._(QueueBlock.class)._();
            }
            ((Hamlet)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.DIV)ul._())._()).script().$type("text/javascript")._(new Object[]{"$('#cs').hide();"})._())._())._(AppsBlock.class);
        }
    }

    public static class QueueBlock
    extends HtmlBlock {
        final CSQInfo csqinfo;

        @Inject
        QueueBlock(CSQInfo info) {
            this.csqinfo = info;
        }

        public void render(HtmlBlock.Block html) {
            ArrayList<CapacitySchedulerQueueInfo> subQueues = this.csqinfo.qinfo == null ? this.csqinfo.csinfo.getQueues().getQueueInfoList() : this.csqinfo.qinfo.getQueues().getQueueInfoList();
            Hamlet.UL ul = html.ul("#pq");
            for (CapacitySchedulerQueueInfo info : subQueues) {
                float used = info.getUsedCapacity() / 100.0f;
                float absCap = info.getAbsoluteCapacity() / 100.0f;
                float absMaxCap = info.getAbsoluteMaxCapacity() / 100.0f;
                float absUsedCap = info.getAbsoluteUsedCapacity() / 100.0f;
                Hamlet.LI li = (Hamlet.LI)((Hamlet.LI)((Hamlet.A)((Hamlet.A)ul.li().a(CapacitySchedulerPage._Q).$style(CapacitySchedulerPage.width(absMaxCap * 0.8f)).$title(StringHelper.join((Object[])new Object[]{"Absolute Capacity:", CapacitySchedulerPage.percent(absCap)})).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.Q_GIVEN, ";font-size:1px;", CapacitySchedulerPage.width(absCap / absMaxCap)}))._(new Object[]{Character.valueOf('.')})._()).span().$style(StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.width(absUsedCap / absMaxCap), ";font-size:1px;left:0%;", absUsedCap > absCap ? CapacitySchedulerPage.Q_OVER : CapacitySchedulerPage.Q_UNDER}))._(new Object[]{Character.valueOf('.')})._()).span(".q", info.getQueuePath().substring(5))._()).span().$class("qstats").$style(CapacitySchedulerPage.left(0.85f))._(new Object[]{StringHelper.join((Object[])new Object[]{CapacitySchedulerPage.percent(used), " used"})})._();
                this.csqinfo.qinfo = info;
                if (info.getQueues() == null) {
                    ((Hamlet.UL)li.ul("#lq").li()._(LeafQueueInfoBlock.class)._())._();
                } else {
                    li._(QueueBlock.class);
                }
                li._();
            }
            ul._();
        }
    }

    static class LeafQueueInfoBlock
    extends HtmlBlock {
        final CapacitySchedulerLeafQueueInfo lqinfo;

        @Inject
        LeafQueueInfoBlock(View.ViewContext ctx, CSQInfo info) {
            super(ctx);
            this.lqinfo = (CapacitySchedulerLeafQueueInfo)info.qinfo;
        }

        private String getPercentage(ResourceInfo numerator, ResourceInfo denominator) {
            StringBuilder percentString = new StringBuilder("Memory: ");
            if (numerator != null) {
                percentString.append(numerator.getMemory());
            }
            if (denominator.getMemory() != 0) {
                percentString.append(" (<span title='of used resources in this queue'>").append(StringUtils.format((String)"%.2f", (Object[])new Object[]{(double)numerator.getMemory() * 100.0 / (double)denominator.getMemory()}) + "%</span>)");
            }
            percentString.append(", vCores: ");
            if (numerator != null) {
                percentString.append(numerator.getvCores());
            }
            if (denominator.getvCores() != 0) {
                percentString.append(" (<span title='of used resources in this queue'>").append(StringUtils.format((String)"%.2f", (Object[])new Object[]{(double)numerator.getvCores() * 100.0 / (double)denominator.getvCores()}) + "%</span>)");
            }
            return percentString.toString();
        }

        protected void render(HtmlBlock.Block html) {
            StringBuilder activeUserList = new StringBuilder("");
            ResourceInfo usedResources = this.lqinfo.getResourcesUsed();
            ArrayList<UserInfo> users = this.lqinfo.getUsers().getUsersList();
            for (UserInfo entry : users) {
                activeUserList.append(entry.getUsername()).append(" &lt;").append(this.getPercentage(entry.getResourcesUsed(), usedResources)).append(", Active Apps: " + entry.getNumActiveApplications()).append(", Pending Apps: " + entry.getNumPendingApplications()).append("&gt;<br style='display:block'>");
            }
            ResponseInfo ri = this.info("'" + this.lqinfo.getQueuePath().substring(5) + "' Queue Status")._("Queue State:", (Object)this.lqinfo.getQueueState())._("Used Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getUsedCapacity() / 100.0f))._("Absolute Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getAbsoluteCapacity() / 100.0f))._("Absolute Max Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getAbsoluteMaxCapacity() / 100.0f))._("Used Resources:", (Object)StringEscapeUtils.escapeHtml((String)this.lqinfo.getUsedResources().toString()))._("Num Active Applications:", (Object)Integer.toString(this.lqinfo.getNumActiveApplications()))._("Num Pending Applications:", (Object)Integer.toString(this.lqinfo.getNumPendingApplications()))._("Num Containers:", (Object)Integer.toString(this.lqinfo.getNumContainers()))._("Max Applications:", (Object)Integer.toString(this.lqinfo.getMaxApplications()))._("Max Applications Per User:", (Object)Integer.toString(this.lqinfo.getMaxApplicationsPerUser()))._("Max Active Applications:", (Object)Integer.toString(this.lqinfo.getMaxActiveApplications()))._("Max Active Applications Per User:", (Object)Integer.toString(this.lqinfo.getMaxActiveApplicationsPerUser()))._("Configured Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getCapacity() / 100.0f))._("Configured Max Capacity:", (Object)CapacitySchedulerPage.percent(this.lqinfo.getMaxCapacity() / 100.0f))._("Configured Minimum User Limit Percent:", (Object)(Integer.toString(this.lqinfo.getUserLimit()) + "%"))._("Configured User Limit Factor:", (Object)String.format("%.1f", Float.valueOf(this.lqinfo.getUserLimitFactor())))._r("Active users: ", (Object)activeUserList.toString());
            html._(InfoBlock.class);
            ri.clear();
        }
    }

    @RequestScoped
    static class CSQInfo {
        CapacitySchedulerInfo csinfo;
        CapacitySchedulerQueueInfo qinfo;

        CSQInfo() {
        }
    }
}

