/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.io.IOException;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.AbstractAutoCreatedLeafQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueueUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CapacitySchedulerContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.PlanQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReservationQueue
extends AbstractAutoCreatedLeafQueue {
    private static final Logger LOG = LoggerFactory.getLogger(ReservationQueue.class);
    private PlanQueue parent;

    public ReservationQueue(CapacitySchedulerContext cs, String queueName, PlanQueue parent) throws IOException {
        super(cs, queueName, parent, null);
        this.updateQuotas(parent.getUserLimitForReservation(), parent.getUserLimitFactor(), parent.getMaxApplicationsForReservations(), parent.getMaxApplicationsPerUserForReservation());
        this.parent = parent;
    }

    @Override
    public void reinitialize(CSQueue newlyParsedQueue, Resource clusterResource) throws IOException {
        try {
            this.writeLock.lock();
            if (!(newlyParsedQueue instanceof ReservationQueue) || !newlyParsedQueue.getQueuePath().equals(this.getQueuePath())) {
                throw new IOException("Trying to reinitialize " + this.getQueuePath() + " from " + newlyParsedQueue.getQueuePath());
            }
            super.reinitialize(newlyParsedQueue, clusterResource);
            CSQueueUtils.updateQueueStatistics(this.resourceCalculator, clusterResource, this, this.labelManager, null);
            this.updateQuotas(this.parent.getUserLimitForReservation(), this.parent.getUserLimitFactor(), this.parent.getMaxApplicationsForReservations(), this.parent.getMaxApplicationsPerUserForReservation());
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void updateQuotas(int userLimit, float userLimitFactor, int maxAppsForReservation, int maxAppsPerUserForReservation) {
        this.setUserLimit(userLimit);
        this.setUserLimitFactor(userLimitFactor);
        this.setMaxApplications(maxAppsForReservation);
        this.maxApplicationsPerUser = maxAppsPerUserForReservation;
    }

    @Override
    protected void setupConfigurableCapacities(CapacitySchedulerConfiguration configuration) {
        super.setupConfigurableCapacities(this.queueCapacities);
    }
}

