/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.webapp.dao;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ExecutionTypeRequestInfo;
import org.apache.hadoop.yarn.server.resourcemanager.webapp.dao.ResourceInfo;

@XmlRootElement(name="resourceRequests")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ResourceRequestInfo {
    @XmlElement(name="priority")
    private int priority;
    @XmlElement(name="resourceName")
    private String resourceName;
    @XmlElement(name="capability")
    private ResourceInfo capability;
    @XmlElement(name="numContainers")
    private int numContainers;
    @XmlElement(name="relaxLocality")
    private boolean relaxLocality;
    @XmlElement(name="nodeLabelExpression")
    private String nodeLabelExpression;
    @XmlElement(name="executionTypeRequest")
    private ExecutionTypeRequestInfo executionTypeRequest;
    @XmlElement(name="executionType")
    private String executionType;
    @XmlElement(name="enforceExecutionType")
    private boolean enforceExecutionType;

    public ResourceRequestInfo() {
    }

    public ResourceRequestInfo(ResourceRequest request) {
        this.priority = request.getPriority().getPriority();
        this.resourceName = request.getResourceName();
        this.capability = new ResourceInfo(request.getCapability());
        this.numContainers = request.getNumContainers();
        this.relaxLocality = request.getRelaxLocality();
        this.nodeLabelExpression = request.getNodeLabelExpression();
        if (request.getExecutionTypeRequest() != null) {
            this.executionTypeRequest = new ExecutionTypeRequestInfo(request.getExecutionTypeRequest());
        }
    }

    public Priority getPriority() {
        return Priority.newInstance((int)this.priority);
    }

    public void setPriority(Priority priority) {
        this.priority = priority.getPriority();
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public ResourceInfo getCapability() {
        return this.capability;
    }

    public void setCapability(ResourceInfo capability) {
        this.capability = capability;
    }

    public int getNumContainers() {
        return this.numContainers;
    }

    public void setNumContainers(int numContainers) {
        this.numContainers = numContainers;
    }

    public boolean getRelaxLocality() {
        return this.relaxLocality;
    }

    public void setRelaxLocality(boolean relaxLocality) {
        this.relaxLocality = relaxLocality;
    }

    public String getNodeLabelExpression() {
        return this.nodeLabelExpression;
    }

    public void setNodeLabelExpression(String nodeLabelExpression) {
        this.nodeLabelExpression = nodeLabelExpression;
    }

    public void setExecutionTypeRequest(ExecutionTypeRequest executionTypeRequest) {
        this.executionTypeRequest = new ExecutionTypeRequestInfo(executionTypeRequest);
    }

    public ExecutionTypeRequestInfo getExecutionTypeRequest() {
        return this.executionTypeRequest;
    }
}

