/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.hadoop.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.records.OpportunisticContainersStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.QueueLimitCalculator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeQueueLoadMonitor
implements ClusterMonitor {
    private static final Logger LOG = LoggerFactory.getLogger(NodeQueueLoadMonitor.class);
    private int numNodesForAnyAllocation = 10;
    private final ScheduledExecutorService scheduledExecutor;
    private final List<NodeId> sortedNodes;
    private final Map<NodeId, ClusterNode> clusterNodes = new ConcurrentHashMap<NodeId, ClusterNode>();
    private final Map<String, RMNode> nodeByHostName = new ConcurrentHashMap<String, RMNode>();
    private final Map<String, Set<NodeId>> nodeIdsByRack = new ConcurrentHashMap<String, Set<NodeId>>();
    private final LoadComparator comparator;
    private QueueLimitCalculator thresholdCalculator;
    private ReentrantReadWriteLock sortedNodesLock = new ReentrantReadWriteLock();
    private ReentrantReadWriteLock clusterNodesLock = new ReentrantReadWriteLock();
    Runnable computeTask = new Runnable(){

        @Override
        public void run() {
            ReentrantReadWriteLock.WriteLock writeLock = NodeQueueLoadMonitor.this.sortedNodesLock.writeLock();
            writeLock.lock();
            try {
                try {
                    List nodeIds = NodeQueueLoadMonitor.this.sortNodes();
                    NodeQueueLoadMonitor.this.sortedNodes.clear();
                    NodeQueueLoadMonitor.this.sortedNodes.addAll(nodeIds);
                }
                catch (Exception ex) {
                    LOG.warn("Got Exception while sorting nodes..", (Throwable)ex);
                }
                if (NodeQueueLoadMonitor.this.thresholdCalculator != null) {
                    NodeQueueLoadMonitor.this.thresholdCalculator.update();
                }
            }
            finally {
                writeLock.unlock();
            }
        }
    };

    @VisibleForTesting
    NodeQueueLoadMonitor(LoadComparator comparator) {
        this.sortedNodes = new ArrayList<NodeId>();
        this.comparator = comparator;
        this.scheduledExecutor = null;
    }

    public NodeQueueLoadMonitor(long nodeComputationInterval, LoadComparator comparator, int numNodes) {
        this.sortedNodes = new ArrayList<NodeId>();
        this.scheduledExecutor = Executors.newScheduledThreadPool(1);
        this.comparator = comparator;
        this.scheduledExecutor.scheduleAtFixedRate(this.computeTask, nodeComputationInterval, nodeComputationInterval, TimeUnit.MILLISECONDS);
        this.numNodesForAnyAllocation = numNodes;
    }

    List<NodeId> getSortedNodes() {
        return this.sortedNodes;
    }

    public QueueLimitCalculator getThresholdCalculator() {
        return this.thresholdCalculator;
    }

    public void stop() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
    }

    Map<NodeId, ClusterNode> getClusterNodes() {
        return this.clusterNodes;
    }

    Comparator<ClusterNode> getComparator() {
        return this.comparator;
    }

    public void initThresholdCalculator(float sigma, int limitMin, int limitMax) {
        this.thresholdCalculator = new QueueLimitCalculator(this, sigma, limitMin, limitMax);
    }

    @Override
    public void addNode(List<NMContainerStatus> containerStatuses, RMNode rmNode) {
        this.nodeByHostName.put(rmNode.getHostName(), rmNode);
        this.addIntoNodeIdsByRack(rmNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode(RMNode removedRMNode) {
        ClusterNode node;
        LOG.info("Node delete event for: {}", (Object)removedRMNode.getNode().getName());
        this.nodeByHostName.remove(removedRMNode.getHostName());
        this.removeFromNodeIdsByRack(removedRMNode);
        ReentrantReadWriteLock.WriteLock writeLock = this.clusterNodesLock.writeLock();
        writeLock.lock();
        try {
            node = this.clusterNodes.remove(removedRMNode.getNodeID());
        }
        finally {
            writeLock.unlock();
        }
        if (LOG.isDebugEnabled()) {
            if (node != null) {
                LOG.debug("Delete ClusterNode: " + removedRMNode.getNodeID());
            } else {
                LOG.debug("Node not in list!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNode(RMNode rmNode) {
        LOG.debug("Node update event from: {}", (Object)rmNode.getNodeID());
        OpportunisticContainersStatus opportunisticContainersStatus = rmNode.getOpportunisticContainersStatus();
        if (opportunisticContainersStatus == null) {
            opportunisticContainersStatus = OpportunisticContainersStatus.newInstance();
        }
        int opportQueueCapacity = opportunisticContainersStatus.getOpportQueueCapacity();
        int estimatedQueueWaitTime = opportunisticContainersStatus.getEstimatedQueueWaitTime();
        int waitQueueLength = opportunisticContainersStatus.getWaitQueueLength();
        ReentrantReadWriteLock.WriteLock writeLock = this.clusterNodesLock.writeLock();
        writeLock.lock();
        try {
            ClusterNode currentNode = this.clusterNodes.get(rmNode.getNodeID());
            if (currentNode == null) {
                if (rmNode.getState() != NodeState.DECOMMISSIONING && (estimatedQueueWaitTime != -1 || this.comparator == LoadComparator.QUEUE_LENGTH)) {
                    this.clusterNodes.put(rmNode.getNodeID(), new ClusterNode(rmNode.getNodeID()).setQueueWaitTime(estimatedQueueWaitTime).setQueueLength(waitQueueLength).setQueueCapacity(opportQueueCapacity));
                    LOG.info("Inserting ClusterNode [" + rmNode.getNodeID() + "] with queue wait time [" + estimatedQueueWaitTime + "] and wait queue length [" + waitQueueLength + "]");
                } else {
                    LOG.warn("IGNORING ClusterNode [" + rmNode.getNodeID() + "] with queue wait time [" + estimatedQueueWaitTime + "] and wait queue length [" + waitQueueLength + "]");
                }
            } else if (rmNode.getState() != NodeState.DECOMMISSIONING && (estimatedQueueWaitTime != -1 || this.comparator == LoadComparator.QUEUE_LENGTH)) {
                currentNode.setQueueWaitTime(estimatedQueueWaitTime).setQueueLength(waitQueueLength).updateTimestamp();
                LOG.debug("Updating ClusterNode [{}] with queue wait time [{}] and wait queue length [{}]", new Object[]{rmNode.getNodeID(), estimatedQueueWaitTime, waitQueueLength});
            } else {
                this.clusterNodes.remove(rmNode.getNodeID());
                LOG.info("Deleting ClusterNode [" + rmNode.getNodeID() + "] with queue wait time [" + currentNode.queueWaitTime + "] and wait queue length [" + currentNode.queueLength + "]");
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    @Override
    public void updateNodeResource(RMNode rmNode, ResourceOption resourceOption) {
        LOG.debug("Node resource update event from: {}", (Object)rmNode.getNodeID());
    }

    public List<NodeId> selectNodes() {
        return this.selectLeastLoadedNodes(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeId> selectLeastLoadedNodes(int k) {
        ReentrantReadWriteLock.ReadLock readLock = this.sortedNodesLock.readLock();
        readLock.lock();
        try {
            ArrayList<NodeId> retVal;
            ArrayList<NodeId> arrayList = retVal = k < this.sortedNodes.size() && k >= 0 ? new ArrayList<NodeId>(this.sortedNodes).subList(0, k) : new ArrayList<NodeId>(this.sortedNodes);
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    public RMNode selectLocalNode(String hostName, Set<String> blacklist) {
        ClusterNode clusterNode;
        if (blacklist.contains(hostName)) {
            return null;
        }
        RMNode node = this.nodeByHostName.get(hostName);
        if (node != null && this.comparator.compareAndIncrement(clusterNode = this.clusterNodes.get(node.getNodeID()), 1)) {
            return node;
        }
        return null;
    }

    public RMNode selectRackLocalNode(String rackName, Set<String> blacklist) {
        Set<NodeId> nodesOnRack = this.nodeIdsByRack.get(rackName);
        if (nodesOnRack != null) {
            for (NodeId nodeId : nodesOnRack) {
                ClusterNode node;
                if (blacklist.contains(nodeId.getHost()) || (node = this.clusterNodes.get(nodeId)) == null || !this.comparator.compareAndIncrement(node, 1)) continue;
                return this.nodeByHostName.get(nodeId.getHost());
            }
        }
        return null;
    }

    public RMNode selectAnyNode(Set<String> blacklist) {
        List<NodeId> nodeIds = this.selectLeastLoadedNodes(this.numNodesForAnyAllocation);
        int size = nodeIds.size();
        if (size <= 0) {
            return null;
        }
        Random rand = new Random();
        int startIndex = rand.nextInt(size);
        for (int i = 0; i < size; ++i) {
            ClusterNode node;
            int index = i + startIndex;
            NodeId nodeId = nodeIds.get(index %= size);
            if (nodeId == null || blacklist.contains(nodeId.getHost()) || (node = this.clusterNodes.get(nodeId)) == null || !this.comparator.compareAndIncrement(node, 1)) continue;
            return this.nodeByHostName.get(nodeId.getHost());
        }
        return null;
    }

    private void removeFromNodeIdsByRack(RMNode removedNode) {
        this.nodeIdsByRack.computeIfPresent(removedNode.getRackName(), (k, v) -> v).remove(removedNode.getNodeID());
    }

    private void addIntoNodeIdsByRack(RMNode addedNode) {
        this.nodeIdsByRack.compute(addedNode.getRackName(), (k, v) -> v == null ? ConcurrentHashMap.newKeySet() : v).add(addedNode.getNodeID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<NodeId> sortNodes() {
        ReentrantReadWriteLock.ReadLock readLock = this.clusterNodesLock.readLock();
        readLock.lock();
        try {
            ArrayList<ClusterNode> aList = new ArrayList<ClusterNode>(this.clusterNodes.values());
            ArrayList<NodeId> retList = new ArrayList<NodeId>();
            Object[] nodes = aList.toArray();
            Arrays.sort(nodes, this.comparator);
            for (int j = 0; j < nodes.length; ++j) {
                ClusterNode cNode = (ClusterNode)nodes[j];
                if (cNode.isQueueFull()) continue;
                retList.add(cNode.nodeId);
            }
            ArrayList<NodeId> arrayList = retList;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    static class ClusterNode {
        private AtomicInteger queueLength = new AtomicInteger(0);
        private AtomicInteger queueWaitTime = new AtomicInteger(-1);
        private long timestamp;
        final NodeId nodeId;
        private int queueCapacity = 0;

        public ClusterNode(NodeId nodeId) {
            this.nodeId = nodeId;
            this.updateTimestamp();
        }

        public ClusterNode setQueueLength(int qLength) {
            this.queueLength.set(qLength);
            return this;
        }

        public ClusterNode setQueueWaitTime(int wTime) {
            this.queueWaitTime.set(wTime);
            return this;
        }

        public ClusterNode updateTimestamp() {
            this.timestamp = System.currentTimeMillis();
            return this;
        }

        public ClusterNode setQueueCapacity(int capacity) {
            this.queueCapacity = capacity;
            return this;
        }

        public boolean isQueueFull() {
            return this.queueCapacity > 0 && this.queueLength.get() >= this.queueCapacity;
        }
    }

    public static enum LoadComparator implements Comparator<ClusterNode>
    {
        QUEUE_LENGTH,
        QUEUE_WAIT_TIME;


        @Override
        public int compare(ClusterNode o1, ClusterNode o2) {
            if (this.getMetric(o1) == this.getMetric(o2)) {
                return (int)(o2.timestamp - o1.timestamp);
            }
            return this.getMetric(o1) - this.getMetric(o2);
        }

        public int getMetric(ClusterNode c) {
            return this == QUEUE_LENGTH ? c.queueLength.get() : c.queueWaitTime.get();
        }

        public boolean compareAndIncrement(ClusterNode c, int incrementSize) {
            if (this == QUEUE_LENGTH) {
                int ret = c.queueLength.addAndGet(incrementSize);
                if (ret <= c.queueCapacity) {
                    return true;
                }
                c.queueLength.addAndGet(-incrementSize);
                return false;
            }
            return true;
        }
    }
}

