/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.webproxy;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.security.authorize.AccessControlList;
import org.apache.hadoop.util.StringUtils;
import org.apache.hadoop.yarn.YarnException;
import org.apache.hadoop.yarn.server.webproxy.AppReportFetcher;
import org.apache.hadoop.yarn.server.webproxy.WebAppProxyServlet;
import org.apache.hadoop.yarn.service.AbstractService;

public class WebAppProxy
extends AbstractService {
    public static final String FETCHER_ATTRIBUTE = "AppUrlFetcher";
    public static final String IS_SECURITY_ENABLED_ATTRIBUTE = "IsSecurityEnabled";
    private static final Log LOG = LogFactory.getLog(WebAppProxy.class);
    private HttpServer proxyServer = null;
    private String bindAddress = null;
    private int port = 0;
    private AccessControlList acl = null;
    private AppReportFetcher fetcher = null;
    private boolean isSecurityEnabled = false;

    public WebAppProxy() {
        super(WebAppProxy.class.getName());
    }

    public void init(Configuration conf) {
        String auth = conf.get("hadoop.security.authentication");
        if (auth == null || "simple".equals(auth)) {
            this.isSecurityEnabled = false;
        } else if ("kerberos".equals(auth)) {
            this.isSecurityEnabled = true;
        } else {
            LOG.warn((Object)("Unrecongized attribute value for hadoop.security.authentication of " + auth));
        }
        this.fetcher = new AppReportFetcher(conf);
        this.bindAddress = conf.get("yarn.web-proxy.address");
        if (this.bindAddress == null || this.bindAddress.isEmpty()) {
            throw new YarnException("yarn.web-proxy.address is not set so the proxy will not run.");
        }
        LOG.info((Object)("Instantiating Proxy at " + this.bindAddress));
        String[] parts = StringUtils.split((String)this.bindAddress, (char)':');
        this.port = 0;
        if (parts.length == 2) {
            this.bindAddress = parts[0];
            this.port = Integer.parseInt(parts[1]);
        }
        this.acl = new AccessControlList(conf.get("yarn.admin.acl", "*"));
        super.init(conf);
    }

    public void start() {
        try {
            this.proxyServer = new HttpServer("proxy", this.bindAddress, this.port, this.port == 0, this.getConfig(), this.acl);
            this.proxyServer.addServlet("proxy", "/proxy/*", WebAppProxyServlet.class);
            this.proxyServer.setAttribute(FETCHER_ATTRIBUTE, (Object)this.fetcher);
            this.proxyServer.setAttribute(IS_SECURITY_ENABLED_ATTRIBUTE, (Object)this.isSecurityEnabled);
            this.proxyServer.start();
        }
        catch (IOException e) {
            LOG.fatal((Object)"Could not start proxy web server", (Throwable)e);
            throw new YarnException("Could not start proxy web server", (Throwable)e);
        }
        super.start();
    }

    public void stop() {
        if (this.proxyServer != null) {
            try {
                this.proxyServer.stop();
            }
            catch (Exception e) {
                LOG.fatal((Object)"Error stopping proxy web server", (Throwable)e);
                throw new YarnException("Error stopping proxy web server", (Throwable)e);
            }
        }
        super.stop();
    }
}

