/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CoalescingBufferQueue;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.io.IOException;
import javax.security.sasl.SaslClient;
import org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class SaslWrapHandler
extends ChannelOutboundHandlerAdapter {
    private final SaslClient saslClient;
    private CoalescingBufferQueue queue;

    public SaslWrapHandler(SaslClient saslClient) {
        this.saslClient = saslClient;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.queue = new CoalescingBufferQueue(ctx.channel());
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            this.queue.add((ByteBuf)msg, promise);
        } else {
            ctx.write(msg, promise);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void flush(ChannelHandlerContext ctx) throws Exception {
        if (this.queue.isEmpty()) {
            return;
        }
        ByteBuf buf = null;
        try {
            ChannelPromise promise = ctx.newPromise();
            int readableBytes = this.queue.readableBytes();
            buf = this.queue.remove(readableBytes, promise);
            byte[] bytes = new byte[readableBytes];
            buf.readBytes(bytes);
            byte[] wrapperBytes = this.saslClient.wrap(bytes, 0, bytes.length);
            ChannelPromise lenPromise = ctx.newPromise();
            ctx.write((Object)ctx.alloc().buffer(4).writeInt(wrapperBytes.length), lenPromise);
            ChannelPromise contentPromise = ctx.newPromise();
            ctx.write((Object)Unpooled.wrappedBuffer((byte[])wrapperBytes), contentPromise);
            PromiseCombiner combiner = new PromiseCombiner();
            combiner.addAll(new Promise[]{lenPromise, contentPromise});
            combiner.finish((Promise)promise);
            ctx.flush();
            if (buf == null) return;
        }
        catch (Throwable throwable) {
            if (buf == null) throw throwable;
            ReferenceCountUtil.safeRelease(buf);
            throw throwable;
        }
        ReferenceCountUtil.safeRelease((Object)buf);
    }

    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (!this.queue.isEmpty()) {
            this.queue.releaseAndFailAll((Throwable)new IOException("Connection closed"));
        }
        ctx.close(promise);
    }
}

