/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.MetricName;
import com.yammer.metrics.core.MetricsRegistry;
import com.yammer.metrics.core.Timer;
import com.yammer.metrics.reporting.JmxReporter;
import com.yammer.metrics.util.RatioGauge;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.ConnectionManager;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.StatisticTrackable;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class MetricsConnection
implements StatisticTrackable {
    public static final String CLIENT_SIDE_METRICS_ENABLED_KEY = "hbase.client.metrics.enable";
    private static final String CNT_BASE = "rpcCount_";
    private static final String DRTN_BASE = "rpcCallDurationMs_";
    private static final String REQ_BASE = "rpcCallRequestSizeBytes_";
    private static final String RESP_BASE = "rpcCallResponseSizeBytes_";
    private static final String MEMLOAD_BASE = "memstoreLoad_";
    private static final String HEAP_BASE = "heapOccupancy_";
    private static final String CACHE_BASE = "cacheDroppingExceptions_";
    private static final String UNKNOWN_EXCEPTION = "UnknownException";
    private static final String NS_LOOKUPS = "nsLookups";
    private static final String NS_LOOKUPS_FAILED = "nsLookupsFailed";
    private static final String CLIENT_SVC = ClientProtos.ClientService.getDescriptor().getName();
    protected ConcurrentHashMap<ServerName, ConcurrentMap<byte[], RegionStats>> serverStats = new ConcurrentHashMap();
    private static final int CAPACITY = 50;
    private static final float LOAD_FACTOR = 0.75f;
    private static final int CONCURRENCY_LEVEL = 256;
    private final MetricsRegistry registry;
    private final JmxReporter reporter;
    private final String scope;
    private final NewMetric<Timer> timerFactory = new NewMetric<Timer>(){

        @Override
        public Timer newMetric(Class<?> clazz, String name, String scope) {
            return MetricsConnection.this.registry.newTimer(clazz, name, scope);
        }
    };
    private final NewMetric<Histogram> histogramFactory = new NewMetric<Histogram>(){

        @Override
        public Histogram newMetric(Class<?> clazz, String name, String scope) {
            return MetricsConnection.this.registry.newHistogram(clazz, name, scope);
        }
    };
    private final NewMetric<Counter> counterFactory = new NewMetric<Counter>(){

        @Override
        public Counter newMetric(Class<?> clazz, String name, String scope) {
            return MetricsConnection.this.registry.newCounter(clazz, name, scope);
        }
    };
    protected final Counter metaCacheHits;
    protected final Counter metaCacheMisses;
    protected final CallTracker getTracker;
    protected final CallTracker scanTracker;
    protected final CallTracker appendTracker;
    protected final CallTracker deleteTracker;
    protected final CallTracker incrementTracker;
    protected final CallTracker putTracker;
    protected final CallTracker multiTracker;
    protected final RunnerStats runnerStats;
    protected final Counter metaCacheNumClearServer;
    protected final Counter metaCacheNumClearRegion;
    protected final Counter hedgedReadOps;
    protected final Counter hedgedReadWin;
    protected final Histogram concurrentCallsPerServerHist;
    protected final Counter nsLookups;
    protected final Counter nsLookupsFailed;
    protected final ConcurrentMap<String, Timer> rpcTimers = new ConcurrentHashMap<String, Timer>(50, 0.75f, 256);
    protected final ConcurrentMap<String, Histogram> rpcHistograms = new ConcurrentHashMap<String, Histogram>(100, 0.75f, 256);
    private final ConcurrentMap<String, Counter> cacheDroppingExceptions = new ConcurrentHashMap<String, Counter>(50, 0.75f, 256);
    protected final ConcurrentMap<String, Counter> rpcCounters = new ConcurrentHashMap<String, Counter>(50, 0.75f, 256);

    public void updateServerStats(ServerName serverName, byte[] regionName, Object r) {
        if (!(r instanceof Result)) {
            return;
        }
        Result result = (Result)r;
        ClientProtos.RegionLoadStats stats = result.getStats();
        if (stats == null) {
            return;
        }
        this.updateRegionStats(serverName, regionName, stats);
    }

    @Override
    public void updateRegionStats(ServerName serverName, byte[] regionName, ClientProtos.RegionLoadStats stats) {
        String name = serverName.getServerName() + "," + Bytes.toStringBinary((byte[])regionName);
        ConcurrentMap<byte[], RegionStats> rsStats = null;
        if (this.serverStats.containsKey(serverName)) {
            rsStats = this.serverStats.get(serverName);
        } else {
            rsStats = this.serverStats.putIfAbsent(serverName, new ConcurrentSkipListMap(Bytes.BYTES_COMPARATOR));
            if (rsStats == null) {
                rsStats = this.serverStats.get(serverName);
            }
        }
        RegionStats regionStats = null;
        if (rsStats.containsKey(regionName)) {
            regionStats = (RegionStats)rsStats.get(regionName);
        } else {
            regionStats = rsStats.putIfAbsent(regionName, new RegionStats(this.registry, name));
            if (regionStats == null) {
                regionStats = (RegionStats)rsStats.get(regionName);
            }
        }
        regionStats.update(stats);
    }

    public MetricsConnection(final ConnectionManager.HConnectionImplementation conn) {
        this.scope = conn.toString();
        this.registry = new MetricsRegistry();
        this.registry.newGauge(this.getExecutorPoolName(), (Gauge)new RatioGauge(){

            protected double getNumerator() {
                ThreadPoolExecutor batchPool = (ThreadPoolExecutor)conn.getCurrentBatchPool();
                if (batchPool == null) {
                    return 0.0;
                }
                return batchPool.getActiveCount();
            }

            protected double getDenominator() {
                ThreadPoolExecutor batchPool = (ThreadPoolExecutor)conn.getCurrentBatchPool();
                if (batchPool == null) {
                    return 0.0;
                }
                return batchPool.getMaximumPoolSize();
            }
        });
        this.registry.newGauge(this.getMetaPoolName(), (Gauge)new RatioGauge(){

            protected double getNumerator() {
                ThreadPoolExecutor metaPool = (ThreadPoolExecutor)conn.getCurrentMetaLookupPool();
                if (metaPool == null) {
                    return 0.0;
                }
                return metaPool.getActiveCount();
            }

            protected double getDenominator() {
                ThreadPoolExecutor metaPool = (ThreadPoolExecutor)conn.getCurrentMetaLookupPool();
                if (metaPool == null) {
                    return 0.0;
                }
                return metaPool.getMaximumPoolSize();
            }
        });
        this.metaCacheHits = this.registry.newCounter(this.getClass(), "metaCacheHits", this.scope);
        this.metaCacheMisses = this.registry.newCounter(this.getClass(), "metaCacheMisses", this.scope);
        this.metaCacheNumClearServer = this.registry.newCounter(this.getClass(), "metaCacheNumClearServer", this.scope);
        this.metaCacheNumClearRegion = this.registry.newCounter(this.getClass(), "metaCacheNumClearRegion", this.scope);
        this.hedgedReadOps = this.registry.newCounter(this.getClass(), "hedgedReadOps", this.scope);
        this.hedgedReadWin = this.registry.newCounter(this.getClass(), "hedgedReadWin", this.scope);
        this.getTracker = new CallTracker(this.registry, "Get", this.scope);
        this.scanTracker = new CallTracker(this.registry, "Scan", this.scope);
        this.appendTracker = new CallTracker(this.registry, "Mutate", "Append", this.scope);
        this.deleteTracker = new CallTracker(this.registry, "Mutate", "Delete", this.scope);
        this.incrementTracker = new CallTracker(this.registry, "Mutate", "Increment", this.scope);
        this.putTracker = new CallTracker(this.registry, "Mutate", "Put", this.scope);
        this.multiTracker = new CallTracker(this.registry, "Multi", this.scope);
        this.runnerStats = new RunnerStats(this.registry);
        this.concurrentCallsPerServerHist = this.registry.newHistogram(this.getClass(), "concurrentCallsPerServer", this.scope);
        this.nsLookups = this.registry.newCounter(this.getClass(), NS_LOOKUPS, this.scope);
        this.nsLookupsFailed = this.registry.newCounter(this.getClass(), NS_LOOKUPS_FAILED, this.scope);
        this.reporter = new JmxReporter(this.registry);
        this.reporter.start();
    }

    final MetricName getExecutorPoolName() {
        return new MetricName(this.getClass(), "executorPoolActiveThreads", this.scope);
    }

    final MetricName getMetaPoolName() {
        return new MetricName(this.getClass(), "metaPoolActiveThreads", this.scope);
    }

    MetricsRegistry getMetricsRegistry() {
        return this.registry;
    }

    public void shutdown() {
        this.reporter.shutdown();
        this.registry.shutdown();
    }

    public static CallStats newCallStats() {
        return new CallStats();
    }

    public void incrMetaCacheHit() {
        this.metaCacheHits.inc();
    }

    public void incrMetaCacheMiss() {
        this.metaCacheMisses.inc();
    }

    public void incrMetaCacheNumClearServer() {
        this.metaCacheNumClearServer.inc();
    }

    public void incrMetaCacheNumClearRegion() {
        this.metaCacheNumClearRegion.inc();
    }

    public void incrHedgedReadOps() {
        this.hedgedReadOps.inc();
    }

    public void incrHedgedReadWin() {
        this.hedgedReadWin.inc();
    }

    public void incrNormalRunners() {
        this.runnerStats.incrNormalRunners();
    }

    public void incrDelayRunners() {
        this.runnerStats.incrDelayRunners();
    }

    public void updateDelayInterval(long interval) {
        this.runnerStats.updateDelayInterval(interval);
    }

    private <T> T getMetric(String key, ConcurrentMap<String, T> map, NewMetric<T> factory) {
        Object t = map.get(key);
        if (t == null) {
            t = factory.newMetric(this.getClass(), key, this.scope);
            T tmp = map.putIfAbsent(key, t);
            t = tmp == null ? t : tmp;
        }
        return (T)t;
    }

    private void updateRpcGeneric(String methodName, CallStats stats) {
        this.getMetric(DRTN_BASE + methodName, this.rpcTimers, this.timerFactory).update(stats.getCallTimeMs(), TimeUnit.MILLISECONDS);
        this.getMetric(REQ_BASE + methodName, this.rpcHistograms, this.histogramFactory).update(stats.getRequestSizeBytes());
        this.getMetric(RESP_BASE + methodName, this.rpcHistograms, this.histogramFactory).update(stats.getResponseSizeBytes());
    }

    public void updateRpc(Descriptors.MethodDescriptor method, Message param, CallStats stats) {
        int callsPerServer = stats.getConcurrentCallsPerServer();
        if (callsPerServer > 0) {
            this.concurrentCallsPerServerHist.update(callsPerServer);
        }
        String methodName = method.getService().getName() + "_" + method.getName();
        this.getMetric(CNT_BASE + methodName, this.rpcCounters, this.counterFactory).inc();
        if (method.getService() == ClientProtos.ClientService.getDescriptor()) {
            switch (method.getIndex()) {
                case 0: {
                    assert ("Get".equals(method.getName()));
                    this.getTracker.updateRpc(stats);
                    return;
                }
                case 1: {
                    assert ("Mutate".equals(method.getName()));
                    ClientProtos.MutationProto.MutationType mutationType = ((ClientProtos.MutateRequest)param).getMutation().getMutateType();
                    switch (mutationType) {
                        case APPEND: {
                            this.appendTracker.updateRpc(stats);
                            return;
                        }
                        case DELETE: {
                            this.deleteTracker.updateRpc(stats);
                            return;
                        }
                        case INCREMENT: {
                            this.incrementTracker.updateRpc(stats);
                            return;
                        }
                        case PUT: {
                            this.putTracker.updateRpc(stats);
                            return;
                        }
                    }
                    throw new RuntimeException("Unrecognized mutation type " + mutationType);
                }
                case 2: {
                    assert ("Scan".equals(method.getName()));
                    this.scanTracker.updateRpc(stats);
                    return;
                }
                case 3: {
                    assert ("BulkLoadHFile".equals(method.getName()));
                    break;
                }
                case 4: {
                    assert ("ExecService".equals(method.getName()));
                    break;
                }
                case 5: {
                    assert ("ExecRegionServerService".equals(method.getName()));
                    break;
                }
                case 6: {
                    assert ("Multi".equals(method.getName()));
                    this.multiTracker.updateRpc(stats);
                    return;
                }
                default: {
                    throw new RuntimeException("Unrecognized ClientService RPC type " + method.getFullName());
                }
            }
        }
        this.updateRpcGeneric(methodName, stats);
    }

    public void incrCacheDroppingExceptions(Object exception) {
        this.getMetric(CACHE_BASE + (exception == null ? UNKNOWN_EXCEPTION : exception.getClass().getSimpleName()), this.cacheDroppingExceptions, this.counterFactory).inc();
    }

    public void incrNsLookups() {
        this.nsLookups.inc();
    }

    public void incrNsLookupsFailed() {
        this.nsLookupsFailed.inc();
    }

    private static interface NewMetric<T> {
        public T newMetric(Class<?> var1, String var2, String var3);
    }

    protected static class RunnerStats {
        final Counter normalRunners;
        final Counter delayRunners;
        final Histogram delayIntevalHist;

        public RunnerStats(MetricsRegistry registry) {
            this.normalRunners = registry.newCounter(MetricsConnection.class, "normalRunnersCount");
            this.delayRunners = registry.newCounter(MetricsConnection.class, "delayRunnersCount");
            this.delayIntevalHist = registry.newHistogram(MetricsConnection.class, "delayIntervalHist");
        }

        public void incrNormalRunners() {
            this.normalRunners.inc();
        }

        public void incrDelayRunners() {
            this.delayRunners.inc();
        }

        public void updateDelayInterval(long interval) {
            this.delayIntevalHist.update(interval);
        }
    }

    protected static class RegionStats {
        final String name;
        final Histogram memstoreLoadHist;
        final Histogram heapOccupancyHist;

        public RegionStats(MetricsRegistry registry, String name) {
            this.name = name;
            this.memstoreLoadHist = registry.newHistogram(MetricsConnection.class, MetricsConnection.MEMLOAD_BASE + this.name);
            this.heapOccupancyHist = registry.newHistogram(MetricsConnection.class, MetricsConnection.HEAP_BASE + this.name);
        }

        public void update(ClientProtos.RegionLoadStats regionStatistics) {
            this.memstoreLoadHist.update(regionStatistics.getMemstoreLoad());
            this.heapOccupancyHist.update(regionStatistics.getHeapOccupancy());
        }
    }

    protected static final class CallTracker {
        private final String name;
        final Timer callTimer;
        final Histogram reqHist;
        final Histogram respHist;

        private CallTracker(MetricsRegistry registry, String name, String subName, String scope) {
            StringBuilder sb = new StringBuilder(CLIENT_SVC).append("_").append(name);
            if (subName != null) {
                sb.append("(").append(subName).append(")");
            }
            this.name = sb.toString();
            this.callTimer = registry.newTimer(MetricsConnection.class, MetricsConnection.DRTN_BASE + this.name, scope);
            this.reqHist = registry.newHistogram(MetricsConnection.class, MetricsConnection.REQ_BASE + this.name, scope);
            this.respHist = registry.newHistogram(MetricsConnection.class, MetricsConnection.RESP_BASE + this.name, scope);
        }

        private CallTracker(MetricsRegistry registry, String name, String scope) {
            this(registry, name, null, scope);
        }

        public void updateRpc(CallStats stats) {
            this.callTimer.update(stats.getCallTimeMs(), TimeUnit.MILLISECONDS);
            this.reqHist.update(stats.getRequestSizeBytes());
            this.respHist.update(stats.getResponseSizeBytes());
        }

        public String toString() {
            return "CallTracker:" + this.name;
        }
    }

    public static class CallStats {
        private long requestSizeBytes = 0L;
        private long responseSizeBytes = 0L;
        private long startTime = 0L;
        private long callTimeMs = 0L;
        private int concurrentCallsPerServer = 0;

        public long getRequestSizeBytes() {
            return this.requestSizeBytes;
        }

        public void setRequestSizeBytes(long requestSizeBytes) {
            this.requestSizeBytes = requestSizeBytes;
        }

        public long getResponseSizeBytes() {
            return this.responseSizeBytes;
        }

        public void setResponseSizeBytes(long responseSizeBytes) {
            this.responseSizeBytes = responseSizeBytes;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public void setStartTime(long startTime) {
            this.startTime = startTime;
        }

        public long getCallTimeMs() {
            return this.callTimeMs;
        }

        public void setCallTimeMs(long callTimeMs) {
            this.callTimeMs = callTimeMs;
        }

        public int getConcurrentCallsPerServer() {
            return this.concurrentCallsPerServer;
        }

        public void setConcurrentCallsPerServer(int callsPerServer) {
            this.concurrentCallsPerServer = callsPerServer;
        }
    }
}

