/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.DNS;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.util.StringUtils;
import org.apache.zookeeper.server.DatadirCleanupManager;
import org.apache.zookeeper.server.ServerConfig;
import org.apache.zookeeper.server.ZooKeeperServerMain;
import org.apache.zookeeper.server.quorum.QuorumPeerConfig;
import org.apache.zookeeper.server.quorum.QuorumPeerMain;

@InterfaceAudience.LimitedPrivate(value={"Tools"})
@InterfaceStability.Evolving
public class HQuorumPeer {
    public static void main(String[] args) {
        Configuration conf = HBaseConfiguration.create();
        try {
            Properties zkProperties = ZKConfig.makeZKProps((Configuration)conf);
            HQuorumPeer.writeMyID(zkProperties);
            QuorumPeerConfig zkConfig = new QuorumPeerConfig();
            zkConfig.parseProperties(zkProperties);
            ZKUtil.loginServer(conf, "hbase.zookeeper.server.keytab.file", "hbase.zookeeper.server.kerberos.principal", zkConfig.getClientPortAddress().getHostName());
            HQuorumPeer.runZKServer(zkConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
    }

    private static void runZKServer(QuorumPeerConfig zkConfig) throws UnknownHostException, IOException {
        try {
            DatadirCleanupManager purgeMgr = new DatadirCleanupManager(zkConfig.getDataDir(), zkConfig.getDataLogDir(), zkConfig.getSnapRetainCount(), zkConfig.getPurgeInterval());
            purgeMgr.start();
            if (zkConfig.isDistributed()) {
                QuorumPeerMain qp = new QuorumPeerMain();
                qp.runFromConfig(zkConfig);
            } else {
                ZooKeeperServerMain zk = new ZooKeeperServerMain();
                ServerConfig serverConfig = new ServerConfig();
                serverConfig.readFrom(zkConfig);
                zk.runFromConfig(serverConfig);
            }
        }
        catch (UnknownHostException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private static boolean addressIsLocalHost(String address) {
        return address.equals("localhost") || address.equals("127.0.0.1");
    }

    static void writeMyID(Properties properties) throws IOException {
        long myId = -1L;
        Configuration conf = HBaseConfiguration.create();
        String myAddress = Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)conf.get("hbase.zookeeper.dns.interface", "default"), (String)conf.get("hbase.zookeeper.dns.nameserver", "default")));
        ArrayList<String> ips = new ArrayList<String>();
        ips.add(myAddress.contains(".") ? myAddress : StringUtils.simpleHostname((String)myAddress));
        Enumeration<NetworkInterface> nics = NetworkInterface.getNetworkInterfaces();
        while (nics.hasMoreElements()) {
            Enumeration<InetAddress> rawAdrs = nics.nextElement().getInetAddresses();
            while (rawAdrs.hasMoreElements()) {
                InetAddress inet = rawAdrs.nextElement();
                ips.add(StringUtils.simpleHostname((String)inet.getHostName()));
                ips.add(inet.getHostAddress());
            }
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString().trim();
            String value = entry.getValue().toString().trim();
            if (!key.startsWith("server.")) continue;
            int dot = key.indexOf(46);
            long id = Long.parseLong(key.substring(dot + 1));
            String[] parts = value.split(":");
            String address = parts[0];
            if (!HQuorumPeer.addressIsLocalHost(address) && !ips.contains(address)) continue;
            myId = id;
            break;
        }
        properties.setProperty("maxSessionTimeout", conf.get("zookeeper.session.timeout", Integer.toString(180000)));
        if (myId == -1L) {
            throw new IOException("Could not find my address: " + myAddress + " in list of ZooKeeper quorum servers");
        }
        String dataDirStr = properties.get("dataDir").toString().trim();
        File dataDir = new File(dataDirStr);
        if (!dataDir.isDirectory() && !dataDir.mkdirs()) {
            throw new IOException("Unable to create data dir " + dataDir);
        }
        File myIdFile = new File(dataDir, "myid");
        PrintWriter w = new PrintWriter(myIdFile, StandardCharsets.UTF_8.name());
        w.println(myId);
        w.close();
    }
}

