/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationGlobalSourceSource;
import org.apache.hadoop.hbase.replication.regionserver.MetricsReplicationSourceImpl;
import org.apache.hadoop.metrics2.lib.MutableFastCounter;
import org.apache.hadoop.metrics2.lib.MutableGaugeLong;
import org.apache.hadoop.metrics2.lib.MutableHistogram;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsReplicationGlobalSourceSourceImpl
implements MetricsReplicationGlobalSourceSource {
    private static final String KEY_PREFIX = "source.";
    private final MetricsReplicationSourceImpl rms;
    private final MutableHistogram ageOfLastShippedOpHist;
    private final MutableGaugeLong sizeOfLogQueueGauge;
    private final MutableFastCounter logReadInEditsCounter;
    private final MutableFastCounter walEditsFilteredCounter;
    private final MutableFastCounter shippedBatchesCounter;
    private final MutableFastCounter shippedOpsCounter;
    private final MutableFastCounter shippedBytesCounter;
    @Deprecated
    private final MutableFastCounter shippedKBsCounter;
    private final MutableFastCounter logReadInBytesCounter;
    private final MutableFastCounter shippedHFilesCounter;
    private final MutableGaugeLong sizeOfHFileRefsQueueGauge;
    private final MutableFastCounter unknownFileLengthForClosedWAL;
    private final MutableFastCounter uncleanlyClosedWAL;
    private final MutableFastCounter uncleanlyClosedSkippedBytes;
    private final MutableFastCounter restartWALReading;
    private final MutableFastCounter repeatedFileBytes;
    private final MutableFastCounter completedWAL;
    private final MutableFastCounter completedRecoveryQueue;
    private final MutableFastCounter failedRecoveryQueue;
    private final MutableGaugeLong walReaderBufferUsageBytes;

    public MetricsReplicationGlobalSourceSourceImpl(MetricsReplicationSourceImpl rms) {
        this.rms = rms;
        this.ageOfLastShippedOpHist = rms.getMetricsRegistry().getHistogram("source.ageOfLastShippedOp");
        this.sizeOfLogQueueGauge = rms.getMetricsRegistry().getGauge("source.sizeOfLogQueue", 0L);
        this.shippedBatchesCounter = rms.getMetricsRegistry().getCounter("source.shippedBatches", 0L);
        this.shippedOpsCounter = rms.getMetricsRegistry().getCounter("source.shippedOps", 0L);
        this.shippedKBsCounter = rms.getMetricsRegistry().getCounter("source.shippedKBs", 0L);
        this.shippedBytesCounter = rms.getMetricsRegistry().getCounter("source.shippedBytes", 0L);
        this.logReadInBytesCounter = rms.getMetricsRegistry().getCounter("source.logReadInBytes", 0L);
        this.logReadInEditsCounter = rms.getMetricsRegistry().getCounter("source.logEditsRead", 0L);
        this.walEditsFilteredCounter = rms.getMetricsRegistry().getCounter("source.logEditsFiltered", 0L);
        this.shippedHFilesCounter = rms.getMetricsRegistry().getCounter("source.shippedHFiles", 0L);
        this.sizeOfHFileRefsQueueGauge = rms.getMetricsRegistry().getGauge("source.sizeOfHFileRefsQueue", 0L);
        this.unknownFileLengthForClosedWAL = rms.getMetricsRegistry().getCounter("source.closedLogsWithUnknownFileLength", 0L);
        this.uncleanlyClosedWAL = rms.getMetricsRegistry().getCounter("source.uncleanlyClosedLogs", 0L);
        this.uncleanlyClosedSkippedBytes = rms.getMetricsRegistry().getCounter("source.ignoredUncleanlyClosedLogContentsInBytes", 0L);
        this.restartWALReading = rms.getMetricsRegistry().getCounter("source.restartedLogReading", 0L);
        this.repeatedFileBytes = rms.getMetricsRegistry().getCounter("source.repeatedLogFileBytes", 0L);
        this.completedWAL = rms.getMetricsRegistry().getCounter("source.completedLogs", 0L);
        this.completedRecoveryQueue = rms.getMetricsRegistry().getCounter("source.completedRecoverQueues", 0L);
        this.failedRecoveryQueue = rms.getMetricsRegistry().getCounter("source.failedRecoverQueues", 0L);
        this.walReaderBufferUsageBytes = rms.getMetricsRegistry().getGauge("source.walReaderEditsBufferUsage", 0L);
    }

    public void setLastShippedAge(long age) {
        this.ageOfLastShippedOpHist.add(age);
    }

    public void incrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.incr((long)size);
    }

    public void decrSizeOfLogQueue(int size) {
        this.sizeOfLogQueueGauge.decr((long)size);
    }

    public void incrLogReadInEdits(long size) {
        this.logReadInEditsCounter.incr(size);
    }

    public void incrLogEditsFiltered(long size) {
        this.walEditsFilteredCounter.incr(size);
    }

    public void incrBatchesShipped(int batches) {
        this.shippedBatchesCounter.incr(batches);
    }

    public void incrOpsShipped(long ops) {
        this.shippedOpsCounter.incr(ops);
    }

    public void incrShippedBytes(long size) {
        this.shippedBytesCounter.incr(size);
        MetricsReplicationGlobalSourceSourceImpl.incrementKBsCounter(this.shippedBytesCounter, this.shippedKBsCounter);
    }

    static void incrementKBsCounter(MutableFastCounter bytesCounter, MutableFastCounter kbsCounter) {
        long bytes;
        long delta = 0L;
        while ((delta = (bytes = bytesCounter.value()) / 1024L - kbsCounter.value()) > 0L) {
            kbsCounter.incr(delta);
        }
    }

    public void incrLogReadInBytes(long size) {
        this.logReadInBytesCounter.incr(size);
    }

    public void clear() {
    }

    public long getLastShippedAge() {
        return this.ageOfLastShippedOpHist.getMax();
    }

    public void incrHFilesShipped(long hfiles) {
        this.shippedHFilesCounter.incr(hfiles);
    }

    public void incrSizeOfHFileRefsQueue(long size) {
        this.sizeOfHFileRefsQueueGauge.incr(size);
    }

    public void decrSizeOfHFileRefsQueue(long size) {
        this.sizeOfHFileRefsQueueGauge.decr(size);
    }

    public int getSizeOfLogQueue() {
        return (int)this.sizeOfLogQueueGauge.value();
    }

    public void incrUnknownFileLengthForClosedWAL() {
        this.unknownFileLengthForClosedWAL.incr(1L);
    }

    public void incrUncleanlyClosedWALs() {
        this.uncleanlyClosedWAL.incr(1L);
    }

    public void incrBytesSkippedInUncleanlyClosedWALs(long bytes) {
        this.uncleanlyClosedSkippedBytes.incr(bytes);
    }

    public void incrRestartedWALReading() {
        this.restartWALReading.incr(1L);
    }

    public void incrRepeatedFileBytes(long bytes) {
        this.repeatedFileBytes.incr(bytes);
    }

    public void incrCompletedWAL() {
        this.completedWAL.incr(1L);
    }

    public void incrCompletedRecoveryQueue() {
        this.completedRecoveryQueue.incr(1L);
    }

    public void incrFailedRecoveryQueue() {
        this.failedRecoveryQueue.incr(1L);
    }

    public void init() {
        this.rms.init();
    }

    public void setGauge(String gaugeName, long value) {
        this.rms.setGauge(KEY_PREFIX + gaugeName, value);
    }

    public void incGauge(String gaugeName, long delta) {
        this.rms.incGauge(KEY_PREFIX + gaugeName, delta);
    }

    public void decGauge(String gaugeName, long delta) {
        this.rms.decGauge(KEY_PREFIX + gaugeName, delta);
    }

    public void removeMetric(String key) {
        this.rms.removeMetric(KEY_PREFIX + key);
    }

    public void incCounters(String counterName, long delta) {
        this.rms.incCounters(KEY_PREFIX + counterName, delta);
    }

    public void updateHistogram(String name, long value) {
        this.rms.updateHistogram(KEY_PREFIX + name, value);
    }

    public String getMetricsContext() {
        return this.rms.getMetricsContext();
    }

    public String getMetricsDescription() {
        return this.rms.getMetricsDescription();
    }

    public String getMetricsJmxContext() {
        return this.rms.getMetricsJmxContext();
    }

    public String getMetricsName() {
        return this.rms.getMetricsName();
    }

    public long getWALEditsRead() {
        return this.logReadInEditsCounter.value();
    }

    public long getShippedOps() {
        return this.shippedOpsCounter.value();
    }

    public long getEditsFiltered() {
        return this.walEditsFilteredCounter.value();
    }

    public void setWALReaderEditsBufferBytes(long usage) {
        this.walReaderBufferUsageBytes.set(usage);
    }

    public long getWALReaderEditsBufferBytes() {
        return this.walReaderBufferUsageBytes.value();
    }
}

