/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.executor.ExecutorService;
import org.apache.hadoop.hbase.ipc.PayloadCarryingRpcController;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.quotas.RegionServerQuotaManager;
import org.apache.hadoop.hbase.regionserver.CompactionRequestor;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HeapMemoryManager;
import org.apache.hadoop.hbase.regionserver.Leases;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

class MockRegionServer
implements AdminProtos.AdminService.BlockingInterface,
ClientProtos.ClientService.BlockingInterface,
RegionServerServices {
    private final ServerName sn;
    private final ZooKeeperWatcher zkw;
    private final Configuration conf;
    private final Random random = new Random();
    private final Map<byte[], Map<byte[], Result>> gets = new TreeMap<byte[], Map<byte[], Result>>(Bytes.BYTES_COMPARATOR);
    private final Map<byte[], Result[]> nexts = new TreeMap<byte[], Result[]>(Bytes.BYTES_COMPARATOR);
    private final Map<Long, RegionNameAndIndex> scannersAndOffsets = new HashMap<Long, RegionNameAndIndex>();

    MockRegionServer(Configuration conf, ServerName sn) throws ZooKeeperConnectionException, IOException {
        this.sn = sn;
        this.conf = conf;
        this.zkw = new ZooKeeperWatcher(conf, sn.toString(), (Abortable)this, true);
    }

    void setGetResult(byte[] regionName, byte[] row, Result r) {
        Map<byte[], Result> value = this.gets.get(regionName);
        if (value == null) {
            value = new TreeMap<byte[], Result>(Bytes.BYTES_COMPARATOR);
            this.gets.put(regionName, value);
        }
        value.put(row, r);
    }

    void setNextResults(byte[] regionName, Result[] rs) {
        this.nexts.put(regionName, rs);
    }

    public boolean isStopped() {
        return false;
    }

    public void abort(String why, Throwable e) {
        throw new RuntimeException(this.sn + ": " + why, e);
    }

    public boolean isAborted() {
        return false;
    }

    public long openScanner(byte[] regionName, Scan scan) throws IOException {
        long scannerId = this.random.nextLong();
        this.scannersAndOffsets.put(scannerId, new RegionNameAndIndex(regionName));
        return scannerId;
    }

    public Result next(long scannerId) throws IOException {
        RegionNameAndIndex rnai = this.scannersAndOffsets.get(scannerId);
        int index = rnai.getThenIncrement();
        Result[] results = this.nexts.get(rnai.getRegionName());
        if (results == null) {
            return null;
        }
        return index < results.length ? results[index] : null;
    }

    public Result[] next(long scannerId, int numberOfRows) throws IOException {
        Result[] resultArray;
        Result r = this.next(scannerId);
        if (r == null) {
            resultArray = null;
        } else {
            Result[] resultArray2 = new Result[1];
            resultArray = resultArray2;
            resultArray2[0] = r;
        }
        return resultArray;
    }

    public void close(long scannerId) throws IOException {
        this.scannersAndOffsets.remove(scannerId);
    }

    public void stop(String why) {
        this.zkw.close();
    }

    public void addToOnlineRegions(Region r) {
    }

    public boolean removeFromOnlineRegions(Region r, ServerName destination) {
        return false;
    }

    public HRegion getFromOnlineRegions(String encodedRegionName) {
        return null;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public ZooKeeperWatcher getZooKeeper() {
        return this.zkw;
    }

    public CoordinatedStateManager getCoordinatedStateManager() {
        return null;
    }

    public ClusterConnection getConnection() {
        return null;
    }

    public MetaTableLocator getMetaTableLocator() {
        return null;
    }

    public ServerName getServerName() {
        return this.sn;
    }

    public boolean isStopping() {
        return false;
    }

    public CompactionRequestor getCompactionRequester() {
        return null;
    }

    public FlushRequester getFlushRequester() {
        return null;
    }

    public RegionServerAccounting getRegionServerAccounting() {
        return null;
    }

    public TableLockManager getTableLockManager() {
        return new TableLockManager.NullTableLockManager();
    }

    public RegionServerQuotaManager getRegionServerQuotaManager() {
        return null;
    }

    public void postOpenDeployTasks(Region r) throws KeeperException, IOException {
    }

    public void postOpenDeployTasks(RegionServerServices.PostOpenDeployContext context) throws KeeperException, IOException {
    }

    public RpcServerInterface getRpcServer() {
        return null;
    }

    public ConcurrentSkipListMap<byte[], Boolean> getRegionsInTransitionInRS() {
        return null;
    }

    public FileSystem getFileSystem() {
        return null;
    }

    public ClientProtos.GetResponse get(RpcController controller, ClientProtos.GetRequest request) throws ServiceException {
        byte[] regionName = request.getRegion().getValue().toByteArray();
        Map<byte[], Result> m = this.gets.get(regionName);
        ClientProtos.GetResponse.Builder builder = ClientProtos.GetResponse.newBuilder();
        if (m != null) {
            byte[] row = request.getGet().getRow().toByteArray();
            builder.setResult(ProtobufUtil.toResult((Result)m.get(row)));
        }
        return builder.build();
    }

    public ClientProtos.MutateResponse mutate(RpcController controller, ClientProtos.MutateRequest request) throws ServiceException {
        return null;
    }

    public ClientProtos.ScanResponse scan(RpcController controller, ClientProtos.ScanRequest request) throws ServiceException {
        ClientProtos.ScanResponse.Builder builder = ClientProtos.ScanResponse.newBuilder();
        try {
            if (request.hasScan()) {
                byte[] regionName = request.getRegion().getValue().toByteArray();
                builder.setScannerId(this.openScanner(regionName, null));
                builder.setMoreResults(true);
            } else {
                long scannerId = request.getScannerId();
                Result result = this.next(scannerId);
                if (result != null) {
                    builder.addCellsPerResult(result.size());
                    ArrayList<Result> results = new ArrayList<Result>(1);
                    results.add(result);
                    ((PayloadCarryingRpcController)controller).setCellScanner(CellUtil.createCellScanner(results));
                    builder.setMoreResults(true);
                } else {
                    builder.setMoreResults(false);
                    this.close(scannerId);
                }
            }
        }
        catch (IOException ie) {
            throw new ServiceException((Throwable)ie);
        }
        return builder.build();
    }

    public ClientProtos.BulkLoadHFileResponse bulkLoadHFile(RpcController controller, ClientProtos.BulkLoadHFileRequest request) throws ServiceException {
        return null;
    }

    public ClientProtos.CoprocessorServiceResponse execService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        return null;
    }

    public ClientProtos.MultiResponse multi(RpcController controller, ClientProtos.MultiRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.GetRegionInfoResponse getRegionInfo(RpcController controller, AdminProtos.GetRegionInfoRequest request) throws ServiceException {
        AdminProtos.GetRegionInfoResponse.Builder builder = AdminProtos.GetRegionInfoResponse.newBuilder();
        builder.setRegionInfo(HRegionInfo.convert((HRegionInfo)HRegionInfo.FIRST_META_REGIONINFO));
        return builder.build();
    }

    public AdminProtos.GetStoreFileResponse getStoreFile(RpcController controller, AdminProtos.GetStoreFileRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.GetOnlineRegionResponse getOnlineRegion(RpcController controller, AdminProtos.GetOnlineRegionRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.OpenRegionResponse openRegion(RpcController controller, AdminProtos.OpenRegionRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.WarmupRegionResponse warmupRegion(RpcController controller, AdminProtos.WarmupRegionRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.CloseRegionResponse closeRegion(RpcController controller, AdminProtos.CloseRegionRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.FlushRegionResponse flushRegion(RpcController controller, AdminProtos.FlushRegionRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.SplitRegionResponse splitRegion(RpcController controller, AdminProtos.SplitRegionRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.MergeRegionsResponse mergeRegions(RpcController controller, AdminProtos.MergeRegionsRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.CompactRegionResponse compactRegion(RpcController controller, AdminProtos.CompactRegionRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.ReplicateWALEntryResponse replicateWALEntry(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.RollWALWriterResponse rollWALWriter(RpcController controller, AdminProtos.RollWALWriterRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.GetServerInfoResponse getServerInfo(RpcController controller, AdminProtos.GetServerInfoRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.StopServerResponse stopServer(RpcController controller, AdminProtos.StopServerRequest request) throws ServiceException {
        return null;
    }

    public List<Region> getOnlineRegions(TableName tableName) throws IOException {
        return null;
    }

    public Set<TableName> getOnlineTables() {
        return null;
    }

    public Leases getLeases() {
        return null;
    }

    public WAL getWAL(HRegionInfo regionInfo) throws IOException {
        return null;
    }

    public ExecutorService getExecutorService() {
        return null;
    }

    public ChoreService getChoreService() {
        return null;
    }

    public void updateRegionFavoredNodesMapping(String encodedRegionName, List<HBaseProtos.ServerName> favoredNodes) {
    }

    public InetSocketAddress[] getFavoredNodesForRegion(String encodedRegionName) {
        return null;
    }

    public AdminProtos.ReplicateWALEntryResponse replay(RpcController controller, AdminProtos.ReplicateWALEntryRequest request) throws ServiceException {
        return null;
    }

    public Map<String, Region> getRecoveringRegions() {
        return null;
    }

    public AdminProtos.UpdateFavoredNodesResponse updateFavoredNodes(RpcController controller, AdminProtos.UpdateFavoredNodesRequest request) throws ServiceException {
        return null;
    }

    public ServerNonceManager getNonceManager() {
        return null;
    }

    public boolean reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, HRegionInfo ... hris) {
        return false;
    }

    public boolean reportRegionStateTransition(RegionServerStatusProtos.RegionStateTransition.TransitionCode code, long openSeqNum, HRegionInfo ... hris) {
        return false;
    }

    public boolean reportRegionStateTransition(RegionServerServices.RegionStateTransitionContext context) {
        return false;
    }

    public boolean registerService(Service service) {
        return false;
    }

    public ClientProtos.CoprocessorServiceResponse execRegionServerService(RpcController controller, ClientProtos.CoprocessorServiceRequest request) throws ServiceException {
        return null;
    }

    public AdminProtos.UpdateConfigurationResponse updateConfiguration(RpcController controller, AdminProtos.UpdateConfigurationRequest request) throws ServiceException {
        return null;
    }

    public HeapMemoryManager getHeapMemoryManager() {
        return null;
    }

    public double getCompactionPressure() {
        return 0.0;
    }

    class RegionNameAndIndex {
        private final byte[] regionName;
        private int index = 0;

        RegionNameAndIndex(byte[] regionName) {
            this.regionName = regionName;
        }

        byte[] getRegionName() {
            return this.regionName;
        }

        int getThenIncrement() {
            int currentIndex = this.index++;
            return currentIndex;
        }
    }
}

