/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.MiniHBaseCluster;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.RegionStates;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.util.StringUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestMaster {
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static final Log LOG = LogFactory.getLog(TestMaster.class);
    private static final TableName TABLENAME = TableName.valueOf((String)"TestMaster");
    private static final byte[] FAMILYNAME = Bytes.toBytes((String)"fam");
    private static Admin admin;

    @BeforeClass
    public static void beforeAllTests() throws Exception {
        TEST_UTIL.getConfiguration().setInt("hbase.client.retries.number", 3);
        TEST_UTIL.startMiniCluster(2);
        admin = TEST_UTIL.getHBaseAdmin();
        TestMaster.TEST_UTIL.getHBaseCluster().getMaster().assignmentManager.initializeHandlerTrackers();
    }

    @AfterClass
    public static void afterAllTests() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMasterOpsWhileSplitting() throws Exception {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        try (HTable ht = TEST_UTIL.createTable(TABLENAME, FAMILYNAME);){
            Assert.assertTrue((boolean)m.assignmentManager.getTableStateManager().isTableState(TABLENAME, new ZooKeeperProtos.Table.State[]{ZooKeeperProtos.Table.State.ENABLED}));
            TEST_UTIL.loadTable((Table)ht, FAMILYNAME, false);
        }
        List tableRegions = MetaTableAccessor.getTableRegionsAndLocations((ZooKeeperWatcher)m.getZooKeeper(), (Connection)m.getConnection(), (TableName)TABLENAME);
        LOG.info((Object)("Regions after load: " + Joiner.on((char)',').join((Iterable)tableRegions)));
        Assert.assertEquals((long)1L, (long)tableRegions.size());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_START_ROW, (byte[])((HRegionInfo)((Pair)tableRegions.get(0)).getFirst()).getStartKey());
        Assert.assertArrayEquals((byte[])HConstants.EMPTY_END_ROW, (byte[])((HRegionInfo)((Pair)tableRegions.get(0)).getFirst()).getEndKey());
        LOG.info((Object)"Splitting table");
        TEST_UTIL.getHBaseAdmin().split(TABLENAME);
        LOG.info((Object)"Waiting for split result to be about to open");
        RegionStates regionStates = m.assignmentManager.getRegionStates();
        while (regionStates.getRegionsOfTable(TABLENAME).size() <= 1) {
            Thread.sleep(100L);
        }
        LOG.info((Object)"Making sure we can call getTableRegions while opening");
        tableRegions = MetaTableAccessor.getTableRegionsAndLocations((ZooKeeperWatcher)m.getZooKeeper(), (Connection)m.getConnection(), (TableName)TABLENAME, (boolean)false);
        LOG.info((Object)("Regions: " + Joiner.on((char)',').join((Iterable)tableRegions)));
        Assert.assertEquals((long)3L, (long)tableRegions.size());
        LOG.info((Object)"Making sure we can call getTableRegionClosest while opening");
        Pair pair = m.getTableRegionForRow(TABLENAME, Bytes.toBytes((String)"cde"));
        LOG.info((Object)("Result is: " + pair));
        Pair tableRegionFromName = MetaTableAccessor.getRegion((Connection)m.getConnection(), (byte[])((HRegionInfo)pair.getFirst()).getRegionName());
        Assert.assertEquals((Object)tableRegionFromName.getFirst(), (Object)pair.getFirst());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveRegionWhenNotInitialized() {
        MiniHBaseCluster cluster = TEST_UTIL.getHBaseCluster();
        HMaster m = cluster.getMaster();
        try {
            m.initialized = false;
            HRegionInfo meta = HRegionInfo.FIRST_META_REGIONINFO;
            m.move(meta.getEncodedNameAsBytes(), null);
            Assert.fail((String)"Region should not be moved since master is not initialized");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe instanceof PleaseHoldException));
        }
        finally {
            m.initialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveThrowsUnknownRegionException() throws IOException {
        TableName tableName = TableName.valueOf((String)"testMoveThrowsUnknownRegionException");
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor("value");
        htd.addFamily(hcd);
        admin.createTable(htd, (byte[][])null);
        try {
            HRegionInfo hri = new HRegionInfo(tableName, Bytes.toBytes((String)"A"), Bytes.toBytes((String)"Z"));
            admin.move(hri.getEncodedNameAsBytes(), null);
            Assert.fail((String)"Region should not be moved since it is fake");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)(ioe instanceof UnknownRegionException));
        }
        finally {
            TEST_UTIL.deleteTable(tableName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMoveThrowsPleaseHoldException() throws IOException {
        TableName tableName = TableName.valueOf((String)"testMoveThrowsPleaseHoldException");
        HMaster master = TEST_UTIL.getMiniHBaseCluster().getMaster();
        HTableDescriptor htd = new HTableDescriptor(tableName);
        HColumnDescriptor hcd = new HColumnDescriptor("value");
        htd.addFamily(hcd);
        admin.createTable(htd, (byte[][])null);
        try {
            List tableRegions = admin.getTableRegions(tableName);
            master.initialized = false;
            admin.move(((HRegionInfo)tableRegions.get(0)).getEncodedNameAsBytes(), null);
            Assert.fail((String)"Region should not be moved since master is not initialized");
        }
        catch (IOException ioe) {
            Assert.assertTrue((boolean)StringUtils.stringifyException((Throwable)ioe).contains("PleaseHoldException"));
        }
        finally {
            master.initialized = true;
            TEST_UTIL.deleteTable(tableName);
        }
    }
}

