/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.security.token;

import com.google.protobuf.BlockingRpcChannel;
import com.google.protobuf.BlockingService;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.ServiceException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.ChoreService;
import org.apache.hadoop.hbase.ClusterId;
import org.apache.hadoop.hbase.CoordinatedStateManager;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.ipc.BlockingRpcCallback;
import org.apache.hadoop.hbase.ipc.FifoRpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcClient;
import org.apache.hadoop.hbase.ipc.RpcClientFactory;
import org.apache.hadoop.hbase.ipc.RpcScheduler;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.ipc.RpcServerInterface;
import org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hadoop.hbase.protobuf.generated.AuthenticationProtos;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.security.SecurityInfo;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenIdentifier;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSecretManager;
import org.apache.hadoop.hbase.security.token.AuthenticationTokenSelector;
import org.apache.hadoop.hbase.security.token.TokenProvider;
import org.apache.hadoop.hbase.security.token.TokenUtil;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.Sleeper;
import org.apache.hadoop.hbase.util.Strings;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hadoop.hbase.zookeeper.ZKClusterId;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.net.DNS;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.PolicyProvider;
import org.apache.hadoop.security.authorize.Service;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.security.token.TokenIdentifier;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class})
public class TestTokenAuthentication {
    private static Log LOG;
    private static HBaseTestingUtility TEST_UTIL;
    private static TokenServer server;
    private static Thread serverThread;
    private static AuthenticationTokenSecretManager secretManager;
    private static ClusterId clusterId;

    @BeforeClass
    public static void setupBeforeClass() throws Exception {
        TEST_UTIL = new HBaseTestingUtility();
        TEST_UTIL.startMiniZKCluster();
        SecurityInfo.addInfo((String)AuthenticationProtos.AuthenticationService.getDescriptor().getName(), (SecurityInfo)new SecurityInfo("hbase.test.kerberos.principal", AuthenticationProtos.TokenIdentifier.Kind.HBASE_AUTH_TOKEN));
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.set("hadoop.security.authentication", "kerberos");
        conf.set("hbase.security.authentication", "kerberos");
        conf.setBoolean("hadoop.security.authorization", true);
        server = new TokenServer(conf);
        serverThread = new Thread(server);
        Threads.setDaemonThreadRunning((Thread)serverThread, (String)("TokenServer:" + server.getServerName().toString()));
        while (!server.isStarted() && !server.isStopped()) {
            Thread.sleep(10L);
        }
        server.rpcServer.refreshAuthManager(new PolicyProvider(){

            public Service[] getServices() {
                return new Service[]{new Service("security.client.protocol.acl", AuthenticationProtos.AuthenticationService.BlockingInterface.class)};
            }
        });
        ZKClusterId.setClusterId((ZooKeeperWatcher)server.getZooKeeper(), (ClusterId)clusterId);
        secretManager = (AuthenticationTokenSecretManager)server.getSecretManager();
        while (secretManager.getCurrentKey() == null) {
            Thread.sleep(1L);
        }
    }

    @AfterClass
    public static void tearDownAfterClass() throws Exception {
        server.stop("Test complete");
        Threads.shutdown((Thread)serverThread);
        TEST_UTIL.shutdownMiniZKCluster();
    }

    @Test
    public void testTokenCreation() throws Exception {
        Token token = secretManager.generateToken("testuser");
        AuthenticationTokenIdentifier ident = new AuthenticationTokenIdentifier();
        Writables.getWritable((byte[])token.getIdentifier(), (Writable)ident);
        Assert.assertEquals((String)"Token username should match", (Object)"testuser", (Object)ident.getUsername());
        byte[] passwd = secretManager.retrievePassword(ident);
        Assert.assertTrue((String)"Token password and password from secret manager should match", (boolean)Bytes.equals((byte[])token.getPassword(), (byte[])passwd));
    }

    @Test
    public void testTokenAuthentication() throws Exception {
        UserGroupInformation testuser = UserGroupInformation.createUserForTesting((String)"testuser", (String[])new String[]{"testgroup"});
        testuser.setAuthenticationMethod(UserGroupInformation.AuthenticationMethod.TOKEN);
        Configuration conf = TEST_UTIL.getConfiguration();
        UserGroupInformation.setConfiguration((Configuration)conf);
        Token token = secretManager.generateToken("testuser");
        LOG.debug((Object)("Got token: " + token.toString()));
        testuser.addToken(token);
        testuser.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object run() throws Exception {
                Configuration c = server.getConfiguration();
                ServerName sn = ServerName.valueOf((String)server.getAddress().getHostName(), (int)server.getAddress().getPort(), (long)System.currentTimeMillis());
                try (RpcClient rpcClient = RpcClientFactory.createClient((Configuration)c, (String)clusterId.toString());){
                    BlockingRpcChannel channel = rpcClient.createBlockingRpcChannel(sn, User.getCurrent(), 60000);
                    AuthenticationProtos.AuthenticationService.BlockingInterface stub = AuthenticationProtos.AuthenticationService.newBlockingStub((BlockingRpcChannel)channel);
                    AuthenticationProtos.WhoAmIResponse response = stub.whoAmI(null, AuthenticationProtos.WhoAmIRequest.getDefaultInstance());
                    String myname = response.getUsername();
                    Assert.assertEquals((Object)"testuser", (Object)myname);
                    String authMethod = response.getAuthMethod();
                    Assert.assertEquals((Object)"TOKEN", (Object)authMethod);
                }
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUseExistingToken() throws Exception {
        User user = User.createUserForTesting((Configuration)TEST_UTIL.getConfiguration(), (String)"testuser2", (String[])new String[]{"testgroup"});
        Token token = secretManager.generateToken(user.getName());
        Assert.assertNotNull((Object)token);
        user.addToken(token);
        Token firstToken = new AuthenticationTokenSelector().selectToken(token.getService(), user.getTokens());
        Assert.assertNotNull((Object)firstToken);
        Assert.assertEquals((Object)token, (Object)firstToken);
        try (Connection conn = ConnectionFactory.createConnection((Configuration)TEST_UTIL.getConfiguration());){
            Assert.assertFalse((boolean)TokenUtil.addTokenIfMissing((Connection)conn, (User)user));
            Token secondToken = new AuthenticationTokenSelector().selectToken(token.getService(), user.getTokens());
            Assert.assertEquals((Object)firstToken, (Object)secondToken);
        }
    }

    static {
        System.setProperty("java.security.krb5.realm", "hbase");
        System.setProperty("java.security.krb5.kdc", "blah");
        LOG = LogFactory.getLog(TestTokenAuthentication.class);
        clusterId = new ClusterId();
    }

    private static class TokenServer
    extends TokenProvider
    implements AuthenticationProtos.AuthenticationService.BlockingInterface,
    Runnable,
    Server {
        private static Log LOG = LogFactory.getLog(TokenServer.class);
        private Configuration conf;
        private RpcServerInterface rpcServer;
        private InetSocketAddress isa;
        private ZooKeeperWatcher zookeeper;
        private Sleeper sleeper;
        private boolean started = false;
        private boolean aborted = false;
        private boolean stopped = false;
        private long startcode;

        public TokenServer(Configuration conf) throws IOException {
            this.conf = conf;
            this.startcode = EnvironmentEdgeManager.currentTime();
            String hostname = Strings.domainNamePointerToHostName((String)DNS.getDefaultHost((String)"default", (String)"default"));
            int port = 0;
            InetSocketAddress initialIsa = new InetSocketAddress(hostname, port);
            if (initialIsa.getAddress() == null) {
                throw new IllegalArgumentException("Failed resolve of " + initialIsa);
            }
            ArrayList<RpcServer.BlockingServiceAndInterface> sai = new ArrayList<RpcServer.BlockingServiceAndInterface>(1);
            BlockingService service = AuthenticationProtos.AuthenticationService.newReflectiveBlockingService((AuthenticationProtos.AuthenticationService.BlockingInterface)this);
            sai.add(new RpcServer.BlockingServiceAndInterface(service, AuthenticationProtos.AuthenticationService.BlockingInterface.class));
            this.rpcServer = new RpcServer((Server)this, "tokenServer", sai, initialIsa, conf, (RpcScheduler)new FifoRpcScheduler(conf, 1));
            InetSocketAddress address = this.rpcServer.getListenerAddress();
            if (address == null) {
                throw new IOException("Listener channel is closed");
            }
            this.isa = address;
            this.sleeper = new Sleeper(1000, (Stoppable)this);
        }

        public Configuration getConfiguration() {
            return this.conf;
        }

        public ClusterConnection getConnection() {
            return null;
        }

        public MetaTableLocator getMetaTableLocator() {
            return null;
        }

        public ZooKeeperWatcher getZooKeeper() {
            return this.zookeeper;
        }

        public CoordinatedStateManager getCoordinatedStateManager() {
            return null;
        }

        public boolean isAborted() {
            return this.aborted;
        }

        public ServerName getServerName() {
            return ServerName.valueOf((String)this.isa.getHostName(), (int)this.isa.getPort(), (long)this.startcode);
        }

        public void abort(String reason, Throwable error) {
            LOG.fatal((Object)("Aborting on: " + reason), error);
            this.aborted = true;
            this.stopped = true;
            this.sleeper.skipSleepCycle();
        }

        private void initialize() throws IOException {
            Configuration zkConf = new Configuration(this.conf);
            zkConf.set("hbase.security.authentication", "simple");
            this.zookeeper = new ZooKeeperWatcher(zkConf, TokenServer.class.getSimpleName(), (Abortable)this, true);
            this.rpcServer.start();
            final RegionServerServices mockServices = TEST_UTIL.createMockRegionServerService(this.rpcServer);
            super.start((CoprocessorEnvironment)new RegionCoprocessorEnvironment(){

                public HRegion getRegion() {
                    return null;
                }

                public RegionServerServices getRegionServerServices() {
                    return mockServices;
                }

                public ConcurrentMap<String, Object> getSharedData() {
                    return null;
                }

                public int getVersion() {
                    return 0;
                }

                public String getHBaseVersion() {
                    return null;
                }

                public Coprocessor getInstance() {
                    return null;
                }

                public int getPriority() {
                    return 0;
                }

                public int getLoadSequence() {
                    return 0;
                }

                public Configuration getConfiguration() {
                    return TokenServer.this.conf;
                }

                public HTableInterface getTable(TableName tableName) throws IOException {
                    return null;
                }

                public HTableInterface getTable(TableName tableName, ExecutorService service) throws IOException {
                    return null;
                }

                public ClassLoader getClassLoader() {
                    return Thread.currentThread().getContextClassLoader();
                }

                public HRegionInfo getRegionInfo() {
                    return null;
                }
            });
            this.started = true;
        }

        @Override
        public void run() {
            try {
                this.initialize();
                while (!this.stopped) {
                    this.sleeper.sleep();
                }
            }
            catch (Exception e) {
                this.abort(e.getMessage(), e);
            }
            this.rpcServer.stop();
        }

        public boolean isStarted() {
            return this.started;
        }

        public void stop(String reason) {
            LOG.info((Object)("Stopping due to: " + reason));
            this.stopped = true;
            this.sleeper.skipSleepCycle();
        }

        public boolean isStopped() {
            return this.stopped;
        }

        public InetSocketAddress getAddress() {
            return this.isa;
        }

        public SecretManager<? extends TokenIdentifier> getSecretManager() {
            return ((RpcServer)this.rpcServer).getSecretManager();
        }

        public AuthenticationProtos.GetAuthenticationTokenResponse getAuthenticationToken(RpcController controller, AuthenticationProtos.GetAuthenticationTokenRequest request) throws ServiceException {
            LOG.debug((Object)("Authentication token request from " + RpcServer.getRequestUserName()));
            ServerRpcController serverController = new ServerRpcController();
            BlockingRpcCallback callback = new BlockingRpcCallback();
            this.getAuthenticationToken((RpcController)serverController, request, (RpcCallback)callback);
            try {
                serverController.checkFailed();
                return (AuthenticationProtos.GetAuthenticationTokenResponse)callback.get();
            }
            catch (IOException ioe) {
                throw new ServiceException((Throwable)ioe);
            }
        }

        public AuthenticationProtos.WhoAmIResponse whoAmI(RpcController controller, AuthenticationProtos.WhoAmIRequest request) throws ServiceException {
            LOG.debug((Object)("whoAmI() request from " + RpcServer.getRequestUserName()));
            ServerRpcController serverController = new ServerRpcController();
            BlockingRpcCallback callback = new BlockingRpcCallback();
            this.whoAmI((RpcController)serverController, request, (RpcCallback)callback);
            try {
                serverController.checkFailed();
                return (AuthenticationProtos.WhoAmIResponse)callback.get();
            }
            catch (IOException ioe) {
                throw new ServiceException((Throwable)ioe);
            }
        }

        public ChoreService getChoreService() {
            return null;
        }
    }

    public static interface AuthenticationServiceSecurityInfo {
    }
}

