/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Closeables;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import com.google.protobuf.TextFormat;
import java.io.Closeable;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.CompoundConfiguration;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.RegionTooBusyException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.Tag;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.backup.HFileArchiver;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RowMutations;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.conf.ConfigurationManager;
import org.apache.hadoop.hbase.conf.PropagatingConfigurationObserver;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.errorhandling.ForeignExceptionSnare;
import org.apache.hadoop.hbase.exceptions.FailedSanityCheckException;
import org.apache.hadoop.hbase.exceptions.RegionInRecoveryException;
import org.apache.hadoop.hbase.exceptions.UnknownProtocolException;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.FilterWrapper;
import org.apache.hadoop.hbase.filter.IncompatibleFilterException;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.ipc.CallerDisconnectedException;
import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.monitoring.MonitoredTask;
import org.apache.hadoop.hbase.monitoring.TaskMonitor;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.protobuf.generated.ClusterStatusProtos;
import org.apache.hadoop.hbase.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.protobuf.generated.WALProtos;
import org.apache.hadoop.hbase.regionserver.FlushPolicy;
import org.apache.hadoop.hbase.regionserver.FlushPolicyFactory;
import org.apache.hadoop.hbase.regionserver.HRegionFileSystem;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MetricsRegion;
import org.apache.hadoop.hbase.regionserver.MetricsRegionWrapperImpl;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.MultiRowMutationProcessor;
import org.apache.hadoop.hbase.regionserver.MultiVersionConsistencyControl;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.OperationStatus;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.RegionMergeTransactionImpl;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerAccounting;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.RegionSplitPolicy;
import org.apache.hadoop.hbase.regionserver.ReversedRegionScannerImpl;
import org.apache.hadoop.hbase.regionserver.RowProcessor;
import org.apache.hadoop.hbase.regionserver.ScannerContext;
import org.apache.hadoop.hbase.regionserver.ServerNonceManager;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFlushContext;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionContext;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionThroughputControllerFactory;
import org.apache.hadoop.hbase.regionserver.compactions.NoLimitCompactionThroughputController;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.MetricsWAL;
import org.apache.hadoop.hbase.regionserver.wal.ReplayHLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.regionserver.wal.WALUtil;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.snapshot.SnapshotManifest;
import org.apache.hadoop.hbase.util.ByteStringer;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.CompressionTest;
import org.apache.hadoop.hbase.util.Counter;
import org.apache.hadoop.hbase.util.EncryptionTest;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSTableDescriptors;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.HashedBytes;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.util.ServerRegionReplicaUtil;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALFactory;
import org.apache.hadoop.hbase.wal.WALKey;
import org.apache.hadoop.hbase.wal.WALSplitter;
import org.apache.hadoop.io.MultipleIOException;
import org.apache.hadoop.util.StringUtils;
import org.apache.htrace.Trace;
import org.apache.htrace.TraceScope;

@InterfaceAudience.Private
public class HRegion
implements HeapSize,
PropagatingConfigurationObserver,
Region {
    public static final Log LOG = LogFactory.getLog(HRegion.class);
    public static final String LOAD_CFS_ON_DEMAND_CONFIG_KEY = "hbase.hregion.scan.loadColumnFamiliesOnDemand";
    private final int maxWaitForSeqId;
    private static final String MAX_WAIT_FOR_SEQ_ID_KEY = "hbase.hregion.max.wait.for.sequenceid.ms";
    private static final int DEFAULT_MAX_WAIT_FOR_SEQ_ID = 30000;
    private static final Durability DEFAULT_DURABILITY = Durability.SYNC_WAL;
    final AtomicBoolean closed = new AtomicBoolean(false);
    final AtomicBoolean closing = new AtomicBoolean(false);
    private volatile long maxFlushedSeqId = -1L;
    private volatile long lastFlushOpSeqId = -1L;
    private final AtomicLong sequenceId = new AtomicLong(-1L);
    protected volatile long lastReplayedOpenRegionSeqId = -1L;
    protected volatile long lastReplayedCompactionSeqId = -1L;
    private final ConcurrentHashMap<HashedBytes, RowLockContext> lockedRows = new ConcurrentHashMap();
    protected final Map<byte[], Store> stores = new ConcurrentSkipListMap<byte[], Store>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
    private Map<String, Service> coprocessorServiceHandlers = Maps.newHashMap();
    public final AtomicLong memstoreSize = new AtomicLong(0L);
    final Counter numMutationsWithoutWAL = new Counter();
    final Counter dataInMemoryWithoutWAL = new Counter();
    final Counter checkAndMutateChecksPassed = new Counter();
    final Counter checkAndMutateChecksFailed = new Counter();
    final Counter readRequestsCount = new Counter();
    final Counter writeRequestsCount = new Counter();
    private final Counter blockedRequestsCount = new Counter();
    final AtomicLong compactionsFinished = new AtomicLong(0L);
    final AtomicLong compactionNumFilesCompacted = new AtomicLong(0L);
    final AtomicLong compactionNumBytesCompacted = new AtomicLong(0L);
    private final WAL wal;
    private final HRegionFileSystem fs;
    protected final Configuration conf;
    private final Configuration baseConf;
    private final KeyValue.KVComparator comparator;
    private final int rowLockWaitDuration;
    static final int DEFAULT_ROWLOCK_WAIT_DURATION = 30000;
    final long busyWaitDuration;
    static final long DEFAULT_BUSY_WAIT_DURATION = 60000L;
    final int maxBusyWaitMultiplier;
    final long maxBusyWaitDuration;
    static final long DEFAULT_ROW_PROCESSOR_TIMEOUT = 60000L;
    final ExecutorService rowProcessorExecutor = Executors.newCachedThreadPool();
    private final ConcurrentHashMap<RegionScanner, Long> scannerReadPoints;
    private long openSeqNum = -1L;
    private boolean isLoadingCfsOnDemandDefault = false;
    private final AtomicInteger majorInProgress = new AtomicInteger(0);
    private final AtomicInteger minorInProgress = new AtomicInteger(0);
    Map<byte[], Long> maxSeqIdInStores = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
    private PrepareFlushResult prepareFlushResult = null;
    private boolean disallowWritesInRecovering = false;
    private volatile boolean isRecovering = false;
    private volatile Optional<ConfigurationManager> configurationManager;
    final WriteState writestate = new WriteState();
    long memstoreFlushSize;
    final long timestampSlop;
    final long rowProcessorTimeout;
    private final ConcurrentMap<Store, Long> lastStoreFlushTimeMap = new ConcurrentHashMap<Store, Long>();
    final RegionServerServices rsServices;
    private RegionServerAccounting rsAccounting;
    private long flushCheckInterval;
    private long flushPerChanges;
    private long blockingMemStoreSize;
    final long threadWakeFrequency;
    final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock updatesLock = new ReentrantReadWriteLock();
    private boolean splitRequest;
    private byte[] explicitSplitPoint = null;
    private final MultiVersionConsistencyControl mvcc = new MultiVersionConsistencyControl();
    private RegionCoprocessorHost coprocessorHost;
    private HTableDescriptor htableDescriptor = null;
    private RegionSplitPolicy splitPolicy;
    private FlushPolicy flushPolicy;
    private final MetricsRegion metricsRegion;
    private final MetricsRegionWrapperImpl metricsRegionWrapper;
    private final Durability durability;
    private final boolean regionStatsEnabled;
    private final Object closeLock = new Object();
    public static final String MEMSTORE_PERIODIC_FLUSH_INTERVAL = "hbase.regionserver.optionalcacheflushinterval";
    public static final int DEFAULT_CACHE_FLUSH_INTERVAL = 3600000;
    public static final int META_CACHE_FLUSH_INTERVAL = 300000;
    public static final String MEMSTORE_FLUSH_PER_CHANGES = "hbase.regionserver.flush.per.changes";
    public static final long DEFAULT_FLUSH_PER_CHANGES = 30000000L;
    public static final long MAX_FLUSH_PER_CHANGES = 1000000000L;
    private static final byte[] FOR_UNIT_TESTS_ONLY = Bytes.toBytes((String)"ForUnitTestsOnly");
    public static final long FIXED_OVERHEAD = ClassSize.align((int)(ClassSize.OBJECT + ClassSize.ARRAY + 45 * ClassSize.REFERENCE + 12 + 112 + 5));
    public static final long DEEP_OVERHEAD = FIXED_OVERHEAD + (long)ClassSize.OBJECT + (long)(2 * ClassSize.ATOMIC_BOOLEAN) + (long)(3 * ClassSize.ATOMIC_LONG) + (long)(2 * ClassSize.CONCURRENT_HASHMAP) + WriteState.HEAP_SIZE + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + (long)(2 * ClassSize.REENTRANT_LOCK) + MultiVersionConsistencyControl.FIXED_SIZE + (long)ClassSize.TREEMAP + (long)(2 * ClassSize.ATOMIC_INTEGER);
    private static final List<Cell> MOCKED_LIST = new AbstractList<Cell>(){

        @Override
        public void add(int index, Cell element) {
        }

        @Override
        public boolean addAll(int index, Collection<? extends Cell> c) {
            return false;
        }

        @Override
        public KeyValue get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSmallestReadPoint() {
        long minimumReadPoint;
        ConcurrentHashMap<RegionScanner, Long> concurrentHashMap = this.scannerReadPoints;
        synchronized (concurrentHashMap) {
            minimumReadPoint = this.mvcc.memstoreReadPoint();
            for (Long readPoint : this.scannerReadPoints.values()) {
                if (readPoint >= minimumReadPoint) continue;
                minimumReadPoint = readPoint;
            }
        }
        return minimumReadPoint;
    }

    @Deprecated
    public HRegion(Path tableDir, WAL wal, FileSystem fs, Configuration confParam, HRegionInfo regionInfo, HTableDescriptor htd, RegionServerServices rsServices) {
        this(new HRegionFileSystem(confParam, fs, tableDir, regionInfo), wal, confParam, htd, rsServices);
    }

    public HRegion(HRegionFileSystem fs, WAL wal, Configuration confParam, HTableDescriptor htd, RegionServerServices rsServices) {
        if (htd == null) {
            throw new IllegalArgumentException("Need table descriptor");
        }
        if (confParam instanceof CompoundConfiguration) {
            throw new IllegalArgumentException("Need original base configuration");
        }
        this.comparator = fs.getRegionInfo().getComparator();
        this.wal = wal;
        this.fs = fs;
        this.baseConf = confParam;
        this.conf = new CompoundConfiguration().add(confParam).addStringMap(htd.getConfiguration()).addWritableMap(htd.getValues());
        this.flushCheckInterval = this.conf.getInt(MEMSTORE_PERIODIC_FLUSH_INTERVAL, 3600000);
        this.flushPerChanges = this.conf.getLong(MEMSTORE_FLUSH_PER_CHANGES, 30000000L);
        if (this.flushPerChanges > 1000000000L) {
            throw new IllegalArgumentException("hbase.regionserver.flush.per.changes can not exceed 1000000000");
        }
        this.rowLockWaitDuration = this.conf.getInt("hbase.rowlock.wait.duration", 30000);
        this.maxWaitForSeqId = this.conf.getInt(MAX_WAIT_FOR_SEQ_ID_KEY, 30000);
        this.isLoadingCfsOnDemandDefault = this.conf.getBoolean(LOAD_CFS_ON_DEMAND_CONFIG_KEY, true);
        this.htableDescriptor = htd;
        this.rsServices = rsServices;
        this.threadWakeFrequency = this.conf.getLong("hbase.server.thread.wakefrequency", 10000L);
        this.setHTableSpecificConf();
        this.scannerReadPoints = new ConcurrentHashMap();
        this.busyWaitDuration = this.conf.getLong("hbase.busy.wait.duration", 60000L);
        this.maxBusyWaitMultiplier = this.conf.getInt("hbase.busy.wait.multiplier.max", 2);
        if (this.busyWaitDuration * (long)this.maxBusyWaitMultiplier <= 0L) {
            throw new IllegalArgumentException("Invalid hbase.busy.wait.duration (" + this.busyWaitDuration + ") or hbase.busy.wait.multiplier.max (" + this.maxBusyWaitMultiplier + "). Their product should be positive");
        }
        this.maxBusyWaitDuration = this.conf.getLong("hbase.ipc.client.call.purge.timeout", 120000L);
        this.timestampSlop = this.conf.getLong("hbase.hregion.keyvalue.timestamp.slop.millisecs", Long.MAX_VALUE);
        this.rowProcessorTimeout = this.conf.getLong("hbase.hregion.row.processor.timeout", 60000L);
        Durability durability = this.durability = htd.getDurability() == Durability.USE_DEFAULT ? DEFAULT_DURABILITY : htd.getDurability();
        if (rsServices != null) {
            this.rsAccounting = this.rsServices.getRegionServerAccounting();
            this.coprocessorHost = new RegionCoprocessorHost(this, rsServices, this.conf);
            this.metricsRegionWrapper = new MetricsRegionWrapperImpl(this);
            this.metricsRegion = new MetricsRegion(this.metricsRegionWrapper);
            Map<String, Region> recoveringRegions = rsServices.getRecoveringRegions();
            String encodedName = this.getRegionInfo().getEncodedName();
            if (recoveringRegions != null && recoveringRegions.containsKey(encodedName)) {
                this.isRecovering = true;
                recoveringRegions.put(encodedName, this);
            }
        } else {
            this.metricsRegionWrapper = null;
            this.metricsRegion = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Instantiated " + this));
        }
        this.disallowWritesInRecovering = this.conf.getBoolean("hbase.regionserver.disallow.writes.when.recovering", false);
        this.configurationManager = Optional.absent();
        this.regionStatsEnabled = htd.getTableName().getNamespaceAsString().equals(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) ? false : this.conf.getBoolean("hbase.client.backpressure.enabled", false);
    }

    void setHTableSpecificConf() {
        if (this.htableDescriptor == null) {
            return;
        }
        long flushSize = this.htableDescriptor.getMemStoreFlushSize();
        if (flushSize <= 0L) {
            flushSize = this.conf.getLong("hbase.hregion.memstore.flush.size", 0x8000000L);
        }
        this.memstoreFlushSize = flushSize;
        this.blockingMemStoreSize = this.memstoreFlushSize * this.conf.getLong("hbase.hregion.memstore.block.multiplier", 4L);
    }

    @Deprecated
    public long initialize() throws IOException {
        return this.initialize(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long initialize(CancelableProgressable reporter) throws IOException {
        MonitoredTask status = TaskMonitor.get().createStatus("Initializing region " + this);
        long nextSeqId = -1L;
        try {
            long l = nextSeqId = this.initializeRegionInternals(reporter, status);
            return l;
        }
        finally {
            if (nextSeqId == -1L) {
                status.abort("Exception during region " + this.getRegionInfo().getRegionNameAsString() + " initialization.");
            }
        }
    }

    private long initializeRegionInternals(CancelableProgressable reporter, MonitoredTask status) throws IOException {
        long maxSeqId;
        if (this.coprocessorHost != null) {
            status.setStatus("Running coprocessor pre-open hook");
            this.coprocessorHost.preOpen();
        }
        status.setStatus("Writing region info on filesystem");
        this.fs.checkRegionInfoOnFilesystem();
        status.setStatus("Initializing all the Stores");
        this.lastReplayedOpenRegionSeqId = maxSeqId = this.initializeRegionStores(reporter, status, false);
        this.writestate.setReadOnly(ServerRegionReplicaUtil.isReadOnly(this));
        this.writestate.flushRequested = false;
        this.writestate.compacting = 0;
        if (this.writestate.writesEnabled) {
            status.setStatus("Cleaning up temporary data from old regions");
            this.fs.cleanupTempDir();
        }
        if (this.writestate.writesEnabled) {
            status.setStatus("Cleaning up detritus from prior splits");
            this.fs.cleanupAnySplitDetritus();
            this.fs.cleanupMergesDir();
        }
        this.splitPolicy = RegionSplitPolicy.create(this, this.conf);
        this.flushPolicy = FlushPolicyFactory.create(this, this.conf);
        long lastFlushTime = EnvironmentEdgeManager.currentTime();
        for (Store store : this.stores.values()) {
            this.lastStoreFlushTimeMap.put(store, lastFlushTime);
        }
        long nextSeqid = maxSeqId;
        nextSeqid = this.writestate.writesEnabled ? WALSplitter.writeRegionSequenceIdFile(this.fs.getFileSystem(), this.fs.getRegionDir(), nextSeqid, this.isRecovering ? this.flushPerChanges + 10000000L : 1L) : ++nextSeqid;
        LOG.info((Object)("Onlined " + this.getRegionInfo().getShortNameToLog() + "; next sequenceid=" + nextSeqid));
        this.closing.set(false);
        this.closed.set(false);
        if (this.coprocessorHost != null) {
            status.setStatus("Running coprocessor post-open hooks");
            this.coprocessorHost.postOpen();
        }
        status.markComplete("Region opened successfully");
        return nextSeqid;
    }

    private long initializeRegionStores(CancelableProgressable reporter, MonitoredTask status, boolean warmupOnly) throws IOException {
        long maxSeqId = -1L;
        long maxMemstoreTS = -1L;
        if (!this.htableDescriptor.getFamilies().isEmpty()) {
            ThreadPoolExecutor storeOpenerThreadPool = this.getStoreOpenAndCloseThreadPool("StoreOpener-" + this.getRegionInfo().getShortNameToLog());
            ExecutorCompletionService<HStore> completionService = new ExecutorCompletionService<HStore>(storeOpenerThreadPool);
            for (final HColumnDescriptor family : this.htableDescriptor.getFamilies()) {
                status.setStatus("Instantiating store for column family " + family);
                completionService.submit(new Callable<HStore>(){

                    @Override
                    public HStore call() throws IOException {
                        return HRegion.this.instantiateHStore(family);
                    }
                });
            }
            boolean allStoresOpened = false;
            try {
                for (int i = 0; i < this.htableDescriptor.getFamilies().size(); ++i) {
                    long maxStoreMemstoreTS;
                    Future future = completionService.take();
                    HStore store = (HStore)future.get();
                    this.stores.put(store.getFamily().getName(), store);
                    long storeMaxSequenceId = store.getMaxSequenceId();
                    this.maxSeqIdInStores.put(store.getColumnFamilyName().getBytes(), storeMaxSequenceId);
                    if (maxSeqId == -1L || storeMaxSequenceId > maxSeqId) {
                        maxSeqId = storeMaxSequenceId;
                    }
                    if ((maxStoreMemstoreTS = store.getMaxMemstoreTS()) <= maxMemstoreTS) continue;
                    maxMemstoreTS = maxStoreMemstoreTS;
                }
                allStoresOpened = true;
            }
            catch (InterruptedException e) {
                throw (InterruptedIOException)new InterruptedIOException().initCause(e);
            }
            catch (ExecutionException e) {
                throw new IOException(e.getCause());
            }
            finally {
                storeOpenerThreadPool.shutdownNow();
                if (!allStoresOpened) {
                    LOG.error((Object)("Could not initialize all stores for the region=" + this));
                    for (Store store : this.stores.values()) {
                        try {
                            store.close();
                        }
                        catch (IOException e) {
                            LOG.warn((Object)e.getMessage());
                        }
                    }
                }
            }
        }
        if (ServerRegionReplicaUtil.shouldReplayRecoveredEdits(this) && !warmupOnly) {
            maxSeqId = Math.max(maxSeqId, this.replayRecoveredEditsIfAny(this.fs.getRegionDir(), this.maxSeqIdInStores, reporter, status));
        }
        maxSeqId = Math.max(maxSeqId, maxMemstoreTS + 1L);
        this.mvcc.initialize(maxSeqId);
        return maxSeqId;
    }

    private void initializeWarmup(CancelableProgressable reporter) throws IOException {
        MonitoredTask status = TaskMonitor.get().createStatus("Initializing region " + this);
        status.setStatus("Warming up all the Stores");
        this.initializeRegionStores(reporter, status, true);
    }

    private NavigableMap<byte[], List<Path>> getStoreFiles() {
        TreeMap<byte[], List<Path>> allStoreFiles = new TreeMap<byte[], List<Path>>(Bytes.BYTES_COMPARATOR);
        for (Store store : this.getStores()) {
            Collection<StoreFile> storeFiles = store.getStorefiles();
            if (storeFiles == null) continue;
            ArrayList<Path> storeFileNames = new ArrayList<Path>();
            for (StoreFile storeFile : storeFiles) {
                storeFileNames.add(storeFile.getPath());
            }
            allStoreFiles.put(store.getFamily().getName(), storeFileNames);
        }
        return allStoreFiles;
    }

    private void writeRegionOpenMarker(WAL wal, long openSeqId) throws IOException {
        NavigableMap<byte[], List<Path>> storeFiles = this.getStoreFiles();
        WALProtos.RegionEventDescriptor regionOpenDesc = ProtobufUtil.toRegionEventDescriptor((WALProtos.RegionEventDescriptor.EventType)WALProtos.RegionEventDescriptor.EventType.REGION_OPEN, (HRegionInfo)this.getRegionInfo(), (long)openSeqId, (ServerName)this.getRegionServerServices().getServerName(), storeFiles);
        WALUtil.writeRegionEventMarker(wal, this.getTableDesc(), this.getRegionInfo(), regionOpenDesc, this.getSequenceId());
    }

    private void writeRegionCloseMarker(WAL wal) throws IOException {
        NavigableMap<byte[], List<Path>> storeFiles = this.getStoreFiles();
        WALProtos.RegionEventDescriptor regionEventDesc = ProtobufUtil.toRegionEventDescriptor((WALProtos.RegionEventDescriptor.EventType)WALProtos.RegionEventDescriptor.EventType.REGION_CLOSE, (HRegionInfo)this.getRegionInfo(), (long)this.getSequenceId().get(), (ServerName)this.getRegionServerServices().getServerName(), storeFiles);
        WALUtil.writeRegionEventMarker(wal, this.getTableDesc(), this.getRegionInfo(), regionEventDesc, this.getSequenceId());
        if (this.fs.getFileSystem().exists(this.fs.getRegionDir())) {
            WALSplitter.writeRegionSequenceIdFile(this.fs.getFileSystem(), this.fs.getRegionDir(), this.getSequenceId().get(), 0L);
        }
    }

    public boolean hasReferences() {
        for (Store store : this.stores.values()) {
            if (!store.hasReferences()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HDFSBlocksDistribution getHDFSBlocksDistribution() {
        HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
        Map<byte[], Store> map = this.stores;
        synchronized (map) {
            for (Store store : this.stores.values()) {
                Collection<StoreFile> storeFiles = store.getStorefiles();
                if (storeFiles == null) continue;
                for (StoreFile sf : storeFiles) {
                    HDFSBlocksDistribution storeFileBlocksDistribution = sf.getHDFSBlockDistribution();
                    hdfsBlocksDistribution.add(storeFileBlocksDistribution);
                }
            }
        }
        return hdfsBlocksDistribution;
    }

    public static HDFSBlocksDistribution computeHDFSBlocksDistribution(Configuration conf, HTableDescriptor tableDescriptor, HRegionInfo regionInfo) throws IOException {
        Path tablePath = FSUtils.getTableDir(FSUtils.getRootDir(conf), tableDescriptor.getTableName());
        return HRegion.computeHDFSBlocksDistribution(conf, tableDescriptor, regionInfo, tablePath);
    }

    public static HDFSBlocksDistribution computeHDFSBlocksDistribution(Configuration conf, HTableDescriptor tableDescriptor, HRegionInfo regionInfo, Path tablePath) throws IOException {
        HDFSBlocksDistribution hdfsBlocksDistribution = new HDFSBlocksDistribution();
        FileSystem fs = tablePath.getFileSystem(conf);
        HRegionFileSystem regionFs = new HRegionFileSystem(conf, fs, tablePath, regionInfo);
        for (HColumnDescriptor family : tableDescriptor.getFamilies()) {
            Collection<StoreFileInfo> storeFiles = regionFs.getStoreFiles(family.getNameAsString());
            if (storeFiles == null) continue;
            for (StoreFileInfo storeFileInfo : storeFiles) {
                hdfsBlocksDistribution.add(storeFileInfo.computeHDFSBlocksDistribution(fs));
            }
        }
        return hdfsBlocksDistribution;
    }

    public long addAndGetGlobalMemstoreSize(long memStoreSize) {
        long size;
        if (this.rsAccounting != null) {
            this.rsAccounting.addAndGetGlobalMemstoreSize(memStoreSize);
        }
        if ((size = this.memstoreSize.addAndGet(memStoreSize)) < 0L) {
            LOG.error((Object)("Asked to modify this region's (" + this.toString() + ") memstoreSize to a negative value which is incorrect. Current memstoreSize=" + (size - memStoreSize) + ", delta=" + memStoreSize), (Throwable)new Exception());
        }
        return size;
    }

    @Override
    public HRegionInfo getRegionInfo() {
        return this.fs.getRegionInfo();
    }

    RegionServerServices getRegionServerServices() {
        return this.rsServices;
    }

    @Override
    public long getReadRequestsCount() {
        return this.readRequestsCount.get();
    }

    @Override
    public void updateReadRequestsCount(long i) {
        this.readRequestsCount.add(i);
    }

    @Override
    public long getWriteRequestsCount() {
        return this.writeRequestsCount.get();
    }

    @Override
    public void updateWriteRequestsCount(long i) {
        this.writeRequestsCount.add(i);
    }

    @Override
    public long getMemstoreSize() {
        return this.memstoreSize.get();
    }

    @Override
    public long getNumMutationsWithoutWAL() {
        return this.numMutationsWithoutWAL.get();
    }

    @Override
    public long getDataInMemoryWithoutWAL() {
        return this.dataInMemoryWithoutWAL.get();
    }

    @Override
    public long getBlockedRequestsCount() {
        return this.blockedRequestsCount.get();
    }

    @Override
    public long getCheckAndMutateChecksPassed() {
        return this.checkAndMutateChecksPassed.get();
    }

    @Override
    public long getCheckAndMutateChecksFailed() {
        return this.checkAndMutateChecksFailed.get();
    }

    @Override
    public MetricsRegion getMetrics() {
        return this.metricsRegion;
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public boolean isClosing() {
        return this.closing.get();
    }

    @Override
    public boolean isReadOnly() {
        return this.writestate.isReadOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRecovering(boolean newState) {
        boolean wasRecovering = this.isRecovering;
        if (this.wal != null && this.getRegionServerServices() != null && !this.writestate.readOnly && wasRecovering && !newState) {
            boolean forceFlush = this.getTableDesc().getRegionReplication() > 1;
            MonitoredTask status = TaskMonitor.get().createStatus("Flushing region " + this + " because recovery is finished");
            try {
                if (forceFlush) {
                    this.internalFlushcache(status);
                }
                status.setStatus("Writing region open event marker to WAL because recovery is finished");
                try {
                    long seqId = this.openSeqNum;
                    if (this.wal != null) {
                        seqId = this.getNextSequenceId(this.wal);
                    }
                    this.writeRegionOpenMarker(this.wal, seqId);
                }
                catch (IOException e) {
                    LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : was not able to write region opening " + "event to WAL, continueing"), (Throwable)e);
                }
            }
            catch (IOException ioe) {
                LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : was not able to flush " + "event to WAL, continueing"), (Throwable)ioe);
            }
            finally {
                status.cleanup();
            }
        }
        this.isRecovering = newState;
        if (wasRecovering && !this.isRecovering) {
            this.coprocessorHost.postLogReplay();
        }
    }

    @Override
    public boolean isRecovering() {
        return this.isRecovering;
    }

    @Override
    public boolean isAvailable() {
        return !this.isClosed() && !this.isClosing();
    }

    public boolean isSplittable() {
        return this.isAvailable() && !this.hasReferences();
    }

    public boolean isMergeable() {
        if (!this.isAvailable()) {
            LOG.debug((Object)("Region " + this.getRegionInfo().getRegionNameAsString() + " is not mergeable because it is closing or closed"));
            return false;
        }
        if (this.hasReferences()) {
            LOG.debug((Object)("Region " + this.getRegionInfo().getRegionNameAsString() + " is not mergeable because it has references"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean areWritesEnabled() {
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            return this.writestate.writesEnabled;
        }
    }

    public MultiVersionConsistencyControl getMVCC() {
        return this.mvcc;
    }

    @Override
    public long getMaxFlushedSeqId() {
        return this.maxFlushedSeqId;
    }

    @Override
    public long getReadpoint(IsolationLevel isolationLevel) {
        if (isolationLevel == IsolationLevel.READ_UNCOMMITTED) {
            return Long.MAX_VALUE;
        }
        return this.mvcc.memstoreReadPoint();
    }

    @Override
    public boolean isLoadingCfsOnDemandDefault() {
        return this.isLoadingCfsOnDemandDefault;
    }

    public Map<byte[], List<StoreFile>> close() throws IOException {
        return this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<byte[], List<StoreFile>> close(boolean abort) throws IOException {
        MonitoredTask status = TaskMonitor.get().createStatus("Closing region " + this + (abort ? " due to abort" : ""));
        status.setStatus("Waiting for close lock");
        try {
            Object object = this.closeLock;
            synchronized (object) {
                Map<byte[], List<StoreFile>> map = this.doClose(abort, status);
                return map;
            }
        }
        finally {
            status.cleanup();
        }
    }

    @VisibleForTesting
    public void setClosing(boolean closing) {
        this.closing.set(closing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<byte[], List<StoreFile>> doClose(boolean abort, MonitoredTask status) throws IOException {
        if (this.isClosed()) {
            LOG.warn((Object)("Region " + this + " already closed"));
            return null;
        }
        if (this.coprocessorHost != null) {
            status.setStatus("Running coprocessor pre-close hooks");
            this.coprocessorHost.preClose(abort);
        }
        status.setStatus("Disabling compacts and flushes for region");
        boolean canFlush = true;
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            canFlush = !this.writestate.readOnly;
            this.writestate.writesEnabled = false;
            LOG.debug((Object)("Closing " + this + ": disabling compactions & flushes"));
            this.waitForFlushesAndCompactions();
        }
        if (!abort && this.worthPreFlushing() && canFlush) {
            status.setStatus("Pre-flushing region before close");
            LOG.info((Object)("Running close preflush of " + this.getRegionInfo().getRegionNameAsString()));
            try {
                this.internalFlushcache(status);
            }
            catch (IOException ioe) {
                status.setStatus("Failed pre-flush " + this + "; " + ioe.getMessage());
            }
        }
        this.lock.writeLock().lock();
        this.closing.set(true);
        status.setStatus("Disabling writes for close");
        try {
            if (this.isClosed()) {
                status.abort("Already got closed by another process");
                Map<byte[], List<StoreFile>> ioe = null;
                return ioe;
            }
            LOG.debug((Object)("Updates disabled for region " + this));
            if (!abort && canFlush) {
                int flushCount = 0;
                while (this.memstoreSize.get() > 0L) {
                    try {
                        if (flushCount++ > 0) {
                            int actualFlushes = flushCount - 1;
                            if (actualFlushes > 5) {
                                throw new DroppedSnapshotException("Failed clearing memory after " + actualFlushes + " attempts on region: " + Bytes.toStringBinary((byte[])this.getRegionInfo().getRegionName()));
                            }
                            LOG.info((Object)("Running extra flush, " + actualFlushes + " (carrying snapshot?) " + this));
                        }
                        this.internalFlushcache(status);
                    }
                    catch (IOException ioe) {
                        status.setStatus("Failed flush " + this + ", putting online again");
                        WriteState writeState2 = this.writestate;
                        synchronized (writeState2) {
                            this.writestate.writesEnabled = true;
                        }
                        throw ioe;
                    }
                }
            }
            TreeMap<byte[], List<StoreFile>> result = new TreeMap<byte[], List<StoreFile>>(Bytes.BYTES_COMPARATOR);
            if (!this.stores.isEmpty()) {
                ThreadPoolExecutor storeCloserThreadPool = this.getStoreOpenAndCloseThreadPool("StoreCloserThread-" + this.getRegionInfo().getRegionNameAsString());
                ExecutorCompletionService<Pair<byte[], Collection<StoreFile>>> completionService = new ExecutorCompletionService<Pair<byte[], Collection<StoreFile>>>(storeCloserThreadPool);
                for (final Store store : this.stores.values()) {
                    long flushableSize = store.getFlushableSize();
                    if (!abort && flushableSize != 0L && !this.writestate.readOnly) {
                        this.getRegionServerServices().abort("Assertion failed while closing store " + this.getRegionInfo().getRegionNameAsString() + " " + store + ". flushableSize expected=0, actual= " + flushableSize + ". Current memstoreSize=" + this.getMemstoreSize() + ". Maybe a coprocessor " + "operation failed and left the memstore in a partially updated state.", null);
                    }
                    completionService.submit(new Callable<Pair<byte[], Collection<StoreFile>>>(){

                        @Override
                        public Pair<byte[], Collection<StoreFile>> call() throws IOException {
                            return new Pair((Object)store.getFamily().getName(), store.close());
                        }
                    });
                }
                try {
                    for (int i = 0; i < this.stores.size(); ++i) {
                        Future future = completionService.take();
                        Pair storeFiles = (Pair)future.get();
                        ArrayList familyFiles = (ArrayList)result.get(storeFiles.getFirst());
                        if (familyFiles == null) {
                            familyFiles = new ArrayList();
                            result.put((byte[])storeFiles.getFirst(), familyFiles);
                        }
                        familyFiles.addAll((Collection)storeFiles.getSecond());
                    }
                }
                catch (InterruptedException e) {
                    throw (InterruptedIOException)new InterruptedIOException().initCause(e);
                }
                catch (ExecutionException e) {
                    throw new IOException(e.getCause());
                }
                finally {
                    storeCloserThreadPool.shutdownNow();
                }
            }
            status.setStatus("Writing region close event to WAL");
            if (!abort && this.wal != null && this.getRegionServerServices() != null && !this.writestate.readOnly) {
                this.writeRegionCloseMarker(this.wal);
            }
            this.closed.set(true);
            if (!canFlush) {
                this.addAndGetGlobalMemstoreSize(-this.memstoreSize.get());
            } else if (this.memstoreSize.get() != 0L) {
                LOG.error((Object)("Memstore size is " + this.memstoreSize.get()));
            }
            if (this.coprocessorHost != null) {
                status.setStatus("Running coprocessor post-close hooks");
                this.coprocessorHost.postClose(abort);
            }
            if (this.metricsRegion != null) {
                this.metricsRegion.close();
            }
            if (this.metricsRegionWrapper != null) {
                Closeables.closeQuietly((Closeable)this.metricsRegionWrapper);
            }
            status.markComplete("Closed");
            LOG.info((Object)("Closed " + this));
            TreeMap<byte[], List<StoreFile>> treeMap = result;
            return treeMap;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitForFlushesAndCompactions() {
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            if (this.writestate.readOnly) {
                return;
            }
            boolean interrupted = false;
            try {
                while (this.writestate.compacting > 0 || this.writestate.flushing) {
                    LOG.debug((Object)("waiting for " + this.writestate.compacting + " compactions" + (this.writestate.flushing ? " & cache flush" : "") + " to complete for region " + this));
                    try {
                        this.writestate.wait();
                    }
                    catch (InterruptedException iex) {
                        LOG.warn((Object)"Interrupted while waiting");
                        interrupted = true;
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    protected ThreadPoolExecutor getStoreOpenAndCloseThreadPool(String threadNamePrefix) {
        int numStores = Math.max(1, this.htableDescriptor.getFamilies().size());
        int maxThreads = Math.min(numStores, this.conf.getInt("hbase.hstore.open.and.close.threads.max", 1));
        return HRegion.getOpenAndCloseThreadPool(maxThreads, threadNamePrefix);
    }

    protected ThreadPoolExecutor getStoreFileOpenAndCloseThreadPool(String threadNamePrefix) {
        int numStores = Math.max(1, this.htableDescriptor.getFamilies().size());
        int maxThreads = Math.max(1, this.conf.getInt("hbase.hstore.open.and.close.threads.max", 1) / numStores);
        return HRegion.getOpenAndCloseThreadPool(maxThreads, threadNamePrefix);
    }

    static ThreadPoolExecutor getOpenAndCloseThreadPool(int maxThreads, final String threadNamePrefix) {
        return Threads.getBoundedCachedThreadPool((int)maxThreads, (long)30L, (TimeUnit)TimeUnit.SECONDS, (ThreadFactory)new ThreadFactory(){
            private int count = 1;

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, threadNamePrefix + "-" + this.count++);
            }
        });
    }

    private boolean worthPreFlushing() {
        return this.memstoreSize.get() > this.conf.getLong("hbase.hregion.preclose.flush.size", 0x500000L);
    }

    @Override
    public HTableDescriptor getTableDesc() {
        return this.htableDescriptor;
    }

    public WAL getWAL() {
        return this.wal;
    }

    Configuration getBaseConf() {
        return this.baseConf;
    }

    public FileSystem getFilesystem() {
        return this.fs.getFileSystem();
    }

    public HRegionFileSystem getRegionFileSystem() {
        return this.fs;
    }

    @Override
    public long getEarliestFlushTimeForAllStores() {
        return this.lastStoreFlushTimeMap.isEmpty() ? Long.MAX_VALUE : (Long)Collections.min(this.lastStoreFlushTimeMap.values());
    }

    @Override
    public long getOldestHfileTs(boolean majorCompactioOnly) throws IOException {
        long result = Long.MAX_VALUE;
        for (Store store : this.getStores()) {
            Collection<StoreFile> storeFiles = store.getStorefiles();
            if (storeFiles == null) continue;
            for (StoreFile file : storeFiles) {
                byte[] val;
                HFile.Reader reader;
                StoreFile.Reader sfReader = file.getReader();
                if (sfReader == null || (reader = sfReader.getHFileReader()) == null || majorCompactioOnly && ((val = reader.loadFileInfo().get(StoreFile.MAJOR_COMPACTION_KEY)) == null || val == null || !Bytes.toBoolean((byte[])val))) continue;
                result = Math.min(result, reader.getFileContext().getFileCreateTime());
            }
        }
        return result == Long.MAX_VALUE ? 0L : result;
    }

    ClusterStatusProtos.RegionLoad.Builder setCompleteSequenceId(ClusterStatusProtos.RegionLoad.Builder regionLoadBldr) {
        long lastFlushOpSeqIdLocal = this.lastFlushOpSeqId;
        byte[] encodedRegionName = this.getRegionInfo().getEncodedNameAsBytes();
        regionLoadBldr.clearStoreCompleteSequenceId();
        for (byte[] familyName : this.stores.keySet()) {
            long oldestUnflushedSeqId = this.wal.getEarliestMemstoreSeqNum(encodedRegionName, familyName);
            regionLoadBldr.addStoreCompleteSequenceId(ClusterStatusProtos.StoreSequenceId.newBuilder().setFamilyName(ByteString.copyFrom((byte[])familyName)).setSequenceId(oldestUnflushedSeqId < 0L ? lastFlushOpSeqIdLocal : oldestUnflushedSeqId - 1L).build());
        }
        return regionLoadBldr.setCompleteSequenceId(this.getMaxFlushedSeqId());
    }

    public long getLargestHStoreSize() {
        long size = 0L;
        for (Store h : this.stores.values()) {
            long storeSize = h.getSize();
            if (storeSize <= size) continue;
            size = storeSize;
        }
        return size;
    }

    public KeyValue.KVComparator getComparator() {
        return this.comparator;
    }

    protected void doRegionCompactionPrep() throws IOException {
    }

    @Override
    public void triggerMajorCompaction() throws IOException {
        for (Store s : this.getStores()) {
            s.triggerMajorCompaction();
        }
    }

    @Override
    public void compact(boolean majorCompaction) throws IOException {
        if (majorCompaction) {
            this.triggerMajorCompaction();
        }
        for (Store s : this.getStores()) {
            CompactionContext compaction = s.requestCompaction();
            if (compaction == null) continue;
            CompactionThroughputController controller = null;
            if (this.rsServices != null) {
                controller = CompactionThroughputControllerFactory.create(this.rsServices, this.conf);
            }
            if (controller == null) {
                controller = NoLimitCompactionThroughputController.INSTANCE;
            }
            this.compact(compaction, s, controller, null);
        }
    }

    public void compactStores() throws IOException {
        for (Store s : this.getStores()) {
            CompactionContext compaction = s.requestCompaction();
            if (compaction == null) continue;
            this.compact(compaction, s, NoLimitCompactionThroughputController.INSTANCE, null);
        }
    }

    @VisibleForTesting
    void compactStore(byte[] family, CompactionThroughputController throughputController) throws IOException {
        Store s = this.getStore(family);
        CompactionContext compaction = s.requestCompaction();
        if (compaction != null) {
            this.compact(compaction, s, throughputController, null);
        }
    }

    public boolean compact(CompactionContext compaction, Store store, CompactionThroughputController throughputController) throws IOException {
        return this.compact(compaction, store, throughputController, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean compact(CompactionContext compaction, Store store, CompactionThroughputController throughputController, User user) throws IOException {
        if (!$assertionsDisabled) {
            if (compaction == null) throw new AssertionError();
            if (!compaction.hasSelection()) {
                throw new AssertionError();
            }
        }
        assert (!compaction.getRequest().getFiles().isEmpty());
        if (this.closing.get() || this.closed.get()) {
            LOG.debug((Object)("Skipping compaction on " + this + " because closing/closed"));
            store.cancelRequestedCompaction(compaction);
            return false;
        }
        MonitoredTask status = null;
        boolean requestNeedsCancellation = true;
        this.lock.readLock().lock();
        try {
            byte[] cf = Bytes.toBytes((String)store.getColumnFamilyName());
            if (this.stores.get(cf) != store) {
                LOG.warn((Object)("Store " + store.getColumnFamilyName() + " on region " + this + " has been re-instantiated, cancel this compaction request. " + " It may be caused by the roll back of split transaction"));
                boolean bl = false;
                return bl;
            }
            status = TaskMonitor.get().createStatus("Compacting " + store + " in " + this);
            if (this.closed.get()) {
                String msg = "Skipping compaction on " + this + " because closed";
                LOG.debug((Object)msg);
                status.abort(msg);
                boolean bl = false;
                return bl;
            }
            boolean wasStateSet = false;
            try {
                WriteState writeState = this.writestate;
                synchronized (writeState) {
                    if (!this.writestate.writesEnabled) {
                        String msg = "NOT compacting region " + this + ". Writes disabled.";
                        LOG.info((Object)msg);
                        status.abort(msg);
                        boolean bl = false;
                        return bl;
                    }
                    wasStateSet = true;
                    ++this.writestate.compacting;
                }
                LOG.info((Object)("Starting compaction on " + store + " in region " + this + (compaction.getRequest().isOffPeak() ? " as an off-peak compaction" : "")));
                this.doRegionCompactionPrep();
                try {
                    status.setStatus("Compacting store " + store);
                    requestNeedsCancellation = false;
                    store.compact(compaction, throughputController, user);
                }
                catch (InterruptedIOException iioe) {
                    String msg = "compaction interrupted";
                    LOG.info((Object)msg, (Throwable)iioe);
                    status.abort(msg);
                    boolean bl = false;
                    if (wasStateSet) {
                        WriteState writeState2 = this.writestate;
                        synchronized (writeState2) {
                            --this.writestate.compacting;
                            if (this.writestate.compacting <= 0) {
                                this.writestate.notifyAll();
                            }
                        }
                    }
                    try {
                        if (requestNeedsCancellation) {
                            store.cancelRequestedCompaction(compaction);
                        }
                        if (status == null) return bl;
                        status.cleanup();
                        return bl;
                    }
                    finally {
                        this.lock.readLock().unlock();
                    }
                }
            }
            finally {
                if (wasStateSet) {
                    WriteState writeState = this.writestate;
                    synchronized (writeState) {
                        --this.writestate.compacting;
                        if (this.writestate.compacting <= 0) {
                            this.writestate.notifyAll();
                        }
                    }
                }
            }
            status.markComplete("Compaction complete");
            boolean bl = true;
            return bl;
        }
        finally {
            try {
                if (requestNeedsCancellation) {
                    store.cancelRequestedCompaction(compaction);
                }
                if (status != null) {
                    status.cleanup();
                }
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    @Override
    public Region.FlushResult flush(boolean force) throws IOException {
        return this.flushcache(force, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public Region.FlushResult flushcache(boolean forceFlushAllStores, boolean writeFlushRequestWalMarker) throws IOException {
        if (this.closing.get()) {
            msg = "Skipping flush on " + this + " because closing";
            HRegion.LOG.debug((Object)msg);
            return new FlushResultImpl(Region.FlushResult.Result.CANNOT_FLUSH, msg, false);
        }
        status = TaskMonitor.get().createStatus("Flushing " + this);
        status.setStatus("Acquiring readlock on region");
        this.lock.readLock().lock();
        try {
            if (this.closed.get()) {
                msg = "Skipping flush on " + this + " because closed";
                HRegion.LOG.debug((Object)msg);
                status.abort(msg);
                var5_7 = new FlushResultImpl(Region.FlushResult.Result.CANNOT_FLUSH, msg, false);
                return var5_7;
            }
            if (this.coprocessorHost != null) {
                status.setStatus("Running coprocessor pre-flush hooks");
                this.coprocessorHost.preFlush();
            }
            if (this.numMutationsWithoutWAL.get() > 0L) {
                this.numMutationsWithoutWAL.set(0L);
                this.dataInMemoryWithoutWAL.set(0L);
            }
            msg = this.writestate;
            synchronized (msg) {
                if (this.writestate.flushing || !this.writestate.writesEnabled) {
                    if (HRegion.LOG.isDebugEnabled()) {
                        HRegion.LOG.debug((Object)("NOT flushing memstore for region " + this + ", flushing=" + this.writestate.flushing + ", writesEnabled=" + this.writestate.writesEnabled));
                    }
                    msg = "Not flushing since " + (this.writestate.flushing != false ? "already flushing" : "writes not enabled");
                    status.abort(msg);
                    var6_10 = new FlushResultImpl(Region.FlushResult.Result.CANNOT_FLUSH, msg, false);
                    return var6_10;
                }
                this.writestate.flushing = true;
                ** try [egrp 4[TRYBLOCK] [1 : 441->447)] { 
                {
                }
            }
lbl36:
            // 1 sources

            try {
                specificStoresToFlush = forceFlushAllStores != false ? this.stores.values() : this.flushPolicy.selectStoresToFlush();
                fs = this.internalFlushcache(specificStoresToFlush, status, writeFlushRequestWalMarker);
                if (this.coprocessorHost != null) {
                    status.setStatus("Running post-flush coprocessor hooks");
                    this.coprocessorHost.postFlush();
                }
                status.markComplete("Flush successful");
                var6_11 = fs;
                var7_13 = this.writestate;
            }
            catch (Throwable var9_15) {
                var10_16 = this.writestate;
                synchronized (var10_16) {
                    this.writestate.flushing = false;
                    this.writestate.flushRequested = false;
                    this.writestate.notifyAll();
                }
                throw var9_15;
            }
            synchronized (var7_13) {
                this.writestate.flushing = false;
                this.writestate.flushRequested = false;
                this.writestate.notifyAll();
            }
            return var6_11;
        }
        finally {
            this.lock.readLock().unlock();
            status.cleanup();
        }
    }

    boolean shouldFlushStore(Store store) {
        long maxFlushedSeqId = this.wal.getEarliestMemstoreSeqNum(this.getRegionInfo().getEncodedNameAsBytes(), store.getFamily().getName()) - 1L;
        if (maxFlushedSeqId > 0L && maxFlushedSeqId + this.flushPerChanges < this.sequenceId.get()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Column Family: " + store.getColumnFamilyName() + " of region " + this + " will be flushed because its max flushed seqId(" + maxFlushedSeqId + ") is far away from current(" + this.sequenceId.get() + "), max allowed is " + this.flushPerChanges));
            }
            return true;
        }
        if (this.flushCheckInterval <= 0L) {
            return false;
        }
        long now = EnvironmentEdgeManager.currentTime();
        if (store.timeOfOldestEdit() < now - this.flushCheckInterval) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Column Family: " + store.getColumnFamilyName() + " of region " + this + " will be flushed because time of its oldest edit (" + store.timeOfOldestEdit() + ") is far away from now(" + now + "), max allowed is " + this.flushCheckInterval));
            }
            return true;
        }
        return false;
    }

    boolean shouldFlush() {
        if (this.maxFlushedSeqId > 0L && this.maxFlushedSeqId + this.flushPerChanges < this.sequenceId.get()) {
            return true;
        }
        long modifiedFlushCheckInterval = this.flushCheckInterval;
        if (this.getRegionInfo().isMetaRegion() && this.getRegionInfo().getReplicaId() == 0) {
            modifiedFlushCheckInterval = 300000L;
        }
        if (modifiedFlushCheckInterval <= 0L) {
            return false;
        }
        long now = EnvironmentEdgeManager.currentTime();
        if (now - this.getEarliestFlushTimeForAllStores() < modifiedFlushCheckInterval) {
            return false;
        }
        for (Store s : this.getStores()) {
            if (s.timeOfOldestEdit() >= now - modifiedFlushCheckInterval) continue;
            return true;
        }
        return false;
    }

    private Region.FlushResult internalFlushcache(MonitoredTask status) throws IOException {
        return this.internalFlushcache(this.stores.values(), status, false);
    }

    private Region.FlushResult internalFlushcache(Collection<Store> storesToFlush, MonitoredTask status, boolean writeFlushWalMarker) throws IOException {
        return this.internalFlushcache(this.wal, -1L, storesToFlush, status, writeFlushWalMarker);
    }

    protected Region.FlushResult internalFlushcache(WAL wal, long myseqid, Collection<Store> storesToFlush, MonitoredTask status, boolean writeFlushWalMarker) throws IOException {
        PrepareFlushResult result = this.internalPrepareFlushCache(wal, myseqid, storesToFlush, status, writeFlushWalMarker);
        if (result.result == null) {
            return this.internalFlushCacheAndCommit(wal, status, result, storesToFlush);
        }
        return result.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PrepareFlushResult internalPrepareFlushCache(WAL wal, long myseqid, Collection<Store> storesToFlush, MonitoredTask status, boolean writeFlushWalMarker) throws IOException {
        MultiVersionConsistencyControl.WriteEntry writeEntry;
        if (this.rsServices != null && this.rsServices.isAborted()) {
            throw new IOException("Aborting flush because server is aborted...");
        }
        long startTime = EnvironmentEdgeManager.currentTime();
        if (this.memstoreSize.get() <= 0L) {
            writeEntry = null;
            this.updatesLock.writeLock().lock();
            try {
                if (this.memstoreSize.get() <= 0L) {
                    if (wal != null) {
                        writeEntry = this.mvcc.beginMemstoreInsert();
                        long flushOpSeqId = this.getNextSequenceId(wal);
                        FlushResultImpl flushResult = new FlushResultImpl(Region.FlushResult.Result.CANNOT_FLUSH_MEMSTORE_EMPTY, flushOpSeqId, "Nothing to flush", this.writeFlushRequestMarkerToWAL(wal, writeFlushWalMarker));
                        writeEntry.setWriteNumber(flushOpSeqId);
                        this.mvcc.waitForPreviousTransactionsComplete(writeEntry);
                        writeEntry = null;
                        PrepareFlushResult prepareFlushResult = new PrepareFlushResult(flushResult, myseqid);
                        return prepareFlushResult;
                    }
                    PrepareFlushResult flushOpSeqId = new PrepareFlushResult(new FlushResultImpl(Region.FlushResult.Result.CANNOT_FLUSH_MEMSTORE_EMPTY, "Nothing to flush", false), myseqid);
                    return flushOpSeqId;
                }
            }
            finally {
                this.updatesLock.writeLock().unlock();
                if (writeEntry != null) {
                    this.mvcc.advanceMemstore(writeEntry);
                }
            }
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("Started memstore flush for " + this + ", current region memstore size " + StringUtils.byteDesc((long)this.memstoreSize.get()) + ", and " + storesToFlush.size() + "/" + this.stores.size() + " column families' memstores are being flushed." + (wal != null ? "" : "; wal is null, using passed sequenceid=" + myseqid)));
            if (this.stores.size() > storesToFlush.size()) {
                for (Store store : storesToFlush) {
                    LOG.info((Object)("Flushing Column Family: " + store.getColumnFamilyName() + " which was occupying " + StringUtils.byteDesc((long)store.getMemStoreSize()) + " of memstore."));
                }
            }
        }
        writeEntry = null;
        status.setStatus("Obtaining lock to block concurrent updates");
        this.updatesLock.writeLock().lock();
        status.setStatus("Preparing to flush by snapshotting stores in " + this.getRegionInfo().getEncodedName());
        long totalFlushableSizeOfFlushableStores = 0L;
        HashSet<byte[]> flushedFamilyNames = new HashSet<byte[]>();
        for (Store store : storesToFlush) {
            flushedFamilyNames.add(store.getFamily().getName());
        }
        TreeMap<byte[], StoreFlushContext> storeFlushCtxs = new TreeMap<byte[], StoreFlushContext>(Bytes.BYTES_COMPARATOR);
        TreeMap<byte[], List<Path>> committedFiles = new TreeMap<byte[], List<Path>>(Bytes.BYTES_COMPARATOR);
        TreeMap<byte[], Long> storeFlushableSize = new TreeMap<byte[], Long>(Bytes.BYTES_COMPARATOR);
        long flushOpSeqId = -1L;
        long flushedSeqId = -1L;
        byte[] encodedRegionName = this.getRegionInfo().getEncodedNameAsBytes();
        long trxId = 0L;
        try {
            block38: {
                try {
                    this.mvcc.waitForPreviousTransactionsComplete();
                    writeEntry = this.mvcc.beginMemstoreInsert();
                    if (wal != null) {
                        Long earliestUnflushedSequenceIdForTheRegion = wal.startCacheFlush(encodedRegionName, flushedFamilyNames);
                        if (earliestUnflushedSequenceIdForTheRegion == null) {
                            String msg = this.getRegionInfo().getEncodedName() + " flush aborted; WAL closing.";
                            status.setStatus(msg);
                            PrepareFlushResult prepareFlushResult = new PrepareFlushResult(new FlushResultImpl(Region.FlushResult.Result.CANNOT_FLUSH, msg, false), myseqid);
                            return prepareFlushResult;
                        }
                        flushOpSeqId = this.getNextSequenceId(wal);
                        flushedSeqId = earliestUnflushedSequenceIdForTheRegion == -1L ? flushOpSeqId : earliestUnflushedSequenceIdForTheRegion - 1L;
                    } else {
                        flushedSeqId = flushOpSeqId = myseqid;
                    }
                    for (Store s : storesToFlush) {
                        totalFlushableSizeOfFlushableStores += s.getFlushableSize();
                        storeFlushCtxs.put(s.getFamily().getName(), s.createFlushContext(flushOpSeqId));
                        committedFiles.put(s.getFamily().getName(), null);
                        storeFlushableSize.put(s.getFamily().getName(), s.getFlushableSize());
                    }
                    if (wal != null && !this.writestate.readOnly) {
                        WALProtos.FlushDescriptor desc = ProtobufUtil.toFlushDescriptor((WALProtos.FlushDescriptor.FlushAction)WALProtos.FlushDescriptor.FlushAction.START_FLUSH, (HRegionInfo)this.getRegionInfo(), (long)flushOpSeqId, committedFiles);
                        trxId = WALUtil.writeFlushMarker(wal, this.htableDescriptor, this.getRegionInfo(), desc, this.sequenceId, false);
                    }
                    for (StoreFlushContext flush : storeFlushCtxs.values()) {
                        flush.prepare();
                    }
                }
                catch (IOException ex) {
                    if (wal == null) break block38;
                    if (trxId > 0L) {
                        try {
                            WALProtos.FlushDescriptor desc = ProtobufUtil.toFlushDescriptor((WALProtos.FlushDescriptor.FlushAction)WALProtos.FlushDescriptor.FlushAction.ABORT_FLUSH, (HRegionInfo)this.getRegionInfo(), (long)flushOpSeqId, committedFiles);
                            WALUtil.writeFlushMarker(wal, this.htableDescriptor, this.getRegionInfo(), desc, this.sequenceId, false);
                        }
                        catch (Throwable t) {
                            LOG.warn((Object)("Received unexpected exception trying to write ABORT_FLUSH marker to WAL:" + StringUtils.stringifyException((Throwable)t)));
                        }
                    }
                    wal.abortCacheFlush(this.getRegionInfo().getEncodedNameAsBytes());
                    throw ex;
                }
                finally {
                    this.updatesLock.writeLock().unlock();
                }
            }
            String s = "Finished memstore snapshotting " + this + ", syncing WAL and waiting on mvcc, flushsize=" + totalFlushableSizeOfFlushableStores;
            status.setStatus(s);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)s);
            }
            if (wal != null) {
                try {
                    wal.sync();
                }
                catch (IOException ioe) {
                    wal.abortCacheFlush(this.getRegionInfo().getEncodedNameAsBytes());
                    throw ioe;
                }
            }
            writeEntry.setWriteNumber(flushOpSeqId);
            this.mvcc.waitForPreviousTransactionsComplete(writeEntry);
            writeEntry = null;
        }
        finally {
            if (writeEntry != null) {
                this.mvcc.advanceMemstore(writeEntry);
            }
        }
        return new PrepareFlushResult(storeFlushCtxs, committedFiles, storeFlushableSize, startTime, flushOpSeqId, flushedSeqId, totalFlushableSizeOfFlushableStores);
    }

    private boolean writeFlushRequestMarkerToWAL(WAL wal, boolean writeFlushWalMarker) {
        if (writeFlushWalMarker && wal != null && !this.writestate.readOnly) {
            WALProtos.FlushDescriptor desc = ProtobufUtil.toFlushDescriptor((WALProtos.FlushDescriptor.FlushAction)WALProtos.FlushDescriptor.FlushAction.CANNOT_FLUSH, (HRegionInfo)this.getRegionInfo(), (long)-1L, new TreeMap());
            try {
                WALUtil.writeFlushMarker(wal, this.htableDescriptor, this.getRegionInfo(), desc, this.sequenceId, true);
                return true;
            }
            catch (IOException e) {
                LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Received exception while trying to write the flush request to wal"), (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Region.FlushResult internalFlushCacheAndCommit(WAL wal, MonitoredTask status, PrepareFlushResult prepareResult, Collection<Store> storesToFlush) throws IOException {
        TreeMap<byte[], StoreFlushContext> storeFlushCtxs = prepareResult.storeFlushCtxs;
        TreeMap<byte[], List<Path>> committedFiles = prepareResult.committedFiles;
        long startTime = prepareResult.startTime;
        long flushOpSeqId = prepareResult.flushOpSeqId;
        long flushedSeqId = prepareResult.flushedSeqId;
        long totalFlushableSizeOfFlushableStores = prepareResult.totalFlushableSize;
        String s = "Flushing stores of " + this;
        status.setStatus(s);
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)s);
        }
        boolean compactionRequested = false;
        try {
            for (StoreFlushContext flush : storeFlushCtxs.values()) {
                flush.flushCache(status);
            }
            Iterator<Store> it = storesToFlush.iterator();
            for (StoreFlushContext flush : storeFlushCtxs.values()) {
                boolean needsCompaction = flush.commit(status);
                if (needsCompaction) {
                    compactionRequested = true;
                }
                byte[] storeName = it.next().getFamily().getName();
                List<Path> storeCommittedFiles = flush.getCommittedFiles();
                committedFiles.put(storeName, storeCommittedFiles);
                if (storeCommittedFiles != null && !storeCommittedFiles.isEmpty()) continue;
                totalFlushableSizeOfFlushableStores -= prepareResult.storeFlushableSize.get(storeName).longValue();
            }
            storeFlushCtxs.clear();
            this.addAndGetGlobalMemstoreSize(-totalFlushableSizeOfFlushableStores);
            if (wal != null) {
                WALProtos.FlushDescriptor desc = ProtobufUtil.toFlushDescriptor((WALProtos.FlushDescriptor.FlushAction)WALProtos.FlushDescriptor.FlushAction.COMMIT_FLUSH, (HRegionInfo)this.getRegionInfo(), (long)flushOpSeqId, committedFiles);
                WALUtil.writeFlushMarker(wal, this.htableDescriptor, this.getRegionInfo(), desc, this.sequenceId, true);
            }
        }
        catch (Throwable t) {
            if (wal != null) {
                try {
                    WALProtos.FlushDescriptor desc = ProtobufUtil.toFlushDescriptor((WALProtos.FlushDescriptor.FlushAction)WALProtos.FlushDescriptor.FlushAction.ABORT_FLUSH, (HRegionInfo)this.getRegionInfo(), (long)flushOpSeqId, committedFiles);
                    WALUtil.writeFlushMarker(wal, this.htableDescriptor, this.getRegionInfo(), desc, this.sequenceId, false);
                }
                catch (Throwable ex) {
                    LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Received unexpected exception trying to write ABORT_FLUSH marker to WAL:" + StringUtils.stringifyException((Throwable)ex)));
                }
                wal.abortCacheFlush(this.getRegionInfo().getEncodedNameAsBytes());
            }
            DroppedSnapshotException dse = new DroppedSnapshotException("region: " + Bytes.toStringBinary((byte[])this.getRegionInfo().getRegionName()));
            dse.initCause(t);
            status.abort("Flush failed: " + StringUtils.stringifyException((Throwable)t));
            this.closing.set(true);
            if (this.rsServices != null) {
                this.rsServices.abort("Replay of WAL required. Forcing server shutdown", (Throwable)dse);
            }
            throw dse;
        }
        if (wal != null) {
            wal.completeCacheFlush(this.getRegionInfo().getEncodedNameAsBytes());
        }
        for (Store store : storesToFlush) {
            this.lastStoreFlushTimeMap.put(store, startTime);
        }
        this.maxFlushedSeqId = flushedSeqId;
        this.lastFlushOpSeqId = flushOpSeqId;
        HRegion i$ = this;
        synchronized (i$) {
            this.notifyAll();
        }
        long time = EnvironmentEdgeManager.currentTime() - startTime;
        long memstoresize = this.memstoreSize.get();
        String msg = "Finished memstore flush of ~" + StringUtils.byteDesc((long)totalFlushableSizeOfFlushableStores) + "/" + totalFlushableSizeOfFlushableStores + ", currentsize=" + StringUtils.byteDesc((long)memstoresize) + "/" + memstoresize + " for region " + this + " in " + time + "ms, sequenceid=" + flushOpSeqId + ", compaction requested=" + compactionRequested + (wal == null ? "; wal=null" : "");
        LOG.info((Object)msg);
        status.setStatus(msg);
        return new FlushResultImpl(compactionRequested ? Region.FlushResult.Result.FLUSHED_COMPACTION_NEEDED : Region.FlushResult.Result.FLUSHED_NO_COMPACTION_NEEDED, flushOpSeqId);
    }

    @VisibleForTesting
    protected long getNextSequenceId(WAL wal) throws IOException {
        WALKey key = this.appendEmptyEdit(wal, null);
        return key.getSequenceId(this.maxWaitForSeqId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result getClosestRowBefore(byte[] row, byte[] family) throws IOException {
        Result result;
        if (this.coprocessorHost != null && this.coprocessorHost.preGetClosestRowBefore(row, family, result = new Result())) {
            return result;
        }
        this.checkRow(row, "getClosestRowBefore");
        this.startRegionOperation(Region.Operation.GET);
        this.readRequestsCount.increment();
        try {
            Store store = this.getStore(family);
            Cell key = store.getRowKeyAtOrBefore(row);
            Result result2 = null;
            if (key != null) {
                Get get = new Get(CellUtil.cloneRow((Cell)key));
                get.addFamily(family);
                result2 = this.get(get);
            }
            if (this.coprocessorHost != null) {
                this.coprocessorHost.postGetClosestRowBefore(row, family, result2);
            }
            Result result3 = result2;
            return result3;
        }
        finally {
            this.closeRegionOperation(Region.Operation.GET);
        }
    }

    @Override
    public RegionScanner getScanner(Scan scan) throws IOException {
        return this.getScanner(scan, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RegionScanner getScanner(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
        this.startRegionOperation(Region.Operation.SCAN);
        try {
            if (!scan.hasFamilies()) {
                for (byte[] family : this.htableDescriptor.getFamiliesKeys()) {
                    scan.addFamily(family);
                }
            } else {
                for (byte[] family : scan.getFamilyMap().keySet()) {
                    this.checkFamily(family);
                }
            }
            RegionScanner regionScanner = this.instantiateRegionScanner(scan, additionalScanners);
            return regionScanner;
        }
        finally {
            this.closeRegionOperation(Region.Operation.SCAN);
        }
    }

    protected RegionScanner instantiateRegionScanner(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
        if (scan.isReversed()) {
            if (scan.getFilter() != null) {
                scan.getFilter().setReversed(true);
            }
            return new ReversedRegionScannerImpl(scan, additionalScanners, this);
        }
        return new RegionScannerImpl(scan, additionalScanners, this);
    }

    @Override
    public void prepareDelete(Delete delete) throws IOException {
        if (delete.getFamilyCellMap().isEmpty()) {
            for (byte[] family : this.htableDescriptor.getFamiliesKeys()) {
                delete.addFamily(family, delete.getTimeStamp());
            }
        } else {
            for (byte[] family : delete.getFamilyCellMap().keySet()) {
                if (family == null) {
                    throw new NoSuchColumnFamilyException("Empty family is invalid");
                }
                this.checkFamily(family);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(Delete delete) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        this.startRegionOperation(Region.Operation.DELETE);
        try {
            delete.getRow();
            this.doBatchMutate((Mutation)delete);
        }
        finally {
            this.closeRegionOperation(Region.Operation.DELETE);
        }
    }

    void delete(NavigableMap<byte[], List<Cell>> familyMap, Durability durability) throws IOException {
        Delete delete = new Delete(FOR_UNIT_TESTS_ONLY);
        delete.setFamilyCellMap(familyMap);
        delete.setDurability(durability);
        this.doBatchMutate((Mutation)delete);
    }

    @Override
    public void prepareDeleteTimestamps(Mutation mutation, Map<byte[], List<Cell>> familyMap, byte[] byteNow) throws IOException {
        for (Map.Entry<byte[], List<Cell>> e : familyMap.entrySet()) {
            byte[] family = e.getKey();
            List<Cell> cells = e.getValue();
            assert (cells instanceof RandomAccess);
            TreeMap<byte[], Integer> kvCount = new TreeMap<byte[], Integer>(Bytes.BYTES_COMPARATOR);
            int listSize = cells.size();
            for (int i = 0; i < listSize; ++i) {
                Cell cell = cells.get(i);
                if (cell.getTimestamp() == Long.MAX_VALUE && CellUtil.isDeleteType((Cell)cell)) {
                    Integer count;
                    byte[] qual = CellUtil.cloneQualifier((Cell)cell);
                    if (qual == null) {
                        qual = HConstants.EMPTY_BYTE_ARRAY;
                    }
                    if ((count = (Integer)kvCount.get(qual)) == null) {
                        kvCount.put(qual, 1);
                    } else {
                        kvCount.put(qual, count + 1);
                    }
                    count = (Integer)kvCount.get(qual);
                    Get get = new Get(CellUtil.cloneRow((Cell)cell));
                    get.setMaxVersions(count.intValue());
                    get.addColumn(family, qual);
                    if (this.coprocessorHost != null) {
                        if (this.coprocessorHost.prePrepareTimeStampForDeleteVersion(mutation, cell, byteNow, get)) continue;
                        this.updateDeleteLatestVersionTimeStamp(cell, get, count, byteNow);
                        continue;
                    }
                    this.updateDeleteLatestVersionTimeStamp(cell, get, count, byteNow);
                    continue;
                }
                CellUtil.updateLatestStamp((Cell)cell, (byte[])byteNow, (int)0);
            }
        }
    }

    void updateDeleteLatestVersionTimeStamp(Cell cell, Get get, int count, byte[] byteNow) throws IOException {
        List<Cell> result = this.get(get, false);
        if (result.size() < count) {
            CellUtil.updateLatestStamp((Cell)cell, (byte[])byteNow, (int)0);
            return;
        }
        if (result.size() > count) {
            throw new RuntimeException("Unexpected size: " + result.size());
        }
        Cell getCell = result.get(count - 1);
        CellUtil.setTimestamp((Cell)cell, (long)getCell.getTimestamp());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Put put) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        this.startRegionOperation(Region.Operation.PUT);
        try {
            this.doBatchMutate((Mutation)put);
        }
        finally {
            this.closeRegionOperation(Region.Operation.PUT);
        }
    }

    @Override
    public OperationStatus[] batchMutate(Mutation[] mutations, long nonceGroup, long nonce) throws IOException {
        return this.batchMutate(new MutationBatch(mutations, nonceGroup, nonce));
    }

    public OperationStatus[] batchMutate(Mutation[] mutations) throws IOException {
        return this.batchMutate(mutations, 0L, 0L);
    }

    @Override
    public OperationStatus[] batchReplay(WALSplitter.MutationReplay[] mutations, long replaySeqId) throws IOException {
        if (!RegionReplicaUtil.isDefaultReplica((HRegionInfo)this.getRegionInfo()) && replaySeqId < this.lastReplayedOpenRegionSeqId) {
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)(this.getRegionInfo().getEncodedName() + " : " + "Skipping " + mutations.length + " mutations with replaySeqId=" + replaySeqId + " which is < than lastReplayedOpenRegionSeqId=" + this.lastReplayedOpenRegionSeqId));
                for (WALSplitter.MutationReplay mut : mutations) {
                    LOG.trace((Object)(this.getRegionInfo().getEncodedName() + " : Skipping : " + mut.mutation));
                }
            }
            OperationStatus[] statuses = new OperationStatus[mutations.length];
            for (int i = 0; i < statuses.length; ++i) {
                statuses[i] = OperationStatus.SUCCESS;
            }
            return statuses;
        }
        return this.batchMutate(new ReplayBatch(mutations, replaySeqId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    OperationStatus[] batchMutate(BatchOperationInProgress<?> batchOp) throws IOException {
        boolean initialized = false;
        Region.Operation op = batchOp.isInReplay() ? Region.Operation.REPLAY_BATCH_MUTATE : Region.Operation.BATCH_MUTATE;
        this.startRegionOperation(op);
        try {
            while (!batchOp.isDone()) {
                if (!batchOp.isInReplay()) {
                    this.checkReadOnly();
                }
                this.checkResources();
                if (!initialized) {
                    this.writeRequestsCount.add((long)batchOp.operations.length);
                    if (!batchOp.isInReplay()) {
                        this.doPreMutationHook(batchOp);
                    }
                    initialized = true;
                }
                this.doMiniBatchMutation(batchOp);
                long newSize = this.getMemstoreSize();
                if (!this.isFlushSize(newSize)) continue;
                this.requestFlush();
            }
        }
        finally {
            this.closeRegionOperation(op);
        }
        return batchOp.retCodeDetails;
    }

    private void doPreMutationHook(BatchOperationInProgress<?> batchOp) throws IOException {
        WALEdit walEdit = new WALEdit();
        if (this.coprocessorHost != null) {
            for (int i = 0; i < batchOp.operations.length; ++i) {
                Mutation m = batchOp.getMutation(i);
                if (m instanceof Put) {
                    if (this.coprocessorHost.prePut((Put)m, walEdit, m.getDurability())) {
                        batchOp.retCodeDetails[i] = OperationStatus.SUCCESS;
                    }
                } else if (m instanceof Delete) {
                    Delete curDel = (Delete)m;
                    if (curDel.getFamilyCellMap().isEmpty()) {
                        this.prepareDelete(curDel);
                    }
                    if (this.coprocessorHost.preDelete(curDel, walEdit, m.getDurability())) {
                        batchOp.retCodeDetails[i] = OperationStatus.SUCCESS;
                    }
                } else {
                    batchOp.retCodeDetails[i] = new OperationStatus(HConstants.OperationStatusCode.FAILURE, "Put/Delete mutations only supported in batchMutate() now");
                }
                if (walEdit.isEmpty()) continue;
                batchOp.walEditsFromCoprocessors[i] = walEdit;
                walEdit = new WALEdit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long doMiniBatchMutation(BatchOperationInProgress<?> batchOp) throws IOException {
        long l;
        int noOfDeletes;
        int noOfPuts;
        boolean success;
        int lastIndexExclusive;
        int firstIndex;
        ArrayList acquiredRowLocks;
        boolean locked;
        block85: {
            long now;
            long addedSize;
            long mvccNum;
            WALKey walKey;
            ArrayList<Cell> memstoreCells;
            Map[] familyMaps;
            boolean doRollBackMemstore;
            long txid;
            MultiVersionConsistencyControl.WriteEntry writeEntry;
            WALEdit walEdit;
            long currentNonce;
            long currentNonceGroup;
            boolean isInReplay;
            block83: {
                long mutation3;
                block84: {
                    MiniBatchOperationInProgress<Mutation> miniBatchOp;
                    byte[] byteNow;
                    int numReadyToWrite;
                    block81: {
                        long isPutMutation2;
                        block82: {
                            isInReplay = batchOp.isInReplay();
                            boolean putsCfSetConsistent = true;
                            Set putsCfSet = null;
                            boolean deletesCfSetConsistent = true;
                            Set deletesCfSet = null;
                            currentNonceGroup = 0L;
                            currentNonce = 0L;
                            walEdit = new WALEdit(isInReplay);
                            writeEntry = null;
                            txid = 0L;
                            doRollBackMemstore = false;
                            locked = false;
                            acquiredRowLocks = Lists.newArrayListWithCapacity((int)batchOp.operations.length);
                            familyMaps = new Map[batchOp.operations.length];
                            memstoreCells = new ArrayList<Cell>();
                            lastIndexExclusive = firstIndex = batchOp.nextIndexToProcess;
                            success = false;
                            noOfPuts = 0;
                            noOfDeletes = 0;
                            walKey = null;
                            mvccNum = 0L;
                            addedSize = 0L;
                            numReadyToWrite = 0;
                            now = EnvironmentEdgeManager.currentTime();
                            while (lastIndexExclusive < batchOp.operations.length) {
                                Mutation mutation2 = batchOp.getMutation(lastIndexExclusive);
                                boolean isPutMutation2 = mutation2 instanceof Put;
                                NavigableMap familyMap = mutation2.getFamilyCellMap();
                                familyMaps[lastIndexExclusive] = familyMap;
                                if (batchOp.retCodeDetails[lastIndexExclusive].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) {
                                    ++lastIndexExclusive;
                                    continue;
                                }
                                try {
                                    if (isPutMutation2) {
                                        if (isInReplay) {
                                            this.removeNonExistentColumnFamilyForReplay(familyMap);
                                        } else {
                                            this.checkFamilies(familyMap.keySet());
                                        }
                                        this.checkTimestamps(mutation2.getFamilyCellMap(), now);
                                    } else {
                                        this.prepareDelete((Delete)mutation2);
                                    }
                                    this.checkRow(mutation2.getRow(), "doMiniBatchMutation");
                                }
                                catch (NoSuchColumnFamilyException nscf) {
                                    LOG.warn((Object)"No such column family in batch mutation", (Throwable)nscf);
                                    batchOp.retCodeDetails[lastIndexExclusive] = new OperationStatus(HConstants.OperationStatusCode.BAD_FAMILY, nscf.getMessage());
                                    ++lastIndexExclusive;
                                    continue;
                                }
                                catch (FailedSanityCheckException fsce) {
                                    LOG.warn((Object)"Batch Mutation did not pass sanity check", (Throwable)fsce);
                                    batchOp.retCodeDetails[lastIndexExclusive] = new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, fsce.getMessage());
                                    ++lastIndexExclusive;
                                    continue;
                                }
                                catch (WrongRegionException we) {
                                    LOG.warn((Object)"Batch mutation had a row that does not belong to this region", (Throwable)we);
                                    batchOp.retCodeDetails[lastIndexExclusive] = new OperationStatus(HConstants.OperationStatusCode.SANITY_CHECK_FAILURE, we.getMessage());
                                    ++lastIndexExclusive;
                                    continue;
                                }
                                boolean shouldBlock = numReadyToWrite == 0;
                                Region.RowLock rowLock = null;
                                try {
                                    rowLock = this.getRowLockInternal(mutation2.getRow(), shouldBlock);
                                }
                                catch (IOException ioe) {
                                    LOG.warn((Object)("Failed getting lock in batch put, row=" + Bytes.toStringBinary((byte[])mutation2.getRow())), (Throwable)ioe);
                                }
                                if (rowLock == null) break;
                                acquiredRowLocks.add(rowLock);
                                ++lastIndexExclusive;
                                ++numReadyToWrite;
                                if (isPutMutation2) {
                                    if (putsCfSet == null) {
                                        putsCfSet = mutation2.getFamilyCellMap().keySet();
                                        continue;
                                    }
                                    putsCfSetConsistent = putsCfSetConsistent && mutation2.getFamilyCellMap().keySet().equals(putsCfSet);
                                    continue;
                                }
                                if (deletesCfSet == null) {
                                    deletesCfSet = mutation2.getFamilyCellMap().keySet();
                                    continue;
                                }
                                deletesCfSetConsistent = deletesCfSetConsistent && mutation2.getFamilyCellMap().keySet().equals(deletesCfSet);
                            }
                            now = EnvironmentEdgeManager.currentTime();
                            byteNow = Bytes.toBytes((long)now);
                            if (numReadyToWrite > 0) break block81;
                            isPutMutation2 = 0L;
                            if (doRollBackMemstore) {
                                this.rollbackMemstore(memstoreCells);
                                if (writeEntry != null) {
                                    this.mvcc.cancelMemstoreInsert(writeEntry);
                                }
                                break block82;
                            }
                            this.addAndGetGlobalMemstoreSize(addedSize);
                            if (writeEntry != null) {
                                this.mvcc.completeMemstoreInsertWithSeqNum(writeEntry, walKey);
                            }
                        }
                        if (locked) {
                            this.updatesLock.readLock().unlock();
                        }
                        this.releaseRowLocks(acquiredRowLocks);
                        if (noOfPuts > 0 && this.metricsRegion != null) {
                            this.metricsRegion.updatePut();
                        }
                        if (noOfDeletes > 0 && this.metricsRegion != null) {
                            this.metricsRegion.updateDelete();
                        }
                        if (!success) {
                            for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                                if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                                batchOp.retCodeDetails[i] = OperationStatus.FAILURE;
                            }
                        }
                        if (this.coprocessorHost != null && !batchOp.isInReplay()) {
                            MiniBatchOperationInProgress<Mutation> miniBatchOp2 = new MiniBatchOperationInProgress<Mutation>(batchOp.getMutationsForCoprocs(), batchOp.retCodeDetails, batchOp.walEditsFromCoprocessors, firstIndex, lastIndexExclusive);
                            this.coprocessorHost.postBatchMutateIndispensably(miniBatchOp2, success);
                        }
                        batchOp.nextIndexToProcess = lastIndexExclusive;
                        return isPutMutation2;
                    }
                    for (int i = firstIndex; !isInReplay && i < lastIndexExclusive; ++i) {
                        if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                        Mutation mutation3 = batchOp.getMutation(i);
                        if (mutation3 instanceof Put) {
                            this.updateCellTimestamps(familyMaps[i].values(), byteNow);
                            ++noOfPuts;
                        } else {
                            this.prepareDeleteTimestamps(mutation3, familyMaps[i], byteNow);
                            ++noOfDeletes;
                        }
                        this.rewriteCellTags(familyMaps[i], mutation3);
                    }
                    this.lock(this.updatesLock.readLock(), numReadyToWrite);
                    locked = true;
                    mvccNum = isInReplay ? batchOp.getReplaySequenceId() : MultiVersionConsistencyControl.getPreAssignedWriteNumber(this.sequenceId);
                    writeEntry = this.mvcc.beginMemstoreInsertWithSeqNum(mvccNum);
                    if (isInReplay || this.coprocessorHost == null || !this.coprocessorHost.preBatchMutate(miniBatchOp = new MiniBatchOperationInProgress<Mutation>(batchOp.getMutationsForCoprocs(), batchOp.retCodeDetails, batchOp.walEditsFromCoprocessors, firstIndex, lastIndexExclusive))) break block83;
                    mutation3 = 0L;
                    if (doRollBackMemstore) {
                        this.rollbackMemstore(memstoreCells);
                        if (writeEntry != null) {
                            this.mvcc.cancelMemstoreInsert(writeEntry);
                        }
                        break block84;
                    }
                    this.addAndGetGlobalMemstoreSize(addedSize);
                    if (writeEntry != null) {
                        this.mvcc.completeMemstoreInsertWithSeqNum(writeEntry, walKey);
                    }
                }
                if (locked) {
                    this.updatesLock.readLock().unlock();
                }
                this.releaseRowLocks(acquiredRowLocks);
                if (noOfPuts > 0 && this.metricsRegion != null) {
                    this.metricsRegion.updatePut();
                }
                if (noOfDeletes > 0 && this.metricsRegion != null) {
                    this.metricsRegion.updateDelete();
                }
                if (!success) {
                    for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                        if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                        batchOp.retCodeDetails[i] = OperationStatus.FAILURE;
                    }
                }
                if (this.coprocessorHost != null && !batchOp.isInReplay()) {
                    MiniBatchOperationInProgress<Mutation> miniBatchOp = new MiniBatchOperationInProgress<Mutation>(batchOp.getMutationsForCoprocs(), batchOp.retCodeDetails, batchOp.walEditsFromCoprocessors, firstIndex, lastIndexExclusive);
                    this.coprocessorHost.postBatchMutateIndispensably(miniBatchOp, success);
                }
                batchOp.nextIndexToProcess = lastIndexExclusive;
                return mutation3;
            }
            try {
                for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                    if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                    doRollBackMemstore = true;
                    addedSize += this.applyFamilyMapToMemstore(familyMaps[i], mvccNum, memstoreCells, isInReplay);
                }
                Durability durability = Durability.USE_DEFAULT;
                for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                    WALEdit fromCP;
                    if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                    batchOp.retCodeDetails[i] = OperationStatus.SUCCESS;
                    Mutation m = batchOp.getMutation(i);
                    Durability tmpDur = this.getEffectiveDurability(m.getDurability());
                    if (tmpDur.ordinal() > durability.ordinal()) {
                        durability = tmpDur;
                    }
                    if (tmpDur == Durability.SKIP_WAL) {
                        this.recordMutationWithoutWal(m.getFamilyCellMap());
                        continue;
                    }
                    long nonceGroup = batchOp.getNonceGroup(i);
                    long nonce = batchOp.getNonce(i);
                    if (nonceGroup != currentNonceGroup || nonce != currentNonce) {
                        if (walEdit.size() > 0) {
                            assert (isInReplay);
                            if (!isInReplay) {
                                throw new IOException("Multiple nonces per batch and not in replay");
                            }
                            walKey = new ReplayHLogKey(this.getRegionInfo().getEncodedNameAsBytes(), this.htableDescriptor.getTableName(), now, m.getClusterIds(), currentNonceGroup, currentNonce);
                            txid = this.wal.append(this.htableDescriptor, this.getRegionInfo(), walKey, walEdit, this.getSequenceId(), true, null);
                            walEdit = new WALEdit(isInReplay);
                            walKey = null;
                        }
                        currentNonceGroup = nonceGroup;
                        currentNonce = nonce;
                    }
                    if ((fromCP = batchOp.walEditsFromCoprocessors[i]) != null) {
                        for (Cell cell : fromCP.getCells()) {
                            walEdit.add(cell);
                        }
                    }
                    this.addFamilyMapToWALEdit(familyMaps[i], walEdit);
                }
                Mutation mutation = batchOp.getMutation(firstIndex);
                if (isInReplay) {
                    long seqId;
                    walKey = new ReplayHLogKey(this.getRegionInfo().getEncodedNameAsBytes(), this.htableDescriptor.getTableName(), -1L, now, mutation.getClusterIds(), currentNonceGroup, currentNonce);
                    long replaySeqId = batchOp.getReplaySequenceId();
                    walKey.setOrigLogSeqNum(replaySeqId);
                    while ((seqId = this.getSequenceId().get()) < replaySeqId && !this.getSequenceId().compareAndSet(seqId, replaySeqId)) {
                    }
                }
                if (walEdit.size() > 0) {
                    if (!isInReplay) {
                        walKey = new HLogKey(this.getRegionInfo().getEncodedNameAsBytes(), this.htableDescriptor.getTableName(), -1L, now, mutation.getClusterIds(), currentNonceGroup, currentNonce);
                    }
                    txid = this.wal.append(this.htableDescriptor, this.getRegionInfo(), walKey, walEdit, this.getSequenceId(), true, memstoreCells);
                }
                if (walKey == null) {
                    walKey = this.appendEmptyEdit(this.wal, memstoreCells);
                }
                if (locked) {
                    this.updatesLock.readLock().unlock();
                    locked = false;
                }
                this.releaseRowLocks(acquiredRowLocks);
                if (txid != 0L) {
                    this.syncOrDefer(txid, durability);
                }
                doRollBackMemstore = false;
                if (!isInReplay && this.coprocessorHost != null) {
                    MiniBatchOperationInProgress<Mutation> miniBatchOp = new MiniBatchOperationInProgress<Mutation>(batchOp.getMutationsForCoprocs(), batchOp.retCodeDetails, batchOp.walEditsFromCoprocessors, firstIndex, lastIndexExclusive);
                    this.coprocessorHost.postBatchMutate(miniBatchOp);
                }
                if (writeEntry != null) {
                    this.mvcc.completeMemstoreInsertWithSeqNum(writeEntry, walKey);
                    writeEntry = null;
                }
                if (!isInReplay && this.coprocessorHost != null) {
                    for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                        if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.SUCCESS) continue;
                        Mutation m = batchOp.getMutation(i);
                        if (m instanceof Put) {
                            this.coprocessorHost.postPut((Put)m, walEdit, m.getDurability());
                            continue;
                        }
                        this.coprocessorHost.postDelete((Delete)m, walEdit, m.getDurability());
                    }
                }
                success = true;
                l = addedSize;
                if (doRollBackMemstore) {
                    this.rollbackMemstore(memstoreCells);
                    if (writeEntry != null) {
                        this.mvcc.cancelMemstoreInsert(writeEntry);
                    }
                    break block85;
                }
                this.addAndGetGlobalMemstoreSize(addedSize);
            }
            catch (Throwable throwable) {
                if (doRollBackMemstore) {
                    this.rollbackMemstore(memstoreCells);
                    if (writeEntry != null) {
                        this.mvcc.cancelMemstoreInsert(writeEntry);
                    }
                } else {
                    this.addAndGetGlobalMemstoreSize(addedSize);
                    if (writeEntry != null) {
                        this.mvcc.completeMemstoreInsertWithSeqNum(writeEntry, walKey);
                    }
                }
                if (locked) {
                    this.updatesLock.readLock().unlock();
                }
                this.releaseRowLocks(acquiredRowLocks);
                if (noOfPuts > 0 && this.metricsRegion != null) {
                    this.metricsRegion.updatePut();
                }
                if (noOfDeletes > 0 && this.metricsRegion != null) {
                    this.metricsRegion.updateDelete();
                }
                if (!success) {
                    for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                        if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                        batchOp.retCodeDetails[i] = OperationStatus.FAILURE;
                    }
                }
                if (this.coprocessorHost != null && !batchOp.isInReplay()) {
                    MiniBatchOperationInProgress<Mutation> miniBatchOp = new MiniBatchOperationInProgress<Mutation>(batchOp.getMutationsForCoprocs(), batchOp.retCodeDetails, batchOp.walEditsFromCoprocessors, firstIndex, lastIndexExclusive);
                    this.coprocessorHost.postBatchMutateIndispensably(miniBatchOp, success);
                }
                batchOp.nextIndexToProcess = lastIndexExclusive;
                throw throwable;
            }
            if (writeEntry != null) {
                this.mvcc.completeMemstoreInsertWithSeqNum(writeEntry, walKey);
            }
        }
        if (locked) {
            this.updatesLock.readLock().unlock();
        }
        this.releaseRowLocks(acquiredRowLocks);
        if (noOfPuts > 0 && this.metricsRegion != null) {
            this.metricsRegion.updatePut();
        }
        if (noOfDeletes > 0 && this.metricsRegion != null) {
            this.metricsRegion.updateDelete();
        }
        if (!success) {
            for (int i = firstIndex; i < lastIndexExclusive; ++i) {
                if (batchOp.retCodeDetails[i].getOperationStatusCode() != HConstants.OperationStatusCode.NOT_RUN) continue;
                batchOp.retCodeDetails[i] = OperationStatus.FAILURE;
            }
        }
        if (this.coprocessorHost != null && !batchOp.isInReplay()) {
            MiniBatchOperationInProgress<Mutation> miniBatchOp = new MiniBatchOperationInProgress<Mutation>(batchOp.getMutationsForCoprocs(), batchOp.retCodeDetails, batchOp.walEditsFromCoprocessors, firstIndex, lastIndexExclusive);
            this.coprocessorHost.postBatchMutateIndispensably(miniBatchOp, success);
        }
        batchOp.nextIndexToProcess = lastIndexExclusive;
        return l;
    }

    protected Durability getEffectiveDurability(Durability d) {
        return d == Durability.USE_DEFAULT ? this.durability : d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkAndMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, Mutation w, boolean writeToWAL) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        boolean isPut = w instanceof Put;
        if (!isPut && !(w instanceof Delete)) {
            throw new DoNotRetryIOException("Action must be Put or Delete");
        }
        if (!Bytes.equals((byte[])row, (byte[])w.getRow())) {
            throw new DoNotRetryIOException("Action's getRow must match the passed row");
        }
        this.startRegionOperation();
        try {
            Region.RowLock rowLock;
            block30: {
                Get get;
                block29: {
                    get = new Get(row);
                    this.checkFamily(family);
                    get.addColumn(family, qualifier);
                    rowLock = this.getRowLock(get.getRow());
                    this.mvcc.waitForPreviousTransactionsComplete();
                    try {
                        if (this.getCoprocessorHost() == null) break block29;
                        Boolean processed = null;
                        if (w instanceof Put) {
                            processed = this.getCoprocessorHost().preCheckAndPutAfterRowLock(row, family, qualifier, compareOp, comparator, (Put)w);
                        } else if (w instanceof Delete) {
                            processed = this.getCoprocessorHost().preCheckAndDeleteAfterRowLock(row, family, qualifier, compareOp, comparator, (Delete)w);
                        }
                        if (processed == null) break block29;
                        boolean bl = processed;
                        rowLock.release();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        rowLock.release();
                        throw throwable;
                    }
                }
                List<Cell> result = this.get(get, false);
                boolean valueIsNull = comparator.getValue() == null || comparator.getValue().length == 0;
                boolean matches = false;
                long cellTs = 0L;
                if (result.size() == 0 && valueIsNull) {
                    matches = true;
                } else if (result.size() > 0 && result.get(0).getValueLength() == 0 && valueIsNull) {
                    matches = true;
                    cellTs = result.get(0).getTimestamp();
                } else if (result.size() == 1 && !valueIsNull) {
                    Cell kv = result.get(0);
                    cellTs = kv.getTimestamp();
                    int compareResult = comparator.compareTo(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
                    switch (compareOp) {
                        case LESS: {
                            matches = compareResult < 0;
                            break;
                        }
                        case LESS_OR_EQUAL: {
                            matches = compareResult <= 0;
                            break;
                        }
                        case EQUAL: {
                            matches = compareResult == 0;
                            break;
                        }
                        case NOT_EQUAL: {
                            matches = compareResult != 0;
                            break;
                        }
                        case GREATER_OR_EQUAL: {
                            matches = compareResult >= 0;
                            break;
                        }
                        case GREATER: {
                            matches = compareResult > 0;
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unknown Compare op " + compareOp.name());
                        }
                    }
                }
                if (!matches) break block30;
                long now = EnvironmentEdgeManager.currentTime();
                long ts = Math.max(now, cellTs);
                byte[] byteTs = Bytes.toBytes((long)ts);
                if (w instanceof Put) {
                    this.updateCellTimestamps(w.getFamilyCellMap().values(), byteTs);
                }
                this.doBatchMutate(w);
                this.checkAndMutateChecksPassed.increment();
                boolean bl = true;
                rowLock.release();
                return bl;
            }
            this.checkAndMutateChecksFailed.increment();
            boolean bl = false;
            rowLock.release();
            return bl;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkAndRowMutate(byte[] row, byte[] family, byte[] qualifier, CompareFilter.CompareOp compareOp, ByteArrayComparable comparator, RowMutations rm, boolean writeToWAL) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        this.startRegionOperation();
        try {
            Region.RowLock rowLock;
            block22: {
                Get get = new Get(row);
                this.checkFamily(family);
                get.addColumn(family, qualifier);
                rowLock = this.getRowLock(get.getRow());
                this.mvcc.waitForPreviousTransactionsComplete();
                try {
                    List<Cell> result = this.get(get, false);
                    boolean valueIsNull = comparator.getValue() == null || comparator.getValue().length == 0;
                    boolean matches = false;
                    long cellTs = 0L;
                    if (result.size() == 0 && valueIsNull) {
                        matches = true;
                    } else if (result.size() > 0 && result.get(0).getValueLength() == 0 && valueIsNull) {
                        matches = true;
                        cellTs = result.get(0).getTimestamp();
                    } else if (result.size() == 1 && !valueIsNull) {
                        Cell kv = result.get(0);
                        cellTs = kv.getTimestamp();
                        int compareResult = comparator.compareTo(kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
                        switch (compareOp) {
                            case LESS: {
                                matches = compareResult < 0;
                                break;
                            }
                            case LESS_OR_EQUAL: {
                                matches = compareResult <= 0;
                                break;
                            }
                            case EQUAL: {
                                matches = compareResult == 0;
                                break;
                            }
                            case NOT_EQUAL: {
                                matches = compareResult != 0;
                                break;
                            }
                            case GREATER_OR_EQUAL: {
                                matches = compareResult >= 0;
                                break;
                            }
                            case GREATER: {
                                matches = compareResult > 0;
                                break;
                            }
                            default: {
                                throw new RuntimeException("Unknown Compare op " + compareOp.name());
                            }
                        }
                    }
                    if (!matches) break block22;
                    long now = EnvironmentEdgeManager.currentTime();
                    long ts = Math.max(now, cellTs);
                    byte[] byteTs = Bytes.toBytes((long)ts);
                    for (Mutation w : rm.getMutations()) {
                        if (!(w instanceof Put)) continue;
                        this.updateCellTimestamps(w.getFamilyCellMap().values(), byteTs);
                    }
                    this.mutateRow(rm);
                    this.checkAndMutateChecksPassed.increment();
                    boolean bl = true;
                    rowLock.release();
                    return bl;
                }
                catch (Throwable throwable) {
                    rowLock.release();
                    throw throwable;
                }
            }
            this.checkAndMutateChecksFailed.increment();
            boolean bl = false;
            rowLock.release();
            return bl;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    private void doBatchMutate(Mutation mutation) throws IOException {
        OperationStatus[] batchMutate = this.batchMutate(new Mutation[]{mutation});
        if (batchMutate[0].getOperationStatusCode().equals((Object)HConstants.OperationStatusCode.SANITY_CHECK_FAILURE)) {
            throw new FailedSanityCheckException(batchMutate[0].getExceptionMsg());
        }
        if (batchMutate[0].getOperationStatusCode().equals((Object)HConstants.OperationStatusCode.BAD_FAMILY)) {
            throw new NoSuchColumnFamilyException(batchMutate[0].getExceptionMsg());
        }
    }

    public void addRegionToSnapshot(HBaseProtos.SnapshotDescription desc, ForeignExceptionSnare exnSnare) throws IOException {
        Path rootDir = FSUtils.getRootDir(this.conf);
        Path snapshotDir = SnapshotDescriptionUtils.getWorkingSnapshotDir(desc, rootDir);
        SnapshotManifest manifest = SnapshotManifest.create(this.conf, this.getFilesystem(), snapshotDir, desc, exnSnare);
        manifest.addRegion(this);
    }

    @Override
    public void updateCellTimestamps(Iterable<List<Cell>> cellItr, byte[] now) throws IOException {
        for (List<Cell> cells : cellItr) {
            if (cells == null) continue;
            assert (cells instanceof RandomAccess);
            int listSize = cells.size();
            for (int i = 0; i < listSize; ++i) {
                CellUtil.updateLatestStamp((Cell)cells.get(i), (byte[])now, (int)0);
            }
        }
    }

    void rewriteCellTags(Map<byte[], List<Cell>> familyMap, Mutation m) {
        if (m.getTTL() == Long.MAX_VALUE) {
            return;
        }
        for (Map.Entry<byte[], List<Cell>> e : familyMap.entrySet()) {
            List<Cell> cells = e.getValue();
            assert (cells instanceof RandomAccess);
            int listSize = cells.size();
            for (int i = 0; i < listSize; ++i) {
                Cell cell = cells.get(i);
                List<Tag> newTags = Tag.carryForwardTags(null, (Cell)cell);
                newTags = HRegion.carryForwardTTLTag(newTags, m);
                cells.set(i, (Cell)new KeyValue(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp(), KeyValue.Type.codeToType((byte)cell.getTypeByte()), cell.getValueArray(), cell.getValueOffset(), cell.getValueLength(), newTags));
            }
        }
    }

    private void checkResources() throws RegionTooBusyException {
        if (this.getRegionInfo().isMetaRegion()) {
            return;
        }
        if (this.memstoreSize.get() > this.blockingMemStoreSize) {
            this.blockedRequestsCount.increment();
            this.requestFlush();
            throw new RegionTooBusyException("Above memstore limit, regionName=" + (this.getRegionInfo() == null ? "unknown" : this.getRegionInfo().getRegionNameAsString()) + ", server=" + (this.getRegionServerServices() == null ? "unknown" : this.getRegionServerServices().getServerName()) + ", memstoreSize=" + this.memstoreSize.get() + ", blockingMemStoreSize=" + this.blockingMemStoreSize);
        }
    }

    protected void checkReadOnly() throws IOException {
        if (this.isReadOnly()) {
            throw new DoNotRetryIOException("region is read only");
        }
    }

    protected void checkReadsEnabled() throws IOException {
        if (!this.writestate.readsEnabled) {
            throw new IOException(this.getRegionInfo().getEncodedName() + ": The region's reads are disabled. Cannot serve the request");
        }
    }

    public void setReadsEnabled(boolean readsEnabled) {
        if (readsEnabled && !this.writestate.readsEnabled) {
            LOG.info((Object)(this.getRegionInfo().getEncodedName() + " : Enabling reads for region."));
        }
        this.writestate.setReadsEnabled(readsEnabled);
    }

    private void put(byte[] row, byte[] family, List<Cell> edits) throws IOException {
        TreeMap<byte[], List<Cell>> familyMap = new TreeMap<byte[], List<Cell>>(Bytes.BYTES_COMPARATOR);
        familyMap.put(family, edits);
        Put p = new Put(row);
        p.setFamilyCellMap(familyMap);
        this.doBatchMutate((Mutation)p);
    }

    private long applyFamilyMapToMemstore(Map<byte[], List<Cell>> familyMap, long mvccNum, List<Cell> memstoreCells, boolean isInReplay) throws IOException {
        long size = 0L;
        for (Map.Entry<byte[], List<Cell>> e : familyMap.entrySet()) {
            byte[] family = e.getKey();
            List<Cell> cells = e.getValue();
            assert (cells instanceof RandomAccess);
            Store store = this.getStore(family);
            int listSize = cells.size();
            for (int i = 0; i < listSize; ++i) {
                Cell cell = cells.get(i);
                CellUtil.setSequenceId((Cell)cell, (long)mvccNum);
                Pair<Long, Cell> ret = store.add(cell);
                size += ((Long)ret.getFirst()).longValue();
                memstoreCells.add((Cell)ret.getSecond());
                if (!isInReplay) continue;
                CellUtil.setSequenceId((Cell)((Cell)ret.getSecond()), (long)mvccNum);
            }
        }
        return size;
    }

    private void rollbackMemstore(List<Cell> memstoreCells) {
        int kvsRolledback = 0;
        for (Cell cell : memstoreCells) {
            byte[] family = CellUtil.cloneFamily((Cell)cell);
            Store store = this.getStore(family);
            store.rollback(cell);
            ++kvsRolledback;
        }
        LOG.debug((Object)("rollbackMemstore rolled back " + kvsRolledback));
    }

    @Override
    public void checkFamilies(Collection<byte[]> families) throws NoSuchColumnFamilyException {
        for (byte[] family : families) {
            this.checkFamily(family);
        }
    }

    private void removeNonExistentColumnFamilyForReplay(Map<byte[], List<Cell>> familyMap) {
        ArrayList<byte[]> nonExistentList = null;
        for (byte[] family : familyMap.keySet()) {
            if (this.htableDescriptor.hasFamily(family)) continue;
            if (nonExistentList == null) {
                nonExistentList = new ArrayList<byte[]>();
            }
            nonExistentList.add(family);
        }
        if (nonExistentList != null) {
            for (byte[] family : nonExistentList) {
                LOG.info((Object)("No family for " + Bytes.toString((byte[])family) + " omit from reply."));
                familyMap.remove(family);
            }
        }
    }

    @Override
    public void checkTimestamps(Map<byte[], List<Cell>> familyMap, long now) throws FailedSanityCheckException {
        if (this.timestampSlop == Long.MAX_VALUE) {
            return;
        }
        long maxTs = now + this.timestampSlop;
        for (List<Cell> kvs : familyMap.values()) {
            assert (kvs instanceof RandomAccess);
            int listSize = kvs.size();
            for (int i = 0; i < listSize; ++i) {
                Cell cell = kvs.get(i);
                long ts = cell.getTimestamp();
                if (ts == Long.MAX_VALUE || ts <= maxTs) continue;
                throw new FailedSanityCheckException("Timestamp for KV out of range " + cell + " (too.new=" + this.timestampSlop + ")");
            }
        }
    }

    private void addFamilyMapToWALEdit(Map<byte[], List<Cell>> familyMap, WALEdit walEdit) {
        for (List<Cell> edits : familyMap.values()) {
            assert (edits instanceof RandomAccess);
            int listSize = edits.size();
            for (int i = 0; i < listSize; ++i) {
                Cell cell = edits.get(i);
                walEdit.add(cell);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFlush() {
        if (this.rsServices == null) {
            return;
        }
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            if (this.writestate.isFlushRequested()) {
                return;
            }
            this.writestate.flushRequested = true;
        }
        this.rsServices.getFlushRequester().requestFlush(this, false);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Flush requested on " + this));
        }
    }

    private boolean isFlushSize(long size) {
        return size > this.memstoreFlushSize;
    }

    protected long replayRecoveredEditsIfAny(Path regiondir, Map<byte[], Long> maxSeqIdInStores, CancelableProgressable reporter, MonitoredTask status) throws IOException {
        long minSeqIdForTheRegion = -1L;
        for (Long maxSeqIdInStore : maxSeqIdInStores.values()) {
            if (maxSeqIdInStore >= minSeqIdForTheRegion && minSeqIdForTheRegion != -1L) continue;
            minSeqIdForTheRegion = maxSeqIdInStore;
        }
        long seqid = minSeqIdForTheRegion;
        FileSystem fs = this.fs.getFileSystem();
        NavigableSet<Path> files = WALSplitter.getSplitEditFilesSorted(fs, regiondir);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Found " + (files == null ? 0 : files.size()) + " recovered edits file(s) under " + regiondir));
        }
        if (files == null || files.isEmpty()) {
            return seqid;
        }
        for (Path edits : files) {
            if (edits == null || !fs.exists(edits)) {
                LOG.warn((Object)("Null or non-existent edits file: " + edits));
                continue;
            }
            if (HRegion.isZeroLengthThenDelete(fs, edits)) continue;
            String fileName = edits.getName();
            long maxSeqId = Math.abs(Long.parseLong(fileName));
            if (maxSeqId <= minSeqIdForTheRegion) {
                if (!LOG.isDebugEnabled()) continue;
                String msg = "Maximum sequenceid for this wal is " + maxSeqId + " and minimum sequenceid for the region is " + minSeqIdForTheRegion + ", skipped the whole file, path=" + edits;
                LOG.debug((Object)msg);
                continue;
            }
            try {
                seqid = Math.max(seqid, this.replayRecoveredEdits(edits, maxSeqIdInStores, reporter));
            }
            catch (IOException e) {
                boolean skipErrors = this.conf.getBoolean("hbase.hregion.edits.replay.skip.errors", this.conf.getBoolean("hbase.skip.errors", false));
                if (this.conf.get("hbase.skip.errors") != null) {
                    LOG.warn((Object)"The property 'hbase.skip.errors' has been deprecated. Please use hbase.hregion.edits.replay.skip.errors instead.");
                }
                if (skipErrors) {
                    Path p = WALSplitter.moveAsideBadEditsFile(fs, edits);
                    LOG.error((Object)("hbase.hregion.edits.replay.skip.errors=true so continuing. Renamed " + edits + " as " + p), (Throwable)e);
                    continue;
                }
                throw e;
            }
        }
        if (this.rsAccounting != null) {
            this.rsAccounting.clearRegionReplayEditsSize(this.getRegionInfo().getRegionName());
        }
        if (seqid > minSeqIdForTheRegion) {
            this.internalFlushcache(null, seqid, this.stores.values(), status, false);
        }
        if (files.size() > 0 && this.conf.getBoolean("hbase.region.archive.recovered.edits", false)) {
            String fakeFamilyName = WALSplitter.getRegionDirRecoveredEditsDir(regiondir).getName();
            HashSet<StoreFile> fakeStoreFiles = new HashSet<StoreFile>(files.size());
            for (Path file : files) {
                fakeStoreFiles.add(new StoreFile(this.getRegionFileSystem().getFileSystem(), file, this.conf, null, null));
            }
            this.getRegionFileSystem().removeStoreFiles(fakeFamilyName, fakeStoreFiles);
        } else {
            for (Path file : files) {
                if (!fs.delete(file, false)) {
                    LOG.error((Object)("Failed delete of " + file));
                    continue;
                }
                LOG.debug((Object)("Deleted recovered.edits file=" + file));
            }
        }
        return seqid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long replayRecoveredEdits(Path edits, Map<byte[], Long> maxSeqIdInStores, CancelableProgressable reporter) throws IOException {
        String msg = "Replaying edits from " + edits;
        LOG.info((Object)msg);
        MonitoredTask status = TaskMonitor.get().createStatus(msg);
        FileSystem fs = this.fs.getFileSystem();
        status.setStatus("Opening recovered edits");
        WAL.Reader reader = null;
        try {
            reader = WALFactory.createReader(fs, edits, this.conf);
            long currentEditSeqId = -1L;
            long currentReplaySeqId = -1L;
            long firstSeqIdInLog = -1L;
            long skippedEdits = 0L;
            long editsCount = 0L;
            long intervalEdits = 0L;
            Store store = null;
            boolean reported_once = false;
            ServerNonceManager ng = this.rsServices == null ? null : this.rsServices.getNonceManager();
            try {
                WAL.Entry entry;
                int interval = this.conf.getInt("hbase.hstore.report.interval.edits", 2000);
                int period = this.conf.getInt("hbase.hstore.report.period", 300000);
                long lastReport = EnvironmentEdgeManager.currentTime();
                while ((entry = reader.next()) != null) {
                    WALKey key = entry.getKey();
                    WALEdit val = entry.getEdit();
                    if (ng != null) {
                        ng.reportOperationFromWal(key.getNonceGroup(), key.getNonce(), key.getWriteTime());
                    }
                    if (reporter != null && (intervalEdits += (long)val.size()) >= (long)interval) {
                        intervalEdits = 0L;
                        long cur = EnvironmentEdgeManager.currentTime();
                        if (lastReport + (long)period <= cur) {
                            status.setStatus("Replaying edits... skipped=" + skippedEdits + " edits=" + editsCount);
                            if (!reporter.progress()) {
                                msg = "Progressable reporter failed, stopping replay";
                                LOG.warn((Object)msg);
                                status.abort(msg);
                                throw new IOException(msg);
                            }
                            reported_once = true;
                            lastReport = cur;
                        }
                    }
                    if (firstSeqIdInLog == -1L) {
                        firstSeqIdInLog = key.getLogSeqNum();
                    }
                    if (currentEditSeqId > key.getLogSeqNum()) {
                        LOG.error((Object)(this.getRegionInfo().getEncodedName() + " : " + "Found decreasing SeqId. PreId=" + currentEditSeqId + " key=" + key + "; edit=" + val));
                    } else {
                        currentEditSeqId = key.getLogSeqNum();
                    }
                    long l = currentReplaySeqId = key.getOrigLogSeqNum() > 0L ? key.getOrigLogSeqNum() : currentEditSeqId;
                    if (this.coprocessorHost != null) {
                        status.setStatus("Running pre-WAL-restore hook in coprocessors");
                        if (this.coprocessorHost.preWALRestore(this.getRegionInfo(), key, val)) continue;
                    }
                    if (!Bytes.equals((byte[])key.getEncodedRegionName(), (byte[])this.getRegionInfo().getEncodedNameAsBytes())) {
                        ++skippedEdits;
                        continue;
                    }
                    boolean flush = false;
                    for (Cell cell : val.getCells()) {
                        if (CellUtil.matchingFamily((Cell)cell, (byte[])WALEdit.METAFAMILY)) {
                            WALProtos.CompactionDescriptor compaction = WALEdit.getCompaction(cell);
                            if (compaction != null) {
                                this.replayWALCompactionMarker(compaction, false, true, Long.MAX_VALUE);
                            }
                            ++skippedEdits;
                            continue;
                        }
                        if (store == null || !CellUtil.matchingFamily((Cell)cell, (byte[])store.getFamily().getName())) {
                            store = this.getStore(cell);
                        }
                        if (store == null) {
                            LOG.warn((Object)("No family for " + cell));
                            ++skippedEdits;
                            continue;
                        }
                        if (key.getLogSeqNum() <= maxSeqIdInStores.get(store.getFamily().getName())) {
                            ++skippedEdits;
                            continue;
                        }
                        CellUtil.setSequenceId((Cell)cell, (long)currentReplaySeqId);
                        flush |= this.restoreEdit(store, cell);
                        ++editsCount;
                    }
                    if (flush) {
                        this.internalFlushcache(null, currentEditSeqId, this.stores.values(), status, false);
                    }
                    if (this.coprocessorHost == null) continue;
                    this.coprocessorHost.postWALRestore(this.getRegionInfo(), key, val);
                }
            }
            catch (EOFException eof) {
                Path p = WALSplitter.moveAsideBadEditsFile(fs, edits);
                msg = "Encountered EOF. Most likely due to Master failure during wal splitting, so we have this data in another edit.  Continuing, but renaming " + edits + " as " + p;
                LOG.warn((Object)msg, (Throwable)eof);
                status.abort(msg);
            }
            catch (IOException ioe) {
                if (ioe.getCause() instanceof ParseException) {
                    Path p = WALSplitter.moveAsideBadEditsFile(fs, edits);
                    msg = "File corruption encountered!  Continuing, but renaming " + edits + " as " + p;
                    LOG.warn((Object)msg, (Throwable)ioe);
                    status.setStatus(msg);
                }
                status.abort(StringUtils.stringifyException((Throwable)ioe));
                throw ioe;
            }
            if (reporter != null && !reported_once) {
                reporter.progress();
            }
            msg = "Applied " + editsCount + ", skipped " + skippedEdits + ", firstSequenceIdInLog=" + firstSeqIdInLog + ", maxSequenceIdInLog=" + currentEditSeqId + ", path=" + edits;
            status.markComplete(msg);
            LOG.debug((Object)msg);
            long l = currentEditSeqId;
            return l;
        }
        finally {
            status.cleanup();
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replayWALCompactionMarker(WALProtos.CompactionDescriptor compaction, boolean pickCompactionFiles, boolean removeFiles, long replaySeqId) throws IOException {
        this.checkTargetRegion(compaction.getEncodedRegionName().toByteArray(), "Compaction marker from WAL ", compaction);
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            if (replaySeqId < this.lastReplayedOpenRegionSeqId) {
                LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Skipping replaying compaction event :" + TextFormat.shortDebugString((MessageOrBuilder)compaction) + " because its sequence id " + replaySeqId + " is smaller than this regions " + "lastReplayedOpenRegionSeqId of " + this.lastReplayedOpenRegionSeqId));
                return;
            }
            if (replaySeqId < this.lastReplayedCompactionSeqId) {
                LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Skipping replaying compaction event :" + TextFormat.shortDebugString((MessageOrBuilder)compaction) + " because its sequence id " + replaySeqId + " is smaller than this regions " + "lastReplayedCompactionSeqId of " + this.lastReplayedCompactionSeqId));
                return;
            }
            this.lastReplayedCompactionSeqId = replaySeqId;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getRegionInfo().getEncodedName() + " : " + "Replaying compaction marker " + TextFormat.shortDebugString((MessageOrBuilder)compaction) + " with seqId=" + replaySeqId + " and lastReplayedOpenRegionSeqId=" + this.lastReplayedOpenRegionSeqId));
            }
            this.startRegionOperation(Region.Operation.REPLAY_EVENT);
            try {
                Store store = this.getStore(compaction.getFamilyName().toByteArray());
                if (store == null) {
                    LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Found Compaction WAL edit for deleted family:" + Bytes.toString((byte[])compaction.getFamilyName().toByteArray())));
                    return;
                }
                store.replayCompactionMarker(compaction, pickCompactionFiles, removeFiles);
                this.logRegionFiles();
            }
            catch (FileNotFoundException ex) {
                LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "At least one of the store files in compaction: " + TextFormat.shortDebugString((MessageOrBuilder)compaction) + " doesn't exist any more. Skip loading the file(s)"), (Throwable)ex);
            }
            finally {
                this.closeRegionOperation(Region.Operation.REPLAY_EVENT);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replayWALFlushMarker(WALProtos.FlushDescriptor flush, long replaySeqId) throws IOException {
        this.checkTargetRegion(flush.getEncodedRegionName().toByteArray(), "Flush marker from WAL ", flush);
        if (ServerRegionReplicaUtil.isDefaultReplica((HRegionInfo)this.getRegionInfo())) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.getRegionInfo().getEncodedName() + " : " + "Replaying flush marker " + TextFormat.shortDebugString((MessageOrBuilder)flush)));
        }
        this.startRegionOperation(Region.Operation.REPLAY_EVENT);
        try {
            WALProtos.FlushDescriptor.FlushAction action = flush.getAction();
            switch (action) {
                case START_FLUSH: {
                    this.replayWALFlushStartMarker(flush);
                    break;
                }
                case COMMIT_FLUSH: {
                    this.replayWALFlushCommitMarker(flush);
                    break;
                }
                case ABORT_FLUSH: {
                    this.replayWALFlushAbortMarker(flush);
                    break;
                }
                case CANNOT_FLUSH: {
                    this.replayWALFlushCannotFlushMarker(flush, replaySeqId);
                    break;
                }
                default: {
                    LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Received a flush event with unknown action, ignoring. " + TextFormat.shortDebugString((MessageOrBuilder)flush)));
                }
            }
            this.logRegionFiles();
        }
        finally {
            this.closeRegionOperation(Region.Operation.REPLAY_EVENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @VisibleForTesting
    PrepareFlushResult replayWALFlushStartMarker(WALProtos.FlushDescriptor flush) throws IOException {
        byte[] family;
        long flushSeqId = flush.getFlushSequenceNumber();
        HashSet<Store> storesToFlush = new HashSet<Store>();
        for (WALProtos.FlushDescriptor.StoreFlushDescriptor storeFlush : flush.getStoreFlushesList()) {
            family = storeFlush.getFamilyName().toByteArray();
            Store store = this.getStore(family);
            if (store == null) {
                LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Received a flush start marker from primary, but the family is not found. Ignoring" + " StoreFlushDescriptor:" + TextFormat.shortDebugString((MessageOrBuilder)storeFlush)));
                continue;
            }
            storesToFlush.add(store);
        }
        MonitoredTask status = TaskMonitor.get().createStatus("Preparing flush " + this);
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            block20: {
                try {
                    if (flush.getFlushSequenceNumber() < this.lastReplayedOpenRegionSeqId) {
                        LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Skipping replaying flush event :" + TextFormat.shortDebugString((MessageOrBuilder)flush) + " because its sequence id is smaller than this regions lastReplayedOpenRegionSeqId " + " of " + this.lastReplayedOpenRegionSeqId));
                        family = null;
                        return family;
                    }
                    if (this.numMutationsWithoutWAL.get() > 0L) {
                        this.numMutationsWithoutWAL.set(0L);
                        this.dataInMemoryWithoutWAL.set(0L);
                    }
                    if (!this.writestate.flushing) {
                        PrepareFlushResult prepareResult = this.internalPrepareFlushCache(null, flushSeqId, storesToFlush, status, false);
                        if (prepareResult.result == null) {
                            this.writestate.flushing = true;
                            this.prepareFlushResult = prepareResult;
                            status.markComplete("Flush prepare successful");
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)(this.getRegionInfo().getEncodedName() + " : " + " Prepared flush with seqId:" + flush.getFlushSequenceNumber()));
                            }
                        } else {
                            if (prepareResult.getResult().getResult() == Region.FlushResult.Result.CANNOT_FLUSH_MEMSTORE_EMPTY) {
                                this.writestate.flushing = true;
                                this.prepareFlushResult = prepareResult;
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)(this.getRegionInfo().getEncodedName() + " : " + " Prepared empty flush with seqId:" + flush.getFlushSequenceNumber()));
                                }
                            }
                            status.abort("Flush prepare failed with " + prepareResult.result);
                        }
                        PrepareFlushResult prepareFlushResult = prepareResult;
                        return prepareFlushResult;
                    }
                    if (flush.getFlushSequenceNumber() == this.prepareFlushResult.flushOpSeqId) {
                        LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Received a flush prepare marker with the same seqId: " + flush.getFlushSequenceNumber() + " before clearing the previous one with seqId: " + this.prepareFlushResult.flushOpSeqId + ". Ignoring"));
                        break block20;
                    }
                    if (flush.getFlushSequenceNumber() < this.prepareFlushResult.flushOpSeqId) {
                        LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Received a flush prepare marker with a smaller seqId: " + flush.getFlushSequenceNumber() + " before clearing the previous one with seqId: " + this.prepareFlushResult.flushOpSeqId + ". Ignoring"));
                    } else {
                        LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Received a flush prepare marker with a larger seqId: " + flush.getFlushSequenceNumber() + " before clearing the previous one with seqId: " + this.prepareFlushResult.flushOpSeqId + ". Ignoring"));
                    }
                }
                finally {
                    status.cleanup();
                    this.writestate.notifyAll();
                }
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void replayWALFlushCommitMarker(WALProtos.FlushDescriptor flush) throws IOException {
        MonitoredTask status = TaskMonitor.get().createStatus("Committing flush " + this);
        Object object = this.writestate;
        synchronized (object) {
            try {
                if (flush.getFlushSequenceNumber() < this.lastReplayedOpenRegionSeqId) {
                    LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Skipping replaying flush event :" + TextFormat.shortDebugString((MessageOrBuilder)flush) + " because its sequence id is smaller than this regions lastReplayedOpenRegionSeqId " + " of " + this.lastReplayedOpenRegionSeqId));
                    return;
                }
                if (this.writestate.flushing) {
                    PrepareFlushResult prepareFlushResult = this.prepareFlushResult;
                    if (flush.getFlushSequenceNumber() == prepareFlushResult.flushOpSeqId) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)(this.getRegionInfo().getEncodedName() + " : " + "Received a flush commit marker with seqId:" + flush.getFlushSequenceNumber() + " and a previous prepared snapshot was found"));
                        }
                        this.replayFlushInStores(flush, prepareFlushResult, true);
                        this.addAndGetGlobalMemstoreSize(-prepareFlushResult.totalFlushableSize);
                        this.prepareFlushResult = null;
                        this.writestate.flushing = false;
                    } else if (flush.getFlushSequenceNumber() < prepareFlushResult.flushOpSeqId) {
                        LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Received a flush commit marker with smaller seqId: " + flush.getFlushSequenceNumber() + " than what we have prepared with seqId: " + prepareFlushResult.flushOpSeqId + ". Picking up new file, but not dropping" + "  prepared memstore snapshot"));
                        this.replayFlushInStores(flush, prepareFlushResult, false);
                    } else {
                        LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Received a flush commit marker with larger seqId: " + flush.getFlushSequenceNumber() + " than what we have prepared with seqId: " + prepareFlushResult.flushOpSeqId + ". Picking up new file and dropping prepared" + " memstore snapshot"));
                        this.replayFlushInStores(flush, prepareFlushResult, true);
                        this.addAndGetGlobalMemstoreSize(-prepareFlushResult.totalFlushableSize);
                        this.dropMemstoreContentsForSeqId(flush.getFlushSequenceNumber(), null);
                        this.prepareFlushResult = null;
                        this.writestate.flushing = false;
                    }
                    this.setReadsEnabled(true);
                } else {
                    LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Received a flush commit marker with seqId:" + flush.getFlushSequenceNumber() + ", but no previous prepared snapshot was found"));
                    this.replayFlushInStores(flush, null, false);
                    this.dropMemstoreContentsForSeqId(flush.getFlushSequenceNumber(), null);
                }
                status.markComplete("Flush commit successful");
                this.maxFlushedSeqId = flush.getFlushSequenceNumber();
                this.getMVCC().advanceMemstoreReadPointIfNeeded(flush.getFlushSequenceNumber());
            }
            catch (FileNotFoundException ex) {
                LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "At least one of the store files in flush: " + TextFormat.shortDebugString((MessageOrBuilder)flush) + " doesn't exist any more. Skip loading the file(s)"), (Throwable)ex);
            }
            finally {
                status.cleanup();
                this.writestate.notifyAll();
            }
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    private void replayFlushInStores(WALProtos.FlushDescriptor flush, PrepareFlushResult prepareFlushResult, boolean dropMemstoreSnapshot) throws IOException {
        for (WALProtos.FlushDescriptor.StoreFlushDescriptor storeFlush : flush.getStoreFlushesList()) {
            byte[] family = storeFlush.getFamilyName().toByteArray();
            Store store = this.getStore(family);
            if (store == null) {
                LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Received a flush commit marker from primary, but the family is not found." + "Ignoring StoreFlushDescriptor:" + storeFlush));
                continue;
            }
            List flushFiles = storeFlush.getFlushOutputList();
            StoreFlushContext ctx = null;
            long startTime = EnvironmentEdgeManager.currentTime();
            if (prepareFlushResult == null || prepareFlushResult.storeFlushCtxs == null) {
                ctx = store.createFlushContext(flush.getFlushSequenceNumber());
            } else {
                ctx = prepareFlushResult.storeFlushCtxs.get(family);
                startTime = prepareFlushResult.startTime;
            }
            if (ctx == null) {
                LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Unexpected: flush commit marker received from store " + Bytes.toString((byte[])family) + " but no associated flush context. Ignoring"));
                continue;
            }
            ctx.replayFlush(flushFiles, dropMemstoreSnapshot);
            this.lastStoreFlushTimeMap.put(store, startTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long dropMemstoreContentsForSeqId(long seqId, Store store) throws IOException {
        long totalFreedSize = 0L;
        this.updatesLock.writeLock().lock();
        try {
            this.mvcc.waitForPreviousTransactionsComplete();
            long currentSeqId = this.getSequenceId().get();
            if (seqId >= currentSeqId) {
                LOG.info((Object)(this.getRegionInfo().getEncodedName() + " : " + "Dropping memstore contents as well since replayed flush seqId: " + seqId + " is greater than current seqId:" + currentSeqId));
                if (store == null) {
                    for (Store s : this.stores.values()) {
                        totalFreedSize += this.doDropStoreMemstoreContentsForSeqId(s, currentSeqId);
                    }
                } else {
                    totalFreedSize += this.doDropStoreMemstoreContentsForSeqId(store, currentSeqId);
                }
            } else {
                LOG.info((Object)(this.getRegionInfo().getEncodedName() + " : " + "Not dropping memstore contents since replayed flush seqId: " + seqId + " is smaller than current seqId:" + currentSeqId));
            }
        }
        finally {
            this.updatesLock.writeLock().unlock();
        }
        return totalFreedSize;
    }

    private long doDropStoreMemstoreContentsForSeqId(Store s, long currentSeqId) throws IOException {
        long snapshotSize = s.getFlushableSize();
        this.addAndGetGlobalMemstoreSize(-snapshotSize);
        StoreFlushContext ctx = s.createFlushContext(currentSeqId);
        ctx.prepare();
        ctx.abort();
        return snapshotSize;
    }

    private void replayWALFlushAbortMarker(WALProtos.FlushDescriptor flush) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replayWALFlushCannotFlushMarker(WALProtos.FlushDescriptor flush, long replaySeqId) {
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            if (this.lastReplayedOpenRegionSeqId > replaySeqId) {
                LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Skipping replaying flush event :" + TextFormat.shortDebugString((MessageOrBuilder)flush) + " because its sequence id " + replaySeqId + " is smaller than this regions " + "lastReplayedOpenRegionSeqId of " + this.lastReplayedOpenRegionSeqId));
                return;
            }
            this.setReadsEnabled(true);
        }
    }

    @VisibleForTesting
    PrepareFlushResult getPrepareFlushResult() {
        return this.prepareFlushResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replayWALRegionEventMarker(WALProtos.RegionEventDescriptor regionEvent) throws IOException {
        this.checkTargetRegion(regionEvent.getEncodedRegionName().toByteArray(), "RegionEvent marker from WAL ", regionEvent);
        this.startRegionOperation(Region.Operation.REPLAY_EVENT);
        try {
            if (ServerRegionReplicaUtil.isDefaultReplica((HRegionInfo)this.getRegionInfo())) {
                return;
            }
            if (regionEvent.getEventType() == WALProtos.RegionEventDescriptor.EventType.REGION_CLOSE) {
                return;
            }
            if (regionEvent.getEventType() != WALProtos.RegionEventDescriptor.EventType.REGION_OPEN) {
                LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Unknown region event received, ignoring :" + TextFormat.shortDebugString((MessageOrBuilder)regionEvent)));
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)(this.getRegionInfo().getEncodedName() + " : " + "Replaying region open event marker " + TextFormat.shortDebugString((MessageOrBuilder)regionEvent)));
            }
            WriteState writeState = this.writestate;
            synchronized (writeState) {
                if (this.lastReplayedOpenRegionSeqId > regionEvent.getLogSequenceNumber()) {
                    LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Skipping replaying region event :" + TextFormat.shortDebugString((MessageOrBuilder)regionEvent) + " because its sequence id is smaller than this regions lastReplayedOpenRegionSeqId " + " of " + this.lastReplayedOpenRegionSeqId));
                    return;
                }
                this.lastReplayedOpenRegionSeqId = regionEvent.getLogSequenceNumber();
                for (WALProtos.StoreDescriptor storeDescriptor : regionEvent.getStoresList()) {
                    byte[] family = storeDescriptor.getFamilyName().toByteArray();
                    Store store = this.getStore(family);
                    if (store == null) {
                        LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Received a region open marker from primary, but the family is not found. " + "Ignoring. StoreDescriptor:" + storeDescriptor));
                        continue;
                    }
                    long storeSeqId = store.getMaxSequenceId();
                    List storeFiles = storeDescriptor.getStoreFileList();
                    try {
                        store.refreshStoreFiles(storeFiles);
                    }
                    catch (FileNotFoundException ex) {
                        LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "At least one of the store files: " + storeFiles + " doesn't exist any more. Skip loading the file(s)"), (Throwable)ex);
                        continue;
                    }
                    if (store.getMaxSequenceId() != storeSeqId) {
                        this.lastStoreFlushTimeMap.put(store, EnvironmentEdgeManager.currentTime());
                    }
                    if (this.writestate.flushing && this.prepareFlushResult.flushOpSeqId <= regionEvent.getLogSequenceNumber()) {
                        StoreFlushContext ctx;
                        StoreFlushContext storeFlushContext = ctx = this.prepareFlushResult.storeFlushCtxs == null ? null : this.prepareFlushResult.storeFlushCtxs.get(family);
                        if (ctx != null) {
                            long snapshotSize = store.getFlushableSize();
                            ctx.abort();
                            this.addAndGetGlobalMemstoreSize(-snapshotSize);
                            this.prepareFlushResult.storeFlushCtxs.remove(family);
                        }
                    }
                    this.dropMemstoreContentsForSeqId(regionEvent.getLogSequenceNumber(), store);
                    if (storeSeqId <= this.maxFlushedSeqId) continue;
                    this.maxFlushedSeqId = storeSeqId;
                }
                this.dropPrepareFlushIfPossible();
                this.getMVCC().advanceMemstoreReadPointIfNeeded(this.maxFlushedSeqId);
                this.setReadsEnabled(true);
                HRegion hRegion = this;
                synchronized (hRegion) {
                    this.notifyAll();
                }
            }
            this.logRegionFiles();
        }
        finally {
            this.closeRegionOperation(Region.Operation.REPLAY_EVENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void replayWALBulkLoadEventMarker(WALProtos.BulkLoadDescriptor bulkLoadEvent) throws IOException {
        this.checkTargetRegion(bulkLoadEvent.getEncodedRegionName().toByteArray(), "BulkLoad marker from WAL ", bulkLoadEvent);
        if (ServerRegionReplicaUtil.isDefaultReplica((HRegionInfo)this.getRegionInfo())) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.getRegionInfo().getEncodedName() + " : " + "Replaying bulkload event marker " + TextFormat.shortDebugString((MessageOrBuilder)bulkLoadEvent)));
        }
        boolean multipleFamilies = false;
        byte[] family = null;
        for (WALProtos.StoreDescriptor storeDescriptor : bulkLoadEvent.getStoresList()) {
            byte[] fam = storeDescriptor.getFamilyName().toByteArray();
            if (family == null) {
                family = fam;
                continue;
            }
            if (Bytes.equals((byte[])family, (byte[])fam)) continue;
            multipleFamilies = true;
            break;
        }
        this.startBulkRegionOperation(multipleFamilies);
        try {
            WriteState writeState = this.writestate;
            synchronized (writeState) {
                block18: {
                    if (bulkLoadEvent.getBulkloadSeqNum() < 0L || this.lastReplayedOpenRegionSeqId < bulkLoadEvent.getBulkloadSeqNum()) break block18;
                    LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Skipping replaying bulkload event :" + TextFormat.shortDebugString((MessageOrBuilder)bulkLoadEvent) + " because its sequence id is smaller than this region's lastReplayedOpenRegionSeqId" + " =" + this.lastReplayedOpenRegionSeqId));
                    return;
                }
                for (WALProtos.StoreDescriptor storeDescriptor : bulkLoadEvent.getStoresList()) {
                    family = storeDescriptor.getFamilyName().toByteArray();
                    Store store = this.getStore(family);
                    if (store == null) {
                        LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + "Received a bulk load marker from primary, but the family is not found. " + "Ignoring. StoreDescriptor:" + storeDescriptor));
                        continue;
                    }
                    List storeFiles = storeDescriptor.getStoreFileList();
                    for (String storeFile : storeFiles) {
                        StoreFileInfo storeFileInfo = null;
                        try {
                            storeFileInfo = this.fs.getStoreFileInfo(Bytes.toString((byte[])family), storeFile);
                            store.bulkLoadHFile(storeFileInfo);
                        }
                        catch (FileNotFoundException ex) {
                            LOG.warn((Object)(this.getRegionInfo().getEncodedName() + " : " + (storeFileInfo != null ? storeFileInfo.toString() : new Path(Bytes.toString((byte[])family), storeFile).toString()) + " doesn't exist any more. Skip loading the file"));
                        }
                    }
                }
            }
            if (bulkLoadEvent.getBulkloadSeqNum() > 0L) {
                this.getMVCC().advanceMemstoreReadPointIfNeeded(bulkLoadEvent.getBulkloadSeqNum());
            }
        }
        finally {
            this.closeBulkRegionOperation();
        }
    }

    private void dropPrepareFlushIfPossible() {
        if (this.writestate.flushing) {
            boolean canDrop = true;
            if (this.prepareFlushResult.storeFlushCtxs != null) {
                for (Map.Entry<byte[], StoreFlushContext> entry : this.prepareFlushResult.storeFlushCtxs.entrySet()) {
                    Store store = this.getStore(entry.getKey());
                    if (store == null || store.getSnapshotSize() <= 0L) continue;
                    canDrop = false;
                    break;
                }
            }
            if (canDrop) {
                this.writestate.flushing = false;
                this.prepareFlushResult = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean refreshStoreFiles() throws IOException {
        if (ServerRegionReplicaUtil.isDefaultReplica((HRegionInfo)this.getRegionInfo())) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(this.getRegionInfo().getEncodedName() + " : " + "Refreshing store files to see whether we can free up memstore"));
        }
        long totalFreedSize = 0L;
        long smallestSeqIdInStores = Long.MAX_VALUE;
        this.startRegionOperation();
        try {
            Object object = this.writestate;
            synchronized (object) {
                for (Store store : this.getStores()) {
                    long maxSeqIdBefore = store.getMaxSequenceId();
                    store.refreshStoreFiles();
                    long storeSeqId = store.getMaxSequenceId();
                    if (storeSeqId < smallestSeqIdInStores) {
                        smallestSeqIdInStores = storeSeqId;
                    }
                    if (storeSeqId <= maxSeqIdBefore) continue;
                    if (this.writestate.flushing && this.prepareFlushResult.flushOpSeqId <= storeSeqId) {
                        StoreFlushContext ctx;
                        StoreFlushContext storeFlushContext = ctx = this.prepareFlushResult.storeFlushCtxs == null ? null : this.prepareFlushResult.storeFlushCtxs.get(store.getFamily().getName());
                        if (ctx != null) {
                            long snapshotSize = store.getFlushableSize();
                            ctx.abort();
                            this.addAndGetGlobalMemstoreSize(-snapshotSize);
                            this.prepareFlushResult.storeFlushCtxs.remove(store.getFamily().getName());
                            totalFreedSize += snapshotSize;
                        }
                    }
                    totalFreedSize += this.dropMemstoreContentsForSeqId(storeSeqId, store);
                }
                this.dropPrepareFlushIfPossible();
                for (Store s : this.getStores()) {
                    this.getMVCC().advanceMemstoreReadPointIfNeeded(s.getMaxMemstoreTS());
                }
                if (this.lastReplayedOpenRegionSeqId < smallestSeqIdInStores) {
                    this.lastReplayedOpenRegionSeqId = smallestSeqIdInStores;
                }
            }
            object = this;
            synchronized (object) {
                this.notifyAll();
            }
            boolean bl = totalFreedSize > 0L;
            return bl;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    private void logRegionFiles() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)(this.getRegionInfo().getEncodedName() + " : Store files for region: "));
            for (Store s : this.stores.values()) {
                Collection<StoreFile> storeFiles = s.getStorefiles();
                if (storeFiles == null) continue;
                for (StoreFile sf : storeFiles) {
                    LOG.trace((Object)(this.getRegionInfo().getEncodedName() + " : " + sf));
                }
            }
        }
    }

    private void checkTargetRegion(byte[] encodedRegionName, String exceptionMsg, Object payload) throws WrongRegionException {
        if (Bytes.equals((byte[])this.getRegionInfo().getEncodedNameAsBytes(), (byte[])encodedRegionName)) {
            return;
        }
        if (!RegionReplicaUtil.isDefaultReplica((HRegionInfo)this.getRegionInfo()) && Bytes.equals((byte[])encodedRegionName, (byte[])this.fs.getRegionInfoForFS().getEncodedNameAsBytes())) {
            return;
        }
        throw new WrongRegionException(exceptionMsg + payload + " targetted for region " + Bytes.toStringBinary((byte[])encodedRegionName) + " does not match this region: " + this.getRegionInfo());
    }

    protected boolean restoreEdit(Store s, Cell cell) {
        long kvSize = (Long)s.add(cell).getFirst();
        if (this.rsAccounting != null) {
            this.rsAccounting.addAndGetRegionReplayEditsSize(this.getRegionInfo().getRegionName(), kvSize);
        }
        return this.isFlushSize(this.addAndGetGlobalMemstoreSize(kvSize));
    }

    private static boolean isZeroLengthThenDelete(FileSystem fs, Path p) throws IOException {
        FileStatus stat = fs.getFileStatus(p);
        if (stat.getLen() > 0L) {
            return false;
        }
        LOG.warn((Object)("File " + p + " is zero-length, deleting."));
        fs.delete(p, false);
        return true;
    }

    protected HStore instantiateHStore(HColumnDescriptor family) throws IOException {
        return new HStore(this, family, this.conf);
    }

    @Override
    public Store getStore(byte[] column) {
        return this.stores.get(column);
    }

    public ConcurrentHashMap<HashedBytes, RowLockContext> getLockedRows() {
        return this.lockedRows;
    }

    private Store getStore(Cell cell) {
        for (Map.Entry<byte[], Store> famStore : this.stores.entrySet()) {
            if (!Bytes.equals((byte[])cell.getFamilyArray(), (int)cell.getFamilyOffset(), (int)cell.getFamilyLength(), (byte[])famStore.getKey(), (int)0, (int)famStore.getKey().length)) continue;
            return famStore.getValue();
        }
        return null;
    }

    @Override
    public List<Store> getStores() {
        ArrayList<Store> list = new ArrayList<Store>(this.stores.size());
        list.addAll(this.stores.values());
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getStoreFileList(byte[][] columns) throws IllegalArgumentException {
        ArrayList<String> storeFileNames = new ArrayList<String>();
        Object object = this.closeLock;
        synchronized (object) {
            for (byte[] column : columns) {
                Store store = this.stores.get(column);
                if (store == null) {
                    throw new IllegalArgumentException("No column family : " + new String(column) + " available");
                }
                Collection<StoreFile> storeFiles = store.getStorefiles();
                if (storeFiles == null) continue;
                for (StoreFile storeFile : storeFiles) {
                    storeFileNames.add(storeFile.getPath().toString());
                }
                this.logRegionFiles();
            }
        }
        return storeFileNames;
    }

    void checkRow(byte[] row, String op) throws IOException {
        if (!HRegion.rowIsInRange(this.getRegionInfo(), row)) {
            throw new WrongRegionException("Requested row out of range for " + op + " on HRegion " + this + ", startKey='" + Bytes.toStringBinary((byte[])this.getRegionInfo().getStartKey()) + "', getEndKey()='" + Bytes.toStringBinary((byte[])this.getRegionInfo().getEndKey()) + "', row='" + Bytes.toStringBinary((byte[])row) + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Region.RowLock getRowLock(byte[] row, boolean waitForLock) throws IOException {
        this.startRegionOperation();
        try {
            Region.RowLock rowLock = this.getRowLockInternal(row, waitForLock);
            return rowLock;
        }
        finally {
            this.closeRegionOperation();
        }
    }

    protected Region.RowLock getRowLockInternal(byte[] row, boolean waitForLock) throws IOException {
        RowLockContext existingContext;
        HashedBytes rowKey = new HashedBytes(row);
        RowLockContext rowLockContext = new RowLockContext(rowKey);
        while ((existingContext = this.lockedRows.putIfAbsent(rowKey, rowLockContext)) != null) {
            if (existingContext.ownedByCurrentThread()) {
                rowLockContext = existingContext;
                break;
            }
            if (!waitForLock) {
                return null;
            }
            TraceScope traceScope = null;
            try {
                if (Trace.isTracing()) {
                    traceScope = Trace.startSpan((String)"HRegion.getRowLockInternal");
                }
                if (!existingContext.latch.await(this.rowLockWaitDuration, TimeUnit.MILLISECONDS)) {
                    if (traceScope != null) {
                        traceScope.getSpan().addTimelineAnnotation("Failed to get row lock");
                    }
                    throw new IOException("Timed out waiting for lock for row: " + rowKey);
                }
                if (traceScope != null) {
                    traceScope.close();
                }
                traceScope = null;
            }
            catch (InterruptedException ie) {
                LOG.warn((Object)("Thread interrupted waiting for lock on row: " + rowKey));
                InterruptedIOException iie = new InterruptedIOException();
                iie.initCause(ie);
                throw iie;
            }
            finally {
                if (traceScope == null) continue;
                traceScope.close();
            }
        }
        return rowLockContext.newLock();
    }

    public Region.RowLock getRowLock(byte[] row) throws IOException {
        return this.getRowLock(row, true);
    }

    @Override
    public void releaseRowLocks(List<Region.RowLock> rowLocks) {
        if (rowLocks != null) {
            for (Region.RowLock rowLock : rowLocks) {
                rowLock.release();
            }
            rowLocks.clear();
        }
    }

    private static boolean hasMultipleColumnFamilies(Collection<Pair<byte[], String>> familyPaths) {
        boolean multipleFamilies = false;
        byte[] family = null;
        for (Pair<byte[], String> pair : familyPaths) {
            byte[] fam = (byte[])pair.getFirst();
            if (family == null) {
                family = fam;
                continue;
            }
            if (Bytes.equals((byte[])family, (byte[])fam)) continue;
            multipleFamilies = true;
            break;
        }
        return multipleFamilies;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean bulkLoadHFiles(Collection<Pair<byte[], String>> familyPaths, boolean assignSeqId, Region.BulkLoadListener bulkLoadListener) throws IOException {
        long seqId = -1L;
        TreeMap storeFiles = new TreeMap(Bytes.BYTES_COMPARATOR);
        Preconditions.checkNotNull(familyPaths);
        this.startBulkRegionOperation(HRegion.hasMultipleColumnFamilies(familyPaths));
        try {
            Store store;
            String path;
            this.writeRequestsCount.increment();
            ArrayList<Object> ioes = new ArrayList<Object>();
            ArrayList<Pair<byte[], String>> failures = new ArrayList<Pair<byte[], String>>();
            for (Pair<byte[], String> p : familyPaths) {
                byte[] byArray = (byte[])p.getFirst();
                path = (String)p.getSecond();
                store = this.getStore(byArray);
                if (store == null) {
                    DoNotRetryIOException ioe = new DoNotRetryIOException("No such column family " + Bytes.toStringBinary((byte[])byArray));
                    ioes.add(ioe);
                    continue;
                }
                try {
                    store.assertBulkLoadHFileOk(new Path(path));
                }
                catch (WrongRegionException wre) {
                    failures.add(p);
                }
                catch (IOException ioe) {
                    ioes.add(ioe);
                }
            }
            if (ioes.size() != 0) {
                IOException e = MultipleIOException.createIOException(ioes);
                LOG.error((Object)"There were one or more IO errors when checking if the bulk load is ok.", (Throwable)e);
                throw e;
            }
            if (failures.size() != 0) {
                StringBuilder list = new StringBuilder();
                for (Pair pair : failures) {
                    list.append("\n").append(Bytes.toString((byte[])((byte[])pair.getFirst()))).append(" : ").append((String)pair.getSecond());
                }
                LOG.warn((Object)("There was a recoverable bulk load failure likely due to a split.  These (family, HFile) pairs were not loaded: " + list));
                boolean i$ = false;
                return i$;
            }
            if (assignSeqId) {
                Region.FlushResult fs = this.flushcache(true, false);
                if (fs.isFlushSucceeded()) {
                    seqId = ((FlushResultImpl)fs).flushSequenceId;
                } else if (fs.getResult() == Region.FlushResult.Result.CANNOT_FLUSH_MEMSTORE_EMPTY) {
                    seqId = ((FlushResultImpl)fs).flushSequenceId;
                } else {
                    throw new IOException("Could not bulk load with an assigned sequential ID because the flush didn't run. Reason for not flushing: " + ((FlushResultImpl)fs).failureReason);
                }
            }
            for (Pair<byte[], String> p : familyPaths) {
                byte[] byArray = (byte[])p.getFirst();
                path = (String)p.getSecond();
                store = this.getStore(byArray);
                try {
                    String finalPath = path;
                    if (bulkLoadListener != null) {
                        finalPath = bulkLoadListener.prepareBulkLoad(byArray, path);
                    }
                    Path commitedStoreFile = store.bulkLoadHFile(finalPath, seqId);
                    if (storeFiles.containsKey(byArray)) {
                        ((List)storeFiles.get(byArray)).add(commitedStoreFile);
                    } else {
                        ArrayList<Path> storeFileNames = new ArrayList<Path>();
                        storeFileNames.add(commitedStoreFile);
                        storeFiles.put(byArray, storeFileNames);
                    }
                    if (bulkLoadListener == null) continue;
                    bulkLoadListener.doneBulkLoad(byArray, path);
                }
                catch (IOException ioe) {
                    LOG.error((Object)("There was a partial failure due to IO when attempting to load " + Bytes.toString((byte[])((byte[])p.getFirst())) + " : " + (String)p.getSecond()), (Throwable)ioe);
                    if (bulkLoadListener != null) {
                        try {
                            bulkLoadListener.failedBulkLoad(byArray, path);
                        }
                        catch (Exception ex) {
                            LOG.error((Object)("Error while calling failedBulkLoad for family " + Bytes.toString((byte[])byArray) + " with path " + path), (Throwable)ex);
                        }
                    }
                    throw ioe;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            block33: {
                if (this.wal != null && !storeFiles.isEmpty()) {
                    try {
                        WALProtos.BulkLoadDescriptor bulkLoadDescriptor = ProtobufUtil.toBulkLoadDescriptor((TableName)this.getRegionInfo().getTable(), (ByteString)ByteStringer.wrap((byte[])this.getRegionInfo().getEncodedNameAsBytes()), storeFiles, (long)seqId);
                        WALUtil.writeBulkLoadMarkerAndSync(this.wal, this.htableDescriptor, this.getRegionInfo(), bulkLoadDescriptor, this.sequenceId);
                    }
                    catch (IOException iOException) {
                        if (this.rsServices == null) break block33;
                        this.rsServices.abort("Failed to write bulk load event into WAL.", iOException);
                    }
                }
            }
            this.closeBulkRegionOperation();
        }
    }

    public boolean equals(Object o) {
        return o instanceof HRegion && Bytes.equals((byte[])this.getRegionInfo().getRegionName(), (byte[])((HRegion)o).getRegionInfo().getRegionName());
    }

    public int hashCode() {
        return Bytes.hashCode((byte[])this.getRegionInfo().getRegionName());
    }

    public String toString() {
        return this.getRegionInfo().getRegionNameAsString();
    }

    static HRegion newHRegion(Path tableDir, WAL wal, FileSystem fs, Configuration conf, HRegionInfo regionInfo, HTableDescriptor htd, RegionServerServices rsServices) {
        try {
            Class regionClass = conf.getClass("hbase.hregion.impl", HRegion.class);
            Constructor c = regionClass.getConstructor(Path.class, WAL.class, FileSystem.class, Configuration.class, HRegionInfo.class, HTableDescriptor.class, RegionServerServices.class);
            return (HRegion)c.newInstance(tableDir, wal, fs, conf, regionInfo, htd, rsServices);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Could not instantiate a region instance.", e);
        }
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf, HTableDescriptor hTableDescriptor) throws IOException {
        return HRegion.createHRegion(info, rootDir, conf, hTableDescriptor, null);
    }

    public static void closeHRegion(HRegion r) throws IOException {
        if (r == null) {
            return;
        }
        r.close();
        if (r.getWAL() == null) {
            return;
        }
        r.getWAL().close();
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf, HTableDescriptor hTableDescriptor, WAL wal, boolean initialize) throws IOException {
        return HRegion.createHRegion(info, rootDir, conf, hTableDescriptor, wal, initialize, false);
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf, HTableDescriptor hTableDescriptor, WAL wal, boolean initialize, boolean ignoreWAL) throws IOException {
        Path tableDir = FSUtils.getTableDir(rootDir, info.getTable());
        return HRegion.createHRegion(info, rootDir, tableDir, conf, hTableDescriptor, wal, initialize, ignoreWAL);
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Path tableDir, Configuration conf, HTableDescriptor hTableDescriptor, WAL wal, boolean initialize, boolean ignoreWAL) throws IOException {
        LOG.info((Object)("creating HRegion " + info.getTable().getNameAsString() + " HTD == " + hTableDescriptor + " RootDir = " + rootDir + " Table name == " + info.getTable().getNameAsString()));
        FileSystem fs = FileSystem.get((Configuration)conf);
        HRegionFileSystem.createRegionOnFileSystem(conf, fs, tableDir, info);
        WAL effectiveWAL = wal;
        if (wal == null && !ignoreWAL) {
            Configuration confForWAL = new Configuration(conf);
            confForWAL.set("hbase.rootdir", rootDir.toString());
            effectiveWAL = new WALFactory(confForWAL, Collections.singletonList(new MetricsWAL()), "hregion-" + RandomStringUtils.randomNumeric((int)8)).getWAL(info.getEncodedNameAsBytes());
        }
        HRegion region = HRegion.newHRegion(tableDir, effectiveWAL, fs, conf, info, hTableDescriptor, null);
        if (initialize) {
            region.setSequenceId(region.initialize(null));
        }
        return region;
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, Configuration conf, HTableDescriptor hTableDescriptor, WAL wal) throws IOException {
        return HRegion.createHRegion(info, rootDir, conf, hTableDescriptor, wal, true);
    }

    public static HRegion openHRegion(HRegionInfo info, HTableDescriptor htd, WAL wal, Configuration conf) throws IOException {
        return HRegion.openHRegion(info, htd, wal, conf, null, null);
    }

    public static HRegion openHRegion(HRegionInfo info, HTableDescriptor htd, WAL wal, Configuration conf, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        return HRegion.openHRegion(FSUtils.getRootDir(conf), info, htd, wal, conf, rsServices, reporter);
    }

    public static HRegion openHRegion(Path rootDir, HRegionInfo info, HTableDescriptor htd, WAL wal, Configuration conf) throws IOException {
        return HRegion.openHRegion(rootDir, info, htd, wal, conf, null, null);
    }

    public static HRegion openHRegion(Path rootDir, HRegionInfo info, HTableDescriptor htd, WAL wal, Configuration conf, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        FileSystem fs = null;
        if (rsServices != null) {
            fs = rsServices.getFileSystem();
        }
        if (fs == null) {
            fs = FileSystem.get((Configuration)conf);
        }
        return HRegion.openHRegion(conf, fs, rootDir, info, htd, wal, rsServices, reporter);
    }

    public static HRegion openHRegion(Configuration conf, FileSystem fs, Path rootDir, HRegionInfo info, HTableDescriptor htd, WAL wal) throws IOException {
        return HRegion.openHRegion(conf, fs, rootDir, info, htd, wal, null, null);
    }

    public static HRegion openHRegion(Configuration conf, FileSystem fs, Path rootDir, HRegionInfo info, HTableDescriptor htd, WAL wal, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        Path tableDir = FSUtils.getTableDir(rootDir, info.getTable());
        return HRegion.openHRegion(conf, fs, rootDir, tableDir, info, htd, wal, rsServices, reporter);
    }

    public static HRegion openHRegion(Configuration conf, FileSystem fs, Path rootDir, Path tableDir, HRegionInfo info, HTableDescriptor htd, WAL wal, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        if (info == null) {
            throw new NullPointerException("Passed region info is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Opening region: " + info));
        }
        HRegion r = HRegion.newHRegion(tableDir, wal, fs, conf, info, htd, rsServices);
        return r.openHRegion(reporter);
    }

    public static HRegion openHRegion(HRegion other, CancelableProgressable reporter) throws IOException {
        HRegionFileSystem regionFs = other.getRegionFileSystem();
        HRegion r = HRegion.newHRegion(regionFs.getTableDir(), other.getWAL(), regionFs.getFileSystem(), other.baseConf, other.getRegionInfo(), other.getTableDesc(), null);
        return r.openHRegion(reporter);
    }

    public static Region openHRegion(Region other, CancelableProgressable reporter) throws IOException {
        return HRegion.openHRegion((HRegion)other, reporter);
    }

    protected HRegion openHRegion(CancelableProgressable reporter) throws IOException {
        this.checkCompressionCodecs();
        this.checkEncryption();
        this.checkClassLoading();
        this.openSeqNum = this.initialize(reporter);
        this.setSequenceId(this.openSeqNum);
        if (this.wal != null && this.getRegionServerServices() != null && !this.writestate.readOnly && !this.isRecovering) {
            this.writeRegionOpenMarker(this.wal, this.openSeqNum);
        }
        return this;
    }

    public static void warmupHRegion(HRegionInfo info, HTableDescriptor htd, WAL wal, Configuration conf, RegionServerServices rsServices, CancelableProgressable reporter) throws IOException {
        if (info == null) {
            throw new NullPointerException("Passed region info is null");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("HRegion.Warming up region: " + info));
        }
        Path rootDir = FSUtils.getRootDir(conf);
        Path tableDir = FSUtils.getTableDir(rootDir, info.getTable());
        FileSystem fs = null;
        if (rsServices != null) {
            fs = rsServices.getFileSystem();
        }
        if (fs == null) {
            fs = FileSystem.get((Configuration)conf);
        }
        HRegion r = HRegion.newHRegion(tableDir, wal, fs, conf, info, htd, rsServices);
        r.initializeWarmup(reporter);
        r.close();
    }

    private void checkCompressionCodecs() throws IOException {
        for (HColumnDescriptor fam : this.htableDescriptor.getColumnFamilies()) {
            CompressionTest.testCompression(fam.getCompression());
            CompressionTest.testCompression(fam.getCompactionCompression());
        }
    }

    private void checkEncryption() throws IOException {
        for (HColumnDescriptor fam : this.htableDescriptor.getColumnFamilies()) {
            EncryptionTest.testEncryption(this.conf, fam.getEncryptionType(), fam.getEncryptionKey());
        }
    }

    private void checkClassLoading() throws IOException {
        RegionSplitPolicy.getSplitPolicyClass(this.htableDescriptor, this.conf);
        RegionCoprocessorHost.testTableCoprocessorAttrs(this.conf, this.htableDescriptor);
    }

    HRegion createDaughterRegionFromSplits(HRegionInfo hri) throws IOException {
        this.fs.commitDaughterRegion(hri);
        HRegion r = HRegion.newHRegion(this.fs.getTableDir(), this.getWAL(), this.fs.getFileSystem(), this.getBaseConf(), hri, this.getTableDesc(), this.rsServices);
        r.readRequestsCount.set(this.getReadRequestsCount() / 2L);
        r.writeRequestsCount.set(this.getWriteRequestsCount() / 2L);
        return r;
    }

    HRegion createMergedRegionFromMerges(HRegionInfo mergedRegionInfo, HRegion region_b) throws IOException {
        HRegion r = HRegion.newHRegion(this.fs.getTableDir(), this.getWAL(), this.fs.getFileSystem(), this.getBaseConf(), mergedRegionInfo, this.getTableDesc(), this.rsServices);
        r.readRequestsCount.set(this.getReadRequestsCount() + region_b.getReadRequestsCount());
        r.writeRequestsCount.set(this.getWriteRequestsCount() + region_b.getWriteRequestsCount());
        this.fs.commitMergedRegion(mergedRegionInfo);
        return r;
    }

    public static void addRegionToMETA(HRegion meta, HRegion r) throws IOException {
        meta.checkResources();
        byte[] row = r.getRegionInfo().getRegionName();
        long now = EnvironmentEdgeManager.currentTime();
        ArrayList<Cell> cells = new ArrayList<Cell>(2);
        cells.add((Cell)new KeyValue(row, HConstants.CATALOG_FAMILY, HConstants.REGIONINFO_QUALIFIER, now, r.getRegionInfo().toByteArray()));
        cells.add((Cell)new KeyValue(row, HConstants.CATALOG_FAMILY, HConstants.META_VERSION_QUALIFIER, now, Bytes.toBytes((short)1)));
        meta.put(row, HConstants.CATALOG_FAMILY, cells);
    }

    @Deprecated
    public static Path getRegionDir(Path tabledir, String name) {
        return new Path(tabledir, name);
    }

    @Deprecated
    @VisibleForTesting
    public static Path getRegionDir(Path rootdir, HRegionInfo info) {
        return new Path(FSUtils.getTableDir(rootdir, info.getTable()), info.getEncodedName());
    }

    public static boolean rowIsInRange(HRegionInfo info, byte[] row) {
        return !(info.getStartKey().length != 0 && Bytes.compareTo((byte[])info.getStartKey(), (byte[])row) > 0 || info.getEndKey().length != 0 && Bytes.compareTo((byte[])info.getEndKey(), (byte[])row) <= 0);
    }

    public static HRegion mergeAdjacent(HRegion srcA, HRegion srcB) throws IOException {
        HRegion a = srcA;
        HRegion b = srcB;
        if (srcA.getRegionInfo().getStartKey() == null) {
            if (srcB.getRegionInfo().getStartKey() == null) {
                throw new IOException("Cannot merge two regions with null start key");
            }
        } else if (srcB.getRegionInfo().getStartKey() == null || Bytes.compareTo((byte[])srcA.getRegionInfo().getStartKey(), (byte[])srcB.getRegionInfo().getStartKey()) > 0) {
            a = srcB;
            b = srcA;
        }
        if (Bytes.compareTo((byte[])a.getRegionInfo().getEndKey(), (byte[])b.getRegionInfo().getStartKey()) != 0) {
            throw new IOException("Cannot merge non-adjacent regions");
        }
        return HRegion.merge(a, b);
    }

    public static HRegion merge(HRegion a, HRegion b) throws IOException {
        HRegion dstRegion;
        RegionMergeTransactionImpl rmt;
        if (!a.getRegionInfo().getTable().equals((Object)b.getRegionInfo().getTable())) {
            throw new IOException("Regions do not belong to the same table");
        }
        FileSystem fs = a.getRegionFileSystem().getFileSystem();
        a.flush(true);
        b.flush(true);
        a.compact(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Files for region: " + a));
            a.getRegionFileSystem().logFileSystemState(LOG);
        }
        b.compact(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Files for region: " + b));
            b.getRegionFileSystem().logFileSystemState(LOG);
        }
        if (!(rmt = new RegionMergeTransactionImpl(a, b, true)).prepare(null)) {
            throw new IOException("Unable to merge regions " + a + " and " + b);
        }
        HRegionInfo mergedRegionInfo = rmt.getMergedRegionInfo();
        LOG.info((Object)("starting merge of regions: " + a + " and " + b + " into new region " + mergedRegionInfo.getRegionNameAsString() + " with start key <" + Bytes.toStringBinary((byte[])mergedRegionInfo.getStartKey()) + "> and end key <" + Bytes.toStringBinary((byte[])mergedRegionInfo.getEndKey()) + ">"));
        try {
            dstRegion = rmt.execute(null, null);
        }
        catch (IOException ioe) {
            rmt.rollback(null, null);
            throw new IOException("Failed merging region " + a + " and " + b + ", and successfully rolled back");
        }
        dstRegion.compact(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Files for new region");
            dstRegion.getRegionFileSystem().logFileSystemState(LOG);
        }
        if (dstRegion.getRegionFileSystem().hasReferences(dstRegion.getTableDesc())) {
            throw new IOException("Merged region " + dstRegion + " still has references after the compaction, is compaction canceled?");
        }
        HFileArchiver.archiveRegion(a.getBaseConf(), fs, a.getRegionInfo());
        HFileArchiver.archiveRegion(b.getBaseConf(), fs, b.getRegionInfo());
        LOG.info((Object)("merge completed. New region is " + dstRegion));
        return dstRegion;
    }

    @Override
    public Result get(Get get) throws IOException {
        boolean stale;
        this.checkRow(get.getRow(), "Get");
        if (get.hasFamilies()) {
            for (byte[] family : get.familySet()) {
                this.checkFamily(family);
            }
        } else {
            for (byte[] family : this.htableDescriptor.getFamiliesKeys()) {
                get.addFamily(family);
            }
        }
        List<Cell> results = this.get(get, true);
        boolean bl = stale = this.getRegionInfo().getReplicaId() != 0;
        return Result.create(results, get.isCheckExistenceOnly() ? Boolean.valueOf(!results.isEmpty()) : null, (boolean)stale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Cell> get(Get get, boolean withCoprocessor) throws IOException {
        ArrayList<Cell> results = new ArrayList<Cell>();
        if (withCoprocessor && this.coprocessorHost != null && this.coprocessorHost.preGet(get, results)) {
            return results;
        }
        Scan scan = new Scan(get);
        try (RegionScanner scanner = null;){
            scanner = this.getScanner(scan);
            scanner.next(results);
        }
        if (withCoprocessor && this.coprocessorHost != null) {
            this.coprocessorHost.postGet(get, results);
        }
        if (this.metricsRegion != null) {
            long totalSize = 0L;
            for (Cell cell : results) {
                totalSize += (long)CellUtil.estimatedSerializedSizeOf((Cell)cell);
            }
            this.metricsRegion.updateGet(totalSize);
        }
        return results;
    }

    @Override
    public void mutateRow(RowMutations rm) throws IOException {
        this.mutateRowsWithLocks(rm.getMutations(), Collections.singleton(rm.getRow()));
    }

    public void mutateRowsWithLocks(Collection<Mutation> mutations, Collection<byte[]> rowsToLock) throws IOException {
        this.mutateRowsWithLocks(mutations, rowsToLock, 0L, 0L);
    }

    @Override
    public void mutateRowsWithLocks(Collection<Mutation> mutations, Collection<byte[]> rowsToLock, long nonceGroup, long nonce) throws IOException {
        MultiRowMutationProcessor proc = new MultiRowMutationProcessor(mutations, rowsToLock);
        this.processRowsWithLocks(proc, -1L, nonceGroup, nonce);
    }

    public ClientProtos.RegionLoadStats getRegionStats() {
        if (!this.regionStatsEnabled) {
            return null;
        }
        ClientProtos.RegionLoadStats.Builder stats = ClientProtos.RegionLoadStats.newBuilder();
        stats.setMemstoreLoad((int)Math.min(100L, this.memstoreSize.get() * 100L / this.memstoreFlushSize));
        stats.setHeapOccupancy((int)this.rsServices.getHeapMemoryManager().getHeapOccupancyPercent() * 100);
        return stats.build();
    }

    @Override
    public void processRowsWithLocks(RowProcessor<?, ?> processor) throws IOException {
        this.processRowsWithLocks(processor, this.rowProcessorTimeout, 0L, 0L);
    }

    @Override
    public void processRowsWithLocks(RowProcessor<?, ?> processor, long nonceGroup, long nonce) throws IOException {
        this.processRowsWithLocks(processor, this.rowProcessorTimeout, nonceGroup, nonce);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRowsWithLocks(RowProcessor<?, ?> processor, long timeout, long nonceGroup, long nonce) throws IOException {
        for (byte[] row : processor.getRowsToLock()) {
            this.checkRow(row, "processRowsWithLocks");
        }
        if (!processor.readOnly()) {
            this.checkReadOnly();
        }
        this.checkResources();
        this.startRegionOperation();
        WALEdit walEdit = new WALEdit();
        try {
            processor.preProcess(this, walEdit);
        }
        catch (IOException e) {
            this.closeRegionOperation();
            throw e;
        }
        if (processor.readOnly()) {
            try {
                long now = EnvironmentEdgeManager.currentTime();
                this.doProcessRowWithTimeout(processor, now, this, null, null, timeout);
                processor.postProcess(this, walEdit, true);
            }
            finally {
                this.closeRegionOperation();
            }
            return;
        }
        MultiVersionConsistencyControl.WriteEntry writeEntry = null;
        boolean walSyncSuccessful = false;
        long addedSize = 0L;
        ArrayList<Mutation> mutations = new ArrayList<Mutation>();
        ArrayList<Cell> memstoreCells = new ArrayList<Cell>();
        Collection<byte[]> rowsToLock = processor.getRowsToLock();
        long mvccNum = 0L;
        WALKey walKey = null;
        try {
            boolean locked;
            ArrayList<Region.RowLock> acquiredRowLocks;
            block35: {
                Cell cell;
                CellScanner cellScanner;
                acquiredRowLocks = new ArrayList<Region.RowLock>(rowsToLock.size());
                for (byte[] row : rowsToLock) {
                    acquiredRowLocks.add(this.getRowLock(row));
                }
                this.lock(this.updatesLock.readLock(), acquiredRowLocks.size() == 0 ? 1 : acquiredRowLocks.size());
                locked = true;
                mvccNum = MultiVersionConsistencyControl.getPreAssignedWriteNumber(this.sequenceId);
                long now = EnvironmentEdgeManager.currentTime();
                try {
                    this.doProcessRowWithTimeout(processor, now, this, mutations, walEdit, timeout);
                    if (!mutations.isEmpty()) {
                        writeEntry = this.mvcc.beginMemstoreInsertWithSeqNum(mvccNum);
                        processor.preBatchMutate(this, walEdit);
                        for (Mutation m : mutations) {
                            this.rewriteCellTags(m.getFamilyCellMap(), m);
                            cellScanner = m.cellScanner();
                            while (cellScanner.advance()) {
                                cell = cellScanner.current();
                                CellUtil.setSequenceId((Cell)cell, (long)mvccNum);
                                Store store = this.getStore(cell);
                                if (store == null) {
                                    this.checkFamily(CellUtil.cloneFamily((Cell)cell));
                                }
                                Pair<Long, Cell> ret = store.add(cell);
                                addedSize += ((Long)ret.getFirst()).longValue();
                                memstoreCells.add((Cell)ret.getSecond());
                            }
                        }
                        long txid = 0L;
                        if (!walEdit.isEmpty()) {
                            walKey = new HLogKey(this.getRegionInfo().getEncodedNameAsBytes(), this.htableDescriptor.getTableName(), -1L, now, processor.getClusterIds(), nonceGroup, nonce);
                            txid = this.wal.append(this.htableDescriptor, this.getRegionInfo(), walKey, walEdit, this.getSequenceId(), true, memstoreCells);
                        }
                        if (walKey == null) {
                            walKey = this.appendEmptyEdit(this.wal, memstoreCells);
                        }
                        if (locked) {
                            this.updatesLock.readLock().unlock();
                            locked = false;
                        }
                        this.releaseRowLocks(acquiredRowLocks);
                        if (txid != 0L) {
                            this.syncOrDefer(txid, this.getEffectiveDurability(processor.useDurability()));
                        }
                        walSyncSuccessful = true;
                        processor.postBatchMutate(this);
                    }
                    if (mutations.isEmpty() || walSyncSuccessful) break block35;
                }
                catch (Throwable throwable) {
                    if (!mutations.isEmpty() && !walSyncSuccessful) {
                        LOG.warn((Object)("Wal sync failed. Roll back " + mutations.size() + " memstore keyvalues for row(s):" + StringUtils.byteToHexString((byte[])processor.getRowsToLock().iterator().next()) + "..."));
                        for (Mutation m : mutations) {
                            CellScanner cellScanner2 = m.cellScanner();
                            while (cellScanner2.advance()) {
                                Cell cell2 = cellScanner2.current();
                                this.getStore(cell2).rollback(cell2);
                            }
                        }
                        if (writeEntry != null) {
                            this.mvcc.cancelMemstoreInsert(writeEntry);
                            writeEntry = null;
                        }
                    }
                    if (writeEntry != null) {
                        this.mvcc.completeMemstoreInsertWithSeqNum(writeEntry, walKey);
                    }
                    if (locked) {
                        this.updatesLock.readLock().unlock();
                    }
                    this.releaseRowLocks(acquiredRowLocks);
                    throw throwable;
                }
                LOG.warn((Object)("Wal sync failed. Roll back " + mutations.size() + " memstore keyvalues for row(s):" + StringUtils.byteToHexString((byte[])processor.getRowsToLock().iterator().next()) + "..."));
                for (Mutation m : mutations) {
                    cellScanner = m.cellScanner();
                    while (cellScanner.advance()) {
                        cell = cellScanner.current();
                        this.getStore(cell).rollback(cell);
                    }
                }
                if (writeEntry != null) {
                    this.mvcc.cancelMemstoreInsert(writeEntry);
                    writeEntry = null;
                }
            }
            if (writeEntry != null) {
                this.mvcc.completeMemstoreInsertWithSeqNum(writeEntry, walKey);
            }
            if (locked) {
                this.updatesLock.readLock().unlock();
            }
            this.releaseRowLocks(acquiredRowLocks);
            processor.postProcess(this, walEdit, walSyncSuccessful);
        }
        finally {
            this.closeRegionOperation();
            if (!mutations.isEmpty() && this.isFlushSize(this.addAndGetGlobalMemstoreSize(addedSize))) {
                this.requestFlush();
            }
        }
    }

    private void doProcessRowWithTimeout(final RowProcessor<?, ?> processor, final long now, final HRegion region, final List<Mutation> mutations, final WALEdit walEdit, long timeout) throws IOException {
        if (timeout < 0L) {
            try {
                processor.process(now, region, mutations, walEdit);
            }
            catch (IOException e) {
                LOG.warn((Object)("RowProcessor:" + processor.getClass().getName() + " throws Exception on row(s):" + Bytes.toStringBinary((byte[])processor.getRowsToLock().iterator().next()) + "..."), (Throwable)e);
                throw e;
            }
            return;
        }
        FutureTask<Void> task = new FutureTask<Void>(new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                try {
                    processor.process(now, region, mutations, walEdit);
                    return null;
                }
                catch (IOException e) {
                    LOG.warn((Object)("RowProcessor:" + processor.getClass().getName() + " throws Exception on row(s):" + Bytes.toStringBinary((byte[])processor.getRowsToLock().iterator().next()) + "..."), (Throwable)e);
                    throw e;
                }
            }
        });
        this.rowProcessorExecutor.execute(task);
        try {
            task.get(timeout, TimeUnit.MILLISECONDS);
        }
        catch (TimeoutException te) {
            LOG.error((Object)("RowProcessor timeout:" + timeout + " ms on row(s):" + Bytes.toStringBinary((byte[])processor.getRowsToLock().iterator().next()) + "..."));
            throw new IOException(te);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Result append(Append append) throws IOException {
        return this.append(append, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result append(Append append, long nonceGroup, long nonce) throws IOException {
        block45: {
            block42: {
                block43: {
                    row = append.getRow();
                    this.checkRow(row, "append");
                    flush = false;
                    durability = this.getEffectiveDurability(append.getDurability());
                    writeToWAL = durability != Durability.SKIP_WAL;
                    walEdits = null;
                    allKVs = new ArrayList<E>(append.size());
                    tempMemstore = new HashMap<Store, ArrayList<E>>();
                    size = 0L;
                    txid = 0L;
                    this.checkReadOnly();
                    this.checkResources();
                    this.startRegionOperation(Region.Operation.APPEND);
                    this.writeRequestsCount.increment();
                    mvccNum = 0L;
                    writeEntry = null;
                    walKey = null;
                    rowLock = null;
                    memstoreCells = new ArrayList<Cell>();
                    doRollBackMemstore = false;
                    try {
                        rowLock = this.getRowLock(row);
                        this.lock(this.updatesLock.readLock());
                        this.mvcc.waitForPreviousTransactionsComplete();
                        if (this.coprocessorHost == null || (r = this.coprocessorHost.preAppendAfterRowLock(append)) == null) break block42;
                        var25_21 = r;
                        this.updatesLock.readLock().unlock();
                        rowLock.release();
                        rowLock = null;
                        if (rowLock != null) {
                            rowLock.release();
                        }
                        if (doRollBackMemstore) {
                            this.rollbackMemstore(memstoreCells);
                            if (writeEntry != null) {
                                this.mvcc.cancelMemstoreInsert(writeEntry);
                            }
                            break block43;
                        }
                        if (writeEntry == null) break block43;
                    }
                    catch (Throwable var43_39) {
                        if (rowLock != null) {
                            rowLock.release();
                        }
                        if (doRollBackMemstore) {
                            this.rollbackMemstore(memstoreCells);
                            if (writeEntry != null) {
                                this.mvcc.cancelMemstoreInsert(writeEntry);
                            }
                        } else if (writeEntry != null) {
                            this.mvcc.completeMemstoreInsertWithSeqNum(writeEntry, walKey);
                        }
                        this.closeRegionOperation(Region.Operation.APPEND);
                        throw var43_39;
                    }
                    this.mvcc.completeMemstoreInsertWithSeqNum(writeEntry, walKey);
                }
                this.closeRegionOperation(Region.Operation.APPEND);
                return var25_21;
            }
            ** try [egrp 5[TRYBLOCK] [1 : 258->1447)] { 
lbl64:
            // 1 sources

            mvccNum = MultiVersionConsistencyControl.getPreAssignedWriteNumber(this.sequenceId);
            writeEntry = this.mvcc.beginMemstoreInsertWithSeqNum(mvccNum);
            now = EnvironmentEdgeManager.currentTime();
            for (Map.Entry<K, V> family : append.getFamilyCellMap().entrySet()) {
                store = this.stores.get(family.getKey());
                kvs = new ArrayList<Cell>(((List)family.getValue()).size());
                Collections.sort((List)family.getValue(), store.getComparator());
                get = new Get(row);
                for (Cell cell : (List)family.getValue()) {
                    get.addColumn((byte[])family.getKey(), CellUtil.cloneQualifier((Cell)cell));
                }
                results = this.get(get, false);
                idx = 0;
                for (Cell cell : (List)family.getValue()) {
                    oldCell = null;
                    if (idx < results.size() && CellUtil.matchingQualifier((Cell)results.get(idx), (Cell)cell)) {
                        oldCell = results.get(idx);
                        ts = Math.max(now, oldCell.getTimestamp() + 1L);
                        tags = Tag.carryForwardTags(null, (Cell)oldCell);
                        tags = Tag.carryForwardTags((List)tags, (Cell)cell);
                        tags = HRegion.carryForwardTTLTag(tags, (Mutation)append);
                        tagBytes = Tag.fromList(tags);
                        newCell /* !! */  = new KeyValue(row.length, (int)cell.getFamilyLength(), cell.getQualifierLength(), ts, KeyValue.Type.Put, oldCell.getValueLength() + cell.getValueLength(), tagBytes == null ? 0 : tagBytes.length);
                        System.arraycopy(cell.getRowArray(), cell.getRowOffset(), newCell /* !! */ .getRowArray(), newCell /* !! */ .getRowOffset(), cell.getRowLength());
                        System.arraycopy(cell.getFamilyArray(), cell.getFamilyOffset(), newCell /* !! */ .getFamilyArray(), newCell /* !! */ .getFamilyOffset(), cell.getFamilyLength());
                        System.arraycopy(cell.getQualifierArray(), cell.getQualifierOffset(), newCell /* !! */ .getQualifierArray(), newCell /* !! */ .getQualifierOffset(), cell.getQualifierLength());
                        System.arraycopy(oldCell.getValueArray(), oldCell.getValueOffset(), newCell /* !! */ .getValueArray(), newCell /* !! */ .getValueOffset(), oldCell.getValueLength());
                        System.arraycopy(cell.getValueArray(), cell.getValueOffset(), newCell /* !! */ .getValueArray(), newCell /* !! */ .getValueOffset() + oldCell.getValueLength(), cell.getValueLength());
                        if (tagBytes != null) {
                            System.arraycopy(tagBytes, 0, newCell /* !! */ .getTagsArray(), newCell /* !! */ .getTagsOffset(), tagBytes.length);
                        }
                        ++idx;
                    } else {
                        CellUtil.updateLatestStamp((Cell)cell, (long)now);
                        newCell /* !! */  = append.getTTL() != 0x7FFFFFFFFFFFFFFFL ? new KeyValue(cell.getRowArray(), cell.getRowOffset(), (int)cell.getRowLength(), cell.getFamilyArray(), cell.getFamilyOffset(), (int)cell.getFamilyLength(), cell.getQualifierArray(), cell.getQualifierOffset(), cell.getQualifierLength(), cell.getTimestamp(), KeyValue.Type.codeToType((byte)cell.getTypeByte()), cell.getValueArray(), cell.getValueOffset(), cell.getValueLength(), HRegion.carryForwardTTLTag((Mutation)append)) : cell;
                    }
                    CellUtil.setSequenceId((Cell)newCell /* !! */ , (long)mvccNum);
                    if (this.coprocessorHost != null) {
                        newCell /* !! */  = this.coprocessorHost.postMutationBeforeWAL(RegionObserver.MutationType.APPEND, (Mutation)append, oldCell, newCell /* !! */ );
                    }
                    kvs.add(newCell /* !! */ );
                    if (!writeToWAL) continue;
                    if (walEdits == null) {
                        walEdits = new WALEdit();
                    }
                    walEdits.add(newCell /* !! */ );
                }
                tempMemstore.put(store, kvs);
            }
            for (Map.Entry<K, V> entry : tempMemstore.entrySet()) {
                store = (Store)entry.getKey();
                if (store.getFamily().getMaxVersions() == 1) {
                    size += store.upsert((Iterable)entry.getValue(), this.getSmallestReadPoint());
                    memstoreCells.addAll((Collection)entry.getValue());
                } else {
                    for (Cell cell : (List)entry.getValue()) {
                        ret = store.add(cell);
                        size += ((Long)ret.getFirst()).longValue();
                        memstoreCells.add((Cell)ret.getSecond());
                        doRollBackMemstore = true;
                    }
                }
                allKVs.addAll((Collection)entry.getValue());
            }
            if (writeToWAL) {
                walKey = new HLogKey(this.getRegionInfo().getEncodedNameAsBytes(), this.htableDescriptor.getTableName(), -1L, nonceGroup, nonce);
                txid = this.wal.append(this.htableDescriptor, this.getRegionInfo(), walKey, walEdits, this.sequenceId, true, memstoreCells);
            } else {
                this.recordMutationWithoutWal(append.getFamilyCellMap());
            }
            if (walKey == null) {
                walKey = this.appendEmptyEdit(this.wal, memstoreCells);
            }
            break block45;
lbl139:
            // 1 sources

            finally {
                this.updatesLock.readLock().unlock();
            }
        }
        size = this.addAndGetGlobalMemstoreSize(size);
        flush = this.isFlushSize(size);
        if (txid != 0L) {
            this.syncOrDefer(txid, durability);
        }
        doRollBackMemstore = false;
        if (rowLock != null) {
            rowLock.release();
        }
        if (doRollBackMemstore) {
            this.rollbackMemstore(memstoreCells);
            if (writeEntry != null) {
                this.mvcc.cancelMemstoreInsert(writeEntry);
            }
        } else if (writeEntry != null) {
            this.mvcc.completeMemstoreInsertWithSeqNum(writeEntry, walKey);
        }
        this.closeRegionOperation(Region.Operation.APPEND);
        if (this.metricsRegion != null) {
            this.metricsRegion.updateAppend();
        }
        if (flush) {
            this.requestFlush();
        }
        if (append.isReturnResults() == false) return null;
        v0 = Result.create(allKVs);
        return v0;
    }

    public Result increment(Increment increment) throws IOException {
        return this.increment(increment, 0L, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result increment(Increment increment, long nonceGroup, long nonce) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        this.checkRow(increment.getRow(), "increment");
        this.checkFamilies(increment.getFamilyCellMap().keySet());
        this.startRegionOperation(Region.Operation.INCREMENT);
        this.writeRequestsCount.increment();
        try {
            Result result = this.doIncrement(increment, nonceGroup, nonce);
            return result;
        }
        finally {
            if (this.metricsRegion != null) {
                this.metricsRegion.updateIncrement();
            }
            this.closeRegionOperation(Region.Operation.INCREMENT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Result doIncrement(Increment increment, long nonceGroup, long nonce) throws IOException {
        block32: {
            block30: {
                rowLock = null;
                writeEntry = null;
                walKey = null;
                doRollBackMemstore = false;
                accumulatedResultSize = 0L;
                allKVs = new ArrayList<Cell>(increment.size());
                memstoreCells = new ArrayList<Cell>();
                effectiveDurability = this.getEffectiveDurability(increment.getDurability());
                try {
                    rowLock = this.getRowLock(increment.getRow());
                    txid = 0L;
                    this.lock(this.updatesLock.readLock());
                    this.mvcc.waitForPreviousTransactionsComplete();
                    if (this.coprocessorHost == null || (r = this.coprocessorHost.preIncrementAfterRowLock(increment)) == null) break block30;
                    var18_15 = r;
                    this.updatesLock.readLock().unlock();
                    rowLock.release();
                    rowLock = null;
                    if (rowLock != null) {
                        rowLock.release();
                    }
                    if (doRollBackMemstore) {
                        this.rollbackMemstore(memstoreCells);
                    }
                    if (writeEntry == null) return var18_15;
                }
                catch (Throwable var34_32) {
                    if (rowLock != null) {
                        rowLock.release();
                    }
                    if (doRollBackMemstore) {
                        this.rollbackMemstore(memstoreCells);
                    }
                    if (writeEntry == null) throw var34_32;
                    this.mvcc.completeMemstoreInsertWithSeqNum(writeEntry, walKey);
                    throw var34_32;
                }
                this.mvcc.completeMemstoreInsertWithSeqNum(writeEntry, walKey);
                return var18_15;
            }
            ** try [egrp 5[TRYBLOCK] [1 : 166->617)] { 
lbl44:
            // 1 sources

            mvccNum = MultiVersionConsistencyControl.getPreAssignedWriteNumber(this.sequenceId);
            writeEntry = this.mvcc.beginMemstoreInsertWithSeqNum(mvccNum);
            now = EnvironmentEdgeManager.currentTime();
            writeToWAL = effectiveDurability != Durability.SKIP_WAL;
            walEdits = null;
            for (Map.Entry<K, V> entry : increment.getFamilyCellMap().entrySet()) {
                columnFamilyName = (byte[])entry.getKey();
                results = this.applyIncrementsToColumnFamily(increment, columnFamilyName, HRegion.sort(increments = (List)entry.getValue(), (Comparator<Cell>)(store = this.stores.get(columnFamilyName)).getComparator()), now, mvccNum, allKVs, null);
                if (results.isEmpty()) continue;
                if (writeToWAL) {
                    resultsSize = results.size();
                    for (i = 0; i < resultsSize; ++i) {
                        if (walEdits == null) {
                            walEdits = new WALEdit();
                        }
                        walEdits.add(results.get(i));
                    }
                }
                if (store.getFamily().getMaxVersions() == 1) {
                    accumulatedResultSize += store.upsert(results, this.getSmallestReadPoint());
                    memstoreCells.addAll(results);
                    continue;
                }
                for (Cell cell : results) {
                    ret = store.add(cell);
                    accumulatedResultSize += ((Long)ret.getFirst()).longValue();
                    memstoreCells.add((Cell)ret.getSecond());
                    doRollBackMemstore = true;
                }
            }
            if (walEdits != null && !walEdits.isEmpty()) {
                if (writeToWAL) {
                    walKey = new HLogKey(this.getRegionInfo().getEncodedNameAsBytes(), this.htableDescriptor.getTableName(), -1L, nonceGroup, nonce);
                    txid = this.wal.append(this.htableDescriptor, this.getRegionInfo(), walKey, walEdits, this.getSequenceId(), true, memstoreCells);
                } else {
                    this.recordMutationWithoutWal(increment.getFamilyCellMap());
                }
            }
            if (walKey == null) {
                walKey = this.appendEmptyEdit(this.wal, memstoreCells);
            }
            break block32;
lbl83:
            // 1 sources

            finally {
                this.updatesLock.readLock().unlock();
            }
        }
        if (txid != 0L) {
            this.syncOrDefer(txid, effectiveDurability);
        }
        doRollBackMemstore = false;
        if (rowLock != null) {
            rowLock.release();
        }
        if (doRollBackMemstore) {
            this.rollbackMemstore(memstoreCells);
        }
        if (writeEntry != null) {
            this.mvcc.completeMemstoreInsertWithSeqNum(writeEntry, walKey);
        }
        if (this.isFlushSize(this.addAndGetGlobalMemstoreSize(accumulatedResultSize))) {
            this.requestFlush();
        }
        if (increment.isReturnResults() == false) return null;
        v0 = Result.create(allKVs);
        return v0;
    }

    private static List<Cell> sort(List<Cell> cells, Comparator<Cell> comparator) {
        Collections.sort(cells, comparator);
        return cells;
    }

    private List<Cell> applyIncrementsToColumnFamily(Increment increment, byte[] columnFamilyName, List<Cell> sortedIncrements, long now, long mvccNum, List<Cell> allKVs, IsolationLevel isolation) throws IOException {
        ArrayList<Cell> results = new ArrayList<Cell>(sortedIncrements.size());
        byte[] row = increment.getRow();
        List<Cell> currentValues = this.getIncrementCurrentValue(increment, columnFamilyName, sortedIncrements, isolation);
        int idx = 0;
        for (int i = 0; i < sortedIncrements.size(); ++i) {
            Cell inc = sortedIncrements.get(i);
            long incrementAmount = HRegion.getLongValue(inc);
            boolean writeBack = incrementAmount != 0L;
            List tags = Tag.carryForwardTags((Cell)inc);
            Cell currentValue = null;
            long ts = now;
            if (idx < currentValues.size() && CellUtil.matchingQualifier((Cell)currentValues.get(idx), (Cell)inc)) {
                currentValue = currentValues.get(idx);
                ts = Math.max(now, currentValue.getTimestamp() + 1L);
                incrementAmount += HRegion.getLongValue(currentValue);
                tags = Tag.carryForwardTags(tags, (Cell)currentValue);
                if (i < sortedIncrements.size() - 1 && !CellUtil.matchingQualifier((Cell)inc, (Cell)sortedIncrements.get(i + 1))) {
                    ++idx;
                }
            }
            byte[] qualifier = CellUtil.cloneQualifier((Cell)inc);
            byte[] incrementAmountInBytes = Bytes.toBytes((long)incrementAmount);
            tags = HRegion.carryForwardTTLTag(tags, (Mutation)increment);
            KeyValue newValue = new KeyValue(row, 0, row.length, columnFamilyName, 0, columnFamilyName.length, qualifier, 0, qualifier.length, ts, KeyValue.Type.Put, incrementAmountInBytes, 0, incrementAmountInBytes.length, tags);
            if (mvccNum != 0L) {
                CellUtil.setSequenceId((Cell)newValue, (long)mvccNum);
            }
            if (this.coprocessorHost != null) {
                newValue = this.coprocessorHost.postMutationBeforeWAL(RegionObserver.MutationType.INCREMENT, (Mutation)increment, currentValue, (Cell)newValue);
            }
            allKVs.add((Cell)newValue);
            if (!writeBack) continue;
            results.add((Cell)newValue);
        }
        return results;
    }

    private static long getLongValue(Cell cell) throws DoNotRetryIOException {
        int len = cell.getValueLength();
        if (len != 8) {
            throw new DoNotRetryIOException("Field is not a long, it's " + len + " bytes wide");
        }
        return Bytes.toLong((byte[])cell.getValueArray(), (int)cell.getValueOffset(), (int)len);
    }

    private List<Cell> getIncrementCurrentValue(Increment increment, byte[] columnFamily, List<Cell> increments, IsolationLevel isolation) throws IOException {
        Get get = new Get(increment.getRow());
        if (isolation != null) {
            get.setIsolationLevel(isolation);
        }
        for (Cell cell : increments) {
            get.addColumn(columnFamily, CellUtil.cloneQualifier((Cell)cell));
        }
        TimeRange tr = increment.getTimeRange();
        get.setTimeRange(tr.getMin(), tr.getMax());
        return this.get(get, false);
    }

    private static List<Tag> carryForwardTTLTag(Mutation mutation) {
        return HRegion.carryForwardTTLTag(null, mutation);
    }

    private static List<Tag> carryForwardTTLTag(List<Tag> tagsOrNull, Mutation mutation) {
        long ttl = mutation.getTTL();
        if (ttl == Long.MAX_VALUE) {
            return tagsOrNull;
        }
        List<Tag> tags = tagsOrNull;
        if (tags == null) {
            tags = new ArrayList<Tag>(1);
        }
        tags.add(new Tag(8, Bytes.toBytes((long)ttl)));
        return tags;
    }

    private void checkFamily(byte[] family) throws NoSuchColumnFamilyException {
        if (!this.htableDescriptor.hasFamily(family)) {
            throw new NoSuchColumnFamilyException("Column family " + Bytes.toString((byte[])family) + " does not exist in region " + this + " in table " + this.htableDescriptor);
        }
    }

    public long heapSize() {
        long heapSize = DEEP_OVERHEAD;
        for (Store store : this.stores.values()) {
            heapSize += store.heapSize();
        }
        return heapSize;
    }

    private static void printUsageAndExit(String message) {
        if (message != null && message.length() > 0) {
            System.out.println(message);
        }
        System.out.println("Usage: HRegion CATALOG_TABLE_DIR [major_compact]");
        System.out.println("Options:");
        System.out.println(" major_compact  Pass this option to major compact passed region.");
        System.out.println("Default outputs scan of passed region.");
        System.exit(1);
    }

    @Override
    public boolean registerService(Service instance) {
        Descriptors.ServiceDescriptor serviceDesc = instance.getDescriptorForType();
        if (this.coprocessorServiceHandlers.containsKey(serviceDesc.getFullName())) {
            LOG.error((Object)("Coprocessor service " + serviceDesc.getFullName() + " already registered, rejecting request from " + instance));
            return false;
        }
        this.coprocessorServiceHandlers.put(serviceDesc.getFullName(), instance);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Registered coprocessor service: region=" + Bytes.toStringBinary((byte[])this.getRegionInfo().getRegionName()) + " service=" + serviceDesc.getFullName()));
        }
        return true;
    }

    @Override
    public Message execService(RpcController controller, ClientProtos.CoprocessorServiceCall call) throws IOException {
        String serviceName = call.getServiceName();
        String methodName = call.getMethodName();
        if (!this.coprocessorServiceHandlers.containsKey(serviceName)) {
            throw new UnknownProtocolException(null, "No registered coprocessor service found for name " + serviceName + " in region " + Bytes.toStringBinary((byte[])this.getRegionInfo().getRegionName()));
        }
        Service service = this.coprocessorServiceHandlers.get(serviceName);
        Descriptors.ServiceDescriptor serviceDesc = service.getDescriptorForType();
        Descriptors.MethodDescriptor methodDesc = serviceDesc.findMethodByName(methodName);
        if (methodDesc == null) {
            throw new UnknownProtocolException(service.getClass(), "Unknown method " + methodName + " called on service " + serviceName + " in region " + Bytes.toStringBinary((byte[])this.getRegionInfo().getRegionName()));
        }
        Message.Builder builder = service.getRequestPrototype(methodDesc).newBuilderForType();
        ProtobufUtil.mergeFrom((Message.Builder)builder, (ByteString)call.getRequest());
        Message request = builder.build();
        if (this.coprocessorHost != null) {
            request = this.coprocessorHost.preEndpointInvocation(service, methodName, request);
        }
        final Message.Builder responseBuilder = service.getResponsePrototype(methodDesc).newBuilderForType();
        service.callMethod(methodDesc, controller, request, (RpcCallback)new RpcCallback<Message>(){

            public void run(Message message) {
                if (message != null) {
                    responseBuilder.mergeFrom(message);
                }
            }
        });
        if (this.coprocessorHost != null) {
            this.coprocessorHost.postEndpointInvocation(service, methodName, request, responseBuilder);
        }
        return responseBuilder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTable(FileSystem fs, Path p, WALFactory walFactory, Configuration c, boolean majorCompact) throws IOException {
        block9: {
            FSTableDescriptors fst = new FSTableDescriptors(c);
            if (!FSUtils.getTableName(p).equals((Object)TableName.META_TABLE_NAME)) {
                throw new IOException("Not a known catalog table: " + p.toString());
            }
            WAL wal = walFactory.getMetaWAL(HRegionInfo.FIRST_META_REGIONINFO.getEncodedNameAsBytes());
            try (HRegion region = HRegion.newHRegion(p, wal, fs, c, HRegionInfo.FIRST_META_REGIONINFO, fst.get(TableName.META_TABLE_NAME), null);){
                region.initialize(null);
                if (majorCompact) {
                    region.compact(true);
                    break block9;
                }
                Scan scan = new Scan();
                try (RegionScanner scanner = region.getScanner(scan);){
                    boolean done;
                    ArrayList<Cell> kvs = new ArrayList<Cell>();
                    do {
                        kvs.clear();
                        done = scanner.next(kvs);
                        if (kvs.size() <= 0) continue;
                        LOG.info(kvs);
                    } while (done);
                }
            }
        }
    }

    boolean shouldForceSplit() {
        return this.splitRequest;
    }

    byte[] getExplicitSplitPoint() {
        return this.explicitSplitPoint;
    }

    void forceSplit(byte[] sp) {
        this.splitRequest = true;
        if (sp != null) {
            this.explicitSplitPoint = sp;
        }
    }

    void clearSplit() {
        this.splitRequest = false;
        this.explicitSplitPoint = null;
    }

    protected void prepareToSplit() {
    }

    public byte[] checkSplit() {
        if (this.getRegionInfo().isMetaTable() || TableName.NAMESPACE_TABLE_NAME.equals((Object)this.getRegionInfo().getTable())) {
            if (this.shouldForceSplit()) {
                LOG.warn((Object)"Cannot split meta region in HBase 0.20 and above");
            }
            return null;
        }
        if (this.isRecovering()) {
            LOG.info((Object)("Cannot split region " + this.getRegionInfo().getEncodedName() + " in recovery."));
            return null;
        }
        if (!this.splitPolicy.shouldSplit()) {
            return null;
        }
        byte[] ret = this.splitPolicy.getSplitPoint();
        if (ret != null) {
            try {
                this.checkRow(ret, "calculated split");
            }
            catch (IOException e) {
                LOG.error((Object)"Ignoring invalid split", (Throwable)e);
                return null;
            }
        }
        return ret;
    }

    public int getCompactPriority() {
        int count = Integer.MAX_VALUE;
        for (Store store : this.stores.values()) {
            count = Math.min(count, store.getCompactPriority());
        }
        return count;
    }

    @Override
    public RegionCoprocessorHost getCoprocessorHost() {
        return this.coprocessorHost;
    }

    public void setCoprocessorHost(RegionCoprocessorHost coprocessorHost) {
        this.coprocessorHost = coprocessorHost;
    }

    @Override
    public void startRegionOperation() throws IOException {
        this.startRegionOperation(Region.Operation.ANY);
    }

    @Override
    public void startRegionOperation(Region.Operation op) throws IOException {
        switch (op) {
            case GET: 
            case SCAN: {
                this.checkReadsEnabled();
            }
            case INCREMENT: 
            case APPEND: 
            case SPLIT_REGION: 
            case MERGE_REGION: 
            case PUT: 
            case DELETE: 
            case BATCH_MUTATE: 
            case COMPACT_REGION: {
                if (!this.isRecovering() || !this.disallowWritesInRecovering && (op == Region.Operation.PUT || op == Region.Operation.DELETE || op == Region.Operation.BATCH_MUTATE)) break;
                throw new RegionInRecoveryException(this.getRegionInfo().getRegionNameAsString() + " is recovering; cannot take reads");
            }
        }
        if (op == Region.Operation.MERGE_REGION || op == Region.Operation.SPLIT_REGION || op == Region.Operation.COMPACT_REGION) {
            return;
        }
        if (this.closing.get()) {
            throw new NotServingRegionException(this.getRegionInfo().getRegionNameAsString() + " is closing");
        }
        this.lock(this.lock.readLock());
        if (this.closed.get()) {
            this.lock.readLock().unlock();
            throw new NotServingRegionException(this.getRegionInfo().getRegionNameAsString() + " is closed");
        }
        try {
            if (this.coprocessorHost != null) {
                this.coprocessorHost.postStartRegionOperation(op);
            }
        }
        catch (Exception e) {
            this.lock.readLock().unlock();
            throw new IOException(e);
        }
    }

    @Override
    public void closeRegionOperation() throws IOException {
        this.closeRegionOperation(Region.Operation.ANY);
    }

    public void closeRegionOperation(Region.Operation operation) throws IOException {
        this.lock.readLock().unlock();
        if (this.coprocessorHost != null) {
            this.coprocessorHost.postCloseRegionOperation(operation);
        }
    }

    private void startBulkRegionOperation(boolean writeLockNeeded) throws NotServingRegionException, RegionTooBusyException, InterruptedIOException {
        if (this.closing.get()) {
            throw new NotServingRegionException(this.getRegionInfo().getRegionNameAsString() + " is closing");
        }
        if (writeLockNeeded) {
            this.lock(this.lock.writeLock());
        } else {
            this.lock(this.lock.readLock());
        }
        if (this.closed.get()) {
            if (writeLockNeeded) {
                this.lock.writeLock().unlock();
            } else {
                this.lock.readLock().unlock();
            }
            throw new NotServingRegionException(this.getRegionInfo().getRegionNameAsString() + " is closed");
        }
    }

    private void closeBulkRegionOperation() {
        if (this.lock.writeLock().isHeldByCurrentThread()) {
            this.lock.writeLock().unlock();
        } else {
            this.lock.readLock().unlock();
        }
    }

    private void recordMutationWithoutWal(Map<byte[], List<Cell>> familyMap) {
        this.numMutationsWithoutWAL.increment();
        if (this.numMutationsWithoutWAL.get() <= 1L) {
            LOG.info((Object)("writing data to region " + this + " with WAL disabled. Data may be lost in the event of a crash."));
        }
        long mutationSize = 0L;
        for (List<Cell> cells : familyMap.values()) {
            assert (cells instanceof RandomAccess);
            int listSize = cells.size();
            for (int i = 0; i < listSize; ++i) {
                Cell cell = cells.get(i);
                mutationSize += (long)(KeyValueUtil.keyLength((Cell)cell) + cell.getValueLength());
            }
        }
        this.dataInMemoryWithoutWAL.add(mutationSize);
    }

    private void lock(Lock lock) throws RegionTooBusyException, InterruptedIOException {
        this.lock(lock, 1);
    }

    private void lock(Lock lock, int multiplier) throws RegionTooBusyException, InterruptedIOException {
        try {
            long waitTime = Math.min(this.maxBusyWaitDuration, this.busyWaitDuration * (long)Math.min(multiplier, this.maxBusyWaitMultiplier));
            if (!lock.tryLock(waitTime, TimeUnit.MILLISECONDS)) {
                throw new RegionTooBusyException("failed to get a lock in " + waitTime + " ms. " + "regionName=" + (this.getRegionInfo() == null ? "unknown" : this.getRegionInfo().getRegionNameAsString()) + ", server=" + (this.getRegionServerServices() == null ? "unknown" : this.getRegionServerServices().getServerName()));
            }
        }
        catch (InterruptedException ie) {
            LOG.info((Object)"Interrupted while waiting for a lock");
            InterruptedIOException iie = new InterruptedIOException();
            iie.initCause(ie);
            throw iie;
        }
    }

    private void syncOrDefer(long txid, Durability durability) throws IOException {
        if (this.getRegionInfo().isMetaRegion()) {
            this.wal.sync(txid);
        } else {
            switch (durability) {
                case USE_DEFAULT: {
                    if (!this.shouldSyncWAL()) break;
                    this.wal.sync(txid);
                    break;
                }
                case SKIP_WAL: {
                    break;
                }
                case ASYNC_WAL: {
                    break;
                }
                case SYNC_WAL: 
                case FSYNC_WAL: {
                    this.wal.sync(txid);
                }
            }
        }
    }

    private boolean shouldSyncWAL() {
        return this.durability.ordinal() > Durability.ASYNC_WAL.ordinal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            HRegion.printUsageAndExit(null);
        }
        boolean majorCompact = false;
        if (args.length > 1) {
            if (!args[1].toLowerCase().startsWith("major")) {
                HRegion.printUsageAndExit("ERROR: Unrecognized option <" + args[1] + ">");
            }
            majorCompact = true;
        }
        Path tableDir = new Path(args[0]);
        Configuration c = HBaseConfiguration.create();
        FileSystem fs = FileSystem.get((Configuration)c);
        Path logdir = new Path(c.get("hbase.tmp.dir"));
        String logname = "wal" + FSUtils.getTableName(tableDir) + System.currentTimeMillis();
        Configuration walConf = new Configuration(c);
        FSUtils.setRootDir(walConf, logdir);
        WALFactory wals = new WALFactory(walConf, null, logname);
        try {
            HRegion.processTable(fs, tableDir, wals, c, majorCompact);
        }
        finally {
            wals.close();
            BlockCache bc = new CacheConfig(c).getBlockCache();
            if (bc != null) {
                bc.shutdown();
            }
        }
    }

    @Override
    public long getOpenSeqNum() {
        return this.openSeqNum;
    }

    @Override
    public Map<byte[], Long> getMaxStoreSeqId() {
        return this.maxSeqIdInStores;
    }

    @Override
    public long getOldestSeqIdOfStore(byte[] familyName) {
        return this.wal.getEarliestMemstoreSeqNum(this.getRegionInfo().getEncodedNameAsBytes(), familyName);
    }

    @Override
    public AdminProtos.GetRegionInfoResponse.CompactionState getCompactionState() {
        boolean hasMinor;
        boolean hasMajor = this.majorInProgress.get() > 0;
        boolean bl = hasMinor = this.minorInProgress.get() > 0;
        return hasMajor ? (hasMinor ? AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR_AND_MINOR : AdminProtos.GetRegionInfoResponse.CompactionState.MAJOR) : (hasMinor ? AdminProtos.GetRegionInfoResponse.CompactionState.MINOR : AdminProtos.GetRegionInfoResponse.CompactionState.NONE);
    }

    public void reportCompactionRequestStart(boolean isMajor) {
        (isMajor ? this.majorInProgress : this.minorInProgress).incrementAndGet();
    }

    public void reportCompactionRequestEnd(boolean isMajor, int numFiles, long filesSizeCompacted) {
        int newValue = (isMajor ? this.majorInProgress : this.minorInProgress).decrementAndGet();
        this.compactionsFinished.incrementAndGet();
        this.compactionNumFilesCompacted.addAndGet(numFiles);
        this.compactionNumBytesCompacted.addAndGet(filesSizeCompacted);
        assert (newValue >= 0);
    }

    @VisibleForTesting
    public AtomicLong getSequenceId() {
        return this.sequenceId;
    }

    private void setSequenceId(long value) {
        this.sequenceId.set(value);
    }

    private WALKey appendEmptyEdit(WAL wal, List<Cell> cells) throws IOException {
        HLogKey key = new HLogKey(this.getRegionInfo().getEncodedNameAsBytes(), this.getRegionInfo().getTable(), -1L, 0L, null, 0L, 0L);
        wal.append(this.getTableDesc(), this.getRegionInfo(), key, WALEdit.EMPTY_WALEDIT, this.getSequenceId(), false, cells);
        return key;
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
    }

    @Override
    public void registerChildren(ConfigurationManager manager) {
        this.configurationManager = Optional.of((Object)manager);
        for (Store s : this.stores.values()) {
            ((ConfigurationManager)this.configurationManager.get()).registerObserver(s);
        }
    }

    @Override
    public void deregisterChildren(ConfigurationManager manager) {
        for (Store s : this.stores.values()) {
            ((ConfigurationManager)this.configurationManager.get()).deregisterObserver(s);
        }
    }

    public RegionSplitPolicy getSplitPolicy() {
        return this.splitPolicy;
    }

    public static class RowLockImpl
    implements Region.RowLock {
        private RowLockContext context;
        private boolean released = false;

        @VisibleForTesting
        public RowLockContext getContext() {
            return this.context;
        }

        @VisibleForTesting
        public void setContext(RowLockContext context) {
            this.context = context;
        }

        @Override
        public void release() {
            if (!this.released) {
                this.context.releaseLock();
            }
            this.released = true;
        }
    }

    @VisibleForTesting
    class RowLockContext {
        private final HashedBytes row;
        private final CountDownLatch latch = new CountDownLatch(1);
        private final Thread thread;
        private int lockCount = 0;

        RowLockContext(HashedBytes row) {
            this.row = row;
            this.thread = Thread.currentThread();
        }

        boolean ownedByCurrentThread() {
            return this.thread == Thread.currentThread();
        }

        Region.RowLock newLock() {
            ++this.lockCount;
            RowLockImpl rl = new RowLockImpl();
            rl.setContext(this);
            return rl;
        }

        void releaseLock() {
            if (!this.ownedByCurrentThread()) {
                throw new IllegalArgumentException("Lock held by thread: " + this.thread + " cannot be released by different thread: " + Thread.currentThread());
            }
            --this.lockCount;
            if (this.lockCount == 0) {
                RowLockContext existingContext = (RowLockContext)HRegion.this.lockedRows.remove(this.row);
                if (existingContext != this) {
                    throw new RuntimeException("Internal row lock state inconsistent, should not happen, row: " + this.row);
                }
                this.latch.countDown();
            }
        }

        public String toString() {
            return "RowLockContext{row=" + this.row + ", count=" + this.lockCount + ", threadName=" + this.thread.getName() + '}';
        }
    }

    class RegionScannerImpl
    implements RegionScanner {
        KeyValueHeap storeHeap = null;
        KeyValueHeap joinedHeap = null;
        protected Cell joinedContinuationRow = null;
        protected final byte[] stopRow;
        private final FilterWrapper filter;
        private ScannerContext defaultScannerContext;
        protected int isScan;
        private boolean filterClosed = false;
        private long readPt;
        private long maxResultSize;
        protected HRegion region;

        @Override
        public HRegionInfo getRegionInfo() {
            return this.region.getRegionInfo();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        RegionScannerImpl(Scan scan, List<KeyValueScanner> additionalScanners, HRegion region) throws IOException {
            this.region = region;
            this.maxResultSize = scan.getMaxResultSize();
            this.filter = scan.hasFilter() ? new FilterWrapper(scan.getFilter()) : null;
            this.defaultScannerContext = ScannerContext.newBuilder().setBatchLimit(scan.getBatch()).build();
            this.stopRow = (byte[])(Bytes.equals((byte[])scan.getStopRow(), (byte[])HConstants.EMPTY_END_ROW) && !scan.isGetScan() ? null : scan.getStopRow());
            this.isScan = scan.isGetScan() ? -1 : 0;
            IsolationLevel isolationLevel = scan.getIsolationLevel();
            ConcurrentHashMap concurrentHashMap = HRegion.this.scannerReadPoints;
            synchronized (concurrentHashMap) {
                this.readPt = HRegion.this.getReadpoint(isolationLevel);
                HRegion.this.scannerReadPoints.put(this, this.readPt);
            }
            ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>();
            ArrayList<KeyValueScanner> joinedScanners = new ArrayList<KeyValueScanner>();
            ArrayList<KeyValueScanner> instantiatedScanners = new ArrayList<KeyValueScanner>();
            if (additionalScanners != null && !additionalScanners.isEmpty()) {
                scanners.addAll(additionalScanners);
                instantiatedScanners.addAll(additionalScanners);
            }
            try {
                for (Map.Entry entry : scan.getFamilyMap().entrySet()) {
                    Store store = HRegion.this.stores.get(entry.getKey());
                    KeyValueScanner scanner = store.getScanner(scan, (NavigableSet)entry.getValue(), this.readPt);
                    instantiatedScanners.add(scanner);
                    if (this.filter == null || !scan.doLoadColumnFamiliesOnDemand() || this.filter.isFamilyEssential((byte[])entry.getKey())) {
                        scanners.add(scanner);
                        continue;
                    }
                    joinedScanners.add(scanner);
                }
                this.initializeKVHeap(scanners, joinedScanners, region);
            }
            catch (Throwable t) {
                throw this.handleException(instantiatedScanners, t);
            }
        }

        protected void initializeKVHeap(List<KeyValueScanner> scanners, List<KeyValueScanner> joinedScanners, HRegion region) throws IOException {
            this.storeHeap = new KeyValueHeap(scanners, region.comparator);
            if (!joinedScanners.isEmpty()) {
                this.joinedHeap = new KeyValueHeap(joinedScanners, region.comparator);
            }
        }

        private IOException handleException(List<KeyValueScanner> instantiatedScanners, Throwable t) {
            HRegion.this.scannerReadPoints.remove(this);
            if (this.storeHeap != null) {
                this.storeHeap.close();
                this.storeHeap = null;
                if (this.joinedHeap != null) {
                    this.joinedHeap.close();
                    this.joinedHeap = null;
                }
            } else {
                for (KeyValueScanner scanner : instantiatedScanners) {
                    scanner.close();
                }
            }
            return t instanceof IOException ? (IOException)t : new IOException(t);
        }

        @Override
        public long getMaxResultSize() {
            return this.maxResultSize;
        }

        @Override
        public long getMvccReadPoint() {
            return this.readPt;
        }

        @Override
        public int getBatch() {
            return this.defaultScannerContext.getBatchLimit();
        }

        protected void resetFilters() throws IOException {
            if (this.filter != null) {
                this.filter.reset();
            }
        }

        @Override
        public boolean next(List<Cell> outResults) throws IOException {
            return this.next(outResults, this.defaultScannerContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean next(List<Cell> outResults, ScannerContext scannerContext) throws IOException {
            if (this.filterClosed) {
                throw new UnknownScannerException("Scanner was closed (timed out?) after we renewed it. Could be caused by a very slow scanner or a lengthy garbage collection");
            }
            HRegion.this.startRegionOperation(Region.Operation.SCAN);
            HRegion.this.readRequestsCount.increment();
            try {
                boolean bl = this.nextRaw(outResults, scannerContext);
                return bl;
            }
            finally {
                HRegion.this.closeRegionOperation(Region.Operation.SCAN);
            }
        }

        @Override
        public boolean nextRaw(List<Cell> outResults) throws IOException {
            return this.nextRaw(outResults, this.defaultScannerContext);
        }

        @Override
        public boolean nextRaw(List<Cell> outResults, ScannerContext scannerContext) throws IOException {
            boolean moreValues;
            if (this.storeHeap == null) {
                throw new UnknownScannerException("Scanner was closed");
            }
            if (outResults.isEmpty()) {
                moreValues = this.nextInternal(outResults, scannerContext);
            } else {
                ArrayList<Cell> tmpList = new ArrayList<Cell>();
                moreValues = this.nextInternal(tmpList, scannerContext);
                outResults.addAll(tmpList);
            }
            if (!scannerContext.midRowResultFormed()) {
                this.resetFilters();
            }
            if (this.isFilterDoneInternal()) {
                moreValues = false;
            }
            return moreValues;
        }

        private boolean populateFromJoinedHeap(List<Cell> results, ScannerContext scannerContext) throws IOException {
            assert (this.joinedContinuationRow != null);
            boolean moreValues = this.populateResult(results, this.joinedHeap, scannerContext, this.joinedContinuationRow.getRowArray(), this.joinedContinuationRow.getRowOffset(), this.joinedContinuationRow.getRowLength());
            if (!scannerContext.checkAnyLimitReached(ScannerContext.LimitScope.BETWEEN_CELLS)) {
                this.joinedContinuationRow = null;
            }
            Collections.sort(results, HRegion.this.comparator);
            return moreValues;
        }

        private boolean populateResult(List<Cell> results, KeyValueHeap heap, ScannerContext scannerContext, byte[] currentRow, int offset, short length) throws IOException {
            Cell nextKv;
            boolean moreCellsInRow = false;
            boolean tmpKeepProgress = scannerContext.getKeepProgress();
            ScannerContext.LimitScope limitScope = ScannerContext.LimitScope.BETWEEN_CELLS;
            do {
                scannerContext.setKeepProgress(true);
                heap.next(results, scannerContext);
                scannerContext.setKeepProgress(tmpKeepProgress);
                nextKv = heap.peek();
                moreCellsInRow = this.moreCellsInRow(nextKv, currentRow, offset, length);
                if (moreCellsInRow && scannerContext.checkBatchLimit(limitScope)) {
                    return scannerContext.setScannerState(ScannerContext.NextState.BATCH_LIMIT_REACHED).hasMoreValues();
                }
                if (scannerContext.checkSizeLimit(limitScope)) {
                    ScannerContext.NextState state = moreCellsInRow ? ScannerContext.NextState.SIZE_LIMIT_REACHED_MID_ROW : ScannerContext.NextState.SIZE_LIMIT_REACHED;
                    return scannerContext.setScannerState(state).hasMoreValues();
                }
                if (!scannerContext.checkTimeLimit(limitScope)) continue;
                ScannerContext.NextState state = moreCellsInRow ? ScannerContext.NextState.TIME_LIMIT_REACHED_MID_ROW : ScannerContext.NextState.TIME_LIMIT_REACHED;
                return scannerContext.setScannerState(state).hasMoreValues();
            } while (moreCellsInRow);
            return nextKv != null;
        }

        private boolean moreCellsInRow(Cell nextKv, byte[] currentRow, int offset, short length) {
            return nextKv != null && CellUtil.matchingRow((Cell)nextKv, (byte[])currentRow, (int)offset, (int)length);
        }

        @Override
        public synchronized boolean isFilterDone() throws IOException {
            return this.isFilterDoneInternal();
        }

        private boolean isFilterDoneInternal() throws IOException {
            return this.filter != null && this.filter.filterAllRemaining();
        }

        private boolean nextInternal(List<Cell> results, ScannerContext scannerContext) throws IOException {
            boolean stopRow;
            if (!results.isEmpty()) {
                throw new IllegalArgumentException("First parameter should be an empty list");
            }
            if (scannerContext == null) {
                throw new IllegalArgumentException("Scanner context cannot be null");
            }
            RpcCallContext rpcCall = RpcServer.getCurrentCall();
            int initialBatchProgress = scannerContext.getBatchProgress();
            long initialSizeProgress = scannerContext.getSizeProgress();
            long initialTimeProgress = scannerContext.getTimeProgress();
            while (true) {
                boolean hasFilterRow;
                long afterTime;
                if (scannerContext.getKeepProgress()) {
                    scannerContext.setProgress(initialBatchProgress, initialSizeProgress, initialTimeProgress);
                } else {
                    scannerContext.clearProgress();
                }
                if (rpcCall != null && (afterTime = rpcCall.disconnectSince()) >= 0L) {
                    throw new CallerDisconnectedException("Aborting on region " + this.getRegionInfo().getRegionNameAsString() + ", call " + this + " after " + afterTime + " ms, since " + "caller disconnected");
                }
                Cell current = this.storeHeap.peek();
                byte[] currentRow = null;
                int offset = 0;
                short length = 0;
                if (current != null) {
                    currentRow = current.getRowArray();
                    offset = current.getRowOffset();
                    length = current.getRowLength();
                }
                stopRow = this.isStopRow(currentRow, offset, length);
                boolean bl = hasFilterRow = this.filter != null && this.filter.hasFilterRow();
                if (hasFilterRow) {
                    if (LOG.isTraceEnabled()) {
                        LOG.trace((Object)"filter#hasFilterRow is true which prevents partial results from being  formed. Changing scope of limits that may create partials");
                    }
                    scannerContext.setSizeLimitScope(ScannerContext.LimitScope.BETWEEN_ROWS);
                    scannerContext.setTimeLimitScope(ScannerContext.LimitScope.BETWEEN_ROWS);
                }
                if (this.joinedContinuationRow == null) {
                    boolean mayHaveData;
                    if (stopRow) {
                        if (hasFilterRow) {
                            this.filter.filterRowCells(results);
                        }
                        return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                    }
                    if (this.filterRowKey(currentRow, offset, length)) {
                        boolean moreRows;
                        boolean bl2 = moreRows = !this.isFilterDoneInternal() && this.nextRow(currentRow, offset, length);
                        if (!moreRows) {
                            return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                        }
                        results.clear();
                        continue;
                    }
                    this.populateResult(results, this.storeHeap, scannerContext, currentRow, offset, length);
                    if (scannerContext.checkAnyLimitReached(ScannerContext.LimitScope.BETWEEN_CELLS)) {
                        if (hasFilterRow) {
                            throw new IncompatibleFilterException("Filter whose hasFilterRow() returns true is incompatible with scans that must  stop mid-row because of a limit. ScannerContext:" + scannerContext);
                        }
                        return true;
                    }
                    Cell nextKv = this.storeHeap.peek();
                    stopRow = nextKv == null || this.isStopRow(nextKv.getRowArray(), nextKv.getRowOffset(), nextKv.getRowLength());
                    boolean isEmptyRow = results.isEmpty();
                    FilterWrapper.FilterRowRetCode ret = FilterWrapper.FilterRowRetCode.NOT_CALLED;
                    if (hasFilterRow) {
                        ret = this.filter.filterRowCellsWithRet(results);
                        long timeProgress = scannerContext.getTimeProgress();
                        if (scannerContext.getKeepProgress()) {
                            scannerContext.setProgress(initialBatchProgress, initialSizeProgress, initialTimeProgress);
                        } else {
                            scannerContext.clearProgress();
                        }
                        scannerContext.setTimeProgress(timeProgress);
                        scannerContext.incrementBatchProgress(results.size());
                        for (Cell cell : results) {
                            scannerContext.incrementSizeProgress(CellUtil.estimatedHeapSizeOfWithoutTags((Cell)cell));
                        }
                    }
                    if (isEmptyRow || ret == FilterWrapper.FilterRowRetCode.EXCLUDE || this.filterRow()) {
                        results.clear();
                        boolean moreRows = this.nextRow(currentRow, offset, length);
                        if (!moreRows) {
                            return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                        }
                        if (!stopRow) continue;
                        return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                    }
                    if (this.joinedHeap != null && (mayHaveData = this.joinedHeapMayHaveData(currentRow, offset, length))) {
                        this.joinedContinuationRow = current;
                        this.populateFromJoinedHeap(results, scannerContext);
                        if (scannerContext.checkAnyLimitReached(ScannerContext.LimitScope.BETWEEN_CELLS)) {
                            return true;
                        }
                    }
                } else {
                    this.populateFromJoinedHeap(results, scannerContext);
                    if (scannerContext.checkAnyLimitReached(ScannerContext.LimitScope.BETWEEN_CELLS)) {
                        return true;
                    }
                }
                if (this.joinedContinuationRow != null) {
                    return scannerContext.setScannerState(ScannerContext.NextState.MORE_VALUES).hasMoreValues();
                }
                if (!results.isEmpty()) break;
                boolean moreRows = this.nextRow(currentRow, offset, length);
                if (!moreRows) {
                    return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
                }
                if (stopRow) break;
            }
            if (stopRow) {
                return scannerContext.setScannerState(ScannerContext.NextState.NO_MORE_VALUES).hasMoreValues();
            }
            return scannerContext.setScannerState(ScannerContext.NextState.MORE_VALUES).hasMoreValues();
        }

        private boolean joinedHeapMayHaveData(byte[] currentRow, int offset, short length) throws IOException {
            Cell nextJoinedKv = this.joinedHeap.peek();
            boolean matchCurrentRow = nextJoinedKv != null && CellUtil.matchingRow((Cell)nextJoinedKv, (byte[])currentRow, (int)offset, (int)length);
            boolean matchAfterSeek = false;
            if (!matchCurrentRow) {
                KeyValue firstOnCurrentRow = KeyValueUtil.createFirstOnRow((byte[])currentRow, (int)offset, (short)length);
                boolean seekSuccessful = this.joinedHeap.requestSeek((Cell)firstOnCurrentRow, true, true);
                matchAfterSeek = seekSuccessful && this.joinedHeap.peek() != null && CellUtil.matchingRow((Cell)this.joinedHeap.peek(), (byte[])currentRow, (int)offset, (int)length);
            }
            return matchCurrentRow || matchAfterSeek;
        }

        private boolean filterRow() throws IOException {
            return this.filter != null && !this.filter.hasFilterRow() && this.filter.filterRow();
        }

        private boolean filterRowKey(byte[] row, int offset, short length) throws IOException {
            return this.filter != null && this.filter.filterRowKey(row, offset, (int)length);
        }

        protected boolean nextRow(byte[] currentRow, int offset, short length) throws IOException {
            Cell next;
            assert (this.joinedContinuationRow == null) : "Trying to go to next row during joinedHeap read.";
            while ((next = this.storeHeap.peek()) != null && CellUtil.matchingRow((Cell)next, (byte[])currentRow, (int)offset, (int)length)) {
                this.storeHeap.next(MOCKED_LIST);
            }
            this.resetFilters();
            return this.region.getCoprocessorHost() == null || this.region.getCoprocessorHost().postScannerFilterRow(this, currentRow, offset, length);
        }

        protected boolean isStopRow(byte[] currentRow, int offset, short length) {
            return currentRow == null || this.stopRow != null && HRegion.this.comparator.compareRows(this.stopRow, 0, this.stopRow.length, currentRow, offset, (int)length) <= this.isScan;
        }

        @Override
        public synchronized void close() {
            if (this.storeHeap != null) {
                this.storeHeap.close();
                this.storeHeap = null;
            }
            if (this.joinedHeap != null) {
                this.joinedHeap.close();
                this.joinedHeap = null;
            }
            HRegion.this.scannerReadPoints.remove(this);
            this.filterClosed = true;
        }

        KeyValueHeap getStoreHeapForTesting() {
            return this.storeHeap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized boolean reseek(byte[] row) throws IOException {
            if (row == null) {
                throw new IllegalArgumentException("Row cannot be null.");
            }
            boolean result = false;
            HRegion.this.startRegionOperation();
            try {
                KeyValue kv = KeyValueUtil.createFirstOnRow((byte[])row);
                result = this.storeHeap.requestSeek((Cell)kv, true, true);
                if (this.joinedHeap != null) {
                    result = this.joinedHeap.requestSeek((Cell)kv, true, true) || result;
                }
            }
            finally {
                HRegion.this.closeRegionOperation();
            }
            return result;
        }
    }

    private static class ReplayBatch
    extends BatchOperationInProgress<WALSplitter.MutationReplay> {
        private long replaySeqId = 0L;

        public ReplayBatch(WALSplitter.MutationReplay[] operations, long seqId) {
            super(operations);
            this.replaySeqId = seqId;
        }

        @Override
        public Mutation getMutation(int index) {
            return ((WALSplitter.MutationReplay[])this.operations)[index].mutation;
        }

        @Override
        public long getNonceGroup(int index) {
            return ((WALSplitter.MutationReplay[])this.operations)[index].nonceGroup;
        }

        @Override
        public long getNonce(int index) {
            return ((WALSplitter.MutationReplay[])this.operations)[index].nonce;
        }

        @Override
        public Mutation[] getMutationsForCoprocs() {
            assert (false);
            throw new RuntimeException("Should not be called for replay batch");
        }

        @Override
        public boolean isInReplay() {
            return true;
        }

        @Override
        public long getReplaySequenceId() {
            return this.replaySeqId;
        }
    }

    private static class MutationBatch
    extends BatchOperationInProgress<Mutation> {
        private long nonceGroup;
        private long nonce;

        public MutationBatch(Mutation[] operations, long nonceGroup, long nonce) {
            super(operations);
            this.nonceGroup = nonceGroup;
            this.nonce = nonce;
        }

        @Override
        public Mutation getMutation(int index) {
            return ((Mutation[])this.operations)[index];
        }

        @Override
        public long getNonceGroup(int index) {
            return this.nonceGroup;
        }

        @Override
        public long getNonce(int index) {
            return this.nonce;
        }

        @Override
        public Mutation[] getMutationsForCoprocs() {
            return (Mutation[])this.operations;
        }

        @Override
        public boolean isInReplay() {
            return false;
        }

        @Override
        public long getReplaySequenceId() {
            return 0L;
        }
    }

    private static abstract class BatchOperationInProgress<T> {
        T[] operations;
        int nextIndexToProcess = 0;
        OperationStatus[] retCodeDetails;
        WALEdit[] walEditsFromCoprocessors;

        public BatchOperationInProgress(T[] operations) {
            this.operations = operations;
            this.retCodeDetails = new OperationStatus[operations.length];
            this.walEditsFromCoprocessors = new WALEdit[operations.length];
            Arrays.fill(this.retCodeDetails, OperationStatus.NOT_RUN);
        }

        public abstract Mutation getMutation(int var1);

        public abstract long getNonceGroup(int var1);

        public abstract long getNonce(int var1);

        public abstract Mutation[] getMutationsForCoprocs();

        public abstract boolean isInReplay();

        public abstract long getReplaySequenceId();

        public boolean isDone() {
            return this.nextIndexToProcess == this.operations.length;
        }
    }

    @VisibleForTesting
    static class PrepareFlushResult {
        final Region.FlushResult result;
        final TreeMap<byte[], StoreFlushContext> storeFlushCtxs;
        final TreeMap<byte[], List<Path>> committedFiles;
        final TreeMap<byte[], Long> storeFlushableSize;
        final long startTime;
        final long flushOpSeqId;
        final long flushedSeqId;
        final long totalFlushableSize;

        PrepareFlushResult(Region.FlushResult result, long flushSeqId) {
            this(result, null, null, null, Math.max(0L, flushSeqId), 0L, 0L, 0L);
        }

        PrepareFlushResult(TreeMap<byte[], StoreFlushContext> storeFlushCtxs, TreeMap<byte[], List<Path>> committedFiles, TreeMap<byte[], Long> storeFlushableSize, long startTime, long flushSeqId, long flushedSeqId, long totalFlushableSize) {
            this(null, storeFlushCtxs, committedFiles, storeFlushableSize, startTime, flushSeqId, flushedSeqId, totalFlushableSize);
        }

        private PrepareFlushResult(Region.FlushResult result, TreeMap<byte[], StoreFlushContext> storeFlushCtxs, TreeMap<byte[], List<Path>> committedFiles, TreeMap<byte[], Long> storeFlushableSize, long startTime, long flushSeqId, long flushedSeqId, long totalFlushableSize) {
            this.result = result;
            this.storeFlushCtxs = storeFlushCtxs;
            this.committedFiles = committedFiles;
            this.storeFlushableSize = storeFlushableSize;
            this.startTime = startTime;
            this.flushOpSeqId = flushSeqId;
            this.flushedSeqId = flushedSeqId;
            this.totalFlushableSize = totalFlushableSize;
        }

        public Region.FlushResult getResult() {
            return this.result;
        }
    }

    public static class FlushResultImpl
    implements Region.FlushResult {
        final Region.FlushResult.Result result;
        final String failureReason;
        final long flushSequenceId;
        final boolean wroteFlushWalMarker;

        FlushResultImpl(Region.FlushResult.Result result, long flushSequenceId) {
            this(result, flushSequenceId, null, false);
            assert (result == Region.FlushResult.Result.FLUSHED_NO_COMPACTION_NEEDED || result == Region.FlushResult.Result.FLUSHED_COMPACTION_NEEDED);
        }

        FlushResultImpl(Region.FlushResult.Result result, String failureReason, boolean wroteFlushMarker) {
            this(result, -1L, failureReason, wroteFlushMarker);
            assert (result == Region.FlushResult.Result.CANNOT_FLUSH_MEMSTORE_EMPTY || result == Region.FlushResult.Result.CANNOT_FLUSH);
        }

        FlushResultImpl(Region.FlushResult.Result result, long flushSequenceId, String failureReason, boolean wroteFlushMarker) {
            this.result = result;
            this.flushSequenceId = flushSequenceId;
            this.failureReason = failureReason;
            this.wroteFlushWalMarker = wroteFlushMarker;
        }

        @Override
        public boolean isFlushSucceeded() {
            return this.result == Region.FlushResult.Result.FLUSHED_NO_COMPACTION_NEEDED || this.result == Region.FlushResult.Result.FLUSHED_COMPACTION_NEEDED;
        }

        @Override
        public boolean isCompactionNeeded() {
            return this.result == Region.FlushResult.Result.FLUSHED_COMPACTION_NEEDED;
        }

        public String toString() {
            return "flush result:" + (Object)((Object)this.result) + ", " + "failureReason:" + this.failureReason + "," + "flush seq id" + this.flushSequenceId;
        }

        @Override
        public Region.FlushResult.Result getResult() {
            return this.result;
        }
    }

    static class WriteState {
        volatile boolean flushing = false;
        volatile boolean flushRequested = false;
        volatile int compacting = 0;
        volatile boolean writesEnabled = true;
        volatile boolean readOnly = false;
        volatile boolean readsEnabled = true;
        static final long HEAP_SIZE = ClassSize.align((int)(ClassSize.OBJECT + 5));

        WriteState() {
        }

        synchronized void setReadOnly(boolean onOff) {
            this.writesEnabled = !onOff;
            this.readOnly = onOff;
        }

        boolean isReadOnly() {
            return this.readOnly;
        }

        boolean isFlushRequested() {
            return this.flushRequested;
        }

        void setReadsEnabled(boolean readsEnabled) {
            this.readsEnabled = readsEnabled;
        }
    }
}

