/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessor;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.wal.WALEdit;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MediumTests.class, ClientTests.class})
public class TestTableOperationException {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestTableOperationException.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName TABLE_DONOT_RETRY = TableName.valueOf((String)"TableDoNotRetry");
    private static TableName TABLE_RETRY = TableName.valueOf((String)"TableRetry");
    private static Table tableDoNotRetry;
    private static Table tableRetry;
    private static byte[] CF;
    private static byte[] CQ;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setInt("hbase.client.retries.number", 2);
        UTIL.startMiniCluster();
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TABLE_DONOT_RETRY).setCoprocessor(ThrowDoNotRetryIOExceptionCoprocessor.class.getName()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF).build()).build());
        UTIL.getAdmin().createTable(TableDescriptorBuilder.newBuilder((TableName)TABLE_RETRY).setCoprocessor(ThrowIOExceptionCoprocessor.class.getName()).setColumnFamily(ColumnFamilyDescriptorBuilder.newBuilder((byte[])CF).build()).build());
        tableDoNotRetry = UTIL.getConnection().getTable(TABLE_DONOT_RETRY);
        tableRetry = UTIL.getConnection().getTable(TABLE_RETRY);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.getAdmin().disableTable(TABLE_DONOT_RETRY);
        UTIL.getAdmin().disableTable(TABLE_RETRY);
        UTIL.getAdmin().deleteTable(TABLE_DONOT_RETRY);
        UTIL.getAdmin().deleteTable(TABLE_RETRY);
        UTIL.shutdownMiniCluster();
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testGetWithDoNotRetryIOException() throws Exception {
        tableDoNotRetry.get(new Get(Bytes.toBytes((String)"row")).addColumn(CF, CQ));
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testPutWithDoNotRetryIOException() throws Exception {
        tableDoNotRetry.put(new Put(Bytes.toBytes((String)"row")).addColumn(CF, CQ, Bytes.toBytes((String)"value")));
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testDeleteWithDoNotRetryIOException() throws Exception {
        tableDoNotRetry.delete(new Delete(Bytes.toBytes((String)"row")).addColumn(CF, CQ));
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testAppendWithDoNotRetryIOException() throws Exception {
        tableDoNotRetry.append(new Append(Bytes.toBytes((String)"row")).addColumn(CF, CQ, Bytes.toBytes((String)"value")));
    }

    @Test(expected=DoNotRetryIOException.class)
    public void testIncrementWithDoNotRetryIOException() throws Exception {
        tableDoNotRetry.increment(new Increment(Bytes.toBytes((String)"row")).addColumn(CF, CQ, 1L));
    }

    @Test(expected=RetriesExhaustedException.class)
    public void testGetWithIOException() throws Exception {
        tableRetry.get(new Get(Bytes.toBytes((String)"row")).addColumn(CF, CQ));
    }

    @Test(expected=RetriesExhaustedException.class)
    public void testPutWithIOException() throws Exception {
        tableRetry.put(new Put(Bytes.toBytes((String)"row")).addColumn(CF, CQ, Bytes.toBytes((String)"value")));
    }

    @Test(expected=RetriesExhaustedException.class)
    public void testDeleteWithIOException() throws Exception {
        tableRetry.delete(new Delete(Bytes.toBytes((String)"row")).addColumn(CF, CQ));
    }

    @Test(expected=RetriesExhaustedException.class)
    public void testAppendWithIOException() throws Exception {
        tableRetry.append(new Append(Bytes.toBytes((String)"row")).addColumn(CF, CQ, Bytes.toBytes((String)"value")));
    }

    @Test(expected=RetriesExhaustedException.class)
    public void testIncrementWithIOException() throws Exception {
        tableRetry.increment(new Increment(Bytes.toBytes((String)"row")).addColumn(CF, CQ, 1L));
    }

    static {
        CF = Bytes.toBytes((String)"cf");
        CQ = Bytes.toBytes((String)"cq");
    }

    public static class ThrowIOExceptionCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            throw new IOException("Call failed and retry");
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            throw new IOException("Call failed and retry");
        }

        public void preDelete(ObserverContext<RegionCoprocessorEnvironment> e, Delete delete, WALEdit edit, Durability durability) throws IOException {
            throw new IOException("Call failed and retry");
        }

        public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment) throws IOException {
            throw new IOException("Call failed and retry");
        }

        public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> e, Append append) throws IOException {
            throw new IOException("Call failed and retry");
        }
    }

    public static class ThrowDoNotRetryIOExceptionCoprocessor
    implements RegionCoprocessor,
    RegionObserver {
        public Optional<RegionObserver> getRegionObserver() {
            return Optional.of(this);
        }

        public void preGetOp(ObserverContext<RegionCoprocessorEnvironment> e, Get get, List<Cell> results) throws IOException {
            throw new DoNotRetryIOException("Call failed and don't retry");
        }

        public void prePut(ObserverContext<RegionCoprocessorEnvironment> e, Put put, WALEdit edit, Durability durability) throws IOException {
            throw new DoNotRetryIOException("Call failed and don't retry");
        }

        public void preDelete(ObserverContext<RegionCoprocessorEnvironment> e, Delete delete, WALEdit edit, Durability durability) throws IOException {
            throw new DoNotRetryIOException("Call failed and don't retry");
        }

        public Result preIncrement(ObserverContext<RegionCoprocessorEnvironment> e, Increment increment) throws IOException {
            throw new DoNotRetryIOException("Call failed and don't retry");
        }

        public Result preAppend(ObserverContext<RegionCoprocessorEnvironment> e, Append append) throws IOException {
            throw new DoNotRetryIOException("Call failed and don't retry");
        }
    }
}

