/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestDataBlockEncoding {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDataBlockEncoding.class);

    @Test
    public void testGetDataBlockEncoder() throws Exception {
        for (DataBlockEncoding algo : DataBlockEncoding.values()) {
            DataBlockEncoder encoder = DataBlockEncoding.getDataBlockEncoderById((short)algo.getId());
            if (algo.getId() == 0) continue;
            Assert.assertTrue((boolean)DataBlockEncoding.isCorrectEncoder((DataBlockEncoder)encoder, (short)algo.getId()));
        }
        try {
            DataBlockEncoding.getDataBlockEncoderById((short)-1);
            Assert.fail((String)"Illegal encoderId, should get IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            DataBlockEncoding.getDataBlockEncoderById((short)127);
            Assert.fail((String)"Illegal encoderId, should get IllegalArgumentException.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

