/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.io.ByteBuffAllocator;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.HFileBlock;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.hbase.io.hfile.HFileDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.NoOpDataBlockEncoder;
import org.apache.hadoop.hbase.io.hfile.ReaderContext;
import org.apache.hadoop.hbase.io.hfile.ReaderContextBuilder;
import org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hadoop.hbase.testclassification.IOTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={IOTests.class, MediumTests.class})
public class TestHFileBlockUnpack {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileBlockUnpack.class);
    private static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private static float CHANCE_TO_REPEAT = 0.6f;
    private static final int MIN_ALLOCATION_SIZE = 10240;
    ByteBuffAllocator allocator;
    @Rule
    public TestName name = new TestName();
    private FileSystem fs;

    @Before
    public void setUp() throws Exception {
        this.fs = HFileSystem.get((Configuration)TEST_UTIL.getConfiguration());
        Configuration conf = HBaseConfiguration.create((Configuration)TEST_UTIL.getConfiguration());
        conf.setInt("hbase.server.allocator.minimal.allocate.size", 10240);
        this.allocator = ByteBuffAllocator.create((Configuration)conf, (boolean)true);
    }

    @Test
    public void itUnpacksIdenticallyEachTime() throws IOException {
        Path path = new Path(TEST_UTIL.getDataTestDir(), this.name.getMethodName());
        int totalSize = this.createTestBlock(path);
        Random random = new Random();
        byte[] temp = new byte[65536];
        ArrayList<ByteBuff> buffs = new ArrayList<ByteBuff>();
        for (int i = 0; i < 10; ++i) {
            ByteBuff buff = this.allocator.allocate(65536);
            random.nextBytes(temp);
            buff.put(temp);
            buffs.add(buff);
        }
        buffs.forEach(ByteBuff::release);
        HFileBlockWrapper blockOne = this.readBlock(path, totalSize);
        HFileBlockWrapper blockTwo = this.readBlock(path, totalSize);
        Assert.assertEquals((long)blockOne.original.getOnDiskSizeWithHeader(), (long)blockTwo.original.getOnDiskSizeWithHeader());
        Assert.assertEquals((long)blockOne.original.getUncompressedSizeWithoutHeader(), (long)blockTwo.original.getUncompressedSizeWithoutHeader());
        this.assertBuffersEqual(blockOne.original.getBufferWithoutHeader(), blockTwo.original.getBufferWithoutHeader(), blockOne.original.getOnDiskDataSizeWithHeader() - blockOne.original.headerSize());
        this.assertBuffersEqual(blockOne.unpacked.getBufferWithoutHeader(), blockTwo.unpacked.getBufferWithoutHeader(), blockOne.original.getUncompressedSizeWithoutHeader());
    }

    private void assertBuffersEqual(ByteBuff bufferOne, ByteBuff bufferTwo, int expectedSize) {
        Assert.assertEquals((long)expectedSize, (long)bufferOne.limit());
        Assert.assertEquals((long)expectedSize, (long)bufferTwo.limit());
        Assert.assertEquals((long)0L, (long)ByteBuff.compareTo((ByteBuff)bufferOne, (int)0, (int)bufferOne.limit(), (ByteBuff)bufferTwo, (int)0, (int)bufferTwo.limit()));
    }

    @Test
    public void itUsesSharedMemoryIfUnpackedBlockExceedsMinAllocationSize() throws IOException {
        Path path = new Path(TEST_UTIL.getDataTestDir(), this.name.getMethodName());
        int totalSize = this.createTestBlock(path);
        HFileBlockWrapper blockFromHFile = this.readBlock(path, totalSize);
        Assert.assertFalse((String)"expected hfile block to NOT be unpacked", (boolean)blockFromHFile.original.isUnpacked());
        Assert.assertFalse((String)"expected hfile block to NOT use shared memory", (boolean)blockFromHFile.original.isSharedMem());
        Assert.assertTrue((String)("expected generated block size " + blockFromHFile.original.getOnDiskSizeWithHeader() + " to be less than " + 10240), (blockFromHFile.original.getOnDiskSizeWithHeader() < 10240 ? 1 : 0) != 0);
        Assert.assertTrue((String)("expected generated block uncompressed size " + blockFromHFile.original.getUncompressedSizeWithoutHeader() + " to be more than " + 10240), (blockFromHFile.original.getUncompressedSizeWithoutHeader() > 10240 ? 1 : 0) != 0);
        Assert.assertTrue((String)"expected unpacked block to be unpacked", (boolean)blockFromHFile.unpacked.isUnpacked());
        Assert.assertTrue((String)"expected unpacked block to use shared memory", (boolean)blockFromHFile.unpacked.isSharedMem());
    }

    private HFileBlockWrapper readBlock(Path path, int totalSize) throws IOException {
        try (FSDataInputStream is = this.fs.open(path);){
            HFileContext meta = new HFileContextBuilder().withHBaseCheckSum(true).withCompression(Compression.Algorithm.GZ).withIncludesMvcc(false).withIncludesTags(false).build();
            ReaderContext context = new ReaderContextBuilder().withInputStreamWrapper(new FSDataInputStreamWrapper(is)).withFileSize((long)totalSize).withFilePath(path).withFileSystem(this.fs).build();
            HFileBlock.FSReaderImpl hbr = new HFileBlock.FSReaderImpl(context, meta, this.allocator);
            hbr.setDataBlockEncoder((HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE);
            hbr.setIncludesMemStoreTS(false);
            HFileBlock blockFromHFile = hbr.readBlockData(0L, -1L, false, false, false);
            blockFromHFile.sanityCheck();
            HFileBlockWrapper hFileBlockWrapper = new HFileBlockWrapper(blockFromHFile, blockFromHFile.unpack(meta, (HFileBlock.FSReader)hbr));
            return hFileBlockWrapper;
        }
    }

    private int createTestBlock(Path path) throws IOException {
        int totalSize;
        HFileContext meta = new HFileContextBuilder().withCompression(Compression.Algorithm.GZ).withIncludesMvcc(false).withIncludesTags(false).withBytesPerCheckSum(16384).build();
        try (FSDataOutputStream os = this.fs.create(path);){
            HFileBlock.Writer hbw = new HFileBlock.Writer((HFileDataBlockEncoder)NoOpDataBlockEncoder.INSTANCE, meta, this.allocator);
            hbw.startWriting(BlockType.DATA);
            TestHFileBlockUnpack.writeTestKeyValues(hbw, 10239);
            hbw.writeHeaderAndData(os);
            totalSize = hbw.getOnDiskSizeWithHeader();
            Assert.assertTrue((String)("expected generated block size " + totalSize + " to be less than " + 10240), (totalSize < 10240 ? 1 : 0) != 0);
        }
        return totalSize;
    }

    static int writeTestKeyValues(HFileBlock.Writer hbw, int desiredSize) throws IOException {
        int totalSize;
        KeyValue keyValue;
        Random random = new Random(42L);
        byte[] family = new byte[]{1};
        int rowKey = 0;
        int qualifier = 0;
        int value = 0;
        long timestamp = 0L;
        for (totalSize = 0; totalSize < desiredSize; totalSize += keyValue.getLength()) {
            rowKey = TestHFileBlockUnpack.maybeIncrement(random, rowKey);
            qualifier = TestHFileBlockUnpack.maybeIncrement(random, qualifier);
            value = TestHFileBlockUnpack.maybeIncrement(random, value);
            timestamp = TestHFileBlockUnpack.maybeIncrement(random, (int)timestamp);
            keyValue = new KeyValue(Bytes.toBytes((int)rowKey), family, Bytes.toBytes((int)qualifier), timestamp, Bytes.toBytes((int)value));
            hbw.write((Cell)keyValue);
        }
        return totalSize;
    }

    private static int maybeIncrement(Random random, int value) {
        if (random.nextFloat() < CHANCE_TO_REPEAT) {
            return value;
        }
        return value + 1;
    }

    private static final class HFileBlockWrapper {
        private final HFileBlock original;
        private final HFileBlock unpacked;

        private HFileBlockWrapper(HFileBlock original, HFileBlock unpacked) {
            this.original = original;
            this.unpacked = unpacked;
        }
    }
}

