/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import junit.framework.TestCase;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.TableState;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.hadoop.hbase.zookeeper.ZNodePaths;
import org.apache.hbase.thirdparty.com.google.protobuf.Message;
import org.apache.zookeeper.KeeperException;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;

@Category(value={MasterTests.class, LargeTests.class})
public class TestMirroringTableStateManager {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestMirroringTableStateManager.class);
    @Rule
    public TestName name = new TestName();
    private final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();

    @Before
    public void before() throws Exception {
        this.TEST_UTIL.startMiniCluster();
    }

    @After
    public void after() throws Exception {
        this.TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testMirroring() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        this.TEST_UTIL.createTable(tableName, "info");
        ZKWatcher zkw = this.TEST_UTIL.getZooKeeperWatcher();
        TestCase.assertTrue((boolean)TableState.State.ENABLED.equals((Object)this.getTableStateInZK(zkw, tableName)));
        this.TEST_UTIL.getAdmin().disableTable(tableName);
        TestCase.assertTrue((boolean)TableState.State.DISABLED.equals((Object)this.getTableStateInZK(zkw, tableName)));
        this.TEST_UTIL.getAdmin().deleteTable(tableName);
        TestCase.assertTrue((this.getTableStateInZK(zkw, tableName) == null ? 1 : 0) != 0);
    }

    private TableState.State getTableStateInZK(ZKWatcher watcher, TableName tableName) throws KeeperException, IOException, InterruptedException {
        String znode = ZNodePaths.joinZNode((String)watcher.getZNodePaths().tableZNode, (String)tableName.getNameAsString());
        byte[] data = ZKUtil.getData((ZKWatcher)watcher, (String)znode);
        if (data == null || data.length <= 0) {
            return null;
        }
        try {
            ProtobufUtil.expectPBMagicPrefix((byte[])data);
            ZooKeeperProtos.DeprecatedTableState.Builder builder = ZooKeeperProtos.DeprecatedTableState.newBuilder();
            int magicLen = ProtobufUtil.lengthOfPBMagic();
            ProtobufUtil.mergeFrom((Message.Builder)builder, (byte[])data, (int)magicLen, (int)(data.length - magicLen));
            return TableState.State.valueOf((String)builder.getState().toString());
        }
        catch (IOException e) {
            KeeperException.DataInconsistencyException ke = new KeeperException.DataInconsistencyException();
            ke.initCause((Throwable)e);
            throw ke;
        }
        catch (DeserializationException e) {
            throw ZKUtil.convert((DeserializationException)e);
        }
    }
}

