/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.zookeeper.KeeperException;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, LargeTests.class})
public class TestRaceBetweenSCPAndTRSP {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRaceBetweenSCPAndTRSP.class);
    private static final HBaseTestingUtility UTIL = new HBaseTestingUtility();
    private static TableName NAME = TableName.valueOf((String)"Race");
    private static byte[] CF = Bytes.toBytes((String)"cf");
    private static CountDownLatch ARRIVE_REGION_OPENING;
    private static CountDownLatch RESUME_REGION_OPENING;
    private static CountDownLatch ARRIVE_GET_REGIONS_ON_SERVER;
    private static CountDownLatch RESUME_GET_REGIONS_ON_SERVER;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setClass("hbase.master.impl", HMasterForTest.class, HMaster.class);
        UTIL.startMiniCluster(2);
        UTIL.createTable(NAME, CF);
        UTIL.waitTableAvailable(NAME);
        UTIL.getAdmin().balancerSwitch(false, true);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void test() throws Exception {
        RegionInfo region = UTIL.getMiniHBaseCluster().getRegions(NAME).get(0).getRegionInfo();
        AssignmentManager am = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        ServerName sn = am.getRegionStates().getRegionState(region).getServerName();
        CountDownLatch arriveRegionOpening = ARRIVE_REGION_OPENING = new CountDownLatch(1);
        RESUME_REGION_OPENING = new CountDownLatch(1);
        CountDownLatch arriveGetRegionsOnServer = ARRIVE_GET_REGIONS_ON_SERVER = new CountDownLatch(1);
        RESUME_GET_REGIONS_ON_SERVER = new CountDownLatch(1);
        Future moveFuture = am.moveAsync(new RegionPlan(region, sn, sn));
        arriveRegionOpening.await();
        UTIL.getMiniHBaseCluster().killRegionServer(sn);
        arriveGetRegionsOnServer.await();
        RESUME_REGION_OPENING.countDown();
        moveFuture.get();
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        long scpProcId = procExec.getProcedures().stream().filter(p -> p instanceof ServerCrashProcedure).map(p -> (ServerCrashProcedure)p).findAny().get().getProcId();
        RESUME_GET_REGIONS_ON_SERVER.countDown();
        UTIL.waitFor(60000L, () -> procExec.isFinished(scpProcId));
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException, KeeperException {
            super(conf);
        }

        protected AssignmentManager createAssignmentManager(MasterServices master) {
            return new AssignmentManagerForTest(master);
        }
    }

    private static final class AssignmentManagerForTest
    extends AssignmentManager {
        public AssignmentManagerForTest(MasterServices master) {
            super(master);
        }

        void regionOpening(RegionStateNode regionNode) throws IOException {
            super.regionOpening(regionNode);
            if (regionNode.getRegionInfo().getTable().equals((Object)NAME) && ARRIVE_REGION_OPENING != null) {
                ARRIVE_REGION_OPENING.countDown();
                ARRIVE_REGION_OPENING = null;
                try {
                    RESUME_REGION_OPENING.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        public List<RegionInfo> getRegionsOnServer(ServerName serverName) {
            List regions = super.getRegionsOnServer(serverName);
            if (ARRIVE_GET_REGIONS_ON_SERVER != null) {
                ARRIVE_GET_REGIONS_ON_SERVER.countDown();
                ARRIVE_GET_REGIONS_ON_SERVER = null;
                try {
                    RESUME_GET_REGIONS_ON_SERVER.await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return regions;
        }
    }
}

