/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.assignment;

import java.io.IOException;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hadoop.hbase.master.RegionState;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.IdLock;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MasterTests.class, MediumTests.class})
public class TestReportOnlineRegionsRace {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestReportOnlineRegionsRace.class);
    private static volatile CountDownLatch ARRIVE_RS_REPORT;
    private static volatile CountDownLatch RESUME_RS_REPORT;
    private static volatile CountDownLatch FINISH_RS_REPORT;
    private static volatile CountDownLatch RESUME_REPORT_STATE;
    private static final HBaseTestingUtility UTIL;
    private static TableName NAME;
    private static byte[] CF;

    @BeforeClass
    public static void setUp() throws Exception {
        UTIL.getConfiguration().setClass("hbase.master.impl", HMasterForTest.class, HMaster.class);
        UTIL.getConfiguration().setInt("hbase.regionserver.msginterval", 1000);
        UTIL.getConfiguration().setInt("hbase.regionserver.metahandler.count", 20);
        UTIL.startMiniCluster(1);
        UTIL.createTable(NAME, CF);
        UTIL.waitTableAvailable(NAME);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        UTIL.shutdownMiniCluster();
    }

    @Test
    public void testRace() throws Exception {
        RegionInfo region = UTIL.getMiniHBaseCluster().getRegions(NAME).get(0).getRegionInfo();
        ProcedureExecutor procExec = UTIL.getMiniHBaseCluster().getMaster().getMasterProcedureExecutor();
        AssignmentManager am = UTIL.getMiniHBaseCluster().getMaster().getAssignmentManager();
        RegionStateNode rsn = am.getRegionStates().getRegionStateNode(region);
        RESUME_RS_REPORT = new CountDownLatch(1);
        ARRIVE_RS_REPORT = new CountDownLatch(1);
        FINISH_RS_REPORT = new CountDownLatch(1);
        ARRIVE_RS_REPORT.await();
        RESUME_REPORT_STATE = new CountDownLatch(1);
        Future future = am.moveAsync(new RegionPlan(region, rsn.getRegionLocation(), rsn.getRegionLocation()));
        TransitRegionStateProcedure proc = procExec.getProcedures().stream().filter(p -> p instanceof TransitRegionStateProcedure).filter(p -> !p.isFinished()).map(p -> (TransitRegionStateProcedure)p).findAny().get();
        IdLock procExecLock = procExec.getProcExecutionLock();
        IdLock.Entry lockEntry = procExecLock.getLockEntry(proc.getProcId() + 2L);
        RESUME_REPORT_STATE.countDown();
        UTIL.waitFor(10000L, () -> proc.getCurrentStateId() == 3);
        Assert.assertEquals((Object)RegionState.State.OPENING, (Object)rsn.getState());
        RESUME_RS_REPORT.countDown();
        FINISH_RS_REPORT.await();
        procExecLock.releaseLockEntry(lockEntry);
        future.get();
        try (Table table = UTIL.getConnection().getTableBuilder(NAME, null).setWriteRpcTimeout(1000).setOperationTimeout(2000).build();){
            table.put(new Put(Bytes.toBytes((String)"key")).addColumn(CF, Bytes.toBytes((String)"cq"), Bytes.toBytes((String)"val")));
        }
    }

    static {
        UTIL = new HBaseTestingUtility();
        NAME = TableName.valueOf((String)"Race");
        CF = Bytes.toBytes((String)"cf");
    }

    public static final class HMasterForTest
    extends HMaster {
        public HMasterForTest(Configuration conf) throws IOException {
            super(conf);
        }

        protected AssignmentManager createAssignmentManager(MasterServices master) {
            return new AssignmentManagerForTest(master);
        }
    }

    private static final class AssignmentManagerForTest
    extends AssignmentManager {
        public AssignmentManagerForTest(MasterServices master) {
            super(master);
        }

        public void reportOnlineRegions(ServerName serverName, Set<byte[]> regionNames) {
            if (ARRIVE_RS_REPORT != null) {
                ARRIVE_RS_REPORT.countDown();
                try {
                    RESUME_RS_REPORT.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            super.reportOnlineRegions(serverName, regionNames);
            if (FINISH_RS_REPORT != null) {
                FINISH_RS_REPORT.countDown();
            }
        }

        public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws PleaseHoldException {
            if (RESUME_REPORT_STATE != null) {
                try {
                    RESUME_REPORT_STATE.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
            return super.reportRegionStateTransition(req);
        }
    }
}

