/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.procedure2.store.region;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableLong;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.master.region.MasterRegionFactory;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.store.region.HFileProcedurePrettyPrinter;
import org.apache.hadoop.hbase.procedure2.store.region.RegionProcedureStoreTestBase;
import org.apache.hadoop.hbase.procedure2.store.region.RegionProcedureStoreTestProcedure;
import org.apache.hadoop.hbase.testclassification.MasterTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.util.Tool;
import org.apache.hadoop.util.ToolRunner;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MasterTests.class, SmallTests.class})
public class TestHFileProcedurePrettyPrinter
extends RegionProcedureStoreTestBase {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestHFileProcedurePrettyPrinter.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHFileProcedurePrettyPrinter.class);

    private List<String> checkOutput(BufferedReader reader, MutableLong putCount, MutableLong deleteCount, MutableLong markDeletedCount) throws IOException {
        putCount.setValue(0L);
        deleteCount.setValue(0L);
        markDeletedCount.setValue(0L);
        ArrayList<String> fileScanned = new ArrayList<String>();
        String line;
        while ((line = reader.readLine()) != null) {
            LOG.info(line);
            if (line.contains("V: mark deleted")) {
                markDeletedCount.increment();
                continue;
            }
            if (line.contains("/Put/")) {
                putCount.increment();
                continue;
            }
            if (line.contains("/DeleteFamily/")) {
                deleteCount.increment();
                continue;
            }
            if (line.startsWith("Scanning -> ")) {
                fileScanned.add(line.split(" -> ")[1]);
                continue;
            }
            Assert.fail((String)("Unrecognized output: " + line));
        }
        return fileScanned;
    }

    @Test
    public void test() throws Exception {
        int i;
        HFileProcedurePrettyPrinter printer = new HFileProcedurePrettyPrinter();
        Assert.assertNotEquals((long)0L, (long)ToolRunner.run((Configuration)this.htu.getConfiguration(), (Tool)printer, (String[])new String[0]));
        ArrayList<RegionProcedureStoreTestProcedure> procs = new ArrayList<RegionProcedureStoreTestProcedure>();
        for (i = 0; i < 10; ++i) {
            RegionProcedureStoreTestProcedure proc = new RegionProcedureStoreTestProcedure();
            this.store.insert((Procedure)proc, null);
            procs.add(proc);
        }
        this.store.region.flush(true);
        for (i = 0; i < 5; ++i) {
            this.store.delete(((RegionProcedureStoreTestProcedure)((Object)procs.get(i))).getProcId());
        }
        this.store.region.flush(true);
        this.store.cleanup();
        this.store.region.flush(true);
        Path tableDir = CommonFSUtils.getTableDir((Path)new Path(this.htu.getDataTestDir(), "MasterData"), (TableName)MasterRegionFactory.TABLE_NAME);
        FileSystem fs = tableDir.getFileSystem(this.htu.getConfiguration());
        Path regionDir = fs.listStatus(tableDir, p -> RegionInfo.isEncodedRegionName((byte[])Bytes.toBytes((String)p.getName())))[0].getPath();
        List storefiles = HFile.getStoreFiles((FileSystem)fs, (Path)regionDir);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream out = new PrintStream(bos);
        MutableLong putCount = new MutableLong();
        MutableLong deleteCount = new MutableLong();
        MutableLong markDeletedCount = new MutableLong();
        for (Path file : storefiles) {
            bos.reset();
            printer = new HFileProcedurePrettyPrinter(out);
            Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)this.htu.getConfiguration(), (Tool)printer, (String[])new String[]{"-f", file.toString()}));
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bos.toByteArray()), StandardCharsets.UTF_8));
            Throwable throwable = null;
            try {
                List<String> fileScanned = this.checkOutput(reader, putCount, deleteCount, markDeletedCount);
                Assert.assertEquals((long)1L, (long)fileScanned.size());
                Assert.assertEquals((Object)file.toString(), (Object)fileScanned.get(0));
                if (putCount.longValue() == 10L) {
                    Assert.assertEquals((long)0L, (long)deleteCount.longValue());
                    Assert.assertEquals((long)0L, (long)markDeletedCount.longValue());
                    continue;
                }
                if (deleteCount.longValue() == 5L) {
                    Assert.assertEquals((long)0L, (long)putCount.longValue());
                    Assert.assertEquals((long)0L, (long)markDeletedCount.longValue());
                    continue;
                }
                if (markDeletedCount.longValue() == 5L) {
                    Assert.assertEquals((long)0L, (long)putCount.longValue());
                    Assert.assertEquals((long)0L, (long)deleteCount.longValue());
                    continue;
                }
                Assert.fail((String)"Should have entered one of the above 3 branches");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (reader == null) continue;
                if (throwable != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                reader.close();
            }
        }
        bos.reset();
        printer = new HFileProcedurePrettyPrinter(out);
        Assert.assertEquals((long)0L, (long)ToolRunner.run((Configuration)this.htu.getConfiguration(), (Tool)printer, (String[])new String[]{"-a"}));
        try (BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(bos.toByteArray()), StandardCharsets.UTF_8));){
            List<String> fileScanned = this.checkOutput(reader, putCount, deleteCount, markDeletedCount);
            Assert.assertEquals((long)3L, (long)fileScanned.size());
            Assert.assertEquals((long)10L, (long)putCount.longValue());
            Assert.assertEquals((long)5L, (long)deleteCount.longValue());
            Assert.assertEquals((long)5L, (long)markDeletedCount.longValue());
        }
    }
}

