/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.quotas.RegionSize;
import org.apache.hadoop.hbase.quotas.RegionSizeStore;
import org.apache.hadoop.hbase.quotas.RegionSizeStoreFactory;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Matchers;
import org.mockito.Mockito;

@Category(value={SmallTests.class})
public class TestRegionServerRegionSpaceUseReport {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestRegionServerRegionSpaceUseReport.class);

    @Test
    public void testConversion() {
        TableName tn = TableName.valueOf((String)"table1");
        RegionInfo hri1 = RegionInfoBuilder.newBuilder((TableName)tn).setStartKey(Bytes.toBytes((String)"a")).setEndKey(Bytes.toBytes((String)"b")).build();
        RegionInfo hri2 = RegionInfoBuilder.newBuilder((TableName)tn).setStartKey(Bytes.toBytes((String)"b")).setEndKey(Bytes.toBytes((String)"c")).build();
        RegionInfo hri3 = RegionInfoBuilder.newBuilder((TableName)tn).setStartKey(Bytes.toBytes((String)"c")).setEndKey(Bytes.toBytes((String)"d")).build();
        RegionSizeStore store = RegionSizeStoreFactory.getInstance().createStore();
        store.put(hri1, 0x100000L);
        store.put(hri2, 0x800000L);
        store.put(hri3, 0x2000000L);
        HRegionServer rs = (HRegionServer)Mockito.mock(HRegionServer.class);
        ((HRegionServer)Mockito.doCallRealMethod().when((Object)rs)).buildRegionSpaceUseReportRequest((RegionSizeStore)Matchers.any(RegionSizeStore.class));
        ((HRegionServer)Mockito.doCallRealMethod().when((Object)rs)).convertRegionSize((RegionInfo)Matchers.any(), Long.valueOf(Matchers.anyLong()));
        RegionServerStatusProtos.RegionSpaceUseReportRequest requests = rs.buildRegionSpaceUseReportRequest(store);
        Assert.assertEquals((long)store.size(), (long)requests.getSpaceUseCount());
        for (RegionServerStatusProtos.RegionSpaceUse spaceUse : requests.getSpaceUseList()) {
            RegionInfo hri = ProtobufUtil.toRegionInfo((HBaseProtos.RegionInfo)spaceUse.getRegionInfo());
            RegionSize expectedSize = store.remove(hri);
            Assert.assertNotNull((String)("Could not find size for HRI: " + hri), (Object)expectedSize);
            Assert.assertEquals((long)expectedSize.getSize(), (long)spaceUse.getRegionSize());
        }
        Assert.assertTrue((String)("Should not have any space use entries left: " + store), (boolean)store.isEmpty());
    }
}

