/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellComparatorImpl;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.regionserver.querymatcher.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanWildcardColumnTracker;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={RegionServerTests.class, SmallTests.class})
public class TestScanWildcardColumnTracker {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestScanWildcardColumnTracker.class);
    static final int VERSIONS = 2;

    @Test
    public void testCheckColumnOk() throws IOException {
        ScanWildcardColumnTracker tracker = new ScanWildcardColumnTracker(0, 2, Long.MIN_VALUE, (CellComparator)CellComparatorImpl.COMPARATOR);
        ArrayList<byte[]> qualifiers = new ArrayList<byte[]>(4);
        qualifiers.add(Bytes.toBytes((String)"qualifier1"));
        qualifiers.add(Bytes.toBytes((String)"qualifier2"));
        qualifiers.add(Bytes.toBytes((String)"qualifier3"));
        qualifiers.add(Bytes.toBytes((String)"qualifier4"));
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>(4);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(qualifiers.size());
        for (byte[] qualifier : qualifiers) {
            ScanQueryMatcher.MatchCode mc = ScanQueryMatcher.checkColumn((ColumnTracker)tracker, (byte[])qualifier, (int)0, (int)qualifier.length, (long)1L, (byte)KeyValue.Type.Put.getCode(), (boolean)false);
            actual.add(mc);
        }
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals(expected.get(i), actual.get(i));
        }
    }

    @Test
    public void testCheckColumnEnforceVersions() throws IOException {
        ScanWildcardColumnTracker tracker = new ScanWildcardColumnTracker(0, 2, Long.MIN_VALUE, (CellComparator)CellComparatorImpl.COMPARATOR);
        ArrayList<byte[]> qualifiers = new ArrayList<byte[]>(4);
        qualifiers.add(Bytes.toBytes((String)"qualifier1"));
        qualifiers.add(Bytes.toBytes((String)"qualifier1"));
        qualifiers.add(Bytes.toBytes((String)"qualifier1"));
        qualifiers.add(Bytes.toBytes((String)"qualifier2"));
        ArrayList<ScanQueryMatcher.MatchCode> expected = new ArrayList<ScanQueryMatcher.MatchCode>(4);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        expected.add(ScanQueryMatcher.MatchCode.SEEK_NEXT_COL);
        expected.add(ScanQueryMatcher.MatchCode.INCLUDE);
        ArrayList<ScanQueryMatcher.MatchCode> actual = new ArrayList<ScanQueryMatcher.MatchCode>(qualifiers.size());
        long timestamp = 0L;
        for (byte[] qualifier : qualifiers) {
            ScanQueryMatcher.MatchCode mc = ScanQueryMatcher.checkColumn((ColumnTracker)tracker, (byte[])qualifier, (int)0, (int)qualifier.length, (long)(++timestamp), (byte)KeyValue.Type.Put.getCode(), (boolean)false);
            actual.add(mc);
        }
        for (int i = 0; i < expected.size(); ++i) {
            Assert.assertEquals(expected.get(i), actual.get(i));
        }
    }

    @Test
    public void DisabledTestCheckColumnWrongOrder() {
        ScanWildcardColumnTracker tracker = new ScanWildcardColumnTracker(0, 2, Long.MIN_VALUE, (CellComparator)CellComparatorImpl.COMPARATOR);
        ArrayList<byte[]> qualifiers = new ArrayList<byte[]>(2);
        qualifiers.add(Bytes.toBytes((String)"qualifier2"));
        qualifiers.add(Bytes.toBytes((String)"qualifier1"));
        try {
            for (byte[] qualifier : qualifiers) {
                ScanQueryMatcher.checkColumn((ColumnTracker)tracker, (byte[])qualifier, (int)0, (int)qualifier.length, (long)1L, (byte)KeyValue.Type.Put.getCode(), (boolean)false);
            }
            Assert.fail();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

