/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.tool;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableExistsException;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Admin;
import org.apache.hadoop.hbase.client.ClientServiceCallable;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.ColumnFamilyDescriptorBuilder;
import org.apache.hadoop.hbase.client.Connection;
import org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.client.TableDescriptor;
import org.apache.hadoop.hbase.client.TableDescriptorBuilder;
import org.apache.hadoop.hbase.ipc.RpcControllerFactory;
import org.apache.hadoop.hbase.log.HBaseMarkers;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.TestHRegionServerBulkLoad;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.shaded.protobuf.generated.AdminProtos;
import org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hadoop.hbase.testclassification.LargeTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.tool.BulkLoadHFilesTool;
import org.apache.hadoop.hbase.tool.LoadIncrementalHFiles;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hbase.thirdparty.com.google.common.collect.Multimap;
import org.apache.hbase.thirdparty.com.google.protobuf.RpcController;
import org.apache.hbase.thirdparty.com.google.protobuf.ServiceException;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, LargeTests.class})
public class TestLoadIncrementalHFilesSplitRecovery {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestLoadIncrementalHFilesSplitRecovery.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestHRegionServerBulkLoad.class);
    static HBaseTestingUtility util;
    static boolean useSecure;
    static final int NUM_CFS = 10;
    static final byte[] QUAL;
    static final int ROWCOUNT = 100;
    private static final byte[][] families;
    @Rule
    public TestName name = new TestName();

    static byte[] rowkey(int i) {
        return Bytes.toBytes((String)String.format("row_%08d", i));
    }

    static String family(int i) {
        return String.format("family_%04d", i);
    }

    static byte[] value(int i) {
        return Bytes.toBytes((String)String.format("%010d", i));
    }

    public static void buildHFiles(FileSystem fs, Path dir, int value) throws IOException {
        byte[] val = TestLoadIncrementalHFilesSplitRecovery.value(value);
        for (int i = 0; i < 10; ++i) {
            Path testIn = new Path(dir, TestLoadIncrementalHFilesSplitRecovery.family(i));
            TestHRegionServerBulkLoad.createHFile(fs, new Path(testIn, "hfile_" + i), Bytes.toBytes((String)TestLoadIncrementalHFilesSplitRecovery.family(i)), QUAL, val, 100);
        }
    }

    private TableDescriptor createTableDesc(TableName name, int cfs) {
        TableDescriptorBuilder builder = TableDescriptorBuilder.newBuilder((TableName)name);
        IntStream.range(0, cfs).mapToObj(i -> ColumnFamilyDescriptorBuilder.of((String)TestLoadIncrementalHFilesSplitRecovery.family(i))).forEachOrdered(arg_0 -> ((TableDescriptorBuilder)builder).setColumnFamily(arg_0));
        return builder.build();
    }

    private void setupTable(Connection connection, TableName table, int cfs) throws IOException {
        try {
            LOG.info("Creating table " + table);
            try (Admin admin = connection.getAdmin();){
                admin.createTable(this.createTableDesc(table, cfs));
            }
        }
        catch (TableExistsException tee) {
            LOG.info("Table " + table + " already exists");
        }
    }

    private void setupTableWithSplitkeys(TableName table, int cfs, byte[][] SPLIT_KEYS) throws IOException {
        try {
            LOG.info("Creating table " + table);
            util.createTable(this.createTableDesc(table, cfs), SPLIT_KEYS);
        }
        catch (TableExistsException tee) {
            LOG.info("Table " + table + " already exists");
        }
    }

    private Path buildBulkFiles(TableName table, int value) throws Exception {
        Path dir = util.getDataTestDirOnTestFS(table.getNameAsString());
        Path bulk1 = new Path(dir, table.getNameAsString() + value);
        FileSystem fs = util.getTestFileSystem();
        TestLoadIncrementalHFilesSplitRecovery.buildHFiles(fs, bulk1, value);
        return bulk1;
    }

    private void populateTable(Connection connection, TableName table, int value) throws Exception {
        LoadIncrementalHFiles lih = new LoadIncrementalHFiles(util.getConfiguration());
        Path bulk1 = this.buildBulkFiles(table, value);
        try (Table t = connection.getTable(table);
             RegionLocator locator = connection.getRegionLocator(table);
             Admin admin = connection.getAdmin();){
            lih.doBulkLoad(bulk1, admin, t, locator);
        }
    }

    private void forceSplit(TableName table) {
        try {
            int regions;
            HRegionServer hrs = util.getRSForFirstRegionInTable(table);
            for (RegionInfo hri : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices())) {
                if (!hri.getTable().equals((Object)table)) continue;
                util.getAdmin().splitRegionAsync(hri.getRegionName(), TestLoadIncrementalHFilesSplitRecovery.rowkey(50));
            }
            do {
                regions = 0;
                for (RegionInfo hri : ProtobufUtil.getOnlineRegions((AdminProtos.AdminService.BlockingInterface)hrs.getRSRpcServices())) {
                    if (!hri.getTable().equals((Object)table)) continue;
                    ++regions;
                }
                if (regions == 2) continue;
                LOG.info("Taking some time to complete split...");
                Thread.sleep(250L);
            } while (regions != 2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    @BeforeClass
    public static void setupCluster() throws Exception {
        util = new HBaseTestingUtility();
        util.getConfiguration().set("hbase.coprocessor.region.classes", "");
        util.startMiniCluster(1);
    }

    @AfterClass
    public static void teardownCluster() throws Exception {
        util.shutdownMiniCluster();
    }

    void assertExpectedTable(TableName table, int count, int value) throws IOException {
        TableDescriptor htd = util.getAdmin().getDescriptor(table);
        Assert.assertNotNull((Object)htd);
        try (Table t = util.getConnection().getTable(table);
             ResultScanner sr = t.getScanner(new Scan());){
            Result r;
            int i = 0;
            while ((r = sr.next()) != null) {
                r.getNoVersionMap().values().stream().flatMap(m -> m.values().stream()).forEach(v -> Assert.assertArrayEquals((byte[])TestLoadIncrementalHFilesSplitRecovery.value(value), (byte[])v));
                ++i;
            }
            Assert.assertEquals((long)count, (long)i);
        }
        catch (IOException e) {
            Assert.fail((String)"Failed due to exception");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=IOException.class)
    public void testBulkLoadPhaseFailure() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        final AtomicInteger attmptedCalls = new AtomicInteger();
        final AtomicInteger failedCalls = new AtomicInteger();
        util.getConfiguration().setInt("hbase.client.retries.number", 2);
        try (Connection connection = ConnectionFactory.createConnection((Configuration)util.getConfiguration());){
            this.setupTable(connection, table, 10);
            LoadIncrementalHFiles lih = new LoadIncrementalHFiles(util.getConfiguration()){

                protected List<LoadIncrementalHFiles.LoadQueueItem> tryAtomicRegionLoad(Connection connection, TableName tableName, byte[] first, Collection<LoadIncrementalHFiles.LoadQueueItem> lqis, boolean copyFile) throws IOException {
                    int i = attmptedCalls.incrementAndGet();
                    if (i == 1) {
                        ClusterConnection errConn;
                        try {
                            errConn = TestLoadIncrementalHFilesSplitRecovery.this.getMockedConnection(util.getConfiguration());
                        }
                        catch (Exception e) {
                            LOG.error(HBaseMarkers.FATAL, "mocking cruft, should never happen", (Throwable)e);
                            throw new RuntimeException("mocking cruft, should never happen");
                        }
                        failedCalls.incrementAndGet();
                        return super.tryAtomicRegionLoad((Connection)errConn, tableName, first, lqis, true);
                    }
                    return super.tryAtomicRegionLoad(connection, tableName, first, lqis, true);
                }
            };
            try {
                Path dir = this.buildBulkFiles(table, 1);
                try (Table t = connection.getTable(table);
                     RegionLocator locator = connection.getRegionLocator(table);
                     Admin admin = connection.getAdmin();){
                    lih.doBulkLoad(dir, admin, t, locator);
                }
            }
            finally {
                util.getConfiguration().setInt("hbase.client.retries.number", 15);
            }
            Assert.fail((String)"doBulkLoad should have thrown an exception");
        }
    }

    @Test
    public void testRetryOnIOException() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        final AtomicInteger calls = new AtomicInteger(0);
        Connection conn = ConnectionFactory.createConnection((Configuration)util.getConfiguration());
        util.getConfiguration().setInt("hbase.client.retries.number", 2);
        util.getConfiguration().setBoolean("hbase.bulkload.retries.retryOnIOException", true);
        LoadIncrementalHFiles lih = new LoadIncrementalHFiles(util.getConfiguration()){

            protected ClientServiceCallable<byte[]> buildClientServiceCallable(Connection conn, TableName tableName, byte[] first, Collection<LoadIncrementalHFiles.LoadQueueItem> lqis, boolean copyFile) {
                if (calls.get() < util.getConfiguration().getInt("hbase.client.retries.number", 15)) {
                    calls.getAndIncrement();
                    return new ClientServiceCallable<byte[]>(conn, tableName, first, (RpcController)new RpcControllerFactory(util.getConfiguration()).newController(), -1){

                        public byte[] rpcCall() throws Exception {
                            throw new IOException("Error calling something on RegionServer");
                        }
                    };
                }
                return super.buildClientServiceCallable(conn, tableName, first, lqis, true);
            }
        };
        this.setupTable(conn, table, 10);
        Path dir = this.buildBulkFiles(table, 1);
        lih.doBulkLoad(dir, conn.getAdmin(), conn.getTable(table), conn.getRegionLocator(table));
        Assert.assertEquals((long)calls.get(), (long)2L);
        util.getConfiguration().setBoolean("hbase.bulkload.retries.retryOnIOException", false);
    }

    private ClusterConnection getMockedConnection(Configuration conf) throws IOException, ServiceException {
        ClusterConnection c = (ClusterConnection)Mockito.mock(ClusterConnection.class);
        Mockito.when((Object)c.getConfiguration()).thenReturn((Object)conf);
        ((ClusterConnection)Mockito.doNothing().when((Object)c)).close();
        HRegionLocation loc = new HRegionLocation(RegionInfoBuilder.FIRST_META_REGIONINFO, ServerName.valueOf((String)"example.org", (int)1234, (long)0L));
        Mockito.when((Object)c.getRegionLocation((TableName)Mockito.any(), (byte[])Mockito.any(), Mockito.anyBoolean())).thenReturn((Object)loc);
        Mockito.when((Object)c.locateRegion((TableName)Mockito.any(), (byte[])Mockito.any())).thenReturn((Object)loc);
        ClientProtos.ClientService.BlockingInterface hri = (ClientProtos.ClientService.BlockingInterface)Mockito.mock(ClientProtos.ClientService.BlockingInterface.class);
        Mockito.when((Object)hri.bulkLoadHFile((RpcController)Mockito.any(), (ClientProtos.BulkLoadHFileRequest)Mockito.any())).thenThrow(new Throwable[]{new ServiceException((Throwable)new IOException("injecting bulk load error"))});
        Mockito.when((Object)c.getClient((ServerName)Mockito.any())).thenReturn((Object)hri);
        return c;
    }

    @Test
    public void testSplitWhileBulkLoadPhase() throws Exception {
        final TableName table = TableName.valueOf((String)this.name.getMethodName());
        try (Connection connection = ConnectionFactory.createConnection((Configuration)util.getConfiguration());){
            this.setupTable(connection, table, 10);
            this.populateTable(connection, table, 1);
            this.assertExpectedTable(table, 100, 1);
            final AtomicInteger attemptedCalls = new AtomicInteger();
            LoadIncrementalHFiles lih2 = new LoadIncrementalHFiles(util.getConfiguration()){

                protected void bulkLoadPhase(Table htable, Connection conn, ExecutorService pool, Deque<LoadIncrementalHFiles.LoadQueueItem> queue, Multimap<ByteBuffer, LoadIncrementalHFiles.LoadQueueItem> regionGroups, boolean copyFile, Map<LoadIncrementalHFiles.LoadQueueItem, ByteBuffer> item2RegionMap) throws IOException {
                    int i = attemptedCalls.incrementAndGet();
                    if (i == 1) {
                        TestLoadIncrementalHFilesSplitRecovery.this.forceSplit(table);
                    }
                    super.bulkLoadPhase(htable, conn, pool, queue, regionGroups, copyFile, item2RegionMap);
                }
            };
            try (Table t = connection.getTable(table);
                 RegionLocator locator = connection.getRegionLocator(table);
                 Admin admin = connection.getAdmin();){
                Path bulk = this.buildBulkFiles(table, 2);
                lih2.doBulkLoad(bulk, admin, t, locator);
            }
            Assert.assertEquals((long)3L, (long)attemptedCalls.get());
            this.assertExpectedTable(table, 100, 2);
        }
    }

    @Test
    public void testGroupOrSplitPresplit() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        try (Connection connection = ConnectionFactory.createConnection((Configuration)util.getConfiguration());){
            this.setupTable(connection, table, 10);
            this.populateTable(connection, table, 1);
            this.assertExpectedTable(connection, table, 100, 1);
            this.forceSplit(table);
            final AtomicInteger countedLqis = new AtomicInteger();
            LoadIncrementalHFiles lih = new LoadIncrementalHFiles(util.getConfiguration()){

                protected Pair<List<LoadIncrementalHFiles.LoadQueueItem>, String> groupOrSplit(Multimap<ByteBuffer, LoadIncrementalHFiles.LoadQueueItem> regionGroups, LoadIncrementalHFiles.LoadQueueItem item, Table htable, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
                    Pair lqis = super.groupOrSplit(regionGroups, item, htable, startEndKeys);
                    if (lqis != null && lqis.getFirst() != null) {
                        countedLqis.addAndGet(((List)lqis.getFirst()).size());
                    }
                    return lqis;
                }
            };
            Path bulk = this.buildBulkFiles(table, 2);
            try (Table t = connection.getTable(table);
                 RegionLocator locator = connection.getRegionLocator(table);
                 Admin admin = connection.getAdmin();){
                lih.doBulkLoad(bulk, admin, t, locator);
            }
            this.assertExpectedTable(connection, table, 100, 2);
            Assert.assertEquals((long)20L, (long)countedLqis.get());
        }
    }

    @Test
    public void testCorrectSplitPoint() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"row_00000010"), Bytes.toBytes((String)"row_00000020"), Bytes.toBytes((String)"row_00000030"), Bytes.toBytes((String)"row_00000040"), Bytes.toBytes((String)"row_00000050"), Bytes.toBytes((String)"row_00000060"), Bytes.toBytes((String)"row_00000070")};
        this.setupTableWithSplitkeys(table, 10, SPLIT_KEYS);
        final AtomicInteger bulkloadRpcTimes = new AtomicInteger();
        BulkLoadHFilesTool loader = new BulkLoadHFilesTool(util.getConfiguration()){

            protected void bulkLoadPhase(Table table, Connection conn, ExecutorService pool, Deque<LoadIncrementalHFiles.LoadQueueItem> queue, Multimap<ByteBuffer, LoadIncrementalHFiles.LoadQueueItem> regionGroups, boolean copyFile, Map<LoadIncrementalHFiles.LoadQueueItem, ByteBuffer> item2RegionMap) throws IOException {
                bulkloadRpcTimes.addAndGet(1);
                super.bulkLoadPhase(table, conn, pool, queue, regionGroups, copyFile, item2RegionMap);
            }
        };
        Path dir = this.buildBulkFiles(table, 1);
        loader.bulkLoad(table, dir);
        Assert.assertEquals((long)4L, (long)bulkloadRpcTimes.get());
    }

    @Test
    public void testSplitTmpFileCleanUp() throws Exception {
        TableName table = TableName.valueOf((String)this.name.getMethodName());
        byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"row_00000010"), Bytes.toBytes((String)"row_00000020"), Bytes.toBytes((String)"row_00000030"), Bytes.toBytes((String)"row_00000040"), Bytes.toBytes((String)"row_00000050")};
        try (Connection connection = ConnectionFactory.createConnection((Configuration)util.getConfiguration());){
            this.setupTableWithSplitkeys(table, 10, SPLIT_KEYS);
            LoadIncrementalHFiles lih = new LoadIncrementalHFiles(util.getConfiguration());
            Path bulk = this.buildBulkFiles(table, 2);
            try (Table t = connection.getTable(table);
                 RegionLocator locator = connection.getRegionLocator(table);
                 Admin admin = connection.getAdmin();){
                lih.doBulkLoad(bulk, admin, t, locator);
            }
            Path tmpPath = new Path(bulk, TestLoadIncrementalHFilesSplitRecovery.family(0));
            tmpPath = new Path(tmpPath, ".tmp");
            FileSystem fs = bulk.getFileSystem(util.getConfiguration());
            Assert.assertTrue((boolean)fs.exists(tmpPath));
            Assert.assertNull((String)".tmp should be empty.", (Object)CommonFSUtils.listStatus((FileSystem)fs, (Path)tmpPath));
            this.assertExpectedTable(connection, table, 100, 2);
        }
    }

    @Test(expected=IOException.class)
    public void testGroupOrSplitFailure() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        try (Connection connection = ConnectionFactory.createConnection((Configuration)util.getConfiguration());){
            this.setupTable(connection, tableName, 10);
            LoadIncrementalHFiles lih = new LoadIncrementalHFiles(util.getConfiguration()){
                int i;
                {
                    this.i = 0;
                }

                protected Pair<List<LoadIncrementalHFiles.LoadQueueItem>, String> groupOrSplit(Multimap<ByteBuffer, LoadIncrementalHFiles.LoadQueueItem> regionGroups, LoadIncrementalHFiles.LoadQueueItem item, Table table, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
                    ++this.i;
                    if (this.i == 5) {
                        throw new IOException("failure");
                    }
                    return super.groupOrSplit(regionGroups, item, table, startEndKeys);
                }
            };
            Path dir = this.buildBulkFiles(tableName, 1);
            try (Table t = connection.getTable(tableName);
                 RegionLocator locator = connection.getRegionLocator(tableName);
                 Admin admin = connection.getAdmin();){
                lih.doBulkLoad(dir, admin, t, locator);
            }
        }
        Assert.fail((String)"doBulkLoad should have thrown an exception");
    }

    @Test
    public void testGroupOrSplitWhenRegionHoleExistsInMeta() throws Exception {
        TableName tableName = TableName.valueOf((String)this.name.getMethodName());
        byte[][] SPLIT_KEYS = new byte[][]{Bytes.toBytes((String)"row_00000100")};
        Connection connection = ConnectionFactory.createConnection((Configuration)util.getConfiguration());
        Table table = connection.getTable(tableName);
        this.setupTableWithSplitkeys(tableName, 10, SPLIT_KEYS);
        Path dir = this.buildBulkFiles(tableName, 2);
        final AtomicInteger countedLqis = new AtomicInteger();
        LoadIncrementalHFiles loader = new LoadIncrementalHFiles(util.getConfiguration()){

            protected Pair<List<LoadIncrementalHFiles.LoadQueueItem>, String> groupOrSplit(Multimap<ByteBuffer, LoadIncrementalHFiles.LoadQueueItem> regionGroups, LoadIncrementalHFiles.LoadQueueItem item, Table htable, Pair<byte[][], byte[][]> startEndKeys) throws IOException {
                Pair lqis = super.groupOrSplit(regionGroups, item, htable, startEndKeys);
                if (lqis != null && lqis.getFirst() != null) {
                    countedLqis.addAndGet(((List)lqis.getFirst()).size());
                }
                return lqis;
            }
        };
        try {
            Table t = connection.getTable(tableName);
            Object object = null;
            try (RegionLocator locator2 = connection.getRegionLocator(tableName);
                 Admin admin = connection.getAdmin();){
                loader.doBulkLoad(dir, admin, t, locator2);
            }
            catch (Throwable locator2) {
                object = locator2;
                throw locator2;
            }
            finally {
                if (t != null) {
                    if (object != null) {
                        try {
                            t.close();
                        }
                        catch (Throwable locator2) {
                            ((Throwable)object).addSuppressed(locator2);
                        }
                    } else {
                        t.close();
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("exeception=", (Throwable)e);
        }
        this.assertExpectedTable(tableName, 100, 2);
        dir = this.buildBulkFiles(tableName, 3);
        List regionInfos = MetaTableAccessor.getTableRegions((Connection)connection, (TableName)tableName);
        for (RegionInfo regionInfo : regionInfos) {
            if (!Bytes.equals((byte[])regionInfo.getStartKey(), (byte[])HConstants.EMPTY_BYTE_ARRAY)) continue;
            MetaTableAccessor.deleteRegionInfo((Connection)connection, (RegionInfo)regionInfo);
            break;
        }
        try (Table t = connection.getTable(tableName);
             RegionLocator locator = connection.getRegionLocator(tableName);
             Admin admin = connection.getAdmin();){
            loader.doBulkLoad(dir, admin, t, locator);
        }
        catch (Exception e) {
            LOG.error("exception=", (Throwable)e);
            Assert.assertTrue((String)"IOException expected", (boolean)(e instanceof IOException));
        }
        table.close();
        regionInfos = MetaTableAccessor.getTableRegions((Connection)connection, (TableName)tableName);
        Assert.assertTrue((regionInfos.size() >= 1 ? 1 : 0) != 0);
        this.assertExpectedTable(connection, tableName, 100, 2);
        connection.close();
    }

    void assertExpectedTable(Connection connection, TableName table, int count, int value) throws IOException {
        TableDescriptor htd = util.getAdmin().getDescriptor(table);
        Assert.assertNotNull((Object)htd);
        try (Table t = connection.getTable(table);
             ResultScanner sr = t.getScanner(new Scan());){
            Result r;
            int i = 0;
            while ((r = sr.next()) != null) {
                r.getNoVersionMap().values().stream().flatMap(m -> m.values().stream()).forEach(v -> Assert.assertArrayEquals((byte[])TestLoadIncrementalHFilesSplitRecovery.value(value), (byte[])v));
                ++i;
            }
            Assert.assertEquals((long)count, (long)i);
        }
        catch (IOException e) {
            Assert.fail((String)"Failed due to exception");
        }
    }

    static {
        useSecure = false;
        QUAL = Bytes.toBytes((String)"qual");
        families = new byte[10][];
        for (int i = 0; i < 10; ++i) {
            TestLoadIncrementalHFilesSplitRecovery.families[i] = Bytes.toBytes((String)TestLoadIncrementalHFilesSplitRecovery.family(i));
        }
    }
}

