/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.fs.HFileSystem;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.MiscTests;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hadoop.hbase.util.EnvironmentEdge;
import org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.FileSystemVersionException;
import org.apache.hadoop.hbase.util.ManualEnvironmentEdge;
import org.apache.hadoop.hdfs.DFSHedgedReadMetrics;
import org.apache.hadoop.hdfs.DFSTestUtil;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.util.VersionInfo;
import org.junit.Assert;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={MiscTests.class, MediumTests.class})
public class TestFSUtils {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestFSUtils.class);
    private static final Logger LOG = LoggerFactory.getLogger(TestFSUtils.class);
    private HBaseTestingUtility htu;
    private FileSystem fs;
    private Configuration conf;
    final String INVALID_STORAGE_POLICY = "1772";
    static final int blockSize = 4096;
    static final long seed = 3735928559L;
    private Random rand = new Random();

    @Before
    public void setUp() throws IOException {
        this.htu = new HBaseTestingUtility();
        this.fs = this.htu.getTestFileSystem();
        this.conf = this.htu.getConfiguration();
    }

    @Test
    public void testIsHDFS() throws Exception {
        Assert.assertFalse((boolean)CommonFSUtils.isHDFS((Configuration)this.conf));
        MiniDFSCluster cluster = null;
        try {
            cluster = this.htu.startMiniDFSCluster(1);
            Assert.assertTrue((boolean)CommonFSUtils.isHDFS((Configuration)this.conf));
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    private void WriteDataToHDFS(FileSystem fs, Path file, int dataSize) throws Exception {
        FSDataOutputStream out = fs.create(file);
        byte[] data = new byte[dataSize];
        out.write(data, 0, dataSize);
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testcomputeHDFSBlocksDistribution() throws Exception {
        FileStatus status;
        long maxTime;
        DistributedFileSystem fs;
        String[] hosts;
        int DEFAULT_BLOCK_SIZE = 1024;
        this.conf.setLong("dfs.blocksize", 1024L);
        MiniDFSCluster cluster = null;
        Path testFile = null;
        try {
            boolean ok;
            hosts = new String[]{"host1", "host2", "host3"};
            cluster = this.htu.startMiniDFSCluster(hosts);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            testFile = new Path("/test1.txt");
            this.WriteDataToHDFS((FileSystem)fs, testFile, 2048);
            maxTime = System.currentTimeMillis() + 2000L;
            do {
                ok = true;
                status = fs.getFileStatus(testFile);
                HDFSBlocksDistribution blocksDistribution = FSUtils.computeHDFSBlocksDistribution((FileSystem)fs, (FileStatus)status, (long)0L, (long)status.getLen());
                long uniqueBlocksTotalWeight = blocksDistribution.getUniqueBlocksTotalWeight();
                for (String host : hosts) {
                    long weight = blocksDistribution.getWeight(host);
                    ok = ok && uniqueBlocksTotalWeight == weight;
                }
            } while (!ok && System.currentTimeMillis() < maxTime);
            Assert.assertTrue((boolean)ok);
        }
        finally {
            this.htu.shutdownMiniDFSCluster();
        }
        try {
            String tophost;
            long weight;
            FileStatus status2;
            HDFSBlocksDistribution blocksDistribution;
            long uniqueBlocksTotalWeight;
            hosts = new String[]{"host1", "host2", "host3", "host4"};
            cluster = this.htu.startMiniDFSCluster(hosts);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            testFile = new Path("/test2.txt");
            this.WriteDataToHDFS((FileSystem)fs, testFile, 3072);
            maxTime = System.currentTimeMillis() + 2000L;
            while ((uniqueBlocksTotalWeight = (blocksDistribution = FSUtils.computeHDFSBlocksDistribution((FileSystem)fs, (FileStatus)(status2 = fs.getFileStatus(testFile)), (long)0L, (long)status2.getLen())).getUniqueBlocksTotalWeight()) != (weight = blocksDistribution.getWeight(tophost = (String)blocksDistribution.getTopHosts().get(0))) && System.currentTimeMillis() < maxTime) {
            }
            Assert.assertTrue((uniqueBlocksTotalWeight == weight ? 1 : 0) != 0);
        }
        finally {
            this.htu.shutdownMiniDFSCluster();
        }
        try {
            HDFSBlocksDistribution blocksDistribution;
            hosts = new String[]{"host1", "host2", "host3", "host4"};
            cluster = this.htu.startMiniDFSCluster(hosts);
            cluster.waitActive();
            fs = cluster.getFileSystem();
            testFile = new Path("/test3.txt");
            this.WriteDataToHDFS((FileSystem)fs, testFile, 1024);
            maxTime = System.currentTimeMillis() + 2000L;
            while ((blocksDistribution = FSUtils.computeHDFSBlocksDistribution((FileSystem)fs, (FileStatus)(status = fs.getFileStatus(testFile)), (long)0L, (long)status.getLen())).getTopHosts().size() != 3 && System.currentTimeMillis() < maxTime) {
            }
            Assert.assertEquals((String)"Wrong number of hosts distributing blocks.", (long)3L, (long)blocksDistribution.getTopHosts().size());
        }
        finally {
            this.htu.shutdownMiniDFSCluster();
        }
    }

    private void writeVersionFile(Path versionFile, String version) throws IOException {
        if (CommonFSUtils.isExists((FileSystem)this.fs, (Path)versionFile)) {
            Assert.assertTrue((boolean)CommonFSUtils.delete((FileSystem)this.fs, (Path)versionFile, (boolean)true));
        }
        try (FSDataOutputStream s = this.fs.create(versionFile);){
            s.writeUTF(version);
        }
        Assert.assertTrue((boolean)this.fs.exists(versionFile));
    }

    @Test
    public void testVersion() throws DeserializationException, IOException {
        Path rootdir = this.htu.getDataTestDir();
        FileSystem fs = rootdir.getFileSystem(this.conf);
        Assert.assertNull((Object)FSUtils.getVersion((FileSystem)fs, (Path)rootdir));
        FSUtils.checkVersion((FileSystem)fs, (Path)rootdir, (boolean)true);
        Path versionFile = new Path(rootdir, "hbase.version");
        Assert.assertTrue((boolean)CommonFSUtils.isExists((FileSystem)fs, (Path)versionFile));
        Assert.assertTrue((boolean)CommonFSUtils.delete((FileSystem)fs, (Path)versionFile, (boolean)true));
        Path metaRegionDir = FSUtils.getRegionDirFromRootDir((Path)rootdir, (RegionInfo)RegionInfoBuilder.FIRST_META_REGIONINFO);
        FsPermission defaultPerms = CommonFSUtils.getFilePermissions((FileSystem)fs, (Configuration)this.conf, (String)"hbase.data.umask");
        CommonFSUtils.create((FileSystem)fs, (Path)metaRegionDir, (FsPermission)defaultPerms, (boolean)false);
        boolean thrown = false;
        try {
            FSUtils.checkVersion((FileSystem)fs, (Path)rootdir, (boolean)true);
        }
        catch (FileSystemVersionException e) {
            thrown = true;
        }
        Assert.assertTrue((String)"Expected FileSystemVersionException", (boolean)thrown);
        String version = "8";
        this.writeVersionFile(versionFile, version);
        FileStatus[] status = fs.listStatus(versionFile);
        Assert.assertNotNull((Object)status);
        Assert.assertTrue((status.length > 0 ? 1 : 0) != 0);
        String newVersion = FSUtils.getVersion((FileSystem)fs, (Path)rootdir);
        Assert.assertEquals((long)version.length(), (long)newVersion.length());
        Assert.assertEquals((Object)version, (Object)newVersion);
        Assert.assertEquals((Object)version, (Object)FSUtils.getVersion((FileSystem)fs, (Path)rootdir));
        FSUtils.checkVersion((FileSystem)fs, (Path)rootdir, (boolean)true);
        String oldVersion = "1";
        this.writeVersionFile(versionFile, oldVersion);
        newVersion = FSUtils.getVersion((FileSystem)fs, (Path)rootdir);
        Assert.assertNotEquals((Object)version, (Object)newVersion);
        thrown = false;
        try {
            FSUtils.checkVersion((FileSystem)fs, (Path)rootdir, (boolean)true);
        }
        catch (FileSystemVersionException e) {
            thrown = true;
        }
        Assert.assertTrue((String)"Expected FileSystemVersionException", (boolean)thrown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPermMask() throws Exception {
        Path rootdir = this.htu.getDataTestDir();
        FileSystem fs = rootdir.getFileSystem(this.conf);
        FsPermission defaultFsPerm = CommonFSUtils.getFilePermissions((FileSystem)fs, (Configuration)this.conf, (String)"hbase.data.umask");
        Assert.assertEquals((Object)FsPermission.getFileDefault(), (Object)defaultFsPerm);
        this.conf.setBoolean("hbase.data.umask.enable", true);
        FsPermission defaultStartPerm = CommonFSUtils.getFilePermissions((FileSystem)fs, (Configuration)this.conf, (String)"hbase.data.umask");
        Assert.assertEquals((Object)new FsPermission("777"), (Object)defaultStartPerm);
        this.conf.setStrings("hbase.data.umask", new String[]{"077"});
        FsPermission filePerm = CommonFSUtils.getFilePermissions((FileSystem)fs, (Configuration)this.conf, (String)"hbase.data.umask");
        Assert.assertEquals((Object)new FsPermission("700"), (Object)filePerm);
        Path p = new Path("target" + File.separator + HBaseTestingUtility.getRandomUUID().toString());
        try {
            FSDataOutputStream out = FSUtils.create((Configuration)this.conf, (FileSystem)fs, (Path)p, (FsPermission)filePerm, null);
            out.close();
            FileStatus stat = fs.getFileStatus(p);
            Assert.assertEquals((Object)new FsPermission("700"), (Object)stat.getPermission());
        }
        finally {
            fs.delete(p, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDeleteAndExists() throws Exception {
        Path rootdir = this.htu.getDataTestDir();
        FileSystem fs = rootdir.getFileSystem(this.conf);
        this.conf.setBoolean("hbase.data.umask.enable", true);
        FsPermission perms = CommonFSUtils.getFilePermissions((FileSystem)fs, (Configuration)this.conf, (String)"hbase.data.umask");
        String file = HBaseTestingUtility.getRandomUUID().toString();
        Path p = new Path(this.htu.getDataTestDir(), "temptarget" + File.separator + file);
        Path p1 = new Path(this.htu.getDataTestDir(), "temppath" + File.separator + file);
        try {
            FSDataOutputStream out = FSUtils.create((Configuration)this.conf, (FileSystem)fs, (Path)p, (FsPermission)perms, null);
            out.close();
            Assert.assertTrue((String)"The created file should be present", (boolean)CommonFSUtils.isExists((FileSystem)fs, (Path)p));
            CommonFSUtils.delete((FileSystem)fs, (Path)p, (boolean)false);
            FSDataOutputStream out1 = FSUtils.create((Configuration)this.conf, (FileSystem)fs, (Path)p1, (FsPermission)perms, null);
            out1.close();
            CommonFSUtils.delete((FileSystem)fs, (Path)p1, (boolean)true);
            Assert.assertFalse((String)"The created file should be present", (boolean)CommonFSUtils.isExists((FileSystem)fs, (Path)p1));
        }
        finally {
            CommonFSUtils.delete((FileSystem)fs, (Path)p, (boolean)true);
            CommonFSUtils.delete((FileSystem)fs, (Path)p1, (boolean)true);
        }
    }

    @Test
    public void testFilteredStatusDoesNotThrowOnNotFound() throws Exception {
        MiniDFSCluster cluster = this.htu.startMiniDFSCluster(1);
        try {
            Assert.assertNull((Object)FSUtils.listStatusWithStatusFilter((FileSystem)cluster.getFileSystem(), (Path)new Path("definitely/doesn't/exist"), null));
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenameAndSetModifyTime() throws Exception {
        MiniDFSCluster cluster = this.htu.startMiniDFSCluster(1);
        Assert.assertTrue((boolean)CommonFSUtils.isHDFS((Configuration)this.conf));
        FileSystem fs = FileSystem.get((Configuration)this.conf);
        Path testDir = this.htu.getDataTestDirOnTestFS("testArchiveFile");
        String file = HBaseTestingUtility.getRandomUUID().toString();
        Path p = new Path(testDir, file);
        FSDataOutputStream out = fs.create(p);
        out.close();
        Assert.assertTrue((String)"The created file should be present", (boolean)CommonFSUtils.isExists((FileSystem)fs, (Path)p));
        long expect = System.currentTimeMillis() + 1000L;
        Assert.assertNotEquals((long)expect, (long)fs.getFileStatus(p).getModificationTime());
        ManualEnvironmentEdge mockEnv = new ManualEnvironmentEdge();
        mockEnv.setValue(expect);
        EnvironmentEdgeManager.injectEdge((EnvironmentEdge)mockEnv);
        try {
            String dstFile = HBaseTestingUtility.getRandomUUID().toString();
            Path dst = new Path(testDir, dstFile);
            Assert.assertTrue((boolean)CommonFSUtils.renameAndSetModifyTime((FileSystem)fs, (Path)p, (Path)dst));
            Assert.assertFalse((String)"The moved file should not be present", (boolean)CommonFSUtils.isExists((FileSystem)fs, (Path)p));
            Assert.assertTrue((String)"The dst file should be present", (boolean)CommonFSUtils.isExists((FileSystem)fs, (Path)dst));
            Assert.assertEquals((long)expect, (long)fs.getFileStatus(dst).getModificationTime());
            cluster.shutdown();
        }
        finally {
            EnvironmentEdgeManager.reset();
        }
    }

    @Test
    public void testSetStoragePolicyDefault() throws Exception {
        this.verifyNoHDFSApiInvocationForDefaultPolicy();
        this.verifyFileInDirWithStoragePolicy("NONE");
    }

    private void verifyNoHDFSApiInvocationForDefaultPolicy() {
        AlwaysFailSetStoragePolicyFileSystem testFs = new AlwaysFailSetStoragePolicyFileSystem();
        try {
            CommonFSUtils.setStoragePolicy((FileSystem)testFs, (Path)new Path("non-exist"), (String)"NONE", (boolean)true);
        }
        catch (IOException e) {
            Assert.fail((String)"Should have bypassed the FS API when setting default storage policy");
        }
        try {
            CommonFSUtils.setStoragePolicy((FileSystem)testFs, (Path)new Path("non-exist"), (String)"HOT", (boolean)true);
            Assert.fail((String)"Should have invoked the FS API but haven't");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testSetStoragePolicyValidButMaybeNotPresent() throws Exception {
        this.verifyFileInDirWithStoragePolicy("ALL_SSD");
    }

    @Test
    public void testSetStoragePolicyInvalid() throws Exception {
        this.verifyFileInDirWithStoragePolicy("1772");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void verifyFileInDirWithStoragePolicy(String policy) throws Exception {
        this.conf.set("hbase.wal.storage.policy", policy);
        MiniDFSCluster cluster = this.htu.startMiniDFSCluster(1);
        try {
            Assert.assertTrue((boolean)CommonFSUtils.isHDFS((Configuration)this.conf));
            FileSystem fs = FileSystem.get((Configuration)this.conf);
            Path testDir = this.htu.getDataTestDirOnTestFS("testArchiveFile");
            fs.mkdirs(testDir);
            String storagePolicy = this.conf.get("hbase.wal.storage.policy", "NONE");
            CommonFSUtils.setStoragePolicy((FileSystem)fs, (Path)testDir, (String)storagePolicy);
            String file = HBaseTestingUtility.getRandomUUID().toString();
            Path p = new Path(testDir, file);
            this.WriteDataToHDFS(fs, p, 4096);
            HFileSystem hfs = new HFileSystem(fs);
            String policySet = hfs.getStoragePolicyName(p);
            LOG.debug("The storage policy of path " + p + " is " + policySet);
            if (policy.equals("NONE") || policy.equals("1772")) {
                String hdfsDefaultPolicy = hfs.getStoragePolicyName(hfs.getHomeDirectory());
                LOG.debug("The default hdfs storage policy (indicated by home path: " + hfs.getHomeDirectory() + ") is " + hdfsDefaultPolicy);
                Assert.assertEquals((Object)hdfsDefaultPolicy, (Object)policySet);
            } else {
                Assert.assertEquals((Object)policy, (Object)policySet);
            }
            this.cleanupFile(fs, testDir);
        }
        finally {
            cluster.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDFSHedgedReadMetrics() throws Exception {
        this.conf.setInt("dfs.client.hedged.read.threadpool.size", 5);
        this.conf.setLong("dfs.client.hedged.read.threshold.millis", 0L);
        this.conf.setLong("dfs.blocksize", 4096L);
        this.conf.setLong("dfs.client.read.prefetch.size", 4096L);
        this.conf.setInt("dfs.client.retry.window.base", 0);
        this.conf.setBoolean("dfs.datanode.transferTo.allowed", false);
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(this.conf).numDataNodes(3).build();
        DFSHedgedReadMetrics metrics = FSUtils.getDFSHedgedReadMetrics((Configuration)this.conf);
        Assert.assertEquals((long)0L, (long)metrics.getHedgedReadOps());
        DistributedFileSystem fileSys = cluster.getFileSystem();
        try {
            Path p = new Path("preadtest.dat");
            DFSTestUtil.createFile((FileSystem)fileSys, (Path)p, (int)49152, (long)49152L, (long)4096L, (short)3, (long)3735928559L);
            this.pReadFile((FileSystem)fileSys, p);
            this.cleanupFile((FileSystem)fileSys, p);
            Assert.assertTrue((metrics.getHedgedReadOps() > 0L ? 1 : 0) != 0);
        }
        finally {
            fileSys.close();
            cluster.shutdown();
        }
    }

    @Test
    public void testCopyFilesParallel() throws Exception {
        MiniDFSCluster cluster = this.htu.startMiniDFSCluster(1);
        cluster.waitActive();
        DistributedFileSystem fs = cluster.getFileSystem();
        Path src = new Path("/src");
        fs.mkdirs(src);
        for (int i = 0; i < 50; ++i) {
            this.WriteDataToHDFS((FileSystem)fs, new Path(src, String.valueOf(i)), 1024);
        }
        Path sub = new Path(src, "sub");
        fs.mkdirs(sub);
        for (int i = 0; i < 50; ++i) {
            this.WriteDataToHDFS((FileSystem)fs, new Path(sub, String.valueOf(i)), 1024);
        }
        Path dst = new Path("/dst");
        List allFiles = FSUtils.copyFilesParallel((FileSystem)fs, (Path)src, (FileSystem)fs, (Path)dst, (Configuration)this.conf, (int)4);
        Assert.assertEquals((long)102L, (long)allFiles.size());
        FileStatus[] list = fs.listStatus(dst);
        Assert.assertEquals((long)51L, (long)list.length);
        FileStatus[] sublist = fs.listStatus(new Path(dst, "sub"));
        Assert.assertEquals((long)50L, (long)sublist.length);
    }

    private void pReadFile(FileSystem fileSys, Path name) throws IOException {
        FSDataInputStream stm = fileSys.open(name);
        byte[] expected = new byte[49152];
        this.rand.setSeed(3735928559L);
        this.rand.nextBytes(expected);
        byte[] actual = new byte[4096];
        stm.readFully(actual);
        this.checkAndEraseData(actual, 0, expected, "Read Sanity Test");
        actual = new byte[8192];
        this.doPread(stm, 0L, actual, 0, 8192);
        this.checkAndEraseData(actual, 0, expected, "Pread Test 1");
        actual = new byte[4096];
        stm.readFully(actual);
        this.checkAndEraseData(actual, 4096, expected, "Pread Test 2");
        stm.readFully(2048L, actual, 0, 4096);
        this.checkAndEraseData(actual, 2048, expected, "Pread Test 3");
        actual = new byte[8192];
        stm.readFully(2048L, actual);
        this.checkAndEraseData(actual, 2048, expected, "Pread Test 4");
        actual = new byte[8192];
        stm.readFully(38912L, actual);
        this.checkAndEraseData(actual, 38912, expected, "Pread Test 5");
        actual = new byte[4096];
        stm.readFully(actual);
        this.checkAndEraseData(actual, 8192, expected, "Pread Test 6");
        stm.close();
        stm = fileSys.open(name);
        stm.readFully(1L, actual, 0, 4096);
        stm.readFully(16384L, actual, 0, 4096);
        stm.readFully(28672L, actual, 0, 4096);
        actual = new byte[12288];
        stm.readFully(0L, actual, 0, 12288);
        this.checkAndEraseData(actual, 0, expected, "Pread Test 7");
        actual = new byte[32768];
        stm.readFully(12288L, actual, 0, 32768);
        this.checkAndEraseData(actual, 12288, expected, "Pread Test 8");
        stm.readFully(47104L, actual, 0, 2048);
        IOException res = null;
        try {
            stm.readFully(47104L, actual, 0, 4096);
        }
        catch (IOException e) {
            res = e;
        }
        Assert.assertTrue((String)"Error reading beyond file boundary.", (res != null ? 1 : 0) != 0);
        stm.close();
    }

    private void checkAndEraseData(byte[] actual, int from, byte[] expected, String message) {
        for (int idx = 0; idx < actual.length; ++idx) {
            Assert.assertEquals((String)(message + " byte " + (from + idx) + " differs. expected " + expected[from + idx] + " actual " + actual[idx]), (long)actual[idx], (long)expected[from + idx]);
            actual[idx] = 0;
        }
    }

    private void doPread(FSDataInputStream stm, long position, byte[] buffer, int offset, int length) throws IOException {
        int nbytes;
        for (int nread = 0; nread < length; nread += nbytes) {
            nbytes = stm.read(position + (long)nread, buffer, offset + nread, length - nread);
            Assert.assertTrue((String)"Error in pread", (nbytes > 0 ? 1 : 0) != 0);
        }
    }

    private void cleanupFile(FileSystem fileSys, Path name) throws IOException {
        Assert.assertTrue((boolean)fileSys.exists(name));
        Assert.assertTrue((boolean)fileSys.delete(name, true));
        Assert.assertTrue((!fileSys.exists(name) ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void checkStreamCapabilitiesOnHdfsDataOutputStream() throws Exception {
        MiniDFSCluster cluster = this.htu.startMiniDFSCluster(1);
        try (DistributedFileSystem filesystem = cluster.getFileSystem();){
            FSDataOutputStream stream = filesystem.create(new Path("/tmp/foobar"));
            Assert.assertTrue((boolean)stream.hasCapability("hsync"));
            Assert.assertTrue((boolean)stream.hasCapability("hflush"));
            Assert.assertFalse((boolean)stream.hasCapability("a capability that hopefully HDFS doesn't add."));
        }
        finally {
            cluster.shutdown();
        }
    }

    private void testIsSameHdfs(int nnport) throws IOException {
        Configuration conf = HBaseConfiguration.create();
        Path srcPath = new Path("hdfs://localhost:" + nnport + "/");
        Path desPath = new Path("hdfs://127.0.0.1/");
        FileSystem srcFs = srcPath.getFileSystem(conf);
        FileSystem desFs = desPath.getFileSystem(conf);
        Assert.assertTrue((boolean)FSUtils.isSameHdfs((Configuration)conf, (FileSystem)srcFs, (FileSystem)desFs));
        desPath = new Path("hdfs://127.0.0.1:8070/");
        desFs = desPath.getFileSystem(conf);
        Assert.assertTrue((!FSUtils.isSameHdfs((Configuration)conf, (FileSystem)srcFs, (FileSystem)desFs) ? 1 : 0) != 0);
        desPath = new Path("hdfs://127.0.1.1:" + nnport + "/");
        desFs = desPath.getFileSystem(conf);
        Assert.assertTrue((!FSUtils.isSameHdfs((Configuration)conf, (FileSystem)srcFs, (FileSystem)desFs) ? 1 : 0) != 0);
        conf.set("fs.defaultFS", "hdfs://haosong-hadoop");
        conf.set("dfs.nameservices", "haosong-hadoop");
        conf.set("dfs.ha.namenodes.haosong-hadoop", "nn1,nn2");
        conf.set("dfs.client.failover.proxy.provider.haosong-hadoop", "org.apache.hadoop.hdfs.server.namenode.ha.ConfiguredFailoverProxyProvider");
        conf.set("dfs.namenode.rpc-address.haosong-hadoop.nn1", "127.0.0.1:" + nnport);
        conf.set("dfs.namenode.rpc-address.haosong-hadoop.nn2", "127.10.2.1:8000");
        desPath = new Path("/");
        desFs = desPath.getFileSystem(conf);
        Assert.assertTrue((boolean)FSUtils.isSameHdfs((Configuration)conf, (FileSystem)srcFs, (FileSystem)desFs));
        conf.set("dfs.namenode.rpc-address.haosong-hadoop.nn1", "127.10.2.1:" + nnport);
        conf.set("dfs.namenode.rpc-address.haosong-hadoop.nn2", "127.0.0.1:8000");
        desPath = new Path("/");
        desFs = desPath.getFileSystem(conf);
        Assert.assertTrue((!FSUtils.isSameHdfs((Configuration)conf, (FileSystem)srcFs, (FileSystem)desFs) ? 1 : 0) != 0);
    }

    @Test
    public void testIsSameHdfs() throws IOException {
        String hadoopVersion = VersionInfo.getVersion();
        LOG.info("hadoop version is: " + hadoopVersion);
        boolean isHadoop3_0_0 = hadoopVersion.startsWith("3.0.0");
        if (isHadoop3_0_0) {
            this.testIsSameHdfs(9820);
        } else {
            this.testIsSameHdfs(8020);
        }
    }

    static {
        try {
            Class.forName("org.apache.hadoop.fs.StreamCapabilities");
            LOG.debug("Test thought StreamCapabilities class was present.");
        }
        catch (ClassNotFoundException exception) {
            LOG.debug("Test didn't think StreamCapabilities class was present.");
        }
    }

    class AlwaysFailSetStoragePolicyFileSystem
    extends DistributedFileSystem {
        AlwaysFailSetStoragePolicyFileSystem() {
        }

        public void setStoragePolicy(Path src, String policyName) throws IOException {
            throw new IOException("The setStoragePolicy method is invoked");
        }
    }
}

