/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.wal;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.HBaseTestingUtility;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Table;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.apache.hadoop.hbase.testclassification.RegionServerTests;
import org.apache.hadoop.hbase.util.Bytes;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.TestName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Category(value={RegionServerTests.class, MediumTests.class})
public class TestDisabledWAL {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestDisabledWAL.class);
    @Rule
    public TestName name = new TestName();
    private static final Logger LOG = LoggerFactory.getLogger(TestDisabledWAL.class);
    static final HBaseTestingUtility TEST_UTIL = new HBaseTestingUtility();
    private Table table;
    private TableName tableName;
    private byte[] fam = Bytes.toBytes((String)"f1");

    @BeforeClass
    public static void beforeClass() throws Exception {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setBoolean("hbase.regionserver.hlog.enabled", false);
        try {
            TEST_UTIL.startMiniCluster();
        }
        catch (IOException | RuntimeException e) {
            LOG.error("Master failed to start.", (Throwable)e);
            Assert.fail((String)("Failed to start cluster. Reason being: " + e.getCause().getMessage()));
        }
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Before
    public void setup() throws Exception {
        this.tableName = TableName.valueOf((String)this.name.getMethodName().replaceAll("[^a-zA-Z0-9]", "_"));
        LOG.info("Creating table " + this.tableName);
        this.table = TEST_UTIL.createTable(this.tableName, this.fam);
    }

    @After
    public void cleanup() throws Exception {
        LOG.info("Deleting table " + this.tableName);
        TEST_UTIL.deleteTable(this.tableName);
    }

    @Test
    public void testDisabledWAL() throws Exception {
        LOG.info("Writing data to table " + this.tableName);
        Put p = new Put(Bytes.toBytes((String)"row"));
        p.addColumn(this.fam, Bytes.toBytes((String)"qual"), Bytes.toBytes((String)"val"));
        this.table.put(p);
        LOG.info("Flushing table " + this.tableName);
        TEST_UTIL.flush(this.tableName);
        LOG.info("Getting data from table " + this.tableName);
        Get get = new Get(Bytes.toBytes((String)"row"));
        Result result = this.table.get(get);
        Assert.assertNotNull((Object)result.getValue(this.fam, Bytes.toBytes((String)"qual")));
    }
}

