/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import org.apache.hadoop.hbase.ipc.RpcCallContext;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class VersionInfoUtil {
    private VersionInfoUtil() {
    }

    public static boolean currentClientHasMinimumVersion(int major, int minor) {
        return VersionInfoUtil.hasMinimumVersion(VersionInfoUtil.getCurrentClientVersionInfo(), major, minor);
    }

    public static boolean hasMinimumVersion(HBaseProtos.VersionInfo versionInfo, int major, int minor) {
        if (versionInfo != null) {
            if (versionInfo.hasVersionMajor() && versionInfo.hasVersionMinor()) {
                int clientMajor = versionInfo.getVersionMajor();
                if (clientMajor != major) {
                    return clientMajor > major;
                }
                int clientMinor = versionInfo.getVersionMinor();
                return clientMinor >= minor;
            }
            try {
                int clientMajor;
                String[] components = VersionInfoUtil.getVersionComponents(versionInfo);
                int n = clientMajor = components.length > 0 ? Integer.parseInt(components[0]) : 0;
                if (clientMajor != major) {
                    return clientMajor > major;
                }
                int clientMinor = components.length > 1 ? Integer.parseInt(components[1]) : 0;
                return clientMinor >= minor;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static HBaseProtos.VersionInfo getCurrentClientVersionInfo() {
        return RpcServer.getCurrentCall().map(RpcCallContext::getClientVersionInfo).orElse(null);
    }

    public static String versionNumberToString(int version) {
        return String.format("%d.%d.%d", version >> 20 & 0xFF, version >> 12 & 0xFF, version & 0xFFF);
    }

    public static int getVersionNumber(HBaseProtos.VersionInfo versionInfo) {
        if (versionInfo != null) {
            try {
                String[] components = VersionInfoUtil.getVersionComponents(versionInfo);
                int clientMajor = components.length > 0 ? Integer.parseInt(components[0]) : 0;
                int clientMinor = components.length > 1 ? Integer.parseInt(components[1]) : 0;
                int clientPatch = components.length > 2 ? Integer.parseInt(components[2]) : 0;
                return VersionInfoUtil.buildVersionNumber(clientMajor, clientMinor, clientPatch);
            }
            catch (NumberFormatException e) {
                int clientMajor = versionInfo.hasVersionMajor() ? versionInfo.getVersionMajor() : 0;
                int clientMinor = versionInfo.hasVersionMinor() ? versionInfo.getVersionMinor() : 0;
                return VersionInfoUtil.buildVersionNumber(clientMajor, clientMinor, 0);
            }
        }
        return 0;
    }

    private static int buildVersionNumber(int major, int minor, int patch) {
        return major << 20 | minor << 12 | patch;
    }

    private static String[] getVersionComponents(HBaseProtos.VersionInfo versionInfo) {
        return versionInfo.getVersion().split("[\\.-]");
    }
}

