/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.balancer.BalancerRegionLoad;
import org.apache.hadoop.hbase.master.balancer.CostFromRegionLoadAsRateFunction;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class MemStoreSizeCostFunction
extends CostFromRegionLoadAsRateFunction {
    private static final String MEMSTORE_SIZE_COST_KEY = "hbase.master.balancer.stochastic.memstoreSizeCost";
    private static final float DEFAULT_MEMSTORE_SIZE_COST = 5.0f;

    MemStoreSizeCostFunction(Configuration conf) {
        this.setMultiplier(conf.getFloat(MEMSTORE_SIZE_COST_KEY, 5.0f));
    }

    @Override
    protected double getCostFromRl(BalancerRegionLoad rl) {
        return rl.getMemStoreSizeMB();
    }
}

