/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.balancer;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.master.balancer.BalancerRegionLoad;
import org.apache.hadoop.hbase.master.balancer.CostFromRegionLoadAsRateFunction;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class ReadRequestCostFunction
extends CostFromRegionLoadAsRateFunction {
    private static final String READ_REQUEST_COST_KEY = "hbase.master.balancer.stochastic.readRequestCost";
    private static final float DEFAULT_READ_REQUEST_COST = 5.0f;

    ReadRequestCostFunction(Configuration conf) {
        this.setMultiplier(conf.getFloat(READ_REQUEST_COST_KEY, 5.0f));
    }

    @Override
    protected double getCostFromRl(BalancerRegionLoad rl) {
        return rl.getReadRequestsCount();
    }
}

