/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.snapshot;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.master.snapshot.SnapshotManager;
import org.apache.hadoop.hbase.snapshot.CorruptedSnapshotException;
import org.apache.hadoop.hbase.snapshot.SnapshotDescriptionUtils;
import org.apache.hadoop.hbase.util.CommonFSUtils;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hbase.thirdparty.com.google.common.collect.ImmutableSet;
import org.apache.hbase.thirdparty.com.google.common.collect.Lists;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class SnapshotFileCache
implements Stoppable {
    private static final Logger LOG = LoggerFactory.getLogger(SnapshotFileCache.class);
    private volatile boolean stop = false;
    private final FileSystem fs;
    private final FileSystem workingFs;
    private final SnapshotFileInspector fileInspector;
    private final Path snapshotDir;
    private final Path workingSnapshotDir;
    private volatile ImmutableSet<String> cache = ImmutableSet.of();
    private ImmutableMap<String, SnapshotDirectoryInfo> snapshots = ImmutableMap.of();
    private final Timer refreshTimer;
    private static final int LOCK_TIMEOUT_MS = 30000;

    public SnapshotFileCache(Configuration conf, long cacheRefreshPeriod, long cacheRefreshDelay, String refreshThreadName, SnapshotFileInspector inspectSnapshotFiles) throws IOException {
        this(CommonFSUtils.getCurrentFileSystem((Configuration)conf), CommonFSUtils.getRootDir((Configuration)conf), SnapshotDescriptionUtils.getWorkingSnapshotDir(CommonFSUtils.getRootDir((Configuration)conf), conf).getFileSystem(conf), SnapshotDescriptionUtils.getWorkingSnapshotDir(CommonFSUtils.getRootDir((Configuration)conf), conf), cacheRefreshPeriod, cacheRefreshDelay, refreshThreadName, inspectSnapshotFiles);
    }

    public SnapshotFileCache(FileSystem fs, Path rootDir, FileSystem workingFs, Path workingDir, long cacheRefreshPeriod, long cacheRefreshDelay, String refreshThreadName, SnapshotFileInspector inspectSnapshotFiles) {
        this.fs = fs;
        this.workingFs = workingFs;
        this.workingSnapshotDir = workingDir;
        this.fileInspector = inspectSnapshotFiles;
        this.snapshotDir = SnapshotDescriptionUtils.getSnapshotsDir(rootDir);
        this.refreshTimer = new Timer(refreshThreadName, true);
        this.refreshTimer.scheduleAtFixedRate((TimerTask)new RefreshCacheTask(), cacheRefreshDelay, cacheRefreshPeriod);
    }

    public synchronized void triggerCacheRefreshForTesting() {
        try {
            this.refreshCache();
        }
        catch (IOException e) {
            LOG.warn("Failed to refresh snapshot hfile cache!", (Throwable)e);
        }
        LOG.debug("Current cache:" + this.cache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Iterable<FileStatus> getUnreferencedFiles(List<FileStatus> files, SnapshotManager snapshotManager) throws IOException {
        ArrayList unReferencedFiles = Lists.newArrayList();
        List<String> snapshotsInProgress = null;
        boolean refreshed = false;
        Lock lock = null;
        if (snapshotManager != null) {
            lock = snapshotManager.getTakingSnapshotLock().writeLock();
        }
        try {
            if (lock != null && !lock.tryLock(30000L, TimeUnit.MILLISECONDS)) {
                LOG.warn("Failed to acquire write lock on taking snapshot after waiting {}ms", (Object)30000);
                return unReferencedFiles;
            }
            try {
                if (snapshotManager != null && snapshotManager.isTakingAnySnapshot()) {
                    LOG.warn("Not checking unreferenced files since snapshot is running, it will skip to clean the HFiles this time");
                    ArrayList arrayList = unReferencedFiles;
                    return arrayList;
                }
                ImmutableSet<String> currentCache = this.cache;
                Iterator<FileStatus> iterator = files.iterator();
                while (iterator.hasNext()) {
                    FileStatus file = iterator.next();
                    String fileName = file.getPath().getName();
                    if (!refreshed && !currentCache.contains((Object)fileName)) {
                        SnapshotFileCache snapshotFileCache = this;
                        synchronized (snapshotFileCache) {
                            this.refreshCache();
                            currentCache = this.cache;
                            refreshed = true;
                        }
                    }
                    if (currentCache.contains((Object)fileName)) continue;
                    if (snapshotsInProgress == null) {
                        snapshotsInProgress = this.getSnapshotsInProgress();
                    }
                    if (snapshotsInProgress.contains(fileName)) continue;
                    unReferencedFiles.add(file);
                }
                return unReferencedFiles;
            }
            finally {
                if (lock != null) {
                    lock.unlock();
                }
            }
        }
        catch (InterruptedException e) {
            LOG.warn("Interrupted while acquiring write lock on taking snapshot");
            Thread.currentThread().interrupt();
        }
        return unReferencedFiles;
    }

    private void refreshCache() throws IOException {
        Object[] snapshotDirs = CommonFSUtils.listStatus((FileSystem)this.fs, (Path)this.snapshotDir, p -> !p.getName().equals(".tmp"));
        if (ArrayUtils.isEmpty((Object[])snapshotDirs)) {
            if (LOG.isDebugEnabled() && this.snapshots.size() > 0) {
                LOG.debug("No snapshots on-disk, clear cache");
            }
            this.snapshots = ImmutableMap.of();
            this.cache = ImmutableSet.of();
            return;
        }
        ImmutableSet.Builder cacheBuilder = ImmutableSet.builder();
        ImmutableMap.Builder snapshotsBuilder = ImmutableMap.builder();
        for (Object snapshotDir : snapshotDirs) {
            String name = snapshotDir.getPath().getName();
            SnapshotDirectoryInfo files = (SnapshotDirectoryInfo)this.snapshots.get((Object)name);
            if (files == null || files.hasBeenModified(snapshotDir.getModificationTime())) {
                Collection<String> storedFiles = this.fileInspector.filesUnderSnapshot(this.fs, snapshotDir.getPath());
                files = new SnapshotDirectoryInfo(snapshotDir.getModificationTime(), storedFiles);
            }
            cacheBuilder.addAll(files.getFiles());
            snapshotsBuilder.put((Object)name, (Object)files);
        }
        this.snapshots = snapshotsBuilder.build();
        this.cache = cacheBuilder.build();
    }

    List<String> getSnapshotsInProgress() throws IOException {
        ArrayList snapshotInProgress = Lists.newArrayList();
        Object[] snapshotsInProgress = CommonFSUtils.listStatus((FileSystem)this.workingFs, (Path)this.workingSnapshotDir);
        if (!ArrayUtils.isEmpty((Object[])snapshotsInProgress)) {
            for (Object snapshot : snapshotsInProgress) {
                try {
                    snapshotInProgress.addAll(this.fileInspector.filesUnderSnapshot(this.workingFs, snapshot.getPath()));
                }
                catch (CorruptedSnapshotException cse) {
                    LOG.info("Corrupted in-progress snapshot file exception, ignored.", (Throwable)cse);
                }
            }
        }
        return snapshotInProgress;
    }

    public void stop(String why) {
        if (!this.stop) {
            this.stop = true;
            this.refreshTimer.cancel();
        }
    }

    public boolean isStopped() {
        return this.stop;
    }

    private static class SnapshotDirectoryInfo {
        long lastModified;
        Collection<String> files;

        public SnapshotDirectoryInfo(long mtime, Collection<String> files) {
            this.lastModified = mtime;
            this.files = files;
        }

        public Collection<String> getFiles() {
            return this.files;
        }

        public boolean hasBeenModified(long mtime) {
            return this.lastModified < mtime;
        }
    }

    public class RefreshCacheTask
    extends TimerTask {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            SnapshotFileCache snapshotFileCache = SnapshotFileCache.this;
            synchronized (snapshotFileCache) {
                try {
                    SnapshotFileCache.this.refreshCache();
                }
                catch (IOException e) {
                    LOG.warn("Failed to refresh snapshot hfile cache!", (Throwable)e);
                    SnapshotFileCache.this.cache = ImmutableSet.of();
                    SnapshotFileCache.this.snapshots = ImmutableMap.of();
                }
            }
        }
    }

    static interface SnapshotFileInspector {
        public Collection<String> filesUnderSnapshot(FileSystem var1, Path var2) throws IOException;
    }
}

