/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.util.List;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class VersionedSegmentsList {
    private final List<ImmutableSegment> storeSegments;
    private final long version;

    public VersionedSegmentsList(List<ImmutableSegment> storeSegments, long version) {
        this.storeSegments = storeSegments;
        this.version = version;
    }

    public List<ImmutableSegment> getStoreSegments() {
        return this.storeSegments;
    }

    public long getVersion() {
        return this.version;
    }

    public int getNumOfCells() {
        int totalCells = 0;
        for (ImmutableSegment s : this.storeSegments) {
            totalCells += s.getCellsCount();
        }
        return totalCells;
    }

    public int getNumOfSegments() {
        return this.storeSegments.size();
    }

    double getEstimatedUniquesFrac() {
        int segmentCells = 0;
        int maxCells = 0;
        double est = 0.0;
        for (ImmutableSegment s : this.storeSegments) {
            double segmentUniques = s.getNumUniqueKeys();
            if (segmentUniques == -1.0 || (segmentCells = s.getCellsCount()) <= maxCells) continue;
            maxCells = segmentCells;
            est = segmentUniques / (double)segmentCells;
        }
        if (maxCells == 0) {
            return 1.0;
        }
        return est;
    }
}

