/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import org.apache.hadoop.fs.Path;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class ReplicationStatus {
    private final String peerId;
    private final String walGroup;
    private final Path currentPath;
    private final int queueSize;
    private final long ageOfLastShippedOp;
    private final long replicationDelay;
    private final long currentPosition;
    private final long fileSize;

    private ReplicationStatus(ReplicationStatusBuilder builder) {
        this.peerId = builder.peerId;
        this.walGroup = builder.walGroup;
        this.currentPath = builder.currentPath;
        this.queueSize = builder.queueSize;
        this.ageOfLastShippedOp = builder.ageOfLastShippedOp;
        this.replicationDelay = builder.replicationDelay;
        this.currentPosition = builder.currentPosition;
        this.fileSize = builder.fileSize;
    }

    public long getCurrentPosition() {
        return this.currentPosition;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public String getPeerId() {
        return this.peerId;
    }

    public String getWalGroup() {
        return this.walGroup;
    }

    public int getQueueSize() {
        return this.queueSize;
    }

    public long getAgeOfLastShippedOp() {
        return this.ageOfLastShippedOp;
    }

    public long getReplicationDelay() {
        return this.replicationDelay;
    }

    public Path getCurrentPath() {
        return this.currentPath;
    }

    public static ReplicationStatusBuilder newBuilder() {
        return new ReplicationStatusBuilder();
    }

    public static class ReplicationStatusBuilder {
        private String peerId = "UNKNOWN";
        private String walGroup = "UNKNOWN";
        private Path currentPath = new Path("UNKNOWN");
        private int queueSize = -1;
        private long ageOfLastShippedOp = -1L;
        private long replicationDelay = -1L;
        private long currentPosition = -1L;
        private long fileSize = -1L;

        public ReplicationStatusBuilder withPeerId(String peerId) {
            this.peerId = peerId;
            return this;
        }

        public ReplicationStatusBuilder withFileSize(long fileSize) {
            this.fileSize = fileSize;
            return this;
        }

        public ReplicationStatusBuilder withWalGroup(String walGroup) {
            this.walGroup = walGroup;
            return this;
        }

        public ReplicationStatusBuilder withCurrentPath(Path currentPath) {
            this.currentPath = currentPath;
            return this;
        }

        public ReplicationStatusBuilder withQueueSize(int queueSize) {
            this.queueSize = queueSize;
            return this;
        }

        public ReplicationStatusBuilder withAgeOfLastShippedOp(long ageOfLastShippedOp) {
            this.ageOfLastShippedOp = ageOfLastShippedOp;
            return this;
        }

        public ReplicationStatusBuilder withReplicationDelay(long replicationDelay) {
            this.replicationDelay = replicationDelay;
            return this;
        }

        public ReplicationStatusBuilder withCurrentPosition(long currentPosition) {
            this.currentPosition = currentPosition;
            return this;
        }

        public ReplicationStatus build() {
            return new ReplicationStatus(this);
        }
    }
}

