/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.encoding;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class NoneEncoder {
    private DataOutputStream out;
    private HFileBlockDefaultEncodingContext encodingCtx;

    public NoneEncoder(DataOutputStream out, HFileBlockDefaultEncodingContext encodingCtx) {
        this.out = out;
        this.encodingCtx = encodingCtx;
    }

    public int write(Cell cell) throws IOException {
        int klength = KeyValueUtil.keyLength(cell);
        int vlength = cell.getValueLength();
        this.out.writeInt(klength);
        this.out.writeInt(vlength);
        CellUtil.writeFlatKey(cell, this.out);
        this.out.write(cell.getValueArray(), cell.getValueOffset(), vlength);
        int size = klength + vlength + 8;
        if (this.encodingCtx.getHFileContext().isIncludesTags()) {
            int tagsLength = cell.getTagsLength();
            this.out.writeShort(tagsLength);
            if (tagsLength > 0) {
                this.out.write(cell.getTagsArray(), cell.getTagsOffset(), tagsLength);
            }
            size += tagsLength + 2;
        }
        if (this.encodingCtx.getHFileContext().isIncludesMvcc()) {
            WritableUtils.writeVLong(this.out, cell.getSequenceId());
            size += WritableUtils.getVIntSize(cell.getSequenceId());
        }
        return size;
    }
}

