/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.controller.rebalancer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.HelixManager;
import org.apache.helix.ZNRecord;
import org.apache.helix.controller.rebalancer.Rebalancer;
import org.apache.helix.controller.rebalancer.internal.MappingCalculator;
import org.apache.helix.controller.rebalancer.util.ConstraintBasedAssignment;
import org.apache.helix.controller.stages.ClusterDataCache;
import org.apache.helix.controller.stages.CurrentStateOutput;
import org.apache.helix.controller.strategy.AutoRebalanceStrategy;
import org.apache.helix.model.IdealState;
import org.apache.helix.model.LiveInstance;
import org.apache.helix.model.Partition;
import org.apache.helix.model.Resource;
import org.apache.helix.model.ResourceAssignment;
import org.apache.helix.model.StateModelDefinition;
import org.apache.log4j.Logger;

public class AutoRebalancer
implements Rebalancer,
MappingCalculator {
    private HelixManager _manager;
    private AutoRebalanceStrategy _algorithm;
    private static final Logger LOG = Logger.getLogger(AutoRebalancer.class);

    @Override
    public void init(HelixManager manager) {
        this._manager = manager;
        this._algorithm = null;
    }

    @Override
    public IdealState computeNewIdealState(String resourceName, IdealState currentIdealState, CurrentStateOutput currentStateOutput, ClusterDataCache clusterData) {
        ArrayList<String> partitions = new ArrayList<String>(currentIdealState.getPartitionSet());
        String stateModelName = currentIdealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = clusterData.getStateModelDef(stateModelName);
        Map<String, LiveInstance> liveInstance = clusterData.getLiveInstances();
        String replicas = currentIdealState.getReplicas();
        LinkedHashMap<String, Integer> stateCountMap = new LinkedHashMap();
        stateCountMap = AutoRebalancer.stateCount(stateModelDef, liveInstance.size(), Integer.parseInt(replicas));
        ArrayList<String> liveNodes = new ArrayList<String>(liveInstance.keySet());
        ArrayList<String> allNodes = new ArrayList<String>(clusterData.getInstanceConfigMap().keySet());
        Map<String, Map<String, String>> currentMapping = this.currentMapping(currentStateOutput, resourceName, partitions, stateCountMap);
        HashSet<String> taggedNodes = new HashSet<String>();
        HashSet<String> taggedLiveNodes = new HashSet<String>();
        if (currentIdealState.getInstanceGroupTag() != null) {
            for (String instanceName : allNodes) {
                if (!clusterData.getInstanceConfigMap().get(instanceName).containsTag(currentIdealState.getInstanceGroupTag())) continue;
                taggedNodes.add(instanceName);
                if (!liveInstance.containsKey(instanceName)) continue;
                taggedLiveNodes.add(instanceName);
            }
            if (!taggedLiveNodes.isEmpty()) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("found the following participants with tag " + currentIdealState.getInstanceGroupTag() + " for " + resourceName + ": " + taggedLiveNodes));
                }
            } else if (taggedNodes.isEmpty()) {
                LOG.warn((Object)("Resource " + resourceName + " has tag " + currentIdealState.getInstanceGroupTag() + " but no configured participants have this tag"));
            } else {
                LOG.warn((Object)("Resource " + resourceName + " has tag " + currentIdealState.getInstanceGroupTag() + " but no live participants have this tag"));
            }
            allNodes = new ArrayList(taggedNodes);
            liveNodes = new ArrayList(taggedLiveNodes);
        }
        Collections.sort(allNodes);
        Collections.sort(liveNodes);
        int maxPartition = currentIdealState.getMaxPartitionsPerInstance();
        AutoRebalanceStrategy.DefaultPlacementScheme placementScheme = new AutoRebalanceStrategy.DefaultPlacementScheme();
        placementScheme.init(this._manager);
        this._algorithm = new AutoRebalanceStrategy(resourceName, partitions, stateCountMap, maxPartition, placementScheme);
        ZNRecord newMapping = this._algorithm.computePartitionAssignment(liveNodes, currentMapping, allNodes);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("currentMapping: " + currentMapping));
            LOG.debug((Object)("stateCountMap: " + stateCountMap));
            LOG.debug((Object)("liveNodes: " + liveNodes));
            LOG.debug((Object)("allNodes: " + allNodes));
            LOG.debug((Object)("maxPartition: " + maxPartition));
            LOG.debug((Object)("newMapping: " + newMapping));
        }
        IdealState newIdealState = new IdealState(resourceName);
        newIdealState.getRecord().setSimpleFields(currentIdealState.getRecord().getSimpleFields());
        newIdealState.setRebalanceMode(IdealState.RebalanceMode.FULL_AUTO);
        newIdealState.getRecord().setListFields(newMapping.getListFields());
        return newIdealState;
    }

    public static LinkedHashMap<String, Integer> stateCount(StateModelDefinition stateModelDef, int liveNodesNb, int totalReplicas) {
        String num;
        LinkedHashMap<String, Integer> stateCountMap = new LinkedHashMap<String, Integer>();
        List<String> statesPriorityList = stateModelDef.getStatesPriorityList();
        int replicas = totalReplicas;
        for (String state : statesPriorityList) {
            num = stateModelDef.getNumInstancesPerState(state);
            if ("N".equals(num)) {
                stateCountMap.put(state, liveNodesNb);
                continue;
            }
            if ("R".equals(num)) continue;
            int stateCount = -1;
            try {
                stateCount = Integer.parseInt(num);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (stateCount <= 0) continue;
            stateCountMap.put(state, stateCount);
            replicas -= stateCount;
        }
        for (String state : statesPriorityList) {
            num = stateModelDef.getNumInstancesPerState(state);
            if (!"R".equals(num)) continue;
            stateCountMap.put(state, replicas);
            break;
        }
        return stateCountMap;
    }

    private Map<String, Map<String, String>> currentMapping(CurrentStateOutput currentStateOutput, String resourceName, List<String> partitions, Map<String, Integer> stateCountMap) {
        HashMap<String, Map<String, String>> map = new HashMap<String, Map<String, String>>();
        for (String partition : partitions) {
            Map<String, String> curStateMap = currentStateOutput.getCurrentStateMap(resourceName, new Partition(partition));
            map.put(partition, new HashMap());
            for (String node : curStateMap.keySet()) {
                String state = curStateMap.get(node);
                ((Map)map.get(partition)).put(node, state);
            }
            Map<String, String> pendingStateMap = currentStateOutput.getPendingStateMap(resourceName, new Partition(partition));
            for (String node : pendingStateMap.keySet()) {
                String state = pendingStateMap.get(node);
                ((Map)map.get(partition)).put(node, state);
            }
        }
        return map;
    }

    @Override
    public ResourceAssignment computeBestPossiblePartitionState(ClusterDataCache cache, IdealState idealState, Resource resource, CurrentStateOutput currentStateOutput) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Processing resource:" + resource.getResourceName()));
        }
        String stateModelDefName = idealState.getStateModelDefRef();
        StateModelDefinition stateModelDef = cache.getStateModelDef(stateModelDefName);
        ResourceAssignment partitionMapping = new ResourceAssignment(resource.getResourceName());
        for (Partition partition : resource.getPartitions()) {
            Map<String, String> currentStateMap = currentStateOutput.getCurrentStateMap(resource.getResourceName(), partition);
            Set<String> disabledInstancesForPartition = cache.getDisabledInstancesForPartition(partition.toString());
            List<String> preferenceList = ConstraintBasedAssignment.getPreferenceList(cache, partition, idealState, stateModelDef);
            Map<String, String> bestStateForPartition = ConstraintBasedAssignment.computeAutoBestStateForPartition(cache, stateModelDef, preferenceList, currentStateMap, disabledInstancesForPartition, idealState.isEnabled());
            partitionMapping.addReplicaMap(partition, bestStateForPartition);
        }
        return partitionMapping;
    }
}

