/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.manager.zk;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.I0Itec.zkclient.DataUpdater;
import org.I0Itec.zkclient.exception.ZkBadVersionException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.apache.helix.manager.zk.ZkBaseDataAccessor;
import org.apache.log4j.Logger;
import org.apache.zookeeper.data.Stat;

public class HelixGroupCommit<T> {
    private static Logger LOG = Logger.getLogger(HelixGroupCommit.class);
    private final Queue<T>[] _queues = new Queue[100];

    public HelixGroupCommit() {
        for (int i = 0; i < this._queues.length; ++i) {
            this._queues[i] = new Queue();
        }
    }

    private Queue<T> getQueue(String key) {
        return this._queues[(key.hashCode() & Integer.MAX_VALUE) % this._queues.length];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean commit(ZkBaseDataAccessor<T> accessor, int options, String key, DataUpdater<T> updater) {
        Queue<T> queue = this.getQueue(key);
        Entry<T> entry = new Entry<T>(key, updater);
        queue._pending.add(entry);
        while (!entry._sent.get()) {
            if (queue._running.compareAndSet(null, Thread.currentThread())) {
                Iterator i$;
                Entry first;
                boolean success;
                ArrayList<Entry> processed;
                block30: {
                    processed = new ArrayList<Entry>();
                    success = true;
                    first = queue._pending.peek();
                    if (first != null) break block30;
                    boolean bl = true;
                    queue._running.set(null);
                    Iterator i$2 = processed.iterator();
                    while (i$2.hasNext()) {
                        Entry e;
                        Entry entry2 = e = (Entry)i$2.next();
                        synchronized (entry2) {
                            e._sent.set(true);
                            e._isSuccess = success;
                            e.notify();
                        }
                    }
                    return bl;
                }
                try {
                    boolean retry;
                    String mergedKey = first._key;
                    do {
                        retry = false;
                        try {
                            Object merged = null;
                            Stat readStat = new Stat();
                            readStat.setVersion(-1);
                            try {
                                merged = accessor.get(mergedKey, readStat, options);
                            }
                            catch (ZkNoNodeException e) {
                                // empty catch block
                            }
                            for (Entry ent : processed) {
                                if (!ent._key.equals(mergedKey)) continue;
                                merged = ent._updater.update(merged);
                                if (!LOG.isDebugEnabled()) continue;
                                LOG.debug((Object)("After merging processed entry. path: " + mergedKey + ", value: " + merged));
                            }
                            Iterator<Object> it = queue._pending.iterator();
                            while (it.hasNext()) {
                                Entry ent;
                                ent = (Entry)it.next();
                                if (!ent._key.equals(mergedKey)) continue;
                                processed.add(ent);
                                merged = ent._updater.update(merged);
                                if (LOG.isDebugEnabled()) {
                                    LOG.debug((Object)("After merging pending entry. path: " + mergedKey + ", value: " + merged));
                                }
                                it.remove();
                            }
                            success = accessor.set(mergedKey, merged, readStat.getVersion(), options);
                            if (success) continue;
                            LOG.error((Object)("Fail to group commit. path: " + mergedKey + ", value: " + merged + ", version: " + readStat.getVersion()));
                        }
                        catch (ZkBadVersionException e) {
                            retry = true;
                        }
                    } while (retry);
                    queue._running.set(null);
                    i$ = processed.iterator();
                }
                catch (Throwable throwable) {
                    queue._running.set(null);
                    Iterator i$3 = processed.iterator();
                    while (i$3.hasNext()) {
                        Entry e;
                        Entry entry3 = e = (Entry)i$3.next();
                        synchronized (entry3) {
                            e._sent.set(true);
                            e._isSuccess = success;
                            e.notify();
                        }
                    }
                    throw throwable;
                }
                while (i$.hasNext()) {
                    Entry e;
                    Entry entry4 = e = (Entry)i$.next();
                    synchronized (entry4) {
                        e._sent.set(true);
                        e._isSuccess = success;
                        e.notify();
                    }
                }
                continue;
            }
            Entry<T> entry5 = entry;
            synchronized (entry5) {
                try {
                    entry.wait(10L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return false;
                }
            }
        }
        return entry._isSuccess;
    }

    private static class Entry<T> {
        final String _key;
        final DataUpdater<T> _updater;
        AtomicBoolean _sent = new AtomicBoolean(false);
        boolean _isSuccess;

        Entry(String key, DataUpdater<T> updater) {
            this._key = key;
            this._updater = updater;
            this._isSuccess = true;
        }
    }

    private static class Queue<T> {
        final AtomicReference<Thread> _running = new AtomicReference();
        final ConcurrentLinkedQueue<Entry<T>> _pending = new ConcurrentLinkedQueue();

        private Queue() {
        }
    }
}

