/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.participant;

import org.apache.helix.HelixManager;
import org.apache.helix.HelixManagerFactory;
import org.apache.helix.InstanceType;
import org.apache.helix.NotificationContext;
import org.apache.helix.model.Message;
import org.apache.helix.participant.statemachine.StateModel;
import org.apache.helix.participant.statemachine.StateModelInfo;
import org.apache.helix.participant.statemachine.StateModelParser;
import org.apache.helix.participant.statemachine.StateTransitionError;
import org.apache.helix.participant.statemachine.Transition;
import org.apache.log4j.Logger;

@StateModelInfo(initialState="OFFLINE", states={"LEADER", "STANDBY"})
public class DistClusterControllerStateModel
extends StateModel {
    private static Logger logger = Logger.getLogger(DistClusterControllerStateModel.class);
    private HelixManager _controller = null;
    private final String _zkAddr;

    public DistClusterControllerStateModel(String zkAddr) {
        StateModelParser parser = new StateModelParser();
        this._currentState = parser.getInitialState(DistClusterControllerStateModel.class);
        this._zkAddr = zkAddr;
    }

    @Transition(to="STANDBY", from="OFFLINE")
    public void onBecomeStandbyFromOffline(Message message, NotificationContext context) {
        logger.info((Object)"Becoming standby from offline");
    }

    @Transition(to="LEADER", from="STANDBY")
    public void onBecomeLeaderFromStandby(Message message, NotificationContext context) throws Exception {
        String clusterName = message.getPartitionName();
        String controllerName = message.getTgtName();
        logger.info((Object)(controllerName + " becomes leader from standby for " + clusterName));
        if (this._controller == null) {
            this._controller = HelixManagerFactory.getZKHelixManager(clusterName, controllerName, InstanceType.CONTROLLER, this._zkAddr);
            this._controller.connect();
            this._controller.startTimerTasks();
        } else {
            logger.error((Object)("controller already exists:" + this._controller.getInstanceName() + " for " + clusterName));
        }
    }

    @Transition(to="STANDBY", from="LEADER")
    public void onBecomeStandbyFromLeader(Message message, NotificationContext context) {
        String clusterName = message.getPartitionName();
        String controllerName = message.getTgtName();
        logger.info((Object)(controllerName + " becoming standby from leader for " + clusterName));
        if (this._controller != null) {
            this._controller.disconnect();
            this._controller = null;
        } else {
            logger.error((Object)("No controller exists for " + clusterName));
        }
    }

    @Transition(to="OFFLINE", from="STANDBY")
    public void onBecomeOfflineFromStandby(Message message, NotificationContext context) {
        String clusterName = message.getPartitionName();
        String controllerName = message.getTgtName();
        logger.info((Object)(controllerName + " becoming offline from standby for cluster:" + clusterName));
    }

    @Transition(to="DROPPED", from="OFFLINE")
    public void onBecomeDroppedFromOffline(Message message, NotificationContext context) {
        logger.info((Object)"Becoming dropped from offline");
    }

    @Transition(to="OFFLINE", from="DROPPED")
    public void onBecomeOfflineFromDropped(Message message, NotificationContext context) {
        logger.info((Object)"Becoming offline from dropped");
    }

    @Override
    public void rollbackOnError(Message message, NotificationContext context, StateTransitionError error) {
        String clusterName = message.getPartitionName();
        String controllerName = message.getTgtName();
        logger.error((Object)(controllerName + " rollbacks on error for " + clusterName));
        if (this._controller != null) {
            this._controller.disconnect();
            this._controller = null;
        }
    }

    @Override
    public void reset() {
        if (this._controller != null) {
            this._controller.disconnect();
            this._controller = null;
        }
    }
}

