/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.task;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskUtil;

public class JobConfig {
    public static final String WORKFLOW_ID = "WorkflowID";
    public static final String ASSIGNMENT_STRATEGY = "AssignmentStrategy";
    public static final String TARGET_RESOURCE = "TargetResource";
    public static final String TARGET_PARTITION_STATES = "TargetPartitionStates";
    public static final String TARGET_PARTITIONS = "TargetPartitions";
    public static final String COMMAND = "Command";
    public static final String JOB_COMMAND_CONFIG_MAP = "JobCommandConfig";
    public static final String TIMEOUT_PER_TASK = "TimeoutPerPartition";
    public static final String MAX_ATTEMPTS_PER_TASK = "MaxAttemptsPerTask";
    public static final String MAX_FORCED_REASSIGNMENTS_PER_TASK = "MaxForcedReassignmentsPerTask";
    public static final String NUM_CONCURRENT_TASKS_PER_INSTANCE = "ConcurrentTasksPerInstance";
    public static final String FAILURE_THRESHOLD = "FailureThreshold";
    public static final String TASK_RETRY_DELAY = "TaskRetryDelay";
    public static final String TASK_CONFIGS = "TaskConfigs";
    public static final long DEFAULT_TIMEOUT_PER_TASK = 3600000L;
    public static final long DEFAULT_TASK_RETRY_DELAY = -1L;
    public static final int DEFAULT_MAX_ATTEMPTS_PER_TASK = 10;
    public static final int DEFAULT_NUM_CONCURRENT_TASKS_PER_INSTANCE = 1;
    public static final int DEFAULT_FAILURE_THRESHOLD = 0;
    public static final int DEFAULT_MAX_FORCED_REASSIGNMENTS_PER_TASK = 0;
    private final String _workflow;
    private final String _targetResource;
    private final List<String> _targetPartitions;
    private final Set<String> _targetPartitionStates;
    private final String _command;
    private final Map<String, String> _jobCommandConfigMap;
    private final long _timeoutPerTask;
    private final int _numConcurrentTasksPerInstance;
    private final int _maxAttemptsPerTask;
    private final int _maxForcedReassignmentsPerTask;
    private final int _failureThreshold;
    private final long _retryDelay;
    private final Map<String, TaskConfig> _taskConfigMap;

    private JobConfig(String workflow, String targetResource, List<String> targetPartitions, Set<String> targetPartitionStates, String command, Map<String, String> jobCommandConfigMap, long timeoutPerTask, int numConcurrentTasksPerInstance, int maxAttemptsPerTask, int maxForcedReassignmentsPerTask, int failureThreshold, long retryDelay, Map<String, TaskConfig> taskConfigMap) {
        this._workflow = workflow;
        this._targetResource = targetResource;
        this._targetPartitions = targetPartitions;
        this._targetPartitionStates = targetPartitionStates;
        this._command = command;
        this._jobCommandConfigMap = jobCommandConfigMap;
        this._timeoutPerTask = timeoutPerTask;
        this._numConcurrentTasksPerInstance = numConcurrentTasksPerInstance;
        this._maxAttemptsPerTask = maxAttemptsPerTask;
        this._maxForcedReassignmentsPerTask = maxForcedReassignmentsPerTask;
        this._failureThreshold = failureThreshold;
        this._retryDelay = retryDelay;
        this._taskConfigMap = taskConfigMap != null ? taskConfigMap : Collections.emptyMap();
    }

    public String getWorkflow() {
        return this._workflow == null ? "UNSPECIFIED" : this._workflow;
    }

    public String getTargetResource() {
        return this._targetResource;
    }

    public List<String> getTargetPartitions() {
        return this._targetPartitions;
    }

    public Set<String> getTargetPartitionStates() {
        return this._targetPartitionStates;
    }

    public String getCommand() {
        return this._command;
    }

    public Map<String, String> getJobCommandConfigMap() {
        return this._jobCommandConfigMap;
    }

    public long getTimeoutPerTask() {
        return this._timeoutPerTask;
    }

    public int getNumConcurrentTasksPerInstance() {
        return this._numConcurrentTasksPerInstance;
    }

    public int getMaxAttemptsPerTask() {
        return this._maxAttemptsPerTask;
    }

    public int getMaxForcedReassignmentsPerTask() {
        return this._maxForcedReassignmentsPerTask;
    }

    public int getFailureThreshold() {
        return this._failureThreshold;
    }

    public long getTaskRetryDelay() {
        return this._retryDelay;
    }

    public Map<String, TaskConfig> getTaskConfigMap() {
        return this._taskConfigMap;
    }

    public TaskConfig getTaskConfig(String id) {
        return this._taskConfigMap.get(id);
    }

    public Map<String, String> getResourceConfigMap() {
        String serializedConfig;
        HashMap<String, String> cfgMap = new HashMap<String, String>();
        cfgMap.put(WORKFLOW_ID, this._workflow);
        if (this._command != null) {
            cfgMap.put(COMMAND, this._command);
        }
        if (this._jobCommandConfigMap != null && (serializedConfig = TaskUtil.serializeJobCommandConfigMap(this._jobCommandConfigMap)) != null) {
            cfgMap.put(JOB_COMMAND_CONFIG_MAP, serializedConfig);
        }
        if (this._targetResource != null) {
            cfgMap.put(TARGET_RESOURCE, this._targetResource);
        }
        if (this._targetPartitionStates != null) {
            cfgMap.put(TARGET_PARTITION_STATES, Joiner.on((String)",").join(this._targetPartitionStates));
        }
        if (this._targetPartitions != null) {
            cfgMap.put(TARGET_PARTITIONS, Joiner.on((String)",").join(this._targetPartitions));
        }
        if (this._retryDelay > 0L) {
            cfgMap.put(TASK_RETRY_DELAY, "" + this._retryDelay);
        }
        cfgMap.put(TIMEOUT_PER_TASK, "" + this._timeoutPerTask);
        cfgMap.put(MAX_ATTEMPTS_PER_TASK, "" + this._maxAttemptsPerTask);
        cfgMap.put(MAX_FORCED_REASSIGNMENTS_PER_TASK, "" + this._maxForcedReassignmentsPerTask);
        cfgMap.put(FAILURE_THRESHOLD, "" + this._failureThreshold);
        return cfgMap;
    }

    public static class Builder {
        private String _workflow;
        private String _targetResource;
        private List<String> _targetPartitions;
        private Set<String> _targetPartitionStates;
        private String _command;
        private Map<String, String> _commandConfig;
        private Map<String, TaskConfig> _taskConfigMap = Maps.newHashMap();
        private long _timeoutPerTask = 3600000L;
        private int _numConcurrentTasksPerInstance = 1;
        private int _maxAttemptsPerTask = 10;
        private int _maxForcedReassignmentsPerTask = 0;
        private int _failureThreshold = 0;
        private long _retryDelay = -1L;

        public JobConfig build() {
            this.validate();
            return new JobConfig(this._workflow, this._targetResource, this._targetPartitions, this._targetPartitionStates, this._command, this._commandConfig, this._timeoutPerTask, this._numConcurrentTasksPerInstance, this._maxAttemptsPerTask, this._maxForcedReassignmentsPerTask, this._failureThreshold, this._retryDelay, this._taskConfigMap);
        }

        public static Builder fromMap(Map<String, String> cfg) {
            Builder b = new Builder();
            if (cfg.containsKey(JobConfig.WORKFLOW_ID)) {
                b.setWorkflow(cfg.get(JobConfig.WORKFLOW_ID));
            }
            if (cfg.containsKey(JobConfig.TARGET_RESOURCE)) {
                b.setTargetResource(cfg.get(JobConfig.TARGET_RESOURCE));
            }
            if (cfg.containsKey(JobConfig.TARGET_PARTITIONS)) {
                b.setTargetPartitions(Builder.csvToStringList(cfg.get(JobConfig.TARGET_PARTITIONS)));
            }
            if (cfg.containsKey(JobConfig.TARGET_PARTITION_STATES)) {
                b.setTargetPartitionStates(new HashSet<String>(Arrays.asList(cfg.get(JobConfig.TARGET_PARTITION_STATES).split(","))));
            }
            if (cfg.containsKey(JobConfig.COMMAND)) {
                b.setCommand(cfg.get(JobConfig.COMMAND));
            }
            if (cfg.containsKey(JobConfig.JOB_COMMAND_CONFIG_MAP)) {
                Map<String, String> commandConfigMap = TaskUtil.deserializeJobCommandConfigMap(cfg.get(JobConfig.JOB_COMMAND_CONFIG_MAP));
                b.setJobCommandConfigMap(commandConfigMap);
            }
            if (cfg.containsKey(JobConfig.TIMEOUT_PER_TASK)) {
                b.setTimeoutPerTask(Long.parseLong(cfg.get(JobConfig.TIMEOUT_PER_TASK)));
            }
            if (cfg.containsKey(JobConfig.NUM_CONCURRENT_TASKS_PER_INSTANCE)) {
                b.setNumConcurrentTasksPerInstance(Integer.parseInt(cfg.get(JobConfig.NUM_CONCURRENT_TASKS_PER_INSTANCE)));
            }
            if (cfg.containsKey(JobConfig.MAX_ATTEMPTS_PER_TASK)) {
                b.setMaxAttemptsPerTask(Integer.parseInt(cfg.get(JobConfig.MAX_ATTEMPTS_PER_TASK)));
            }
            if (cfg.containsKey(JobConfig.MAX_FORCED_REASSIGNMENTS_PER_TASK)) {
                b.setMaxForcedReassignmentsPerTask(Integer.parseInt(cfg.get(JobConfig.MAX_FORCED_REASSIGNMENTS_PER_TASK)));
            }
            if (cfg.containsKey(JobConfig.FAILURE_THRESHOLD)) {
                b.setFailureThreshold(Integer.parseInt(cfg.get(JobConfig.FAILURE_THRESHOLD)));
            }
            if (cfg.containsKey(JobConfig.TASK_RETRY_DELAY)) {
                b.setTaskRetryDelay(Long.parseLong(cfg.get(JobConfig.TASK_RETRY_DELAY)));
            }
            return b;
        }

        public Builder setWorkflow(String v) {
            this._workflow = v;
            return this;
        }

        public Builder setTargetResource(String v) {
            this._targetResource = v;
            return this;
        }

        public Builder setTargetPartitions(List<String> v) {
            this._targetPartitions = ImmutableList.copyOf(v);
            return this;
        }

        public Builder setTargetPartitionStates(Set<String> v) {
            this._targetPartitionStates = ImmutableSet.copyOf(v);
            return this;
        }

        public Builder setCommand(String v) {
            this._command = v;
            return this;
        }

        public Builder setJobCommandConfigMap(Map<String, String> v) {
            this._commandConfig = v;
            return this;
        }

        public Builder setTimeoutPerTask(long v) {
            this._timeoutPerTask = v;
            return this;
        }

        public Builder setNumConcurrentTasksPerInstance(int v) {
            this._numConcurrentTasksPerInstance = v;
            return this;
        }

        public Builder setMaxAttemptsPerTask(int v) {
            this._maxAttemptsPerTask = v;
            return this;
        }

        public Builder setMaxForcedReassignmentsPerTask(int v) {
            this._maxForcedReassignmentsPerTask = v;
            return this;
        }

        public Builder setFailureThreshold(int v) {
            this._failureThreshold = v;
            return this;
        }

        public Builder setTaskRetryDelay(long v) {
            this._retryDelay = v;
            return this;
        }

        public Builder addTaskConfigs(List<TaskConfig> taskConfigs) {
            if (taskConfigs != null) {
                for (TaskConfig taskConfig : taskConfigs) {
                    this._taskConfigMap.put(taskConfig.getId(), taskConfig);
                }
            }
            return this;
        }

        public Builder addTaskConfigMap(Map<String, TaskConfig> taskConfigMap) {
            this._taskConfigMap.putAll(taskConfigMap);
            return this;
        }

        private void validate() {
            if (this._taskConfigMap.isEmpty() && this._targetResource == null) {
                throw new IllegalArgumentException(String.format("%s cannot be null", JobConfig.TARGET_RESOURCE));
            }
            if (this._taskConfigMap.isEmpty() && this._targetPartitionStates != null && this._targetPartitionStates.isEmpty()) {
                throw new IllegalArgumentException(String.format("%s cannot be an empty set", JobConfig.TARGET_PARTITION_STATES));
            }
            if (this._taskConfigMap.isEmpty() && this._command == null) {
                throw new IllegalArgumentException(String.format("%s cannot be null", JobConfig.COMMAND));
            }
            if (this._timeoutPerTask < 0L) {
                throw new IllegalArgumentException(String.format("%s has invalid value %s", JobConfig.TIMEOUT_PER_TASK, this._timeoutPerTask));
            }
            if (this._numConcurrentTasksPerInstance < 1) {
                throw new IllegalArgumentException(String.format("%s has invalid value %s", JobConfig.NUM_CONCURRENT_TASKS_PER_INSTANCE, this._numConcurrentTasksPerInstance));
            }
            if (this._maxAttemptsPerTask < 1) {
                throw new IllegalArgumentException(String.format("%s has invalid value %s", JobConfig.MAX_ATTEMPTS_PER_TASK, this._maxAttemptsPerTask));
            }
            if (this._maxForcedReassignmentsPerTask < 0) {
                throw new IllegalArgumentException(String.format("%s has invalid value %s", JobConfig.MAX_FORCED_REASSIGNMENTS_PER_TASK, this._maxForcedReassignmentsPerTask));
            }
            if (this._failureThreshold < 0) {
                throw new IllegalArgumentException(String.format("%s has invalid value %s", JobConfig.FAILURE_THRESHOLD, this._failureThreshold));
            }
            if (this._workflow == null) {
                throw new IllegalArgumentException(String.format("%s cannot be null", JobConfig.WORKFLOW_ID));
            }
        }

        private static List<String> csvToStringList(String csv) {
            String[] vals = csv.split(",");
            return Arrays.asList(vals);
        }
    }
}

