/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;

public class SecureCmdDoAs {
    private final Path tokenPath;

    public SecureCmdDoAs(HiveConf conf) throws HiveException, IOException {
        String uname = UserGroupInformation.getLoginUser().getShortUserName();
        FileSystem fs = FileSystem.get((Configuration)conf);
        Token fsToken = fs.getDelegationToken(uname);
        File t = File.createTempFile("hive_hadoop_delegation_token", null);
        this.tokenPath = new Path(t.toURI());
        Credentials cred = new Credentials();
        cred.addToken(fsToken.getService(), fsToken);
        cred.writeTokenStorageFile(this.tokenPath, (Configuration)conf);
    }

    public void addEnv(Map<String, String> env) {
        env.put("HADOOP_TOKEN_FILE_LOCATION", this.tokenPath.toUri().getPath());
    }
}

