/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.DecimalColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public abstract class FuncDecimalToTimestamp
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    int inputColumn;
    int outputColumn;

    public FuncDecimalToTimestamp(int inputColumn, int outputColumn) {
        this.inputColumn = inputColumn;
        this.outputColumn = outputColumn;
    }

    public FuncDecimalToTimestamp() {
    }

    protected abstract void func(TimestampColumnVector var1, DecimalColumnVector var2, int var3);

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        DecimalColumnVector inV = (DecimalColumnVector)batch.cols[this.inputColumn];
        int[] sel = batch.selected;
        int n = batch.size;
        TimestampColumnVector outV = (TimestampColumnVector)batch.cols[this.outputColumn];
        if (n == 0) {
            return;
        }
        if (inV.noNulls) {
            outV.noNulls = true;
            if (inV.isRepeating) {
                outV.isRepeating = true;
                this.func(outV, inV, 0);
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    this.func(outV, inV, i);
                }
                outV.isRepeating = false;
            } else {
                for (int i = 0; i != n; ++i) {
                    this.func(outV, inV, i);
                }
                outV.isRepeating = false;
            }
        } else {
            outV.noNulls = false;
            if (inV.isRepeating) {
                outV.isRepeating = true;
                outV.isNull[0] = inV.isNull[0];
                if (!inV.isNull[0]) {
                    this.func(outV, inV, 0);
                }
            } else if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i = sel[j];
                    outV.isNull[i] = inV.isNull[i];
                    if (inV.isNull[i]) continue;
                    this.func(outV, inV, i);
                }
                outV.isRepeating = false;
            } else {
                System.arraycopy(inV.isNull, 0, outV.isNull, 0, n);
                for (int i = 0; i != n; ++i) {
                    if (inV.isNull[i]) continue;
                    this.func(outV, inV, i);
                }
                outV.isRepeating = false;
            }
        }
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "timestamp";
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(1).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.DECIMAL).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN);
        return b.build();
    }
}

