/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import java.sql.Timestamp;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.TimestampColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;

public abstract class IfExprTimestampColumnScalarBase
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int arg1Column;
    private int arg2Column;
    private Timestamp arg3Scalar;
    private int outputColumn;

    public IfExprTimestampColumnScalarBase(int arg1Column, int arg2Column, Timestamp arg3Scalar, int outputColumn) {
        this.arg1Column = arg1Column;
        this.arg2Column = arg2Column;
        this.arg3Scalar = arg3Scalar;
        this.outputColumn = outputColumn;
    }

    public IfExprTimestampColumnScalarBase() {
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) {
        if (this.childExpressions != null) {
            super.evaluateChildren(batch);
        }
        LongColumnVector arg1ColVector = (LongColumnVector)batch.cols[this.arg1Column];
        TimestampColumnVector arg2ColVector = (TimestampColumnVector)batch.cols[this.arg2Column];
        TimestampColumnVector outputColVector = (TimestampColumnVector)batch.cols[this.outputColumn];
        int[] sel = batch.selected;
        boolean[] outputIsNull = outputColVector.isNull;
        outputColVector.noNulls = arg2ColVector.noNulls;
        outputColVector.isRepeating = false;
        int n = batch.size;
        long[] vector1 = arg1ColVector.vector;
        if (n == 0) {
            return;
        }
        if (arg1ColVector.isRepeating) {
            if (vector1[0] == 1L) {
                arg2ColVector.copySelected(batch.selectedInUse, sel, n, outputColVector);
            } else {
                outputColVector.fill(this.arg3Scalar);
            }
            return;
        }
        arg2ColVector.flatten(batch.selectedInUse, sel, n);
        if (arg1ColVector.noNulls) {
            if (batch.selectedInUse) {
                for (int j = 0; j != n; ++j) {
                    int i;
                    outputColVector.set(i, vector1[i = sel[j]] == 1L ? arg2ColVector.asScratchTimestamp(i) : this.arg3Scalar);
                }
            } else {
                for (int i = 0; i != n; ++i) {
                    outputColVector.set(i, vector1[i] == 1L ? arg2ColVector.asScratchTimestamp(i) : this.arg3Scalar);
                }
            }
        } else if (batch.selectedInUse) {
            for (int j = 0; j != n; ++j) {
                int i;
                outputColVector.set(i, !arg1ColVector.isNull[i = sel[j]] && vector1[i] == 1L ? arg2ColVector.asScratchTimestamp(i) : this.arg3Scalar);
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : false;
            }
        } else {
            for (int i = 0; i != n; ++i) {
                outputColVector.set(i, !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.asScratchTimestamp(i) : this.arg3Scalar);
                outputIsNull[i] = !arg1ColVector.isNull[i] && vector1[i] == 1L ? arg2ColVector.isNull[i] : false;
            }
        }
        arg2ColVector.unFlatten();
    }

    @Override
    public int getOutputColumn() {
        return this.outputColumn;
    }

    @Override
    public String getOutputType() {
        return "timestamp";
    }
}

