/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.expressions.ISetLongArg;
import org.apache.hadoop.hive.ql.exec.vector.expressions.MathFuncDoubleToDouble;
import org.apache.hadoop.hive.ql.udf.generic.RoundUtils;
import org.apache.hadoop.io.IntWritable;

public class RoundWithNumDigitsDoubleToDouble
extends MathFuncDoubleToDouble
implements ISetLongArg {
    private static final long serialVersionUID = 1L;
    private IntWritable decimalPlaces;

    public RoundWithNumDigitsDoubleToDouble(int colNum, long scalarVal, int outputColumn) {
        super(colNum, outputColumn);
        this.decimalPlaces = new IntWritable();
        this.decimalPlaces.set((int)scalarVal);
    }

    public RoundWithNumDigitsDoubleToDouble() {
    }

    @Override
    public double func(double d) {
        return RoundUtils.round(d, this.decimalPlaces.get());
    }

    void setDecimalPlaces(IntWritable decimalPlaces) {
        this.decimalPlaces = decimalPlaces;
    }

    public IntWritable getDecimalPlaces() {
        return this.decimalPlaces;
    }

    @Override
    public void setArg(long l) {
        this.decimalPlaces.set((int)l);
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        VectorExpressionDescriptor.Builder b = new VectorExpressionDescriptor.Builder();
        b.setMode(VectorExpressionDescriptor.Mode.PROJECTION).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.FLOAT_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR);
        return b.build();
    }
}

