/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashTable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.BytesWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinFastStringCommon {
    public static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastStringCommon.class);
    private boolean isOuterJoin;
    private BinarySortableDeserializeRead keyBinarySortableDeserializeRead;

    public void adaptPutRow(VectorMapJoinFastBytesHashTable hashTable, BytesWritable currentKey, BytesWritable currentValue) throws HiveException, IOException {
        byte[] keyBytes = currentKey.getBytes();
        int keyLength = currentKey.getLength();
        this.keyBinarySortableDeserializeRead.set(keyBytes, 0, keyLength);
        try {
            if (this.keyBinarySortableDeserializeRead.readCheckNull()) {
                return;
            }
        }
        catch (Exception e) {
            throw new HiveException("\nDeserializeRead details: " + this.keyBinarySortableDeserializeRead.getDetailedReadPositionString() + "\nException: " + e.toString());
        }
        hashTable.add(this.keyBinarySortableDeserializeRead.currentBytes, this.keyBinarySortableDeserializeRead.currentBytesStart, this.keyBinarySortableDeserializeRead.currentBytesLength, currentValue);
    }

    public VectorMapJoinFastStringCommon(boolean isOuterJoin) {
        this.isOuterJoin = isOuterJoin;
        PrimitiveTypeInfo[] primitiveTypeInfos = new PrimitiveTypeInfo[]{TypeInfoFactory.stringTypeInfo};
        this.keyBinarySortableDeserializeRead = new BinarySortableDeserializeRead(primitiveTypeInfos);
    }
}

