/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.correlation;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.PTFOperator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessor;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.Rule;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.optimizer.correlation.AbstractCorrelationProcCtx;
import org.apache.hadoop.hive.ql.optimizer.correlation.CorrelationUtilities;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReduceSinkDeDuplication
extends Transform {
    protected static final Logger LOG = LoggerFactory.getLogger(ReduceSinkDeDuplication.class);
    private static final String RS = ReduceSinkOperator.getOperatorName();
    private static final String GBY = GroupByOperator.getOperatorName();
    private static final String JOIN = JoinOperator.getOperatorName();
    protected ParseContext pGraphContext;

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        this.pGraphContext = pctx;
        ReduceSinkDeduplicateProcCtx cppCtx = new ReduceSinkDeduplicateProcCtx(this.pGraphContext);
        boolean mergeJoins = !pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVECONVERTJOIN) && !pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASK) && !pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVE_CONVERT_JOIN_BUCKET_MAPJOIN_TEZ) && !pctx.getConf().getBoolVar(HiveConf.ConfVars.HIVEDYNAMICPARTITIONHASHJOIN);
        LinkedHashMap<Rule, NodeProcessor> opRules = new LinkedHashMap<Rule, NodeProcessor>();
        opRules.put(new RuleRegExp("R1", RS + "%.*%" + RS + "%"), ReduceSinkDeduplicateProcFactory.getReducerReducerProc());
        opRules.put(new RuleRegExp("R2", RS + "%" + GBY + "%.*%" + RS + "%"), ReduceSinkDeduplicateProcFactory.getGroupbyReducerProc());
        if (mergeJoins) {
            opRules.put(new RuleRegExp("R3", JOIN + "%.*%" + RS + "%"), ReduceSinkDeduplicateProcFactory.getJoinReducerProc());
        }
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(ReduceSinkDeduplicateProcFactory.getDefaultProc(), opRules, cppCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(this.pGraphContext.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return this.pGraphContext;
    }

    static class ReducerReducerProc
    extends AbsctractReducerReducerProc {
        ReducerReducerProc() {
        }

        @Override
        public Object process(ReduceSinkOperator cRS, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            ReduceSinkOperator pRS = CorrelationUtilities.findPossibleParent(cRS, ReduceSinkOperator.class, dedupCtx.trustScript());
            if (pRS != null) {
                if (this.aggressiveDedup(cRS, pRS, dedupCtx)) {
                    return true;
                }
                if (this.merge(cRS, pRS, dedupCtx.minReducer())) {
                    CorrelationUtilities.replaceReduceSinkWithSelectOperator(cRS, dedupCtx.getPctx(), dedupCtx);
                    ((ReduceSinkDesc)pRS.getConf()).setDeduplicated(true);
                    return true;
                }
            }
            return false;
        }

        @Override
        public Object process(ReduceSinkOperator cRS, GroupByOperator cGBY, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            Operator<?> start = CorrelationUtilities.getStartForGroupBy(cRS, dedupCtx);
            ReduceSinkOperator pRS = CorrelationUtilities.findPossibleParent(start, ReduceSinkOperator.class, dedupCtx.trustScript());
            if (pRS != null && this.merge(cRS, pRS, dedupCtx.minReducer())) {
                if (dedupCtx.getPctx().getConf().getBoolVar(HiveConf.ConfVars.HIVEGROUPBYSKEW)) {
                    return false;
                }
                CorrelationUtilities.removeReduceSinkForGroupBy(cRS, cGBY, dedupCtx.getPctx(), dedupCtx);
                ((ReduceSinkDesc)pRS.getConf()).setDeduplicated(true);
                return true;
            }
            return false;
        }
    }

    static class JoinReducerProc
    extends AbsctractReducerReducerProc {
        JoinReducerProc() {
        }

        @Override
        public Object process(ReduceSinkOperator cRS, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            JoinOperator pJoin = CorrelationUtilities.findPossibleParent(cRS, JoinOperator.class, dedupCtx.trustScript());
            if (pJoin != null && this.merge(cRS, pJoin, dedupCtx.minReducer())) {
                ((JoinDesc)pJoin.getConf()).setFixedAsSorted(true);
                CorrelationUtilities.replaceReduceSinkWithSelectOperator(cRS, dedupCtx.getPctx(), dedupCtx);
                ReduceSinkOperator pRS = CorrelationUtilities.findPossibleParent(pJoin, ReduceSinkOperator.class, dedupCtx.trustScript());
                if (pRS != null) {
                    ((ReduceSinkDesc)pRS.getConf()).setDeduplicated(true);
                }
                return true;
            }
            return false;
        }

        @Override
        public Object process(ReduceSinkOperator cRS, GroupByOperator cGBY, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            Operator<?> start = CorrelationUtilities.getStartForGroupBy(cRS, dedupCtx);
            JoinOperator pJoin = CorrelationUtilities.findPossibleParent(start, JoinOperator.class, dedupCtx.trustScript());
            if (pJoin != null && this.merge(cRS, pJoin, dedupCtx.minReducer())) {
                ((JoinDesc)pJoin.getConf()).setFixedAsSorted(true);
                CorrelationUtilities.removeReduceSinkForGroupBy(cRS, cGBY, dedupCtx.getPctx(), dedupCtx);
                ReduceSinkOperator pRS = CorrelationUtilities.findPossibleParent(pJoin, ReduceSinkOperator.class, dedupCtx.trustScript());
                if (pRS != null) {
                    ((ReduceSinkDesc)pRS.getConf()).setDeduplicated(true);
                }
                return true;
            }
            return false;
        }
    }

    static class GroupbyReducerProc
    extends AbsctractReducerReducerProc {
        GroupbyReducerProc() {
        }

        @Override
        public Object process(ReduceSinkOperator cRS, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            GroupByOperator pGBY = CorrelationUtilities.findPossibleParent(cRS, GroupByOperator.class, dedupCtx.trustScript());
            if (pGBY == null) {
                return false;
            }
            ReduceSinkOperator pRS = CorrelationUtilities.findPossibleParent(pGBY, ReduceSinkOperator.class, dedupCtx.trustScript());
            if (pRS != null && this.merge(cRS, pRS, dedupCtx.minReducer())) {
                CorrelationUtilities.replaceReduceSinkWithSelectOperator(cRS, dedupCtx.getPctx(), dedupCtx);
                ((ReduceSinkDesc)pRS.getConf()).setDeduplicated(true);
                return true;
            }
            return false;
        }

        @Override
        public Object process(ReduceSinkOperator cRS, GroupByOperator cGBY, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            Operator<?> start = CorrelationUtilities.getStartForGroupBy(cRS, dedupCtx);
            GroupByOperator pGBY = CorrelationUtilities.findPossibleParent(start, GroupByOperator.class, dedupCtx.trustScript());
            if (pGBY == null) {
                return false;
            }
            ReduceSinkOperator pRS = CorrelationUtilities.getSingleParent(pGBY, ReduceSinkOperator.class);
            if (pRS != null && this.merge(cRS, pRS, dedupCtx.minReducer())) {
                CorrelationUtilities.removeReduceSinkForGroupBy(cRS, cGBY, dedupCtx.getPctx(), dedupCtx);
                ((ReduceSinkDesc)pRS.getConf()).setDeduplicated(true);
                return true;
            }
            return false;
        }
    }

    public static abstract class AbsctractReducerReducerProc
    implements NodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ReduceSinkDeduplicateProcCtx dedupCtx = (ReduceSinkDeduplicateProcCtx)procCtx;
            if (dedupCtx.hasBeenRemoved((Operator)nd)) {
                return false;
            }
            ReduceSinkOperator cRS = (ReduceSinkOperator)nd;
            Operator<?> child = CorrelationUtilities.getSingleChild(cRS);
            if (child instanceof JoinOperator) {
                return false;
            }
            if (child instanceof GroupByOperator) {
                GroupByOperator cGBY = (GroupByOperator)child;
                if (!CorrelationUtilities.hasGroupingSet(cRS) && !((GroupByDesc)cGBY.getConf()).isGroupingSetsPresent()) {
                    return this.process(cRS, cGBY, dedupCtx);
                }
                return false;
            }
            if (child instanceof SelectOperator) {
                return this.process(cRS, dedupCtx);
            }
            return false;
        }

        protected abstract Object process(ReduceSinkOperator var1, ReduceSinkDeduplicateProcCtx var2) throws SemanticException;

        protected abstract Object process(ReduceSinkOperator var1, GroupByOperator var2, ReduceSinkDeduplicateProcCtx var3) throws SemanticException;

        /*
         * WARNING - void declaration
         */
        protected boolean merge(ReduceSinkOperator cRS, JoinOperator pJoin, int minReducer) throws SemanticException {
            void var10_14;
            List<Operator<OperatorDesc>> parents = pJoin.getParentOperators();
            Operator[] pRSs = parents.toArray(new ReduceSinkOperator[parents.size()]);
            ReduceSinkDesc cRSc = (ReduceSinkDesc)cRS.getConf();
            for (ReduceSinkOperator reduceSinkOperator : pRSs) {
                ReduceSinkDesc pRSNc = (ReduceSinkDesc)reduceSinkOperator.getConf();
                if (cRSc.getKeyCols().size() < pRSNc.getKeyCols().size()) {
                    return false;
                }
                if (cRSc.getPartitionCols().size() != pRSNc.getPartitionCols().size()) {
                    return false;
                }
                Integer moveReducerNumTo = this.checkNumReducer(cRSc.getNumReducers(), pRSNc.getNumReducers());
                if (moveReducerNumTo == null || moveReducerNumTo > 0 && cRSc.getNumReducers() < minReducer) {
                    return false;
                }
                Integer moveRSOrderTo = this.checkOrder(true, cRSc.getOrder(), pRSNc.getOrder(), cRSc.getNullOrder(), pRSNc.getNullOrder());
                if (moveRSOrderTo != null) continue;
                return false;
            }
            boolean[] sorted = CorrelationUtilities.getSortedTags(pJoin);
            int cKeySize = cRSc.getKeyCols().size();
            for (int i = 0; i < cKeySize; ++i) {
                ExprNodeDesc exprNodeDesc = cRSc.getKeyCols().get(i);
                ExprNodeDesc[] pexprs = new ExprNodeDesc[pRSs.length];
                for (int tag = 0; tag < pRSs.length; ++tag) {
                    pexprs[tag] = ((ReduceSinkDesc)pRSs[tag].getConf()).getKeyCols().get(i);
                }
                int found = CorrelationUtilities.indexOf(exprNodeDesc, pexprs, cRS, pRSs, sorted);
                if (found == i) continue;
                return false;
            }
            int cPartSize = cRSc.getPartitionCols().size();
            boolean bl = false;
            while (var10_14 < cPartSize) {
                ExprNodeDesc cexpr = cRSc.getPartitionCols().get((int)var10_14);
                ExprNodeDesc[] pexprs = new ExprNodeDesc[pRSs.length];
                for (int tag = 0; tag < pRSs.length; ++tag) {
                    pexprs[tag] = ((ReduceSinkDesc)pRSs[tag].getConf()).getPartitionCols().get((int)var10_14);
                }
                int found = CorrelationUtilities.indexOf(cexpr, pexprs, cRS, pRSs, sorted);
                if (found != var10_14) {
                    return false;
                }
                ++var10_14;
            }
            for (Operator pRS : pRSs) {
                ((ReduceSinkDesc)pRS.getConf()).setNumReducers(((ReduceSinkDesc)cRS.getConf()).getNumReducers());
            }
            return true;
        }

        protected boolean merge(ReduceSinkOperator cRS, ReduceSinkOperator pRS, int minReducer) throws SemanticException {
            ArrayList<ExprNodeDesc> parentPCs;
            int[] result = this.extractMergeDirections(cRS, pRS, minReducer);
            if (result == null) {
                return false;
            }
            if (result[0] > 0) {
                ArrayList<ExprNodeDesc> childKCs = ((ReduceSinkDesc)cRS.getConf()).getKeyCols();
                ((ReduceSinkDesc)pRS.getConf()).setKeyCols(ExprNodeDescUtils.backtrack(childKCs, cRS, pRS));
            }
            if (result[1] < 0) {
                ArrayList<ExprNodeDesc> childPCs = ((ReduceSinkDesc)cRS.getConf()).getPartitionCols();
                if (childPCs != null && !childPCs.isEmpty()) {
                    ((ReduceSinkDesc)pRS.getConf()).setPartitionCols(ExprNodeDescUtils.backtrack(childPCs, cRS, pRS));
                }
            } else if (result[1] > 0 && ((parentPCs = ((ReduceSinkDesc)pRS.getConf()).getPartitionCols()) == null || parentPCs.isEmpty())) {
                ArrayList<ExprNodeDesc> childPCs = ((ReduceSinkDesc)cRS.getConf()).getPartitionCols();
                ((ReduceSinkDesc)pRS.getConf()).setPartitionCols(ExprNodeDescUtils.backtrack(childPCs, cRS, pRS));
            }
            if (result[2] > 0) {
                if (result[0] <= 0) {
                    throw new SemanticException("Sorting columns and order don't match. Try set " + (Object)((Object)HiveConf.ConfVars.HIVEOPTREDUCEDEDUPLICATION) + "=false;");
                }
                ((ReduceSinkDesc)pRS.getConf()).setOrder(((ReduceSinkDesc)cRS.getConf()).getOrder());
                ((ReduceSinkDesc)pRS.getConf()).setNullOrder(((ReduceSinkDesc)cRS.getConf()).getNullOrder());
            } else {
                StringBuilder order = new StringBuilder(((ReduceSinkDesc)cRS.getConf()).getOrder());
                StringBuilder orderNull = new StringBuilder(((ReduceSinkDesc)cRS.getConf()).getNullOrder());
                order.append(((ReduceSinkDesc)pRS.getConf()).getOrder().substring(order.length()));
                orderNull.append(((ReduceSinkDesc)pRS.getConf()).getNullOrder().substring(orderNull.length()));
                ((ReduceSinkDesc)pRS.getConf()).setOrder(order.toString());
                ((ReduceSinkDesc)pRS.getConf()).setNullOrder(orderNull.toString());
            }
            if (result[3] > 0) {
                ((ReduceSinkDesc)pRS.getConf()).setNumReducers(((ReduceSinkDesc)cRS.getConf()).getNumReducers());
            }
            if (result[4] > 0 && ((ReduceSinkDesc)pRS.getConf()).getKeyCols() != null && ((ReduceSinkDesc)pRS.getConf()).getKeyCols().size() == 0 && ((ReduceSinkDesc)cRS.getConf()).getKeyCols() != null && ((ReduceSinkDesc)cRS.getConf()).getKeyCols().size() == 0) {
                TableDesc keyTable = PlanUtils.getReduceKeyTableDesc(new ArrayList<FieldSchema>(), ((ReduceSinkDesc)pRS.getConf()).getOrder(), ((ReduceSinkDesc)pRS.getConf()).getNullOrder());
                ((ReduceSinkDesc)pRS.getConf()).setKeySerializeInfo(keyTable);
            }
            return true;
        }

        private int[] extractMergeDirections(ReduceSinkOperator cRS, ReduceSinkOperator pRS, int minReducer) throws SemanticException {
            ArrayList<ExprNodeDesc> ppars;
            ArrayList<ExprNodeDesc> pkeys;
            ReduceSinkDesc cConf = (ReduceSinkDesc)cRS.getConf();
            ReduceSinkDesc pConf = (ReduceSinkDesc)pRS.getConf();
            boolean checkStrictEquality = this.isStrictEqualityNeeded(cRS, pRS);
            Integer moveRSOrderTo = this.checkOrder(checkStrictEquality, cConf.getOrder(), pConf.getOrder(), cConf.getNullOrder(), pConf.getNullOrder());
            if (moveRSOrderTo == null) {
                return null;
            }
            Integer moveReducerNumTo = this.checkNumReducer(cConf.getNumReducers(), pConf.getNumReducers());
            if (moveReducerNumTo == null || moveReducerNumTo > 0 && cConf.getNumReducers() < minReducer) {
                return null;
            }
            ArrayList<ExprNodeDesc> ckeys = cConf.getKeyCols();
            Integer moveKeyColTo = this.checkExprs(ckeys, pkeys = pConf.getKeyCols(), cRS, pRS);
            if (moveKeyColTo == null) {
                return null;
            }
            ArrayList<ExprNodeDesc> cpars = cConf.getPartitionCols();
            Integer movePartitionColTo = this.checkExprs(cpars, ppars = pConf.getPartitionCols(), cRS, pRS);
            if (movePartitionColTo == null) {
                return null;
            }
            Integer moveNumDistKeyTo = this.checkNumDistributionKey(cConf.getNumDistributionKeys(), pConf.getNumDistributionKeys());
            return new int[]{moveKeyColTo, movePartitionColTo, moveRSOrderTo, moveReducerNumTo, moveNumDistKeyTo};
        }

        private boolean isStrictEqualityNeeded(ReduceSinkOperator cRS, ReduceSinkOperator pRS) {
            Operator<OperatorDesc> parent = cRS.getParentOperators().get(0);
            while (parent != pRS) {
                assert (parent.getNumParent() == 1);
                if (parent instanceof PTFOperator) {
                    return true;
                }
                parent = parent.getParentOperators().get(0);
            }
            return false;
        }

        private Integer checkNumDistributionKey(int cnd, int pnd) {
            if (pnd <= 0) {
                return 1;
            }
            return 0;
        }

        private Integer checkExprs(List<ExprNodeDesc> ckeys, List<ExprNodeDesc> pkeys, ReduceSinkOperator cRS, ReduceSinkOperator pRS) throws SemanticException {
            for (ExprNodeDesc ck : ckeys) {
                if (!(ck instanceof ExprNodeConstantDesc)) continue;
                return null;
            }
            for (ExprNodeDesc pk : pkeys) {
                if (!(pk instanceof ExprNodeConstantDesc)) continue;
                return null;
            }
            Integer moveKeyColTo = 0;
            if (ckeys == null || ckeys.isEmpty()) {
                if (pkeys != null && !pkeys.isEmpty()) {
                    moveKeyColTo = -1;
                }
            } else if (pkeys == null || pkeys.isEmpty()) {
                for (ExprNodeDesc ckey : ckeys) {
                    if (ExprNodeDescUtils.backtrack(ckey, cRS, pRS) != null) continue;
                    return null;
                }
                moveKeyColTo = 1;
            } else {
                moveKeyColTo = this.sameKeys(ckeys, pkeys, cRS, pRS);
            }
            return moveKeyColTo;
        }

        protected Integer sameKeys(List<ExprNodeDesc> cexprs, List<ExprNodeDesc> pexprs, Operator<?> child, Operator<?> parent) throws SemanticException {
            int i;
            int common = Math.min(cexprs.size(), pexprs.size());
            int limit = Math.max(cexprs.size(), pexprs.size());
            for (i = 0; i < common; ++i) {
                ExprNodeDesc pexpr = pexprs.get(i);
                ExprNodeDesc cexpr = ExprNodeDescUtils.backtrack(cexprs.get(i), child, parent);
                if (cexpr != null && pexpr.isSame(cexpr)) continue;
                return null;
            }
            while (i < limit) {
                if (cexprs.size() > pexprs.size() && ExprNodeDescUtils.backtrack(cexprs.get(i), child, parent) == null) {
                    return null;
                }
                ++i;
            }
            return Integer.valueOf(cexprs.size()).compareTo(pexprs.size());
        }

        protected Integer checkOrder(boolean checkStrictEquality, String corder, String porder, String cNullOrder, String pNullOrder) {
            assert (corder.length() == cNullOrder.length());
            assert (porder.length() == pNullOrder.length());
            if (corder == null || corder.trim().equals("")) {
                if (porder == null || porder.trim().equals("")) {
                    return 0;
                }
                return -1;
            }
            if (porder == null || porder.trim().equals("")) {
                return 1;
            }
            corder = corder.trim();
            porder = porder.trim();
            if (checkStrictEquality) {
                cNullOrder = cNullOrder.trim();
                pNullOrder = pNullOrder.trim();
                int target = Math.min(corder.length(), porder.length());
                if (!corder.substring(0, target).equals(porder.substring(0, target)) || !cNullOrder.substring(0, target).equals(pNullOrder.substring(0, target))) {
                    return null;
                }
            }
            return Integer.valueOf(corder.length()).compareTo(porder.length());
        }

        protected Integer checkNumReducer(int creduce, int preduce) {
            if (creduce < 0) {
                if (preduce < 0) {
                    return 0;
                }
                return -1;
            }
            if (preduce < 0) {
                return 1;
            }
            if (creduce != preduce) {
                return null;
            }
            return 0;
        }

        /*
         * WARNING - void declaration
         */
        protected boolean aggressiveDedup(ReduceSinkOperator cRS, ReduceSinkOperator pRS, ReduceSinkDeduplicateProcCtx dedupCtx) throws SemanticException {
            assert (cRS.getNumParent() == 1);
            ReduceSinkDesc cConf = (ReduceSinkDesc)cRS.getConf();
            ReduceSinkDesc pConf = (ReduceSinkDesc)pRS.getConf();
            ArrayList<ExprNodeDesc> cKeys = cConf.getKeyCols();
            ArrayList<ExprNodeDesc> pKeys = pConf.getKeyCols();
            Operator<OperatorDesc> parent = cRS.getParentOperators().get(0);
            while (parent != pRS) {
                assert (parent.getNumParent() == 1);
                if (!(parent instanceof SelectOperator)) {
                    return false;
                }
                parent = parent.getParentOperators().get(0);
            }
            if (cKeys == null || cKeys.isEmpty()) {
                return false;
            }
            if (pKeys == null || pKeys.isEmpty()) {
                return false;
            }
            ArrayList<ExprNodeDesc> cKeysInParentRS = ExprNodeDescUtils.backtrack(cKeys, cRS, pRS);
            for (int i = 0; i < cKeysInParentRS.size(); ++i) {
                ExprNodeDesc pexpr = (ExprNodeDesc)cKeysInParentRS.get(i);
                if (pexpr != null) continue;
                return false;
            }
            ((ReduceSinkDesc)cRS.getConf()).setKeyCols(ExprNodeDescUtils.backtrack(cKeysInParentRS, cRS, pRS));
            ArrayList<ExprNodeDesc> cPartitionInParentRS = ExprNodeDescUtils.backtrack(cConf.getPartitionCols(), cRS, pRS);
            for (int i = 0; i < cPartitionInParentRS.size(); ++i) {
                ExprNodeDesc pexpr = (ExprNodeDesc)cPartitionInParentRS.get(i);
                if (pexpr != null) continue;
                return false;
            }
            ((ReduceSinkDesc)cRS.getConf()).setPartitionCols(ExprNodeDescUtils.backtrack(cPartitionInParentRS, cRS, pRS));
            ArrayList<ExprNodeDesc> cValueInParentRS = ExprNodeDescUtils.backtrack(cConf.getValueCols(), cRS, pRS);
            for (int i = 0; i < cValueInParentRS.size(); ++i) {
                ExprNodeDesc exprNodeDesc = (ExprNodeDesc)cValueInParentRS.get(i);
                if (exprNodeDesc != null) continue;
                return false;
            }
            ((ReduceSinkDesc)cRS.getConf()).setValueCols(ExprNodeDescUtils.backtrack(cValueInParentRS, cRS, pRS));
            if (cConf.getBucketCols() != null) {
                void var13_21;
                ArrayList<ExprNodeDesc> cBucketInParentRS = ExprNodeDescUtils.backtrack(cConf.getBucketCols(), cRS, pRS);
                boolean bl = false;
                while (var13_21 < cBucketInParentRS.size()) {
                    ExprNodeDesc pexpr = (ExprNodeDesc)cBucketInParentRS.get((int)var13_21);
                    if (pexpr == null) {
                        return false;
                    }
                    ++var13_21;
                }
                ((ReduceSinkDesc)cRS.getConf()).setBucketCols(ExprNodeDescUtils.backtrack(cBucketInParentRS, cRS, pRS));
            }
            for (Map.Entry<String, ExprNodeDesc> entry : cRS.getColumnExprMap().entrySet()) {
                entry.setValue(ExprNodeDescUtils.backtrack(entry.getValue(), cRS, pRS));
            }
            parent = cRS.getParentOperators().get(0);
            while (parent != pRS) {
                dedupCtx.addRemovedOperator(parent);
                parent = parent.getParentOperators().get(0);
            }
            dedupCtx.addRemovedOperator(pRS);
            cRS.getParentOperators().clear();
            for (Operator operator : pRS.getParentOperators()) {
                operator.replaceChild(pRS, cRS);
                cRS.getParentOperators().add(operator);
            }
            pRS.getParentOperators().clear();
            pRS.getChildOperators().clear();
            return true;
        }
    }

    static class DefaultProc
    implements NodeProcessor {
        DefaultProc() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            return null;
        }
    }

    static class ReduceSinkDeduplicateProcFactory {
        ReduceSinkDeduplicateProcFactory() {
        }

        public static NodeProcessor getReducerReducerProc() {
            return new ReducerReducerProc();
        }

        public static NodeProcessor getGroupbyReducerProc() {
            return new GroupbyReducerProc();
        }

        public static NodeProcessor getJoinReducerProc() {
            return new JoinReducerProc();
        }

        public static NodeProcessor getDefaultProc() {
            return new DefaultProc();
        }
    }

    protected class ReduceSinkDeduplicateProcCtx
    extends AbstractCorrelationProcCtx {
        public ReduceSinkDeduplicateProcCtx(ParseContext pctx) {
            super(pctx);
        }
    }
}

