/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestCloseableHttpClient {
    private NoopCloseableHttpClient client;
    private InputStream content;
    private HttpEntity entity;
    private CloseableHttpResponse response;

    @Before
    public void setup() throws Exception {
        this.content = (InputStream)Mockito.mock(InputStream.class);
        this.entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        this.response = (CloseableHttpResponse)Mockito.mock(CloseableHttpResponse.class);
        Mockito.when((Object)this.entity.getContent()).thenReturn((Object)this.content);
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.response.getEntity()).thenReturn((Object)this.entity);
        this.client = (NoopCloseableHttpClient)((Object)Mockito.mock(NoopCloseableHttpClient.class, (Answer)Mockito.CALLS_REAL_METHODS));
    }

    @Test
    public void testExecuteRequestAbsoluteURI() throws Exception {
        HttpGet httpget = new HttpGet("https://somehost:444/stuff");
        this.client.execute((HttpUriRequest)httpget);
        ((NoopCloseableHttpClient)((Object)Mockito.verify((Object)((Object)this.client)))).doExecute((HttpHost)Mockito.eq((Object)new HttpHost("somehost", 444, "https")), (HttpRequest)Mockito.same((Object)httpget), (HttpContext)Mockito.isNull());
    }

    @Test
    public void testExecuteRequestRelativeURI() throws Exception {
        HttpGet httpget = new HttpGet("/stuff");
        this.client.execute((HttpUriRequest)httpget);
        ((NoopCloseableHttpClient)((Object)Mockito.verify((Object)((Object)this.client)))).doExecute((HttpHost)Mockito.isNull(), (HttpRequest)Mockito.same((Object)httpget), (HttpContext)Mockito.isNull());
    }

    @Test
    public void testExecuteRequestInvalidHost() throws Exception {
        HttpGet httpget = new HttpGet("http://_/stuff");
        this.client.execute((HttpUriRequest)httpget);
        ((NoopCloseableHttpClient)((Object)Mockito.verify((Object)((Object)this.client)))).doExecute((HttpHost)Mockito.eq((Object)new HttpHost("_", -1, "http")), (HttpRequest)Mockito.same((Object)httpget), (HttpContext)Mockito.isNull());
    }

    @Test(expected=ClientProtocolException.class)
    public void testExecuteRequestInvalidHost2() throws Exception {
        HttpGet httpget = new HttpGet("http://@/stuff");
        this.client.execute((HttpUriRequest)httpget);
    }

    @Test
    public void testExecuteRequest() throws Exception {
        HttpGet httpget = new HttpGet("https://somehost:444/stuff");
        Mockito.when((Object)this.client.doExecute(new HttpHost("somehost", 444, "https"), (HttpRequest)httpget, null)).thenReturn((Object)this.response);
        CloseableHttpResponse result = this.client.execute((HttpUriRequest)httpget);
        Assert.assertSame((Object)this.response, (Object)result);
    }

    @Test
    public void testExecuteRequestHandleResponse() throws Exception {
        HttpGet httpget = new HttpGet("https://somehost:444/stuff");
        Mockito.when((Object)this.client.doExecute(new HttpHost("somehost", 444, "https"), (HttpRequest)httpget, null)).thenReturn((Object)this.response);
        ResponseHandler handler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        this.client.execute((HttpUriRequest)httpget, handler);
        ((NoopCloseableHttpClient)((Object)Mockito.verify((Object)((Object)this.client)))).doExecute((HttpHost)Mockito.eq((Object)new HttpHost("somehost", 444, "https")), (HttpRequest)Mockito.same((Object)httpget), (HttpContext)Mockito.isNull());
        ((ResponseHandler)Mockito.verify((Object)handler)).handleResponse((HttpResponse)this.response);
        ((InputStream)Mockito.verify((Object)this.content)).close();
    }

    @Test(expected=IOException.class)
    public void testExecuteRequestHandleResponseIOException() throws Exception {
        HttpGet httpget = new HttpGet("https://somehost:444/stuff");
        Mockito.when((Object)this.client.doExecute(new HttpHost("somehost", 444, "https"), (HttpRequest)httpget, null)).thenReturn((Object)this.response);
        ResponseHandler handler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        Mockito.when((Object)handler.handleResponse((HttpResponse)this.response)).thenThrow(new Throwable[]{new IOException()});
        try {
            this.client.execute((HttpUriRequest)httpget, handler);
        }
        catch (IOException ex) {
            ((NoopCloseableHttpClient)((Object)Mockito.verify((Object)((Object)this.client)))).doExecute((HttpHost)Mockito.eq((Object)new HttpHost("somehost", 444, "https")), (HttpRequest)Mockito.same((Object)httpget), (HttpContext)Mockito.isNull());
            ((InputStream)Mockito.verify((Object)this.content)).close();
            throw ex;
        }
    }

    @Test(expected=RuntimeException.class)
    public void testExecuteRequestHandleResponseHttpException() throws Exception {
        HttpGet httpget = new HttpGet("https://somehost:444/stuff");
        Mockito.when((Object)this.client.doExecute(new HttpHost("somehost", 444, "https"), (HttpRequest)httpget, null)).thenReturn((Object)this.response);
        ResponseHandler handler = (ResponseHandler)Mockito.mock(ResponseHandler.class);
        Mockito.when((Object)handler.handleResponse((HttpResponse)this.response)).thenThrow(new Throwable[]{new RuntimeException()});
        try {
            this.client.execute((HttpUriRequest)httpget, handler);
        }
        catch (RuntimeException ex) {
            ((NoopCloseableHttpClient)((Object)Mockito.verify((Object)((Object)this.client)))).doExecute((HttpHost)Mockito.eq((Object)new HttpHost("somehost", 444, "https")), (HttpRequest)Mockito.same((Object)httpget), (HttpContext)Mockito.isNull());
            ((InputStream)Mockito.verify((Object)this.content)).close();
            throw ex;
        }
    }

    static abstract class NoopCloseableHttpClient
    extends CloseableHttpClient {
        NoopCloseableHttpClient() {
        }

        protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
            return null;
        }
    }
}

