/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpInetConnection;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CookieStore;
import org.apache.http.client.RedirectException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.integration.IntegrationTestBase;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestRedirects
extends IntegrationTestBase {
    @Before
    public void setUp() throws Exception {
        this.startServer();
        this.httpclient = HttpClients.createDefault();
    }

    @Test
    public void testBasicRedirect300() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new BasicRedirectService(300));
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("/oldlocation/");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        Assert.assertEquals((long)300L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/oldlocation/", (Object)reqWrapper.getRequestLine().getUri());
        List redirects = context.getRedirectLocations();
        Assert.assertNull((Object)redirects);
    }

    @Test
    public void testBasicRedirect301() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new BasicRedirectService(301));
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("/oldlocation/");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        HttpHost host = context.getTargetHost();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/newlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)target, (Object)host);
        List redirects = context.getRedirectLocations();
        Assert.assertNotNull((Object)redirects);
        Assert.assertEquals((long)1L, (long)redirects.size());
        URI redirect = URIUtils.rewriteURI((URI)new URI("/newlocation/"), (HttpHost)target);
        Assert.assertTrue((boolean)redirects.contains(redirect));
    }

    @Test
    public void testBasicRedirect302() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new BasicRedirectService(302));
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("/oldlocation/");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        HttpHost host = context.getTargetHost();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/newlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)target, (Object)host);
    }

    @Test
    public void testBasicRedirect302NoLocation() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                response.setStatusCode(302);
            }
        });
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("/oldlocation/");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        HttpHost host = context.getTargetHost();
        Assert.assertEquals((long)302L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/oldlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)target, (Object)host);
    }

    @Test
    public void testBasicRedirect303() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new BasicRedirectService(303));
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("/oldlocation/");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        HttpHost host = context.getTargetHost();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/newlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)target, (Object)host);
    }

    @Test
    public void testBasicRedirect304() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new BasicRedirectService(304));
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("/oldlocation/");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        Assert.assertEquals((long)304L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/oldlocation/", (Object)reqWrapper.getRequestLine().getUri());
    }

    @Test
    public void testBasicRedirect305() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new BasicRedirectService(305));
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("/oldlocation/");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        Assert.assertEquals((long)305L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/oldlocation/", (Object)reqWrapper.getRequestLine().getUri());
    }

    @Test
    public void testBasicRedirect307() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new BasicRedirectService(307));
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("/oldlocation/");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        HttpHost host = context.getTargetHost();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/newlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)target, (Object)host);
    }

    @Test(expected=ClientProtocolException.class)
    public void testMaxRedirectCheck() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new CircularRedirectService());
        RequestConfig config = RequestConfig.custom().setCircularRedirectsAllowed(true).setMaxRedirects(5).build();
        HttpGet httpget = new HttpGet("/circular-oldlocation/");
        httpget.setConfig(config);
        try {
            this.httpclient.execute(target, (HttpRequest)httpget);
        }
        catch (ClientProtocolException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof RedirectException));
            throw e;
        }
    }

    @Test(expected=ClientProtocolException.class)
    public void testCircularRedirect() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new CircularRedirectService());
        RequestConfig config = RequestConfig.custom().setCircularRedirectsAllowed(false).build();
        HttpGet httpget = new HttpGet("/circular-oldlocation/");
        httpget.setConfig(config);
        try {
            this.httpclient.execute(target, (HttpRequest)httpget);
        }
        catch (ClientProtocolException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof CircularRedirectException));
            throw e;
        }
    }

    @Test
    public void testRepeatRequest() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new RomeRedirectService());
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = RequestConfig.custom().setRelativeRedirectsAllowed(true).build();
        HttpGet first = new HttpGet("/rome");
        first.setConfig(config);
        EntityUtils.consume((HttpEntity)this.httpclient.execute(target, (HttpRequest)first, (HttpContext)context).getEntity());
        HttpGet second = new HttpGet("/rome");
        second.setConfig(config);
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)second, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        HttpHost host = context.getTargetHost();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/rome", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)host, (Object)target);
    }

    @Test
    public void testRepeatRequestRedirect() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new RomeRedirectService());
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = RequestConfig.custom().setRelativeRedirectsAllowed(true).build();
        HttpGet first = new HttpGet("/lille");
        first.setConfig(config);
        CloseableHttpResponse response1 = this.httpclient.execute(target, (HttpRequest)first, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response1.getEntity());
        HttpGet second = new HttpGet("/lille");
        second.setConfig(config);
        CloseableHttpResponse response2 = this.httpclient.execute(target, (HttpRequest)second, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response2.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        HttpHost host = context.getTargetHost();
        Assert.assertEquals((long)200L, (long)response2.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/rome", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)host, (Object)target);
    }

    @Test
    public void testDifferentRequestSameRedirect() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new RomeRedirectService());
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = RequestConfig.custom().setRelativeRedirectsAllowed(true).build();
        HttpGet first = new HttpGet("/alian");
        first.setConfig(config);
        CloseableHttpResponse response1 = this.httpclient.execute(target, (HttpRequest)first, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response1.getEntity());
        HttpGet second = new HttpGet("/lille");
        second.setConfig(config);
        CloseableHttpResponse response2 = this.httpclient.execute(target, (HttpRequest)second, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response2.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        HttpHost host = context.getTargetHost();
        Assert.assertEquals((long)200L, (long)response2.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/rome", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)host, (Object)target);
    }

    @Test
    public void testPostNoRedirect() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new BasicRedirectService());
        HttpClientContext context = HttpClientContext.create();
        HttpPost httppost = new HttpPost("/oldlocation/");
        httppost.setEntity((HttpEntity)new StringEntity("stuff"));
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httppost, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        Assert.assertEquals((long)302L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/oldlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)"POST", (Object)reqWrapper.getRequestLine().getMethod());
    }

    @Test
    public void testPostRedirectSeeOther() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new BasicRedirectService(303));
        HttpClientContext context = HttpClientContext.create();
        HttpPost httppost = new HttpPost("/oldlocation/");
        httppost.setEntity((HttpEntity)new StringEntity("stuff"));
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httppost, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/newlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)"GET", (Object)reqWrapper.getRequestLine().getMethod());
    }

    @Test
    public void testRelativeRedirect() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new RelativeRedirectService());
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = RequestConfig.custom().setRelativeRedirectsAllowed(true).build();
        HttpGet httpget = new HttpGet("/oldlocation/");
        httpget.setConfig(config);
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        HttpHost host = context.getTargetHost();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/relativelocation/", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)host, (Object)target);
    }

    @Test
    public void testRelativeRedirect2() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new RelativeRedirectService2());
        HttpClientContext context = HttpClientContext.create();
        RequestConfig config = RequestConfig.custom().setRelativeRedirectsAllowed(true).build();
        HttpGet httpget = new HttpGet("/test/oldlocation");
        httpget.setConfig(config);
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        HttpHost host = context.getTargetHost();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/test/relativelocation", (Object)reqWrapper.getRequestLine().getUri());
        Assert.assertEquals((Object)host, (Object)target);
    }

    @Test(expected=ClientProtocolException.class)
    public void testRejectRelativeRedirect() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new RelativeRedirectService());
        RequestConfig config = RequestConfig.custom().setRelativeRedirectsAllowed(false).build();
        HttpGet httpget = new HttpGet("/oldlocation/");
        httpget.setConfig(config);
        try {
            this.httpclient.execute(target, (HttpRequest)httpget);
        }
        catch (ClientProtocolException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ProtocolException));
            throw e;
        }
    }

    @Test(expected=ClientProtocolException.class)
    public void testRejectBogusRedirectLocation() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new BogusRedirectService("xxx://bogus"));
        HttpGet httpget = new HttpGet("/oldlocation/");
        try {
            this.httpclient.execute(target, (HttpRequest)httpget);
        }
        catch (ClientProtocolException ex) {
            Throwable cause = ex.getCause();
            Assert.assertTrue((boolean)(cause instanceof HttpException));
            throw ex;
        }
    }

    @Test(expected=ClientProtocolException.class)
    public void testRejectInvalidRedirectLocation() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new BogusRedirectService("http://" + target.toHostString() + "/newlocation/?p=I have spaces"));
        HttpGet httpget = new HttpGet("/oldlocation/");
        try {
            this.httpclient.execute(target, (HttpRequest)httpget);
        }
        catch (ClientProtocolException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof ProtocolException));
            throw e;
        }
    }

    @Test
    public void testRedirectWithCookie() throws Exception {
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new BasicRedirectService());
        BasicCookieStore cookieStore = new BasicCookieStore();
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain(target.getHostName());
        cookie.setPath("/");
        cookieStore.addCookie((Cookie)cookie);
        HttpClientContext context = HttpClientContext.create();
        context.setCookieStore((CookieStore)cookieStore);
        HttpGet httpget = new HttpGet("/oldlocation/");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/newlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Header[] headers = reqWrapper.getHeaders("Cookie");
        Assert.assertEquals((String)"There can only be one (cookie)", (long)1L, (long)headers.length);
    }

    @Test
    public void testDefaultHeadersRedirect() throws Exception {
        this.httpclient = HttpClients.custom().setDefaultHeaders(Arrays.asList(new BasicHeader("User-Agent", "my-test-client"))).build();
        HttpHost target = this.getServerHttp();
        this.localServer.register("*", new BasicRedirectService());
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("/oldlocation/");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        EntityUtils.consume((HttpEntity)response.getEntity());
        HttpRequest reqWrapper = context.getRequest();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertEquals((Object)"/newlocation/", (Object)reqWrapper.getRequestLine().getUri());
        Header header = reqWrapper.getFirstHeader("User-Agent");
        Assert.assertEquals((Object)"my-test-client", (Object)header.getValue());
    }

    private static class BogusRedirectService
    implements HttpRequestHandler {
        private final String url;

        public BogusRedirectService(String redirectUrl) {
            this.url = redirectUrl;
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String uri = request.getRequestLine().getUri();
            if (uri.equals("/oldlocation/")) {
                response.setStatusCode(302);
                response.addHeader((Header)new BasicHeader("Location", this.url));
            } else if (uri.equals("/relativelocation/")) {
                response.setStatusCode(200);
                StringEntity entity = new StringEntity("Successful redirect");
                response.setEntity((HttpEntity)entity);
            } else {
                response.setStatusCode(404);
            }
        }
    }

    private static class RomeRedirectService
    implements HttpRequestHandler {
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String uri = request.getRequestLine().getUri();
            if (uri.equals("/rome")) {
                response.setStatusCode(200);
                StringEntity entity = new StringEntity("Successful redirect");
                response.setEntity((HttpEntity)entity);
            } else {
                response.setStatusCode(302);
                response.addHeader((Header)new BasicHeader("Location", "/rome"));
            }
        }
    }

    private static class RelativeRedirectService2
    implements HttpRequestHandler {
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String uri = request.getRequestLine().getUri();
            if (uri.equals("/test/oldlocation")) {
                response.setStatusCode(302);
                response.addHeader((Header)new BasicHeader("Location", "relativelocation"));
            } else if (uri.equals("/test/relativelocation")) {
                response.setStatusCode(200);
                StringEntity entity = new StringEntity("Successful redirect");
                response.setEntity((HttpEntity)entity);
            } else {
                response.setStatusCode(404);
            }
        }
    }

    private static class RelativeRedirectService
    implements HttpRequestHandler {
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String uri = request.getRequestLine().getUri();
            if (uri.equals("/oldlocation/")) {
                response.setStatusCode(302);
                response.addHeader((Header)new BasicHeader("Location", "/relativelocation/"));
            } else if (uri.equals("/relativelocation/")) {
                response.setStatusCode(200);
                StringEntity entity = new StringEntity("Successful redirect");
                response.setEntity((HttpEntity)entity);
            } else {
                response.setStatusCode(404);
            }
        }
    }

    private static class CircularRedirectService
    implements HttpRequestHandler {
        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String uri = request.getRequestLine().getUri();
            if (uri.startsWith("/circular-oldlocation")) {
                response.setStatusCode(302);
                response.addHeader((Header)new BasicHeader("Location", "/circular-location2"));
            } else if (uri.startsWith("/circular-location2")) {
                response.setStatusCode(302);
                response.addHeader((Header)new BasicHeader("Location", "/circular-oldlocation"));
            } else {
                response.setStatusCode(404);
            }
        }
    }

    private static class BasicRedirectService
    implements HttpRequestHandler {
        private final int statuscode;

        public BasicRedirectService(int statuscode) {
            this.statuscode = statuscode > 0 ? statuscode : 302;
        }

        public BasicRedirectService() {
            this(-1);
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            HttpInetConnection conn = (HttpInetConnection)context.getAttribute("http.connection");
            String localhost = conn.getLocalAddress().getHostName();
            int port = conn.getLocalPort();
            String uri = request.getRequestLine().getUri();
            if (uri.equals("/oldlocation/")) {
                response.setStatusCode(this.statuscode);
                response.addHeader((Header)new BasicHeader("Location", "http://" + localhost + ":" + port + "/newlocation/"));
                response.addHeader((Header)new BasicHeader("Connection", "close"));
            } else if (uri.equals("/newlocation/")) {
                response.setStatusCode(200);
                StringEntity entity = new StringEntity("Successful redirect");
                response.setEntity((HttpEntity)entity);
            } else {
                response.setStatusCode(404);
            }
        }
    }
}

