/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.Header;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.entity.AbstractImmutableHttpEntity;
import org.apache.http.impl.io.EmptyInputStream;

@NotThreadSafe
public class IncomingHttpEntity
extends AbstractImmutableHttpEntity {
    private final InputStream content;
    private final long len;
    private final boolean chunked;
    private final Header contentType;
    private final Header contentEncoding;

    public IncomingHttpEntity(InputStream content, long len, boolean chunked, Header contentType, Header contentEncoding) {
        this.content = content;
        this.len = len;
        this.chunked = chunked;
        this.contentType = contentType;
        this.contentEncoding = contentEncoding;
    }

    @Override
    public boolean isRepeatable() {
        return false;
    }

    @Override
    public boolean isChunked() {
        return this.chunked;
    }

    @Override
    public long getContentLength() {
        return this.len;
    }

    @Override
    public String getContentType() {
        return this.contentType != null ? this.contentType.getValue() : null;
    }

    @Override
    public String getContentEncoding() {
        return this.contentEncoding != null ? this.contentEncoding.getValue() : null;
    }

    @Override
    public InputStream getContent() throws IOException, IllegalStateException {
        return this.content;
    }

    @Override
    public boolean isStreaming() {
        return this.content != null && this.content != EmptyInputStream.INSTANCE;
    }
}

