/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.MessageConstraintException;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.config.MessageConstraints;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.LazyLineParser;
import org.apache.http.message.LineParser;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public abstract class AbstractMessageParser<T extends HttpMessage>
implements HttpMessageParser<T> {
    private static final int HEAD_LINE = 0;
    private static final int HEADERS = 1;
    private final MessageConstraints messageConstraints;
    private final List<CharArrayBuffer> headerLines;
    private final CharArrayBuffer headLine;
    private final LineParser lineParser;
    private int state;
    private T message;

    public AbstractMessageParser(LineParser lineParser, MessageConstraints constraints) {
        this.lineParser = lineParser != null ? lineParser : LazyLineParser.INSTANCE;
        this.messageConstraints = constraints != null ? constraints : MessageConstraints.DEFAULT;
        this.headerLines = new ArrayList<CharArrayBuffer>();
        this.headLine = new CharArrayBuffer(128);
        this.state = 0;
    }

    LineParser getLineParser() {
        return this.lineParser;
    }

    public static Header[] parseHeaders(SessionInputBuffer inbuffer, int maxHeaderCount, int maxLineLen, LineParser lineParser) throws HttpException, IOException {
        ArrayList<CharArrayBuffer> headerLines = new ArrayList<CharArrayBuffer>();
        return AbstractMessageParser.parseHeaders(inbuffer, maxHeaderCount, maxLineLen, lineParser != null ? lineParser : LazyLineParser.INSTANCE, headerLines);
    }

    public static Header[] parseHeaders(SessionInputBuffer inbuffer, int maxHeaderCount, int maxLineLen, LineParser parser, List<CharArrayBuffer> headerLines) throws HttpException, IOException {
        int i;
        block7: {
            Args.notNull(inbuffer, "Session input buffer");
            Args.notNull(parser, "Line parser");
            Args.notNull(headerLines, "Header line list");
            CharArrayBuffer current = null;
            CharArrayBuffer previous = null;
            do {
                if (current == null) {
                    current = new CharArrayBuffer(64);
                } else {
                    current.clear();
                }
                int l = inbuffer.readLine(current);
                if (l == -1 || current.length() < 1) break block7;
                if ((current.charAt(0) == ' ' || current.charAt(0) == '\t') && previous != null) {
                    char ch;
                    for (i = 0; i < current.length() && ((ch = current.charAt(i)) == ' ' || ch == '\t'); ++i) {
                    }
                    if (maxLineLen > 0 && previous.length() + 1 + current.length() - i > maxLineLen) {
                        throw new MessageConstraintException("Maximum line length limit exceeded");
                    }
                    previous.append(' ');
                    previous.append(current, i, current.length() - i);
                    continue;
                }
                headerLines.add(current);
                previous = current;
                current = null;
            } while (maxHeaderCount <= 0 || headerLines.size() < maxHeaderCount);
            throw new MessageConstraintException("Maximum header count exceeded");
        }
        Header[] headers = new Header[headerLines.size()];
        for (i = 0; i < headerLines.size(); ++i) {
            CharArrayBuffer buffer = headerLines.get(i);
            headers[i] = parser.parseHeader(buffer);
        }
        return headers;
    }

    protected abstract T createMessage(CharArrayBuffer var1) throws IOException, HttpException;

    protected abstract IOException createConnectionClosedException();

    @Override
    public T parse(SessionInputBuffer buffer) throws IOException, HttpException {
        Args.notNull(buffer, "Session input buffer");
        int st = this.state;
        switch (st) {
            case 0: {
                for (int n = 0; n < this.messageConstraints.getMaxEmptyLineCount(); ++n) {
                    this.headLine.clear();
                    int i = buffer.readLine(this.headLine);
                    if (i == -1) {
                        throw this.createConnectionClosedException();
                    }
                    if (this.headLine.length() <= 0) continue;
                    this.message = this.createMessage(this.headLine);
                    break;
                }
                if (this.message == null) {
                    throw new MessageConstraintException("Maximum empty line limit exceeded");
                }
                this.state = 1;
            }
            case 1: {
                Header[] headers = AbstractMessageParser.parseHeaders(buffer, this.messageConstraints.getMaxHeaderCount(), this.messageConstraints.getMaxLineLength(), this.lineParser, this.headerLines);
                this.message.setHeaders(headers);
                T result = this.message;
                this.message = null;
                this.headerLines.clear();
                this.state = 0;
                return result;
            }
        }
        throw new IllegalStateException("Inconsistent parser state");
    }
}

