/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import java.util.Iterator;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpMessage;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.io.HttpMessageWriter;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.message.BasicLineFormatter;
import org.apache.http.message.LineFormatter;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public abstract class AbstractMessageWriter<T extends HttpMessage>
implements HttpMessageWriter<T> {
    private final CharArrayBuffer lineBuf;
    private final LineFormatter lineFormatter;

    public AbstractMessageWriter(LineFormatter formatter) {
        this.lineFormatter = formatter != null ? formatter : BasicLineFormatter.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    LineFormatter getLineFormatter() {
        return this.lineFormatter;
    }

    protected abstract void writeHeadLine(T var1, CharArrayBuffer var2) throws IOException;

    @Override
    public void write(T message, SessionOutputBuffer buffer) throws IOException, HttpException {
        Args.notNull(message, "HTTP message");
        Args.notNull(buffer, "Session output buffer");
        this.writeHeadLine(message, this.lineBuf);
        buffer.writeLine(this.lineBuf);
        Iterator<Header> it = message.headerIterator();
        while (it.hasNext()) {
            Header header = it.next();
            if (header instanceof FormattedHeader) {
                CharArrayBuffer chbuffer = ((FormattedHeader)header).getBuffer();
                buffer.writeLine(chbuffer);
                continue;
            }
            this.lineBuf.clear();
            this.lineFormatter.formatHeader(this.lineBuf, header);
            buffer.writeLine(this.lineBuf);
        }
        this.lineBuf.clear();
        buffer.writeLine(this.lineBuf);
    }
}

