/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.io;

import java.io.IOException;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.HttpVersion;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolVersion;
import org.apache.http.StatusLine;
import org.apache.http.UnsupportedHttpVersionException;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.config.MessageConstraints;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.io.AbstractMessageParser;
import org.apache.http.message.LineParser;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParser(LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super(lineParser, constraints);
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParser(MessageConstraints constraints) {
        this(null, null, constraints);
    }

    public DefaultHttpResponseParser() {
        this(MessageConstraints.DEFAULT);
    }

    @Override
    protected IOException createConnectionClosedException() {
        return new NoHttpResponseException("The target server failed to respond");
    }

    @Override
    protected HttpResponse createMessage(CharArrayBuffer buffer) throws IOException, HttpException {
        StatusLine statusline = this.getLineParser().parseStatusLine(buffer);
        ProtocolVersion version = statusline.getProtocolVersion();
        if (version.greaterEquals(HttpVersion.HTTP_2)) {
            throw new UnsupportedHttpVersionException("Unsupported version: " + version);
        }
        return this.responseFactory.newHttpResponse(statusline, null);
    }
}

