/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import java.util.Iterator;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.message.AbstractHeaderElementIterator;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.HeaderValueParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.Args;

@NotThreadSafe
public class BasicHeaderElementIterator
extends AbstractHeaderElementIterator<HeaderElement> {
    private final HeaderValueParser parser;

    public BasicHeaderElementIterator(Iterator<Header> headerIterator, HeaderValueParser parser) {
        super(headerIterator);
        this.parser = Args.notNull(parser, "Parser");
    }

    public BasicHeaderElementIterator(Iterator<Header> headerIterator) {
        this(headerIterator, BasicHeaderValueParser.INSTANCE);
    }

    @Override
    HeaderElement parseHeaderElement(CharSequence buf, ParserCursor cursor) {
        HeaderElement e = this.parser.parseHeaderElement(buf, cursor);
        if (e.getName().length() != 0 || e.getValue() != null) {
            return e;
        }
        return null;
    }
}

