/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.Header;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.StatusLine;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.LineFormatter;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class BasicLineFormatter
implements LineFormatter {
    public static final BasicLineFormatter INSTANCE = new BasicLineFormatter();

    void formatProtocolVersion(CharArrayBuffer buffer, ProtocolVersion version) {
        buffer.append(version.getProtocol());
        buffer.append('/');
        buffer.append(Integer.toString(version.getMajor()));
        buffer.append('.');
        buffer.append(Integer.toString(version.getMinor()));
    }

    @Override
    public void formatRequestLine(CharArrayBuffer buffer, RequestLine reqline) {
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(reqline, "Request line");
        buffer.append(reqline.getMethod());
        buffer.append(' ');
        buffer.append(reqline.getUri());
        buffer.append(' ');
        this.formatProtocolVersion(buffer, reqline.getProtocolVersion());
    }

    @Override
    public void formatStatusLine(CharArrayBuffer buffer, StatusLine statline) {
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(statline, "Status line");
        this.formatProtocolVersion(buffer, statline.getProtocolVersion());
        buffer.append(' ');
        buffer.append(Integer.toString(statline.getStatusCode()));
        buffer.append(' ');
        String reasonPhrase = statline.getReasonPhrase();
        if (reasonPhrase != null) {
            buffer.append(reasonPhrase);
        }
    }

    @Override
    public void formatHeader(CharArrayBuffer buffer, Header header) {
        Args.notNull(buffer, "Char array buffer");
        Args.notNull(header, "Header");
        buffer.append(header.getName());
        buffer.append(": ");
        String value = header.getValue();
        if (value != null) {
            buffer.append(value);
        }
    }
}

